/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.process.tube;

import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.locationtech.geomesa.process.tube.TubeBuilder;
import org.locationtech.geomesa.utils.geotools.Conversions;
import org.locationtech.geomesa.utils.geotools.Conversions$;
import org.locationtech.geomesa.utils.text.WKTUtils$;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeature;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001I4A!\u0001\u0002\u0001\u001b\tYA*\u001b8f\u000f\u0006\u0004h)\u001b7m\u0015\t\u0019A!\u0001\u0003uk\n,'BA\u0003\u0007\u0003\u001d\u0001(o\\2fgNT!a\u0002\u0005\u0002\u000f\u001d,w.\\3tC*\u0011\u0011BC\u0001\rY>\u001c\u0017\r^5p]R,7\r\u001b\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\u0004\n\u0011\u0005=\u0001R\"\u0001\u0002\n\u0005E\u0011!a\u0003+vE\u0016\u0014U/\u001b7eKJ\u0004\"a\u0005\u000e\u000e\u0003QQ!!\u0006\f\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005]A\u0012\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003e\t1aY8n\u0013\tYBCA\u0006MCjLHj\\4hS:<\u0007\"C\u000f\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0010)\u00031!XOY3GK\u0006$XO]3t!\tyb%D\u0001!\u0015\t\t#%\u0001\u0004tS6\u0004H.\u001a\u0006\u0003G\u0011\nA\u0001Z1uC*\u0011QEC\u0001\tO\u0016|Go\\8mg&\u0011q\u0005\t\u0002\u0018'&l\u0007\u000f\\3GK\u0006$XO]3D_2dWm\u0019;j_:L!!\b\t\t\u0013)\u0002!\u0011!Q\u0001\n-\n\u0014A\u00042vM\u001a,'\u000fR5ti\u0006t7-\u001a\t\u0003Y=j\u0011!\f\u0006\u0002]\u0005)1oY1mC&\u0011\u0001'\f\u0002\u0007\t>,(\r\\3\n\u0005)\u0002\u0002\"C\u001a\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001b8\u0003\u001di\u0017\r\u001f\"j]N\u0004\"\u0001L\u001b\n\u0005Yj#aA%oi&\u00111\u0007\u0005\u0005\u0006s\u0001!\tAO\u0001\u0007y%t\u0017\u000e\u001e \u0015\tmbTH\u0010\t\u0003\u001f\u0001AQ!\b\u001dA\u0002yAQA\u000b\u001dA\u0002-BQa\r\u001dA\u0002QBq\u0001\u0011\u0001C\u0002\u0013\u0005\u0011)\u0001\u0002jIV\t!\t\u0005\u0002D\u00196\tAI\u0003\u0002F\r\u00061\u0011\r^8nS\u000eT!a\u0012%\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002J\u0015\u0006!Q\u000f^5m\u0015\u0005Y\u0015\u0001\u00026bm\u0006L!!\u0014#\u0003\u001b\u0005#x.\\5d\u0013:$XmZ3s\u0011\u0019y\u0005\u0001)A\u0005\u0005\u0006\u0019\u0011\u000e\u001a\u0011\t\u000bE\u0003A\u0011\u0001*\u0002\r9,\u0007\u0010^%e+\u0005\u0019\u0006C\u0001+X\u001d\taS+\u0003\u0002W[\u00051\u0001K]3eK\u001aL!\u0001W-\u0003\rM#(/\u001b8h\u0015\t1V\u0006C\u0003\\\u0001\u0011\u0005C,\u0001\u0006de\u0016\fG/\u001a+vE\u0016,\u0012!\u0018\t\u0004=\u001aLgBA0e\u001d\t\u00017-D\u0001b\u0015\t\u0011G\"\u0001\u0004=e>|GOP\u0005\u0002]%\u0011Q-L\u0001\ba\u0006\u001c7.Y4f\u0013\t9\u0007N\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0015\t)W\u0006\u0005\u0002ka6\t1N\u0003\u0002\"Y*\u0011QN\\\u0001\bM\u0016\fG/\u001e:f\u0015\ty'\"A\u0004pa\u0016tw-[:\n\u0005E\\'!D*j[BdWMR3biV\u0014X\r")
public class LineGapFill
extends TubeBuilder {
    private final AtomicInteger id = new AtomicInteger(0);

    public AtomicInteger id() {
        return this.id;
    }

    public String nextId() {
        return ((Object)BoxesRunTime.boxToInteger((int)this.id().getAndIncrement())).toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Iterator<SimpleFeature> createTube() {
        Iterator iterator;
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Creating tube with line gap fill");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Iterator<SimpleFeature> transformed = this.transform(super.tubeFeatures(), this.dtgField());
        Seq sortedTube = (Seq)transformed.toSeq().sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LineGapFill $outer;

            public final long apply(SimpleFeature sf) {
                return this.$outer.getStartTime(sf).getTime();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Ordering)Ordering.Long$.MODULE$);
        Seq pointsAndTimes = (Seq)sortedTube.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LineGapFill $outer;

            public final Tuple2<Point, Date> apply(SimpleFeature sf) {
                return new Tuple2((Object)Conversions.RichGeometry$.MODULE$.safeCentroid$extension(Conversions$.MODULE$.RichGeometry(this.$outer.getGeom(sf))), (Object)this.$outer.getStartTime(sf));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        if (pointsAndTimes.lengthCompare(1) == 0) {
            BoxedUnit boxedUnit2;
            Tuple2 tuple2;
            Tuple2 tuple22 = (Tuple2)pointsAndTimes.head();
            if (tuple22 == null) throw new MatchError((Object)tuple22);
            Point p1 = (Point)tuple22._1();
            Date t1 = (Date)tuple22._2();
            Tuple2 tuple23 = tuple2 = new Tuple2((Object)p1, (Object)t1);
            Point p12 = (Point)tuple23._1();
            Date t12 = (Date)tuple23._2();
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Only a single result - can't create a line");
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            iterator = package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleFeature[]{this.builder().buildFeature(this.nextId(), new Object[]{p12, t12, t12})}));
        } else {
            iterator = pointsAndTimes.sliding(2).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LineGapFill $outer;

                public final SimpleFeature apply(Seq<Tuple2<Point, Date>> x0$2) {
                    Seq<Tuple2<Point, Date>> seq = x0$2;
                    Some some = Seq$.MODULE$.unapplySeq(seq);
                    if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                        Tuple2 tuple2 = (Tuple2)((SeqLike)some.get()).apply(0);
                        Tuple2 tuple22 = (Tuple2)((SeqLike)some.get()).apply(1);
                        if (tuple2 != null) {
                            Point p1 = (Point)tuple2._1();
                            Date t1 = (Date)tuple2._2();
                            if (tuple22 != null) {
                                BoxedUnit boxedUnit;
                                Point geo;
                                Point p2 = (Point)tuple22._1();
                                Date t2 = (Date)tuple22._2();
                                Object object = geo = p1.equals((Geometry)p2) ? p1 : this.$outer.makeIDLSafeLineString(p1.getCoordinate(), p2.getCoordinate());
                                if (this.$outer.logger().underlying().isDebugEnabled()) {
                                    this.$outer.logger().underlying().debug("Created Line-filled Geometry: {} From {} and {}", new Object[]{WKTUtils$.MODULE$.write((Geometry)geo), WKTUtils$.MODULE$.write((Geometry)p1), WKTUtils$.MODULE$.write((Geometry)p2)});
                                    boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    boxedUnit = BoxedUnit.UNIT;
                                }
                                SimpleFeature simpleFeature = this.$outer.builder().buildFeature(this.$outer.nextId(), new Object[]{geo, t1, t2});
                                return simpleFeature;
                            }
                        }
                    }
                    throw new MatchError(seq);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }
        Iterator lineFeatures = iterator;
        return this.buffer((Iterator<SimpleFeature>)lineFeatures, super.bufferDistance());
    }

    public LineGapFill(SimpleFeatureCollection tubeFeatures, double bufferDistance, int maxBins) {
        super(tubeFeatures, bufferDistance, maxBins);
    }
}

