/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml2.bindings;

import java.util.List;
import javax.xml.namespace.QName;
import org.geotools.gml2.GML;
import org.geotools.xml.AbstractComplexBinding;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.Node;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;

public class GMLPolygonTypeBinding
extends AbstractComplexBinding {
    GeometryFactory gFactory;

    public GMLPolygonTypeBinding(GeometryFactory gFactory) {
        this.gFactory = gFactory;
    }

    public QName getTarget() {
        return GML.PolygonType;
    }

    public int getExecutionMode() {
        return 1;
    }

    public Class getType() {
        return Polygon.class;
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        LinearRing shell = (LinearRing)node.getChild("outerBoundaryIs").getValue();
        List innerRings = node.getChildren("innerBoundaryIs");
        LinearRing[] holes = new LinearRing[innerRings.size()];
        for (int i = 0; i < innerRings.size(); ++i) {
            Node inode = (Node)innerRings.get(i);
            holes[i] = (LinearRing)inode.getValue();
        }
        return this.gFactory.createPolygon(shell, holes);
    }

    public Object getProperty(Object object, QName name) throws Exception {
        int n;
        Polygon polygon = (Polygon)object;
        if (GML.outerBoundaryIs.equals(name)) {
            return polygon.getExteriorRing();
        }
        if (GML.innerBoundaryIs.equals(name) && (n = polygon.getNumInteriorRing()) > 0) {
            LineString[] interior = new LineString[n];
            for (int i = 0; i < n; ++i) {
                interior[i] = polygon.getInteriorRingN(i);
            }
            return interior;
        }
        return null;
    }
}

