/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.iterators;

import java.util.concurrent.ConcurrentHashMap;
import org.locationtech.geomesa.features.kryo.KryoFeatureSerializer;
import org.locationtech.geomesa.features.kryo.KryoFeatureSerializer$;
import org.locationtech.geomesa.filter.factory.FastFilterFactory$;
import org.locationtech.geomesa.utils.cache.SoftThreadLocalCache;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import scala.Enumeration;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;

public final class IteratorCache$ {
    public static final IteratorCache$ MODULE$;
    private final ConcurrentHashMap<String, SimpleFeatureType> sftCache;
    private final ConcurrentHashMap<Tuple2<String, String>, KryoFeatureSerializer> serializerCache;
    private final ConcurrentHashMap<String, Integer> dtgIndexCache;
    private final SoftThreadLocalCache<Tuple2<String, String>, Filter> filterCache;

    static {
        new IteratorCache$();
    }

    private ConcurrentHashMap<String, SimpleFeatureType> sftCache() {
        return this.sftCache;
    }

    private ConcurrentHashMap<Tuple2<String, String>, KryoFeatureSerializer> serializerCache() {
        return this.serializerCache;
    }

    private ConcurrentHashMap<String, Integer> dtgIndexCache() {
        return this.dtgIndexCache;
    }

    private SoftThreadLocalCache<Tuple2<String, String>, Filter> filterCache() {
        return this.filterCache;
    }

    /*
     * WARNING - void declaration
     */
    public SimpleFeatureType sft(String spec) {
        SimpleFeatureType simpleFeatureType;
        SimpleFeatureType cached = this.sftCache().get(spec);
        if (cached == null) {
            void var3_3;
            SimpleFeatureType sft = SimpleFeatureTypes$.MODULE$.createType("", spec);
            this.sftCache().put(spec, sft);
            simpleFeatureType = var3_3;
        } else {
            simpleFeatureType = cached;
        }
        return simpleFeatureType;
    }

    public KryoFeatureSerializer serializer(String spec, Set<Enumeration.Value> options) {
        KryoFeatureSerializer kryoFeatureSerializer;
        KryoFeatureSerializer cached = this.serializerCache().get(new Tuple2((Object)spec, (Object)options.mkString()));
        if (cached == null) {
            KryoFeatureSerializer serializer = KryoFeatureSerializer$.MODULE$.apply(this.sft(spec), options);
            this.serializerCache().put((Tuple2<String, String>)new Tuple2((Object)spec, (Object)options.mkString()), serializer);
            kryoFeatureSerializer = serializer;
        } else {
            kryoFeatureSerializer = cached;
        }
        return kryoFeatureSerializer;
    }

    public Filter filter(SimpleFeatureType sft, String spec, String ecql) {
        return (Filter)this.filterCache().getOrElseUpdate((Object)new Tuple2((Object)spec, (Object)ecql), (Function0)new Serializable(sft, ecql){
            public static final long serialVersionUID = 0L;
            private final SimpleFeatureType sft$1;
            private final String ecql$1;

            public final Filter apply() {
                return FastFilterFactory$.MODULE$.toFilter(this.sft$1, this.ecql$1);
            }
            {
                this.sft$1 = sft$1;
                this.ecql$1 = ecql$1;
            }
        });
    }

    public int dtgIndex(String spec, SimpleFeatureType sft) {
        int n;
        Integer cached = this.dtgIndexCache().get(spec);
        if (cached == null) {
            int idx = BoxesRunTime.unboxToInt((Object)RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getDtgIndex$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)).get());
            this.dtgIndexCache().put(spec, Predef$.MODULE$.int2Integer(idx));
            n = idx;
        } else {
            n = Predef$.MODULE$.Integer2int(cached);
        }
        return n;
    }

    private IteratorCache$() {
        MODULE$ = this;
        this.sftCache = new ConcurrentHashMap();
        this.serializerCache = new ConcurrentHashMap();
        this.dtgIndexCache = new ConcurrentHashMap();
        this.filterCache = new SoftThreadLocalCache();
    }
}

