/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.planning;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.util.List;
import org.geotools.data.Query;
import org.geotools.factory.Hints;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.FunctionExpressionImpl;
import org.geotools.filter.MathExpressionImpl;
import org.geotools.process.vector.TransformProcess;
import org.locationtech.geomesa.filter.FilterHelper$;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.index.conf.QueryHints$Internal$;
import org.locationtech.geomesa.index.iterators.BinAggregatingScan$;
import org.locationtech.geomesa.index.iterators.DensityScan$;
import org.locationtech.geomesa.index.planning.QueryPlanner$;
import org.locationtech.geomesa.utils.cache.SoftThreadLocal;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.stats.StatParser$;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.sort.SortBy;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public final class QueryPlanner$
implements LazyLogging {
    public static final QueryPlanner$ MODULE$;
    private final SoftThreadLocal<Map<Object, Object>> threadedHints;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new QueryPlanner$();
    }

    private Logger logger$lzycompute() {
        QueryPlanner$ queryPlanner$ = this;
        synchronized (queryPlanner$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public SoftThreadLocal<Map<Object, Object>> threadedHints() {
        return this.threadedHints;
    }

    public void setPerThreadQueryHints(Map<Object, Object> hints) {
        this.threadedHints().put(hints);
    }

    public Option<Map<Object, Object>> getPerThreadQueryHints() {
        return this.threadedHints().get();
    }

    public void clearPerThreadQueryHints() {
        this.threadedHints().clear();
    }

    public void setQueryTransforms(Query query, SimpleFeatureType sft) {
        Option properties = Option$.MODULE$.apply((Object)query.getPropertyNames()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Seq<String> apply(String[] x$6) {
                return Predef$.MODULE$.refArrayOps((Object[])x$6).toSeq();
            }
        }).filter((Function1)new Serializable(sft){
            public static final long serialVersionUID = 0L;
            private final SimpleFeatureType sft$3;

            public final boolean apply(Seq<String> x$7) {
                Seq<String> seq = x$7;
                Object object = ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.sft$3.getAttributeDescriptors()).asScala()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(AttributeDescriptor x$8) {
                        return x$8.getLocalName();
                    }
                }, Buffer$.MODULE$.canBuildFrom());
                return seq != null ? !seq.equals(object) : object != null;
            }
            {
                this.sft$3 = sft$3;
            }
        }).orElse((Function0)new Serializable(query, sft){
            public static final long serialVersionUID = 0L;
            private final Query query$2;
            private final SimpleFeatureType sft$3;

            public final Option<Seq<String>> apply() {
                return new Some((Object)QueryPlanner$.MODULE$.org$locationtech$geomesa$index$planning$QueryPlanner$$transformsFromQueryType$1(this.query$2, this.sft$3)).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Seq<String> x$9) {
                        return x$9.nonEmpty();
                    }
                });
            }
            {
                this.query$2 = query$2;
                this.sft$3 = sft$3;
            }
        });
        query.setProperties(Query.ALL_PROPERTIES);
        properties.foreach((Function1)new Serializable(query, sft){
            public static final long serialVersionUID = 0L;
            private final Query query$2;
            private final SimpleFeatureType sft$3;

            public final Object apply(Seq<String> props) {
                Tuple2<String, SimpleFeatureType> tuple2 = QueryPlanner$.MODULE$.buildTransformSFT(this.sft$3, props);
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    String transforms = (String)tuple2._1();
                    SimpleFeatureType derivedSchema = (SimpleFeatureType)tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)transforms, (Object)derivedSchema);
                    String transforms2 = (String)tuple23._1();
                    SimpleFeatureType derivedSchema2 = (SimpleFeatureType)tuple23._2();
                    this.query$2.getHints().put((Object)QueryHints$Internal$.MODULE$.TRANSFORMS(), (Object)transforms2);
                    return this.query$2.getHints().put((Object)QueryHints$Internal$.MODULE$.TRANSFORM_SCHEMA(), (Object)derivedSchema2);
                }
                throw new MatchError(tuple2);
            }
            {
                this.query$2 = query$2;
                this.sft$3 = sft$3;
            }
        });
    }

    public Tuple2<String, SimpleFeatureType> buildTransformSFT(SimpleFeatureType sft, Seq<String> properties) {
        String transforms = ((TraversableOnce)properties.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String p) {
                return new StringOps(Predef$.MODULE$.augmentString(p)).contains((Object)BoxesRunTime.boxToCharacter((char)'=')) ? p : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{p, p}));
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(";");
        List transformDefs = TransformProcess.toDefinition((String)transforms);
        SimpleFeatureType derivedSchema = this.computeSchema(sft, (Seq<TransformProcess.Definition>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(transformDefs).asScala()));
        return new Tuple2((Object)transforms, (Object)derivedSchema);
    }

    public void setQuerySort(SimpleFeatureType sft, Query query) {
        SortBy[] sortBy = query.getSortBy();
        if (sortBy != null) {
            String hint = QueryHints$Internal$.MODULE$.toSortHint(sortBy);
            Object object = new StringOps(Predef$.MODULE$.augmentString(hint)).nonEmpty() ? query.getHints().put((Object)QueryHints$Internal$.MODULE$.SORT_FIELDS(), (Object)hint) : BoxedUnit.UNIT;
            query.setSortBy(null);
        }
    }

    public void setMaxFeatures(Query query) {
        if (!query.isMaxFeaturesUnlimited()) {
            query.getHints().put((Object)QueryHints$Internal$.MODULE$.MAX_FEATURES(), (Object)BoxesRunTime.boxToInteger((int)query.getMaxFeatures()));
        }
    }

    private SimpleFeatureType computeSchema(SimpleFeatureType sft, Seq<TransformProcess.Definition> transforms) {
        Seq descriptors = (Seq)transforms.map((Function1)new Serializable(sft){
            public static final long serialVersionUID = 0L;
            public final SimpleFeatureType sft$4;

            public final AttributeDescriptor apply(TransformProcess.Definition definition) {
                block5: {
                    AttributeDescriptor attributeDescriptor;
                    block3: {
                        Expression expression;
                        block4: {
                            block2: {
                                expression = definition.expression;
                                if (!(expression instanceof PropertyName)) break block2;
                                PropertyName propertyName = (PropertyName)expression;
                                AttributeDescriptor originalDescriptor = (AttributeDescriptor)Option$.MODULE$.apply(propertyName.evaluate((Object)this.sft$4, AttributeDescriptor.class)).getOrElse((Function0)new Serializable(this, propertyName){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ anonfun.12 $outer;
                                    private final PropertyName x2$1;

                                    public final Nothing$ apply() {
                                        throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attribute '", "' "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.x2$1.getPropertyName()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"does not exist in schema '", "'."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.sft$4.getTypeName()}))).toString());
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.x2$1 = x2$1;
                                    }
                                });
                                AttributeTypeBuilder builder = new AttributeTypeBuilder();
                                builder.init(originalDescriptor);
                                attributeDescriptor = originalDescriptor instanceof GeometryDescriptor ? builder.buildDescriptor(definition.name, builder.buildGeometryType()) : builder.buildDescriptor(definition.name, builder.buildType());
                                break block3;
                            }
                            if (!(expression instanceof FunctionExpressionImpl)) break block4;
                            FunctionExpressionImpl functionExpressionImpl = (FunctionExpressionImpl)expression;
                            Class clazz = functionExpressionImpl.getFunctionName().getReturn().getType();
                            AttributeTypeBuilder ab = new AttributeTypeBuilder().binding(clazz);
                            attributeDescriptor = Geometry.class.isAssignableFrom(clazz) ? ab.buildDescriptor(definition.name, ab.buildGeometryType()) : ab.buildDescriptor(definition.name, ab.buildType());
                            break block3;
                        }
                        if (!(expression instanceof MathExpressionImpl)) break block5;
                        AttributeTypeBuilder ab = new AttributeTypeBuilder().binding(Double.class);
                        attributeDescriptor = ab.buildDescriptor(definition.name, ab.buildType());
                    }
                    return attributeDescriptor;
                }
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Can't handle transform expression ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{definition.expression})));
            }
            {
                this.sft$4 = sft$4;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq geomAttributes = (Seq)((TraversableLike)descriptors.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(AttributeDescriptor x$11) {
                return x$11 instanceof GeometryDescriptor;
            }
        })).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(AttributeDescriptor x$12) {
                return x$12.getLocalName();
            }
        }, Seq$.MODULE$.canBuildFrom());
        SimpleFeatureTypeBuilder sftBuilder = new SimpleFeatureTypeBuilder();
        sftBuilder.setName(sft.getName());
        sftBuilder.addAll((AttributeDescriptor[])descriptors.toArray(ClassTag$.MODULE$.apply(AttributeDescriptor.class)));
        if (geomAttributes.nonEmpty()) {
            String string;
            if (geomAttributes.lengthCompare(1) == 0) {
                string = (String)geomAttributes.head();
            } else {
                String origDefaultGeom = sft.getGeometryDescriptor().getLocalName();
                string = (String)geomAttributes.find((Function1)new Serializable(origDefaultGeom){
                    public static final long serialVersionUID = 0L;
                    private final String origDefaultGeom$1;

                    public final boolean apply(String x$13) {
                        String string = x$13;
                        String string2 = this.origDefaultGeom$1;
                        return !(string != null ? !string.equals(string2) : string2 != null);
                    }
                    {
                        this.origDefaultGeom$1 = origDefaultGeom$1;
                    }
                }).getOrElse((Function0)new Serializable(geomAttributes){
                    public static final long serialVersionUID = 0L;
                    private final Seq geomAttributes$1;

                    public final String apply() {
                        return (String)this.geomAttributes$1.head();
                    }
                    {
                        this.geomAttributes$1 = geomAttributes$1;
                    }
                });
            }
            String defaultGeom = string;
            sftBuilder.setDefaultGeometry(defaultGeom);
        }
        SimpleFeatureType tsft = sftBuilder.buildFeatureType();
        tsft.getUserData().putAll(sft.getUserData());
        return tsft;
    }

    public final Seq org$locationtech$geomesa$index$planning$QueryPlanner$$transformsFromQueryType$1(Query query$2, SimpleFeatureType sft$3) {
        Seq seq;
        Hints hints = query$2.getHints();
        if (QueryHints$.MODULE$.RichHints(hints).isBinQuery()) {
            seq = BinAggregatingScan$.MODULE$.propertyNames(hints, sft$3);
        } else if (QueryHints$.MODULE$.RichHints(hints).isDensityQuery()) {
            seq = DensityScan$.MODULE$.propertyNames(hints, sft$3);
        } else if (QueryHints$.MODULE$.RichHints(hints).isStatsQuery()) {
            Seq props = StatParser$.MODULE$.propertyNames(sft$3, QueryHints$.MODULE$.RichHints(hints).getStatsQuery(), StatParser$.MODULE$.propertyNames$default$3());
            if (props.nonEmpty()) {
                seq = props;
            } else {
                String prop = (String)Option$.MODULE$.apply((Object)RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getGeomField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft$3))).orElse((Function0)new Serializable(sft$3){
                    public static final long serialVersionUID = 0L;
                    private final SimpleFeatureType sft$3;

                    public final Option<String> apply() {
                        return RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getDtgField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(this.sft$3));
                    }
                    {
                        this.sft$3 = sft$3;
                    }
                }).orElse((Function0)new Serializable(query$2, sft$3){
                    public static final long serialVersionUID = 0L;
                    private final Query query$2;
                    private final SimpleFeatureType sft$3;

                    public final Option<String> apply() {
                        return FilterHelper$.MODULE$.propertyNames(this.query$2.getFilter(), this.sft$3).headOption();
                    }
                    {
                        this.query$2 = query$2;
                        this.sft$3 = sft$3;
                    }
                }).getOrElse((Function0)new Serializable(sft$3){
                    public static final long serialVersionUID = 0L;
                    private final SimpleFeatureType sft$3;

                    public final String apply() {
                        return this.sft$3.getDescriptor(0).getLocalName();
                    }
                    {
                        this.sft$3 = sft$3;
                    }
                });
                seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{prop}));
            }
        } else {
            seq = (Seq)Seq$.MODULE$.empty();
        }
        return seq;
    }

    private QueryPlanner$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
        this.threadedHints = new SoftThreadLocal();
    }
}

