/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.conf.partition;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.util.Date;
import org.locationtech.geomesa.curve.BinnedTime;
import org.locationtech.geomesa.curve.BinnedTime$;
import org.locationtech.geomesa.filter.Bounds;
import org.locationtech.geomesa.filter.FilterHelper$;
import org.locationtech.geomesa.filter.FilterValues;
import org.locationtech.geomesa.index.conf.partition.TablePartition;
import org.locationtech.geomesa.index.conf.partition.TablePartitionFactory;
import org.locationtech.geomesa.index.conf.partition.TimePartition$;
import org.locationtech.geomesa.index.conf.partition.TimePartition$$anonfun$org$locationtech$geomesa$index$conf$partition$TimePartition$;
import org.locationtech.geomesa.index.metadata.CachedLazyMetadata$;
import org.locationtech.geomesa.index.metadata.GeoMesaMetadata;
import org.locationtech.geomesa.index.metadata.HasGeoMesaMetadata;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.text.DateParsing$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple5;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.Range;
import scala.collection.immutable.StringOps;
import scala.concurrent.duration.Duration;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\tUc\u0001B\u0001\u0003\u0001=\u0011Q\u0002V5nKB\u000b'\u000f^5uS>t'BA\u0002\u0005\u0003%\u0001\u0018M\u001d;ji&|gN\u0003\u0002\u0006\r\u0005!1m\u001c8g\u0015\t9\u0001\"A\u0003j]\u0012,\u0007P\u0003\u0002\n\u0015\u00059q-Z8nKN\f'BA\u0006\r\u00031awnY1uS>tG/Z2i\u0015\u0005i\u0011aA8sO\u000e\u00011c\u0001\u0001\u0011-A\u0011\u0011\u0003F\u0007\u0002%)\t1#A\u0003tG\u0006d\u0017-\u0003\u0002\u0016%\t1\u0011I\\=SK\u001a\u0004\"a\u0006\r\u000e\u0003\tI!!\u0007\u0002\u0003\u001dQ\u000b'\r\\3QCJ$\u0018\u000e^5p]\"A1\u0004\u0001B\u0001B\u0003%A$\u0001\u0005nKR\fG-\u0019;b!\rir$I\u0007\u0002=)\u00111DB\u0005\u0003Ay\u0011qbR3p\u001b\u0016\u001c\u0018-T3uC\u0012\fG/\u0019\t\u0003E\u0015r!!E\u0012\n\u0005\u0011\u0012\u0012A\u0002)sK\u0012,g-\u0003\u0002'O\t11\u000b\u001e:j]\u001eT!\u0001\n\n\t\u0011%\u0002!\u0011!Q\u0001\n\u0005\n\u0001\u0002^=qK:\u000bW.\u001a\u0005\tW\u0001\u0011\t\u0011)A\u0005C\u0005\u0019A\r^4\t\u00115\u0002!\u0011!Q\u0001\n9\n\u0001\u0002\u001a;h\u0013:$W\r\u001f\t\u0003#=J!\u0001\r\n\u0003\u0007%sG\u000f\u0003\u00053\u0001\t\u0005\t\u0015!\u00034\u0003\u0019\u0001XM]5pIB\u0011A\u0007\u0012\b\u0003k\u0005s!AN \u000f\u0005]rdB\u0001\u001d>\u001d\tID(D\u0001;\u0015\tYd\"\u0001\u0004=e>|GOP\u0005\u0002\u001b%\u00111\u0002D\u0005\u0003\u0013)I!\u0001\u0011\u0005\u0002\u000b\r,(O^3\n\u0005\t\u001b\u0015A\u0003+j[\u0016\u0004VM]5pI*\u0011\u0001\tC\u0005\u0003\u000b\u001a\u0013!\u0002V5nKB+'/[8e\u0015\t\u00115\tC\u0003I\u0001\u0011\u0005\u0011*\u0001\u0004=S:LGO\u0010\u000b\u0007\u0015.cUJT(\u0011\u0005]\u0001\u0001\"B\u000eH\u0001\u0004a\u0002\"B\u0015H\u0001\u0004\t\u0003\"B\u0016H\u0001\u0004\t\u0003\"B\u0017H\u0001\u0004q\u0003\"\u0002\u001aH\u0001\u0004\u0019\u0004bB)\u0001\u0005\u0004%IAU\u0001\u0006i>\u0014\u0015N\\\u000b\u0002'B\u0011A\u000b\u0017\b\u0003+Zk\u0011aQ\u0005\u0003/\u000e\u000b!BQ5o]\u0016$G+[7f\u0013\tI&LA\u0005ECR,Gk\u001c\"j]*\u0011qk\u0011\u0005\u00079\u0002\u0001\u000b\u0011B*\u0002\rQ|')\u001b8!\u0011\u001dq\u0006A1A\u0005\n}\u000ba\u0001^8ECR,W#\u00011\u0011\u0005Q\u000b\u0017B\u00012[\u0005A\u0011\u0015N\u001c8fIRKW.\u001a+p\t\u0006$X\r\u0003\u0004e\u0001\u0001\u0006I\u0001Y\u0001\bi>$\u0015\r^3!\u0011\u001d1\u0007A1A\u0005\n\u001d\fQaY1dQ\u0016,\u0012\u0001\u001b\t\u0004S\u0006edB\u00016q\u001d\tYwN\u0004\u0002m]:\u0011a'\\\u0005\u0003\u000f!I!!\u0002\u0004\n\u0005\r!q!B9\u0003\u0011\u0003\u0011\u0018!\u0004+j[\u0016\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0002\u0018g\u001a)\u0011A\u0001E\u0001iN\u00111\u000f\u0005\u0005\u0006\u0011N$\tA\u001e\u000b\u0002e\"9\u0001p\u001db\u0001\n\u0003I\u0018\u0001\u0002(b[\u0016,\u0012A\u001f\t\u0004w\u0006\u0005Q\"\u0001?\u000b\u0005ut\u0018\u0001\u00027b]\u001eT\u0011a`\u0001\u0005U\u00064\u0018-\u0003\u0002'y\"9\u0011QA:!\u0002\u0013Q\u0018!\u0002(b[\u0016\u0004\u0003\u0002CA\u0005g\n\u0007I\u0011B=\u0002%A\u000b'\u000f^5uS>t7*Z=Qe\u00164\u0017\u000e\u001f\u0005\b\u0003\u001b\u0019\b\u0015!\u0003{\u0003M\u0001\u0016M\u001d;ji&|gnS3z!J,g-\u001b=!\u0011!17O1A\u0005\n\u0005EQCAA\n!\u001d\t)\"!\u000b\u0002.Yi!!a\u0006\u000b\u0007\u0019\fIB\u0003\u0003\u0002\u001c\u0005u\u0011\u0001C2bM\u001a,\u0017N\\3\u000b\t\u0005}\u0011\u0011E\u0001\tE\u0016tW.\u00198fg*!\u00111EA\u0013\u0003\u00199\u0017\u000e\u001e5vE*\u0011\u0011qE\u0001\u0004G>l\u0017\u0002BA\u0016\u0003/\u0011A\u0002T8bI&twmQ1dQ\u0016\u0004\u0002\"EA\u00189\u0005\ncfM\u0005\u0004\u0003c\u0011\"A\u0002+va2,W\u0007\u0003\u0005\u00026M\u0004\u000b\u0011BA\n\u0003\u0019\u0019\u0017m\u00195fA\u00191\u0011\u0011H:\u0001\u0003w\u0011A\u0003V5nKB\u000b'\u000f^5uS>tg)Y2u_JL8#BA\u001c!\u0005u\u0002cA\f\u0002@%\u0019\u0011\u0011\t\u0002\u0003+Q\u000b'\r\\3QCJ$\u0018\u000e^5p]\u001a\u000b7\r^8ss\"9\u0001*a\u000e\u0005\u0002\u0005\u0015CCAA$!\u0011\tI%a\u000e\u000e\u0003MD\u0001\"!\u0014\u00028\u0011\u0005\u0013qJ\u0001\u0005]\u0006lW-F\u0001\"\u0011!\t\u0019&a\u000e\u0005B\u0005U\u0013AB2sK\u0006$X\rF\u0003\u0017\u0003/\n\t\u0007\u0003\u0005\u0002Z\u0005E\u0003\u0019AA.\u0003\t!7\u000f\u0005\u0003\u001e\u0003;\n\u0013bAA0=\t\u0011\u0002*Y:HK>lUm]1NKR\fG-\u0019;b\u0011!\t\u0019'!\u0015A\u0002\u0005\u0015\u0014aA:giB!\u0011qMA;\u001b\t\tIG\u0003\u0003\u0002l\u00055\u0014AB:j[BdWM\u0003\u0003\u0002p\u0005E\u0014a\u00024fCR,(/\u001a\u0006\u0004\u0003gb\u0011aB8qK:<\u0017n]\u0005\u0005\u0003o\nIGA\tTS6\u0004H.\u001a$fCR,(/\u001a+za\u00164a!a\u001ft\t\u0005u$\u0001F\"vgR|W\u000eU1si&$\u0018n\u001c8DC\u000eDWmE\u0002\u0002zAA\u0011bGA=\u0005\u0003\u0005\u000b\u0011\u0002\u000f\t\u0013%\nIH!A!\u0002\u0013\t\u0003b\u0002%\u0002z\u0011\u0005\u0011Q\u0011\u000b\u0007\u0003\u000f\u000bI)a#\u0011\t\u0005%\u0013\u0011\u0010\u0005\u00077\u0005\r\u0005\u0019\u0001\u000f\t\r%\n\u0019\t1\u0001\"\u0011)\ty)!\u001fC\u0002\u0013%\u0011\u0011S\u0001\u0007Kb\u0004\u0018N]=\u0016\u0005\u0005M\u0005cA\t\u0002\u0016&\u0019\u0011q\u0013\n\u0003\t1{gn\u001a\u0005\n\u00037\u000bI\b)A\u0005\u0003'\u000bq!\u001a=qSJL\b\u0005\u0003\u0007\u0002 \u0006e\u0004\u0019!a\u0001\n\u0013\t\t+\u0001\u0006qCJ$\u0018\u000e^5p]N,\"!a)\u0011\r\u0005\u0015\u0016qVA[\u001d\u0011\t9+a+\u000f\u0007e\nI+C\u0001\u0014\u0013\r\tiKE\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\t,a-\u0003\u0007M+\u0017OC\u0002\u0002.J\u0001\u0002\"EA\\C\u0005m\u00161X\u0005\u0004\u0003s\u0013\"A\u0002+va2,7\u0007\u0005\u0003\u0002>\u0006\rWBAA`\u0015\r\t\tM`\u0001\u0005i&lW-\u0003\u0003\u0002F\u0006}&!\u0004.p]\u0016$G)\u0019;f)&lW\r\u0003\u0007\u0002J\u0006e\u0004\u0019!a\u0001\n\u0013\tY-\u0001\bqCJ$\u0018\u000e^5p]N|F%Z9\u0015\t\u00055\u00171\u001b\t\u0004#\u0005=\u0017bAAi%\t!QK\\5u\u0011)\t).a2\u0002\u0002\u0003\u0007\u00111U\u0001\u0004q\u0012\n\u0004\"CAm\u0003s\u0002\u000b\u0015BAR\u0003-\u0001\u0018M\u001d;ji&|gn\u001d\u0011\t\u0015\u0005u\u0017\u0011\u0010a\u0001\n\u0013\t\t*\u0001\u0004sK2|\u0017\r\u001a\u0005\u000b\u0003C\fI\b1A\u0005\n\u0005\r\u0018A\u0003:fY>\fGm\u0018\u0013fcR!\u0011QZAs\u0011)\t).a8\u0002\u0002\u0003\u0007\u00111\u0013\u0005\n\u0003S\fI\b)Q\u0005\u0003'\u000bqA]3m_\u0006$\u0007\u0005\u0003\u0005\u0002n\u0006eD\u0011AAx\u0003A\u0019Wo\u001d;p[B\u000b'\u000f^5uS>t7\u000f\u0006\u0002\u0002$\"A\u00111_A=\t\u0003\t)0\u0001\u0006j]Z\fG.\u001b3bi\u0016$\"!!4\t\u000f\u0005U\u0002\u0001)A\u0005Q\"9\u00111 \u0001\u0005\u0002\u0005u\u0018\u0001\u0003:fO&\u001cH/\u001a:\u0015\u0011\u00055\u0017q B\u0001\u0005\u000bAaaAA}\u0001\u0004\t\u0003\u0002\u0003B\u0002\u0003s\u0004\r!a/\u0002\u000bM$\u0018M\u001d;\t\u0011\t\u001d\u0011\u0011 a\u0001\u0003w\u000b1!\u001a8e\u0011\u0019\u0019\u0001\u0001\"\u0011\u0003\fQ\u0019\u0011E!\u0004\t\u0011\u0005=$\u0011\u0002a\u0001\u0005\u001f\u0001B!a\u001a\u0003\u0012%!!1CA5\u00055\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sK\"9\u0011q\u0014\u0001\u0005B\t]A\u0003\u0002B\r\u00057\u0001R!!*\u00020\u0006B\u0001B!\b\u0003\u0016\u0001\u0007!qD\u0001\u0007M&dG/\u001a:\u0011\t\t\u0005\"QE\u0007\u0003\u0005GQAA!\b\u0002r%!!q\u0005B\u0012\u0005\u00191\u0015\u000e\u001c;fe\"9!1\u0006\u0001\u0005B\t5\u0012a\u0002:fG>4XM\u001d\u000b\u0004!\t=\u0002BB\u0002\u0003*\u0001\u0007\u0011\u0005C\u0004\u00034\u0001!IA!\u000e\u0002\u0011=4XM\u001d7baN$\u0002Ba\u000e\u0003>\tE#1\u000b\t\u0004#\te\u0012b\u0001B\u001e%\t9!i\\8mK\u0006t\u0007\u0002\u0003B \u0005c\u0001\rA!\u0011\u0002\u0013%tG/\u001a:wC2\u001c\bC\u0002B\"\u0005\u000f\u0012Y%\u0004\u0002\u0003F)\u0019!Q\u0004\u0005\n\t\t%#Q\t\u0002\r\r&dG/\u001a:WC2,Xm\u001d\t\u0007\u0005\u0007\u0012i%a/\n\t\t=#Q\t\u0002\u0007\u0005>,h\u000eZ:\t\u0011\t\r!\u0011\u0007a\u0001\u0003wC\u0001Ba\u0002\u00032\u0001\u0007\u00111\u0018")
public class TimePartition
implements TablePartition {
    private final GeoMesaMetadata<String> metadata;
    private final String typeName;
    private final String dtg;
    private final int dtgIndex;
    private final Function1<ZonedDateTime, Object> org$locationtech$geomesa$index$conf$partition$TimePartition$$toBin;
    private final Function1<BinnedTime, ZonedDateTime> toDate;
    private final CustomPartitionCache cache;

    public static String Name() {
        return TimePartition$.MODULE$.Name();
    }

    public Function1<ZonedDateTime, Object> org$locationtech$geomesa$index$conf$partition$TimePartition$$toBin() {
        return this.org$locationtech$geomesa$index$conf$partition$TimePartition$$toBin;
    }

    private Function1<BinnedTime, ZonedDateTime> toDate() {
        return this.toDate;
    }

    private CustomPartitionCache cache() {
        return this.cache;
    }

    public void register(String partition, ZonedDateTime start, ZonedDateTime end) {
        String dates = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DateParsing$.MODULE$.format(start, DateParsing$.MODULE$.format$default$2()), DateParsing$.MODULE$.format(end, DateParsing$.MODULE$.format$default$2())}));
        this.metadata.insert(this.typeName, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{TimePartition$.MODULE$.org$locationtech$geomesa$index$conf$partition$TimePartition$$PartitionKeyPrefix(), partition})), dates);
        this.cache().invalidate();
    }

    @Override
    public String partition(SimpleFeature feature) {
        Date date2 = (Date)feature.getAttribute(this.dtgIndex);
        short arg$macro$1 = BoxesRunTime.unboxToShort((Object)this.org$locationtech$geomesa$index$conf$partition$TimePartition$$toBin().apply((Object)ZonedDateTime.ofInstant(date2.toInstant(), ZoneOffset.UTC)));
        return new StringOps("%05d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToShort((short)arg$macro$1)}));
    }

    @Override
    public Seq<String> partitions(Filter filter2) {
        Seq seq;
        FilterValues intervals = FilterHelper$.MODULE$.extractIntervals(filter2, this.dtg, FilterHelper$.MODULE$.extractIntervals$default$3(), FilterHelper$.MODULE$.extractIntervals$default$4());
        if (!intervals.isEmpty() && intervals.forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Bounds<ZonedDateTime> x$1) {
                return x$1.isBoundedBothSides();
            }
        })) {
            Seq bins = (Seq)intervals.values().flatMap((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TimePartition $outer;

                public final Range.Inclusive apply(Bounds<ZonedDateTime> i) {
                    return package$.MODULE$.Range().inclusive((int)BoxesRunTime.unboxToShort((Object)this.$outer.org$locationtech$geomesa$index$conf$partition$TimePartition$$toBin().apply(i.lower().value().get())), (int)BoxesRunTime.unboxToShort((Object)this.$outer.org$locationtech$geomesa$index$conf$partition$TimePartition$$toBin().apply(i.upper().value().get())));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, Seq$.MODULE$.canBuildFrom());
            seq = (Seq)((TraversableLike)((TraversableLike)bins.distinct()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(int b) {
                    int arg$macro$2 = b;
                    return new StringOps("%05d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)arg$macro$2)}));
                }
            }, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)this.cache().customPartitions().collect((PartialFunction)new Serializable(this, intervals){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TimePartition $outer;
                private final FilterValues intervals$1;

                /*
                 * Enabled aggressive block sorting
                 */
                public final <A1 extends Tuple3<String, ZonedDateTime, ZonedDateTime>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 != null) {
                        ZonedDateTime end;
                        String p = (String)A1._1();
                        ZonedDateTime start = (ZonedDateTime)A1._2();
                        if (this.$outer.org$locationtech$geomesa$index$conf$partition$TimePartition$$overlaps((FilterValues<Bounds<ZonedDateTime>>)this.intervals$1, start, end = (ZonedDateTime)A1._3())) {
                            object = p;
                            return (B1)object;
                        }
                    }
                    object = function1.apply(x1);
                    return (B1)object;
                }

                public final boolean isDefinedAt(Tuple3<String, ZonedDateTime, ZonedDateTime> x1) {
                    ZonedDateTime end;
                    ZonedDateTime start;
                    Tuple3<String, ZonedDateTime, ZonedDateTime> tuple3 = x1;
                    boolean bl = tuple3 != null && this.$outer.org$locationtech$geomesa$index$conf$partition$TimePartition$$overlaps((FilterValues<Bounds<ZonedDateTime>>)this.intervals$1, start = (ZonedDateTime)tuple3._2(), end = (ZonedDateTime)tuple3._3());
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.intervals$1 = intervals$1;
                }
            }, Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        } else {
            seq = (Seq)Seq$.MODULE$.empty();
        }
        return seq;
    }

    @Override
    public Object recover(String partition) {
        return new Date(((ChronoZonedDateTime)this.toDate().apply((Object)new BinnedTime(new StringOps(Predef$.MODULE$.augmentString(partition)).toShort(), 0L))).toInstant().toEpochMilli());
    }

    public boolean org$locationtech$geomesa$index$conf$partition$TimePartition$$overlaps(FilterValues<Bounds<ZonedDateTime>> intervals, ZonedDateTime start, ZonedDateTime end) {
        return intervals.exists((Function1)new Serializable(this, start, end){
            public static final long serialVersionUID = 0L;
            public final ZonedDateTime start$1;
            public final ZonedDateTime end$1;

            public final boolean apply(Bounds<ZonedDateTime> i) {
                return i.lower().value().forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$org$locationtech$geomesa$index$conf$partition$TimePartition$$overlaps$1 $outer;

                    public final boolean apply(ZonedDateTime x$2) {
                        return x$2.isBefore(this.$outer.end$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }) && i.upper().value().forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$org$locationtech$geomesa$index$conf$partition$TimePartition$$overlaps$1 $outer;

                    public final boolean apply(ZonedDateTime x$3) {
                        return x$3.isAfter(this.$outer.start$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.start$1 = start$1;
                this.end$1 = end$1;
            }
        });
    }

    public TimePartition(GeoMesaMetadata<String> metadata, String typeName, String dtg, int dtgIndex, Enumeration.Value period) {
        this.metadata = metadata;
        this.typeName = typeName;
        this.dtg = dtg;
        this.dtgIndex = dtgIndex;
        this.org$locationtech$geomesa$index$conf$partition$TimePartition$$toBin = BinnedTime$.MODULE$.dateToBin(period);
        this.toDate = BinnedTime$.MODULE$.binnedTimeToDate(period);
        this.cache = new CustomPartitionCache(metadata, typeName);
    }

    public static class CustomPartitionCache {
        private final GeoMesaMetadata<String> metadata;
        private final String typeName;
        private final long expiry;
        private Seq<Tuple3<String, ZonedDateTime, ZonedDateTime>> partitions;
        private long reload;

        private long expiry() {
            return this.expiry;
        }

        private Seq<Tuple3<String, ZonedDateTime, ZonedDateTime>> partitions() {
            return this.partitions;
        }

        private void partitions_$eq(Seq<Tuple3<String, ZonedDateTime, ZonedDateTime>> x$1) {
            this.partitions = x$1;
        }

        private long reload() {
            return this.reload;
        }

        private void reload_$eq(long x$1) {
            this.reload = x$1;
        }

        public Seq<Tuple3<String, ZonedDateTime, ZonedDateTime>> customPartitions() {
            Seq<Tuple3<String, ZonedDateTime, ZonedDateTime>> seq;
            if (System.currentTimeMillis() < this.reload()) {
                seq = this.partitions();
            } else {
                this.reload_$eq(System.currentTimeMillis() + this.expiry());
                this.partitions_$eq((Seq<Tuple3<String, ZonedDateTime, ZonedDateTime>>)((Seq)this.metadata.scan(this.typeName, TimePartition$.MODULE$.org$locationtech$geomesa$index$conf$partition$TimePartition$$PartitionKeyPrefix(), this.metadata.scan$default$3()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple3<String, ZonedDateTime, ZonedDateTime> apply(Tuple2<String, String> x0$1) {
                        Tuple2<String, String> tuple2 = x0$1;
                        if (tuple2 != null) {
                            String k = (String)tuple2._1();
                            String v = (String)tuple2._2();
                            ZonedDateTime[] zonedDateTimeArray = (ZonedDateTime[])Predef$.MODULE$.refArrayOps((Object[])v.split("/")).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final ZonedDateTime apply(String x$4) {
                                    return DateParsing$.MODULE$.parse(x$4, DateParsing$.MODULE$.parse$default$2());
                                }
                            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ZonedDateTime.class)));
                            Option option = Array$.MODULE$.unapplySeq((Object)zonedDateTimeArray);
                            if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(2) == 0) {
                                Tuple2 tuple22;
                                ZonedDateTime start = (ZonedDateTime)((SeqLike)option.get()).apply(0);
                                ZonedDateTime end = (ZonedDateTime)((SeqLike)option.get()).apply(1);
                                Tuple2 tuple23 = tuple22 = new Tuple2((Object)start, (Object)end);
                                ZonedDateTime start2 = (ZonedDateTime)tuple23._1();
                                ZonedDateTime end2 = (ZonedDateTime)tuple23._2();
                                Tuple3 tuple3 = new Tuple3((Object)k.substring(TimePartition$.MODULE$.org$locationtech$geomesa$index$conf$partition$TimePartition$$PartitionKeyPrefix().length()), (Object)start2, (Object)end2);
                                return tuple3;
                            }
                            throw new MatchError((Object)zonedDateTimeArray);
                        }
                        throw new MatchError(tuple2);
                    }
                }, Seq$.MODULE$.canBuildFrom())));
                seq = this.partitions();
            }
            return seq;
        }

        public void invalidate() {
            this.reload_$eq(0L);
        }

        public CustomPartitionCache(GeoMesaMetadata<String> metadata, String typeName) {
            this.metadata = metadata;
            this.typeName = typeName;
            this.expiry = ((Duration)CachedLazyMetadata$.MODULE$.Expiry().toDuration().get()).toMillis();
            this.reload = 0L;
        }
    }

    public static class TimePartitionFactory
    implements TablePartitionFactory {
        @Override
        public String name() {
            return TimePartition$.MODULE$.Name();
        }

        @Override
        public TablePartition create(HasGeoMesaMetadata<String> ds, SimpleFeatureType sft) {
            String dtg = (String)RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getDtgField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)).getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Nothing$ apply() {
                    throw new IllegalArgumentException("Can't use time partitioning without a date field");
                }
            });
            return (TablePartition)TimePartition$.MODULE$.org$locationtech$geomesa$index$conf$partition$TimePartition$$cache().get((Object)new Tuple5(ds.metadata(), (Object)sft.getTypeName(), (Object)dtg, RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getDtgIndex$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)).get(), (Object)RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getZ3Interval$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft))));
        }
    }
}

