/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.geotools;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import org.geotools.data.FeatureReader;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.store.DataFeatureCollection;
import org.geotools.feature.visitor.BoundsVisitor;
import org.geotools.feature.visitor.MaxVisitor;
import org.geotools.feature.visitor.MinVisitor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.index.geotools.GeoMesaFeatureCollection$;
import org.locationtech.geomesa.index.geotools.GeoMesaFeatureSource;
import org.locationtech.geomesa.index.process.GeoMesaProcessVisitor;
import org.locationtech.geomesa.index.stats.GeoMesaStats;
import org.locationtech.geomesa.index.stats.package;
import org.locationtech.geomesa.utils.stats.MinMax;
import org.locationtech.jts.geom.Envelope;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.expression.PropertyName;
import org.opengis.util.ProgressListener;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005}d\u0001B\u0001\u0003\u00015\u0011\u0001dR3p\u001b\u0016\u001c\u0018MR3biV\u0014XmQ8mY\u0016\u001cG/[8o\u0015\t\u0019A!\u0001\u0005hK>$xn\u001c7t\u0015\t)a!A\u0003j]\u0012,\u0007P\u0003\u0002\b\u0011\u00059q-Z8nKN\f'BA\u0005\u000b\u00031awnY1uS>tG/Z2i\u0015\u0005Y\u0011aA8sO\u000e\u00011c\u0001\u0001\u000f/A\u0011q\"F\u0007\u0002!)\u0011\u0011CE\u0001\u0006gR|'/\u001a\u0006\u0003'Q\tA\u0001Z1uC*\u00111AC\u0005\u0003-A\u0011Q\u0003R1uC\u001a+\u0017\r^;sK\u000e{G\u000e\\3di&|g\u000e\u0005\u0002\u0019?5\t\u0011D\u0003\u0002\u001b7\u0005a1oY1mC2|wmZ5oO*\u0011A$H\u0001\tif\u0004Xm]1gK*\ta$A\u0002d_6L!\u0001I\r\u0003\u00171\u000b'0\u001f'pO\u001eLgn\u001a\u0005\nE\u0001\u0011)\u0019!C\u0001\u0005\r\naa]8ve\u000e,W#\u0001\u0013\u0011\u0005\u00152S\"\u0001\u0002\n\u0005\u001d\u0012!\u0001F$f_6+7/\u0019$fCR,(/Z*pkJ\u001cW\r\u0003\u0005*\u0001\t\u0005\t\u0015!\u0003%\u0003\u001d\u0019x.\u001e:dK\u0002B\u0011b\u000b\u0001\u0003\u0006\u0004%\tA\u0001\u0017\u0002\u000bE,XM]=\u0016\u00035\u0002\"AL\u0018\u000e\u0003II!\u0001\r\n\u0003\u000bE+XM]=\t\u0011I\u0002!\u0011!Q\u0001\n5\na!];fef\u0004\u0003\"\u0002\u001b\u0001\t\u0003)\u0014A\u0002\u001fj]&$h\bF\u00027oa\u0002\"!\n\u0001\t\u000b\t\u001a\u0004\u0019\u0001\u0013\t\u000b-\u001a\u0004\u0019A\u0017\t\u000fi\u0002!\u0019!C\u0005w\u0005!q\u000e]3o+\u0005a\u0004CA\u001fG\u001b\u0005q$BA A\u0003\u0019\tGo\\7jG*\u0011\u0011IQ\u0001\u000bG>t7-\u001e:sK:$(BA\"E\u0003\u0011)H/\u001b7\u000b\u0003\u0015\u000bAA[1wC&\u0011qI\u0010\u0002\u000e\u0003R|W.[2C_>dW-\u00198\t\r%\u0003\u0001\u0015!\u0003=\u0003\u0015y\u0007/\u001a8!\u0011\u0015Y\u0005\u0001\"\u0011M\u0003%9W\r^*dQ\u0016l\u0017\rF\u0001N!\tqU+D\u0001P\u0015\t\u0001\u0016+\u0001\u0004tS6\u0004H.\u001a\u0006\u0003%N\u000bqAZ3biV\u0014XM\u0003\u0002U\u0015\u00059q\u000e]3oO&\u001c\u0018B\u0001,P\u0005E\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sKRK\b/\u001a\u0005\u00061\u0002!\t&W\u0001\r_B,g.\u0013;fe\u0006$xN\u001d\u000b\u00025B\u00191\f\u00180\u000e\u0003\tK!!\u0018\"\u0003\u0011%#XM]1u_J\u0004\"AT0\n\u0005\u0001|%!D*j[BdWMR3biV\u0014X\rC\u0003c\u0001\u0011\u00053-A\u0004bG\u000e,\u0007\u000f^:\u0015\u0007\u0011T\u0007\u000f\u0005\u0002fQ6\taMC\u0001h\u0003\u0015\u00198-\u00197b\u0013\tIgM\u0001\u0003V]&$\b\"B6b\u0001\u0004a\u0017a\u0002<jg&$xN\u001d\t\u0003[:l\u0011!U\u0005\u0003_F\u0013aBR3biV\u0014XMV5tSR|'\u000fC\u0003rC\u0002\u0007!/\u0001\u0005qe><'/Z:t!\t\u0019X/D\u0001u\u0015\t\u00195+\u0003\u0002wi\n\u0001\u0002K]8he\u0016\u001c8\u000fT5ti\u0016tWM\u001d\u0005\u0006q\u0002!I!_\u0001\u0007[&tW*\u0019=\u0015\u000bi\f9!!\u0007\u0011\u0007\u0015\\X0\u0003\u0002}M\n1q\n\u001d;j_:\u0004b!\u001a@\u0002\u0002\u0005\u0005\u0011BA@g\u0005\u0019!V\u000f\u001d7feA\u0019Q-a\u0001\n\u0007\u0005\u0015aMA\u0002B]fDq!!\u0003x\u0001\u0004\tY!A\u0005biR\u0014\u0018NY;uKB!\u0011QBA\n\u001d\r)\u0017qB\u0005\u0004\u0003#1\u0017A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0016\u0005]!AB*ue&twMC\u0002\u0002\u0012\u0019Dq!a\u0007x\u0001\u0004\ti\"A\u0003fq\u0006\u001cG\u000fE\u0002f\u0003?I1!!\tg\u0005\u001d\u0011un\u001c7fC:Dq!!\n\u0001\t\u0003\n9#\u0001\u0004sK\u0006$WM\u001d\u000b\u0003\u0003S\u0001RALA\u0016\u001bzK1!!\f\u0013\u000551U-\u0019;ve\u0016\u0014V-\u00193fe\"9\u0011\u0011\u0007\u0001\u0005B\u0005M\u0012!C4fi\n{WO\u001c3t)\t\t)\u0004\u0005\u0003\u00028\u0005\u0005SBAA\u001d\u0015\u0011\tY$!\u0010\u0002\u0007)$8OC\u0002\u0002@Q\t\u0001bZ3p[\u0016$(/_\u0005\u0005\u0003\u0007\nID\u0001\nSK\u001a,'/\u001a8dK\u0012,eN^3m_B,\u0007bBA$\u0001\u0011\u0005\u0013\u0011J\u0001\tO\u0016$8i\\;oiR\u0011\u00111\n\t\u0004K\u00065\u0013bAA(M\n\u0019\u0011J\u001c;\t\u000f\u0005M\u0003\u0001\"\u0011\u0002J\u0005!1/\u001b>f\u000f\u001d\t9F\u0001E\u0001\u00033\n\u0001dR3p\u001b\u0016\u001c\u0018MR3biV\u0014XmQ8mY\u0016\u001cG/[8o!\r)\u00131\f\u0004\u0007\u0003\tA\t!!\u0018\u0014\t\u0005m\u0013q\f\t\u0004K\u0006\u0005\u0014bAA2M\n1\u0011I\\=SK\u001aDq\u0001NA.\t\u0003\t9\u0007\u0006\u0002\u0002Z!Q\u00111NA.\u0005\u0004%I!!\u001c\u0002\u000b=tW-\u00169\u0016\u0005\u0005=\u0004cA\u001f\u0002r%\u0019\u00111\u000f \u0003\u0015\u0005#x.\\5d\u0019>tw\rC\u0005\u0002x\u0005m\u0003\u0015!\u0003\u0002p\u00051qN\\3Va\u0002B\u0001\"a\u001f\u0002\\\u0011\u0005\u0011QP\u0001\u0007]\u0016DH/\u00133\u0016\u0005\u0005-\u0001")
public class GeoMesaFeatureCollection
extends DataFeatureCollection
implements LazyLogging {
    private final GeoMesaFeatureSource source;
    private final Query query;
    private final AtomicBoolean open;
    private final Logger logger;
    private volatile boolean bitmap$0;

    public static String nextId() {
        return GeoMesaFeatureCollection$.MODULE$.nextId();
    }

    private Logger logger$lzycompute() {
        GeoMesaFeatureCollection geoMesaFeatureCollection = this;
        synchronized (geoMesaFeatureCollection) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public GeoMesaFeatureSource source() {
        return this.source;
    }

    public Query query() {
        return this.query;
    }

    private AtomicBoolean open() {
        return this.open;
    }

    public SimpleFeatureType getSchema() {
        Object object = this.open().get() ? BoxedUnit.UNIT : this.source().runner().configureQuery(this.source().getSchema(), this.query());
        return QueryHints$.MODULE$.RichHints(this.query().getHints()).getReturnSft();
    }

    /*
     * WARNING - void declaration
     */
    public Iterator<SimpleFeature> openIterator() {
        void var1_1;
        Iterator iter = super.openIterator();
        this.open().set(true);
        return var1_1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void accepts(FeatureVisitor visitor, ProgressListener progress) {
        MaxVisitor maxVisitor;
        MinVisitor minVisitor;
        FeatureVisitor featureVisitor = visitor;
        if (featureVisitor instanceof BoundsVisitor) {
            BoundsVisitor boundsVisitor = (BoundsVisitor)featureVisitor;
            GeoMesaStats qual$1 = ((package.HasGeoMesaStats)this.source().ds()).stats();
            SimpleFeatureType x$2 = this.source().getSchema();
            Filter x$3 = this.query().getFilter();
            boolean x$4 = qual$1.getBounds$default$3();
            boundsVisitor.reset((Envelope)qual$1.getBounds(x$2, x$3, x$4));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        } else if (featureVisitor instanceof MinVisitor && (minVisitor = (MinVisitor)featureVisitor).getExpression() instanceof PropertyName) {
            Some some;
            Tuple2 tuple2;
            String attribute = ((PropertyName)minVisitor.getExpression()).getPropertyName();
            Option option = this.org$locationtech$geomesa$index$geotools$GeoMesaFeatureCollection$$minMax(attribute, false).orElse((Function0)new Serializable(this, attribute){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ GeoMesaFeatureCollection $outer;
                private final String attribute$1;

                public final Option<Tuple2<Object, Object>> apply() {
                    return this.$outer.org$locationtech$geomesa$index$geotools$GeoMesaFeatureCollection$$minMax(this.attribute$1, true);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.attribute$1 = attribute$1;
                }
            });
            if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).x()) != null) {
                Object min2 = tuple2._1();
                minVisitor.setValue(min2);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                super.accepts(visitor, progress);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        } else if (featureVisitor instanceof MaxVisitor && (maxVisitor = (MaxVisitor)featureVisitor).getExpression() instanceof PropertyName) {
            Some some;
            Tuple2 tuple2;
            String attribute = ((PropertyName)maxVisitor.getExpression()).getPropertyName();
            Option option = this.org$locationtech$geomesa$index$geotools$GeoMesaFeatureCollection$$minMax(attribute, false).orElse((Function0)new Serializable(this, attribute){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ GeoMesaFeatureCollection $outer;
                private final String attribute$2;

                public final Option<Tuple2<Object, Object>> apply() {
                    return this.$outer.org$locationtech$geomesa$index$geotools$GeoMesaFeatureCollection$$minMax(this.attribute$2, true);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.attribute$2 = attribute$2;
                }
            });
            if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).x()) != null) {
                Object max2 = tuple2._2();
                maxVisitor.setValue(max2);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                super.accepts(visitor, progress);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        } else if (featureVisitor instanceof GeoMesaProcessVisitor) {
            GeoMesaProcessVisitor geoMesaProcessVisitor = (GeoMesaProcessVisitor)featureVisitor;
            geoMesaProcessVisitor.execute(this.source(), this.query());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        } else {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Using unoptimized method for visiting '{}'", new Object[]{featureVisitor.getClass().getName()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            super.accepts(visitor, progress);
            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
        }
    }

    public Option<Tuple2<Object, Object>> org$locationtech$geomesa$index$geotools$GeoMesaFeatureCollection$$minMax(String attribute, boolean exact) {
        return ((package.HasGeoMesaStats)this.source().ds()).stats().getAttributeBounds(this.source().getSchema(), attribute, this.query().getFilter(), exact).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(MinMax<Object> x$1) {
                return x$1.bounds();
            }
        });
    }

    public FeatureReader<SimpleFeatureType, SimpleFeature> reader() {
        return this.source().ds().getFeatureReader(this.query(), Transaction.AUTO_COMMIT);
    }

    public ReferencedEnvelope getBounds() {
        return this.source().getBounds(this.query());
    }

    public int getCount() {
        Object object = this.open().get() ? BoxedUnit.UNIT : this.source().runner().configureQuery(this.source().getSchema(), this.query());
        return this.source().getCount(this.query());
    }

    public int size() {
        int count = this.getCount();
        return count < 0 ? 0 : count;
    }

    public GeoMesaFeatureCollection(GeoMesaFeatureSource source, Query query) {
        this.source = source;
        this.query = query;
        super(GeoMesaFeatureCollection$.MODULE$.nextId());
        LazyLogging.class.$init$((LazyLogging)this);
        this.open = new AtomicBoolean(false);
    }
}

