/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.index.z3;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.time.ZonedDateTime;
import java.util.Date;
import org.geotools.factory.Hints;
import org.locationtech.geomesa.curve.BinnedTime;
import org.locationtech.geomesa.curve.BinnedTime$;
import org.locationtech.geomesa.curve.Z3SFC;
import org.locationtech.geomesa.curve.Z3SFC$;
import org.locationtech.geomesa.filter.Bounds;
import org.locationtech.geomesa.filter.FilterHelper$;
import org.locationtech.geomesa.filter.FilterValues;
import org.locationtech.geomesa.filter.FilterValues$;
import org.locationtech.geomesa.index.api.IndexKeySpace;
import org.locationtech.geomesa.index.api.IndexKeySpace$class;
import org.locationtech.geomesa.index.api.ShardStrategy;
import org.locationtech.geomesa.index.api.WritableFeature;
import org.locationtech.geomesa.index.api.package;
import org.locationtech.geomesa.index.api.package$ByteRange$;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.index.conf.QueryProperties$;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStoreFactory;
import org.locationtech.geomesa.index.index.z3.Z3IndexKeySpace$;
import org.locationtech.geomesa.index.index.z3.package;
import org.locationtech.geomesa.index.utils.Explainer;
import org.locationtech.geomesa.utils.geotools.GeometryUtils$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.index.ByteArrays$;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.sfcurve.IndexRange;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.GenTraversable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.VolatileByteRef;
import scala.util.Right;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\t%e\u0001B\u0001\u0003\u00019\u0011qBW\u001aJ]\u0012,\u0007pS3z'B\f7-\u001a\u0006\u0003\u0007\u0011\t!A_\u001a\u000b\u0005\u00151\u0011!B5oI\u0016D(BA\u0003\b\u0015\tA\u0011\"A\u0004hK>lWm]1\u000b\u0005)Y\u0011\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"\u0001\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001yQC\n\t\u0003!Mi\u0011!\u0005\u0006\u0002%\u0005)1oY1mC&\u0011A#\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\tYI2dI\u0007\u0002/)\u0011\u0001DB\u0001\u0004CBL\u0017B\u0001\u000e\u0018\u00055Ie\u000eZ3y\u0017\u0016L8\u000b]1dKB\u0011A\u0004\t\b\u0003;yi\u0011AA\u0005\u0003?\t\tq\u0001]1dW\u0006<W-\u0003\u0002\"E\ti!lM%oI\u0016Dh+\u00197vKNT!a\b\u0002\u0011\u0005q!\u0013BA\u0013#\u0005)Q6'\u00138eKb\\U-\u001f\t\u0003O9j\u0011\u0001\u000b\u0006\u0003S)\nAb]2bY\u0006dwnZ4j]\u001eT!a\u000b\u0017\u0002\u0011QL\b/Z:bM\u0016T\u0011!L\u0001\u0004G>l\u0017BA\u0018)\u0005-a\u0015M_=M_\u001e<\u0017N\\4\t\u0011E\u0002!Q1A\u0005\u0002I\n1a\u001d4u+\u0005\u0019\u0004C\u0001\u001b<\u001b\u0005)$B\u0001\u001c8\u0003\u0019\u0019\u0018.\u001c9mK*\u0011\u0001(O\u0001\bM\u0016\fG/\u001e:f\u0015\tQ4\"A\u0004pa\u0016tw-[:\n\u0005q*$!E*j[BdWMR3biV\u0014X\rV=qK\"Aa\b\u0001B\u0001B\u0003%1'\u0001\u0003tMR\u0004\u0003\u0002\u0003!\u0001\u0005\u000b\u0007I\u0011A!\u0002\u0011MD\u0017M\u001d3j]\u001e,\u0012A\u0011\t\u0003-\rK!\u0001R\f\u0003\u001bMC\u0017M\u001d3TiJ\fG/Z4z\u0011!1\u0005A!A!\u0002\u0013\u0011\u0015!C:iCJ$\u0017N\\4!\u0011!A\u0005A!A!\u0002\u0013I\u0015!C4f_64\u0015.\u001a7e!\tQUJ\u0004\u0002\u0011\u0017&\u0011A*E\u0001\u0007!J,G-\u001a4\n\u00059{%AB*ue&twM\u0003\u0002M#!A\u0011\u000b\u0001B\u0001B\u0003%\u0011*\u0001\u0005ei\u001e4\u0015.\u001a7e\u0011\u0015\u0019\u0006\u0001\"\u0001U\u0003\u0019a\u0014N\\5u}Q)QKV,Y3B\u0011Q\u0004\u0001\u0005\u0006cI\u0003\ra\r\u0005\u0006\u0001J\u0003\rA\u0011\u0005\u0006\u0011J\u0003\r!\u0013\u0005\u0006#J\u0003\r!\u0013\u0005\b7\u0002\u0011\r\u0011\"\u0005]\u0003\r\u0019hmY\u000b\u0002;B\u0011a,Y\u0007\u0002?*\u0011\u0001mB\u0001\u0006GV\u0014h/Z\u0005\u0003E~\u0013QAW\u001aT\r\u000eCa\u0001\u001a\u0001!\u0002\u0013i\u0016\u0001B:gG\u0002BqA\u001a\u0001C\u0002\u0013Eq-A\u0005hK>l\u0017J\u001c3fqV\t\u0001\u000e\u0005\u0002\u0011S&\u0011!.\u0005\u0002\u0004\u0013:$\bB\u00027\u0001A\u0003%\u0001.\u0001\u0006hK>l\u0017J\u001c3fq\u0002BqA\u001c\u0001C\u0002\u0013Eq-\u0001\u0005ei\u001eLe\u000eZ3y\u0011\u0019\u0001\b\u0001)A\u0005Q\u0006IA\r^4J]\u0012,\u0007\u0010\t\u0005\be\u0002\u0011\r\u0011\"\u0005t\u0003-!\u0018.\\3U_&sG-\u001a=\u0016\u0003Q\u00042!^A\u0004\u001d\r1\u00181\u0001\b\u0004o\u0006\u0005aB\u0001=\u0000\u001d\tIhP\u0004\u0002{{6\t1P\u0003\u0002}\u001b\u00051AH]8pizJ\u0011\u0001D\u0005\u0003\u0015-I!\u0001C\u0005\n\u0005\u0001<\u0011bAA\u0003?\u0006Q!)\u001b8oK\u0012$\u0016.\\3\n\t\u0005%\u00111\u0002\u0002\u0011)&lW\rV8CS:tW\r\u001a+j[\u0016T1!!\u0002`\u0011\u001d\ty\u0001\u0001Q\u0001\nQ\fA\u0002^5nKR{\u0017J\u001c3fq\u0002B\u0011\"a\u0005\u0001\u0005\u0004%I!!\u0006\u0002\u0017\u0011\fG/\u001a+p\u0013:$W\r_\u000b\u0003\u0003/\u0001B!!\u0007\u0002\u001c9\u0019a,a\u0001\n\t\u0005u\u00111\u0002\u0002\u0011\t\u0006$X\rV8CS:tW\r\u001a+j[\u0016D\u0001\"!\t\u0001A\u0003%\u0011qC\u0001\rI\u0006$X\rV8J]\u0012,\u0007\u0010\t\u0005\n\u0003K\u0001!\u0019!C\u0005\u0003O\tQBY8v]\u0012\u001cHk\u001c#bi\u0016\u001cXCAA\u0015!\u001d\u0001\u00121FA\u0018\u0003\u0017J1!!\f\u0012\u0005%1UO\\2uS>t\u0017\u0007E\u0004\u0011\u0003c\t)$!\u000e\n\u0007\u0005M\u0012C\u0001\u0004UkBdWM\r\t\u0006!\u0005]\u00121H\u0005\u0004\u0003s\t\"AB(qi&|g\u000e\u0005\u0003\u0002>\u0005\u001dSBAA \u0015\u0011\t\t%a\u0011\u0002\tQLW.\u001a\u0006\u0003\u0003\u000b\nAA[1wC&!\u0011\u0011JA \u00055QvN\\3e\t\u0006$X\rV5nKB9\u0001#!\r\u0002<\u0005m\u0002\u0002CA(\u0001\u0001\u0006I!!\u000b\u0002\u001d\t|WO\u001c3t)>$\u0015\r^3tA!I\u00111\u000b\u0001C\u0002\u0013\u0005\u0013QK\u0001\u000bCR$(/\u001b2vi\u0016\u001cXCAA,!\u0015\tI&!\u0019J\u001d\u0011\tY&a\u0018\u000f\u0007i\fi&C\u0001\u0013\u0013\ty\u0012#\u0003\u0003\u0002d\u0005\u0015$aA*fc*\u0011q$\u0005\u0005\t\u0003S\u0002\u0001\u0015!\u0003\u0002X\u0005Y\u0011\r\u001e;sS\n,H/Z:!\u0011%\ti\u0007\u0001b\u0001\n\u0003\ny'\u0001\nj]\u0012,\u0007pS3z\u0005f$X\rT3oORDWCAA9!\u001d\tI&a\u001d\u0002x!LA!!\u001e\u0002f\t)!+[4iiBA\u0001#!\u001f\u0002~!D\u0007.C\u0002\u0002|E\u0011\u0011BR;oGRLwN\\\u001a\u0011\u000bA\ty(a!\n\u0007\u0005\u0005\u0015CA\u0003BeJ\f\u0017\u0010E\u0002\u0011\u0003\u000bK1!a\"\u0012\u0005\u0011\u0011\u0015\u0010^3\t\u0011\u0005-\u0005\u0001)A\u0005\u0003c\n1#\u001b8eKb\\U-\u001f\"zi\u0016dUM\\4uQ\u0002B\u0011\"a$\u0001\u0005\u0004%\t%!%\u0002\u000fMD\u0017M]5oOV\u0011\u0011Q\u0010\u0005\t\u0003+\u0003\u0001\u0015!\u0003\u0002~\u0005A1\u000f[1sS:<\u0007\u0005C\u0004\u0002\u001a\u0002!\t%a'\u0002\u0015Q|\u0017J\u001c3fq.+\u0017\u0010\u0006\u0006\u0002\u001e\u0006E\u00161XA`\u0003\u0007\u0004R!a(\u0002,\u000erA!!)\u0002*:!\u00111UAT\u001d\r9\u0018QU\u0005\u0003\u000b\u001dI!\u0001\u0007\u0004\n\u0005}9\u0012\u0002BAW\u0003_\u00131BU8x\u0017\u0016Lh+\u00197vK*\u0011qd\u0006\u0005\t\u0003g\u000b9\n1\u0001\u00026\u0006AqO]5uC\ndW\rE\u0002\u0017\u0003oK1!!/\u0018\u0005=9&/\u001b;bE2,g)Z1ukJ,\u0007\u0002CA_\u0003/\u0003\r!! \u0002\tQLWM\u001d\u0005\t\u0003\u0003\f9\n1\u0001\u0002~\u0005\u0011\u0011\u000e\u001a\u0005\u000b\u0003\u000b\f9\n%AA\u0002\u0005\u001d\u0017a\u00027f]&,g\u000e\u001e\t\u0004!\u0005%\u0017bAAf#\t9!i\\8mK\u0006t\u0007bBAh\u0001\u0011\u0005\u0013\u0011[\u0001\u000fO\u0016$\u0018J\u001c3fqZ\u000bG.^3t)\u0015Y\u00121[Aq\u0011!\t).!4A\u0002\u0005]\u0017A\u00024jYR,'\u000f\u0005\u0003\u0002Z\u0006uWBAAn\u0015\r\t).O\u0005\u0005\u0003?\fYN\u0001\u0004GS2$XM\u001d\u0005\t\u0003G\fi\r1\u0001\u0002f\u00069Q\r\u001f9mC&t\u0007\u0003BAt\u0003[l!!!;\u000b\u0007\u0005-h!A\u0003vi&d7/\u0003\u0003\u0002p\u0006%(!C#ya2\f\u0017N\\3s\u0011\u001d\t\u0019\u0010\u0001C!\u0003k\f\u0011bZ3u%\u0006tw-Z:\u0015\r\u0005](1\u0001B\u0004!\u0019\tI&!?\u0002~&!\u00111`A3\u0005!IE/\u001a:bi>\u0014\b#BAP\u0003\u007f\u001c\u0013\u0002\u0002B\u0001\u0003_\u0013\u0011bU2b]J\u000bgnZ3\t\u000f\t\u0015\u0011\u0011\u001fa\u00017\u00051a/\u00197vKND\u0011B!\u0003\u0002rB\u0005\t\u0019\u00015\u0002\u00155,H\u000e^5qY&,'\u000fC\u0004\u0003\u000e\u0001!\tEa\u0004\u0002\u001b\u001d,GOU1oO\u0016\u0014\u0015\u0010^3t)\u0019\u0011\tB!\u0007\u0003\u001eA1\u0011\u0011LA}\u0005'\u0001B!a(\u0003\u0016%!!qCAX\u0005%\u0011\u0015\u0010^3SC:<W\r\u0003\u0005\u0003\u001c\t-\u0001\u0019AA|\u0003\u0019\u0011\u0018M\\4fg\"Q\u0011Q\u0018B\u0006!\u0003\u0005\r!a2\t\u000f\t\u0005\u0002\u0001\"\u0011\u0003$\u0005iQo]3Gk2dg)\u001b7uKJ$\u0002\"a2\u0003&\t%\"Q\t\u0005\t\u0005\u000b\u0011y\u00021\u0001\u0003(A!\u0001#a\u000e\u001c\u0011!\u0011YCa\bA\u0002\t5\u0012AB2p]\u001aLw\rE\u0003\u0011\u0003o\u0011y\u0003\u0005\u0003\u00032\t}b\u0002\u0002B\u001a\u0005sqA!a)\u00036%\u0019!q\u0007\u0004\u0002\u0011\u001d,w\u000e^8pYNLAAa\u000f\u0003>\u00059r)Z8NKN\fG)\u0019;b'R|'/\u001a$bGR|'/\u001f\u0006\u0004\u0005o1\u0011\u0002\u0002B!\u0005\u0007\u0012acR3p\u001b\u0016\u001c\u0018\rR1uCN#xN]3D_:4\u0017n\u001a\u0006\u0005\u0005w\u0011i\u0004\u0003\u0005\u0003H\t}\u0001\u0019\u0001B%\u0003\u0015A\u0017N\u001c;t!\u0011\u0011YEa\u0015\u000e\u0005\t5#\u0002\u0002B(\u0005#\nqAZ1di>\u0014\u0018PC\u0002\u00038-IAA!\u0016\u0003N\t)\u0001*\u001b8ug\u001e9!\u0011\f\u0002\t\u0002\tm\u0013a\u0004.4\u0013:$W\r_&fsN\u0003\u0018mY3\u0011\u0007u\u0011iF\u0002\u0004\u0002\u0005!\u0005!qL\n\u0006\u0005;z!\u0011\r\t\u0007\u0005G\u0012IgG\u0012\u000f\t\u0005\u0005&QM\u0005\u0004\u0005O:\u0012!D%oI\u0016D8*Z=Ta\u0006\u001cW-\u0003\u0003\u0003l\t5$\u0001F%oI\u0016D8*Z=Ta\u0006\u001cWMR1di>\u0014\u0018PC\u0002\u0003h]Aqa\u0015B/\t\u0003\u0011\t\b\u0006\u0002\u0003\\!A!Q\u000fB/\t\u0003\u00129(\u0001\u0005tkB\u0004xN\u001d;t)\u0019\t9M!\u001f\u0003|!1\u0011Ga\u001dA\u0002MB\u0001\"a\u0015\u0003t\u0001\u0007\u0011q\u000b\u0005\t\u0005\u007f\u0012i\u0006\"\u0011\u0003\u0002\u0006)\u0011\r\u001d9msR9QKa!\u0003\u0006\n\u001d\u0005BB\u0019\u0003~\u0001\u00071\u0007\u0003\u0005\u0002T\tu\u0004\u0019AA,\u0011!\tiL! A\u0002\u0005\u001d\u0007")
public class Z3IndexKeySpace
implements IndexKeySpace<package.Z3IndexValues, package.Z3IndexKey>,
LazyLogging {
    private final SimpleFeatureType sft;
    private final ShardStrategy sharding;
    public final String org$locationtech$geomesa$index$index$z3$Z3IndexKeySpace$$geomField;
    public final String org$locationtech$geomesa$index$index$z3$Z3IndexKeySpace$$dtgField;
    private final Z3SFC sfc;
    private final int geomIndex;
    private final int dtgIndex;
    private final Function1<Object, BinnedTime> timeToIndex;
    private final Function1<ZonedDateTime, BinnedTime> org$locationtech$geomesa$index$index$z3$Z3IndexKeySpace$$dateToIndex;
    private final Function1<Tuple2<Option<ZonedDateTime>, Option<ZonedDateTime>>, Tuple2<ZonedDateTime, ZonedDateTime>> org$locationtech$geomesa$index$index$z3$Z3IndexKeySpace$$boundsToDates;
    private final Seq<String> attributes;
    private final Right<Function3<byte[], Object, Object, Object>, Object> indexKeyByteLength;
    private final byte[] sharing;
    private final Logger logger;
    private volatile boolean bitmap$0;

    public static Z3IndexKeySpace apply(SimpleFeatureType simpleFeatureType, Seq<String> seq, boolean bl) {
        return Z3IndexKeySpace$.MODULE$.apply(simpleFeatureType, (Seq)seq, bl);
    }

    public static boolean supports(SimpleFeatureType simpleFeatureType, Seq<String> seq) {
        return Z3IndexKeySpace$.MODULE$.supports(simpleFeatureType, seq);
    }

    private Logger logger$lzycompute() {
        Z3IndexKeySpace z3IndexKeySpace = this;
        synchronized (z3IndexKeySpace) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public int getRanges$default$2() {
        return IndexKeySpace$class.getRanges$default$2(this);
    }

    @Override
    public boolean getRangeBytes$default$2() {
        return IndexKeySpace$class.getRangeBytes$default$2(this);
    }

    @Override
    public boolean toIndexKey$default$4() {
        return IndexKeySpace$class.toIndexKey$default$4(this);
    }

    @Override
    public SimpleFeatureType sft() {
        return this.sft;
    }

    @Override
    public ShardStrategy sharding() {
        return this.sharding;
    }

    public Z3SFC sfc() {
        return this.sfc;
    }

    public int geomIndex() {
        return this.geomIndex;
    }

    public int dtgIndex() {
        return this.dtgIndex;
    }

    public Function1<Object, BinnedTime> timeToIndex() {
        return this.timeToIndex;
    }

    public Function1<ZonedDateTime, BinnedTime> org$locationtech$geomesa$index$index$z3$Z3IndexKeySpace$$dateToIndex() {
        return this.org$locationtech$geomesa$index$index$z3$Z3IndexKeySpace$$dateToIndex;
    }

    public Function1<Tuple2<Option<ZonedDateTime>, Option<ZonedDateTime>>, Tuple2<ZonedDateTime, ZonedDateTime>> org$locationtech$geomesa$index$index$z3$Z3IndexKeySpace$$boundsToDates() {
        return this.org$locationtech$geomesa$index$index$z3$Z3IndexKeySpace$$boundsToDates;
    }

    @Override
    public Seq<String> attributes() {
        return this.attributes;
    }

    public Right<Function3<byte[], Object, Object, Object>, Object> indexKeyByteLength() {
        return this.indexKeyByteLength;
    }

    @Override
    public byte[] sharing() {
        return this.sharing;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public package.RowKeyValue<package.Z3IndexKey> toIndexKey(WritableFeature writable, byte[] tier, byte[] id, boolean lenient) {
        byte[] shard;
        long z;
        Tuple2 tuple2;
        Point geom = (Point)writable.getAttribute(this.geomIndex());
        if (geom == null) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Null geometry in feature ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{writable.feature().getID()})));
        }
        Date dtg = (Date)writable.getAttribute(this.dtgIndex());
        long time = dtg == null ? 0L : dtg.getTime();
        BinnedTime binnedTime = (BinnedTime)this.timeToIndex().apply((Object)BoxesRunTime.boxToLong((long)time));
        if (binnedTime == null) throw new MatchError((Object)binnedTime);
        short b = binnedTime.bin();
        long t = binnedTime.offset();
        Tuple2 tuple22 = tuple2 = new Tuple2((Object)BoxesRunTime.boxToShort((short)b), (Object)BoxesRunTime.boxToLong((long)t));
        short b2 = BoxesRunTime.unboxToShort((Object)tuple22._1());
        long t2 = tuple22._2$mcJ$sp();
        try {
            z = this.sfc().index(geom.getX(), geom.getY(), t2, lenient);
            shard = this.sharding().apply(writable);
        }
        catch (Throwable throwable) {
            void var6_6;
            void var5_5;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid z value from geometry/time: ", ",", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var5_5, var6_6})), e);
        }
        byte[] bytes = (byte[])Array$.MODULE$.ofDim(shard.length + 10 + id.length, ClassTag$.MODULE$.Byte());
        if (Predef$.MODULE$.byteArrayOps(shard).isEmpty()) {
            ByteArrays$.MODULE$.writeShort(b2, bytes, 0);
            ByteArrays$.MODULE$.writeLong(z, bytes, 2);
            System.arraycopy(id, 0, bytes, 10, id.length);
            return new package.SingleRowKeyValue<package.Z3IndexKey>(bytes, this.sharing(), shard, new package.Z3IndexKey(b2, z), tier, id, writable.values());
        } else {
            bytes[0] = BoxesRunTime.unboxToByte((Object)Predef$.MODULE$.byteArrayOps(shard).head());
            ByteArrays$.MODULE$.writeShort(b2, bytes, 1);
            ByteArrays$.MODULE$.writeLong(z, bytes, 3);
            System.arraycopy(id, 0, bytes, 11, id.length);
        }
        return new package.SingleRowKeyValue<package.Z3IndexKey>(bytes, this.sharing(), shard, new package.Z3IndexKey(b2, z), tier, id, writable.values());
    }

    @Override
    public package.Z3IndexValues getIndexValues(Filter filter2, Explainer explain) {
        FilterValues extracted = FilterHelper$.MODULE$.extractGeometries(filter2, this.org$locationtech$geomesa$index$index$z3$Z3IndexKeySpace$$geomField, true);
        FilterValues geometries = extracted.nonEmpty() ? extracted : new FilterValues((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Polygon[]{org.locationtech.geomesa.utils.geotools.package$.MODULE$.WholeWorldPolygon()})), FilterValues$.MODULE$.apply$default$2(), FilterValues$.MODULE$.apply$default$3());
        Filter x$11 = filter2;
        String x$12 = this.org$locationtech$geomesa$index$index$z3$Z3IndexKeySpace$$dtgField;
        boolean x$13 = true;
        boolean x$14 = FilterHelper$.MODULE$.extractIntervals$default$3();
        FilterValues intervals = FilterHelper$.MODULE$.extractIntervals(x$11, x$12, x$14, x$13);
        explain.apply((Function0<String>)new Serializable(this, geometries){
            public static final long serialVersionUID = 0L;
            private final FilterValues geometries$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Geometries: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.geometries$1}));
            }
            {
                this.geometries$1 = geometries$1;
            }
        });
        explain.apply((Function0<String>)new Serializable(this, intervals){
            public static final long serialVersionUID = 0L;
            private final FilterValues intervals$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Intervals: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.intervals$1}));
            }
            {
                this.intervals$1 = intervals$1;
            }
        });
        if (geometries.disjoint() || intervals.disjoint()) {
            explain.apply((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Disjoint geometries or dates extracted, short-circuiting to empty query";
                }
            });
            return new package.Z3IndexValues(this.sfc(), (FilterValues<Geometry>)geometries, (Seq<Tuple4<Object, Object, Object, Object>>)((Seq)Seq$.MODULE$.empty()), (FilterValues<Bounds<ZonedDateTime>>)intervals, (Map<Object, Seq<Tuple2<Object, Object>>>)Predef$.MODULE$.Map().empty(), (Seq<Tuple2<Object, Object>>)((Seq)Seq$.MODULE$.empty()));
        }
        int multiplier = BoxesRunTime.unboxToInt((Object)QueryProperties$.MODULE$.PolygonDecompMultiplier().toInt().get());
        int bits = BoxesRunTime.unboxToInt((Object)QueryProperties$.MODULE$.PolygonDecompBits().toInt().get());
        Seq xy = (Seq)geometries.values().flatMap((Function1)new Serializable(this, multiplier, bits){
            public static final long serialVersionUID = 0L;
            private final int multiplier$2;
            private final int bits$1;

            public final Seq<Tuple4<Object, Object, Object, Object>> apply(Geometry x$2) {
                return GeometryUtils$.MODULE$.bounds(x$2, this.multiplier$2, this.bits$1);
            }
            {
                this.multiplier$2 = multiplier$2;
                this.bits$1 = bits$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        long minTime = (long)this.sfc().time().min();
        long maxTime = (long)this.sfc().time().max();
        scala.collection.mutable.Map timesByBin = Map$.MODULE$.empty().withDefaultValue((Object)Seq$.MODULE$.empty());
        Builder unboundedBins = Seq$.MODULE$.newBuilder();
        intervals.foreach((Function1)new Serializable(this, minTime, maxTime, timesByBin, unboundedBins){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Z3IndexKeySpace $outer;
            private final long minTime$1;
            private final long maxTime$1;
            public final scala.collection.mutable.Map timesByBin$1;
            private final Builder unboundedBins$1;

            public final Object apply(Bounds<ZonedDateTime> interval) {
                Tuple2 tuple2 = (Tuple2)this.$outer.org$locationtech$geomesa$index$index$z3$Z3IndexKeySpace$$boundsToDates().apply((Object)interval.bounds());
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    ZonedDateTime lower = (ZonedDateTime)tuple2._1();
                    ZonedDateTime upper = (ZonedDateTime)tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)lower, (Object)upper);
                    ZonedDateTime lower2 = (ZonedDateTime)tuple23._1();
                    ZonedDateTime upper2 = (ZonedDateTime)tuple23._2();
                    BinnedTime binnedTime = (BinnedTime)this.$outer.org$locationtech$geomesa$index$index$z3$Z3IndexKeySpace$$dateToIndex().apply((Object)lower2);
                    if (binnedTime != null) {
                        Tuple2 tuple24;
                        short lb = binnedTime.bin();
                        long lt = binnedTime.offset();
                        Tuple2 tuple25 = tuple24 = new Tuple2((Object)BoxesRunTime.boxToShort((short)lb), (Object)BoxesRunTime.boxToLong((long)lt));
                        short lb2 = BoxesRunTime.unboxToShort((Object)tuple25._1());
                        long lt2 = tuple25._2$mcJ$sp();
                        BinnedTime binnedTime2 = (BinnedTime)this.$outer.org$locationtech$geomesa$index$index$z3$Z3IndexKeySpace$$dateToIndex().apply((Object)upper2);
                        if (binnedTime2 != null) {
                            BoxedUnit boxedUnit;
                            Tuple2 tuple26;
                            short ub = binnedTime2.bin();
                            long ut = binnedTime2.offset();
                            Tuple2 tuple27 = tuple26 = new Tuple2((Object)BoxesRunTime.boxToShort((short)ub), (Object)BoxesRunTime.boxToLong((long)ut));
                            short ub2 = BoxesRunTime.unboxToShort((Object)tuple27._1());
                            long ut2 = tuple27._2$mcJ$sp();
                            if (interval.isBoundedBothSides()) {
                                if (lb2 == ub2) {
                                    this.timesByBin$1.update((Object)BoxesRunTime.boxToShort((short)lb2), ((TraversableLike)this.timesByBin$1.apply((Object)BoxesRunTime.boxToShort((short)lb2))).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcJJ.sp(lt2, ut2)})), Seq$.MODULE$.canBuildFrom()));
                                    boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    this.timesByBin$1.update((Object)BoxesRunTime.boxToShort((short)lb2), ((TraversableLike)this.timesByBin$1.apply((Object)BoxesRunTime.boxToShort((short)lb2))).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcJJ.sp(lt2, this.maxTime$1)})), Seq$.MODULE$.canBuildFrom()));
                                    this.timesByBin$1.update((Object)BoxesRunTime.boxToShort((short)ub2), ((TraversableLike)this.timesByBin$1.apply((Object)BoxesRunTime.boxToShort((short)ub2))).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcJJ.sp(this.minTime$1, ut2)})), Seq$.MODULE$.canBuildFrom()));
                                    package$.MODULE$.Range().inclusive(lb2 + 1, ub2 - 1).foreach$mVc$sp((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ $anonfun$getIndexValues$4 $outer;

                                        public final void apply(int b) {
                                            this.apply$mcVI$sp(b);
                                        }

                                        public void apply$mcVI$sp(int b) {
                                            this.$outer.timesByBin$1.update((Object)BoxesRunTime.boxToShort((short)((short)b)), (Object)this.$outer.org$locationtech$geomesa$index$index$z3$Z3IndexKeySpace$$anonfun$$$outer().sfc().wholePeriod());
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                        }
                                    });
                                    boxedUnit = BoxedUnit.UNIT;
                                }
                            } else if (interval.lower().value().isDefined()) {
                                this.timesByBin$1.update((Object)BoxesRunTime.boxToShort((short)lb2), ((TraversableLike)this.timesByBin$1.apply((Object)BoxesRunTime.boxToShort((short)lb2))).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcJJ.sp(lt2, this.maxTime$1)})), Seq$.MODULE$.canBuildFrom()));
                                boxedUnit = this.unboundedBins$1.$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToShort((short)((short)(lb2 + 1))), (Object)BoxesRunTime.boxToShort((short)Short.MAX_VALUE)));
                            } else if (interval.upper().value().isDefined()) {
                                this.timesByBin$1.update((Object)BoxesRunTime.boxToShort((short)ub2), ((TraversableLike)this.timesByBin$1.apply((Object)BoxesRunTime.boxToShort((short)ub2))).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcJJ.sp(this.minTime$1, ut2)})), Seq$.MODULE$.canBuildFrom()));
                                boxedUnit = this.unboundedBins$1.$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToShort((short)0), (Object)BoxesRunTime.boxToShort((short)((short)(ub2 - 1)))));
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            return boxedUnit;
                        }
                        throw new MatchError((Object)binnedTime2);
                    }
                    throw new MatchError((Object)binnedTime);
                }
                throw new MatchError((Object)tuple2);
            }

            public /* synthetic */ Z3IndexKeySpace org$locationtech$geomesa$index$index$z3$Z3IndexKeySpace$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.minTime$1 = minTime$1;
                this.maxTime$1 = maxTime$1;
                this.timesByBin$1 = timesByBin$1;
                this.unboundedBins$1 = unboundedBins$1;
            }
        });
        return new package.Z3IndexValues(this.sfc(), (FilterValues<Geometry>)geometries, (Seq<Tuple4<Object, Object, Object, Object>>)xy, (FilterValues<Bounds<ZonedDateTime>>)intervals, (Map<Object, Seq<Tuple2<Object, Object>>>)timesByBin.toMap(Predef$.MODULE$.$conforms()), (Seq<Tuple2<Object, Object>>)((Seq)unboundedBins.result()));
    }

    @Override
    public Iterator<package.ScanRange<package.Z3IndexKey>> getRanges(package.Z3IndexValues values2, int multiplier) {
        ObjectRef wholePeriodRanges$lzy = ObjectRef.zero();
        VolatileByteRef bitmap$0 = VolatileByteRef.create((byte)0);
        package.Z3IndexValues z3IndexValues = values2;
        if (z3IndexValues != null) {
            Tuple4 tuple4;
            Z3SFC z3 = z3IndexValues.sfc();
            Seq<Tuple4<Object, Object, Object, Object>> xy = z3IndexValues.spatialBounds();
            Map<Object, Seq<Tuple2<Object, Object>>> timesByBin = z3IndexValues.temporalBounds();
            Seq<Tuple2<Object, Object>> unboundedBins = z3IndexValues.temporalUnbounded();
            Tuple4 tuple42 = tuple4 = new Tuple4((Object)z3, xy, timesByBin, unboundedBins);
            Z3SFC z32 = (Z3SFC)tuple42._1();
            Seq xy2 = (Seq)tuple42._2();
            Map timesByBin2 = (Map)tuple42._3();
            Seq unboundedBins2 = (Seq)tuple42._4();
            Option target = QueryProperties$.MODULE$.ScanRangesTarget().option().map((Function1)new Serializable(this, multiplier, timesByBin2){
                public static final long serialVersionUID = 0L;
                private final int multiplier$1;
                private final Map timesByBin$2;

                public final int apply(String t) {
                    return scala.math.package$.MODULE$.max(1, this.timesByBin$2.isEmpty() ? new StringOps(Predef$.MODULE$.augmentString(t)).toInt() : new StringOps(Predef$.MODULE$.augmentString(t)).toInt() / this.timesByBin$2.size() / this.multiplier$1);
                }
                {
                    this.multiplier$1 = multiplier$1;
                    this.timesByBin$2 = timesByBin$2;
                }
            });
            Iterator bounded = timesByBin2.iterator().flatMap((Function1)new Serializable(this, z32, xy2, target, wholePeriodRanges$lzy, bitmap$0){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Z3IndexKeySpace $outer;
                private final Z3SFC z3$1;
                private final Seq xy$1;
                private final Option target$1;
                private final ObjectRef wholePeriodRanges$lzy$1;
                private final VolatileByteRef bitmap$0$1;

                public final Seq<package.BoundedRange<package.Z3IndexKey>> apply(Tuple2<Object, Seq<Tuple2<Object, Object>>> x0$1) {
                    Tuple2<Object, Seq<Tuple2<Object, Object>>> tuple2 = x0$1;
                    if (tuple2 != null) {
                        short bin = BoxesRunTime.unboxToShort((Object)tuple2._1());
                        Seq times = (Seq)tuple2._2();
                        Seq zs = times == this.z3$1.wholePeriod() ? this.$outer.org$locationtech$geomesa$index$index$z3$Z3IndexKeySpace$$wholePeriodRanges$1(this.z3$1, this.xy$1, this.target$1, this.wholePeriodRanges$lzy$1, this.bitmap$0$1) : this.$outer.org$locationtech$geomesa$index$index$z3$Z3IndexKeySpace$$toZRanges$1(times, this.z3$1, this.xy$1, this.target$1);
                        Seq seq = (Seq)zs.map((Function1)new Serializable(this, bin){
                            public static final long serialVersionUID = 0L;
                            private final short bin$1;

                            public final package.BoundedRange<package.Z3IndexKey> apply(IndexRange range2) {
                                return new package.BoundedRange<package.Z3IndexKey>(new package.Z3IndexKey(this.bin$1, range2.lower()), new package.Z3IndexKey(this.bin$1, range2.upper()));
                            }
                            {
                                this.bin$1 = bin$1;
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                        return seq;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.z3$1 = z3$1;
                    this.xy$1 = xy$1;
                    this.target$1 = target$1;
                    this.wholePeriodRanges$lzy$1 = wholePeriodRanges$lzy$1;
                    this.bitmap$0$1 = bitmap$0$1;
                }
            });
            Iterator unbounded = unboundedBins2.iterator().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Z3IndexKeySpace $outer;

                public final Product apply(Tuple2<Object, Object> x0$2) {
                    Tuple2<Object, Object> tuple2;
                    block9: {
                        Product product;
                        block6: {
                            BoxedUnit boxedUnit;
                            block8: {
                                block7: {
                                    block5: {
                                        tuple2 = x0$2;
                                        if (tuple2 == null) break block5;
                                        short s = BoxesRunTime.unboxToShort((Object)tuple2._1());
                                        short s2 = BoxesRunTime.unboxToShort((Object)tuple2._2());
                                        if (0 != s || Short.MAX_VALUE != s2) break block5;
                                        product = new package.UnboundedRange<package.Z3IndexKey>(new package.Z3IndexKey(0, 0L));
                                        break block6;
                                    }
                                    if (tuple2 == null) break block7;
                                    short lower = BoxesRunTime.unboxToShort((Object)tuple2._1());
                                    short s = BoxesRunTime.unboxToShort((Object)tuple2._2());
                                    if (Short.MAX_VALUE != s) break block7;
                                    product = new package.LowerBoundedRange<package.Z3IndexKey>(new package.Z3IndexKey(lower, 0L));
                                    break block6;
                                }
                                if (tuple2 == null) break block8;
                                short s = BoxesRunTime.unboxToShort((Object)tuple2._1());
                                short upper = BoxesRunTime.unboxToShort((Object)tuple2._2());
                                if (0 != s) break block8;
                                product = new package.UpperBoundedRange<package.Z3IndexKey>(new package.Z3IndexKey(upper, Long.MAX_VALUE));
                                break block6;
                            }
                            if (tuple2 == null) break block9;
                            short lower = BoxesRunTime.unboxToShort((Object)tuple2._1());
                            short upper = BoxesRunTime.unboxToShort((Object)tuple2._2());
                            if (this.$outer.logger().underlying().isErrorEnabled()) {
                                this.$outer.logger().underlying().error("Unexpected unbounded bin endpoints: {}:{}", new Object[]{BoxesRunTime.boxToShort((short)lower), BoxesRunTime.boxToShort((short)upper)});
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            product = new package.UnboundedRange<package.Z3IndexKey>(new package.Z3IndexKey(0, 0L));
                        }
                        return product;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            return bounded.$plus$plus((Function0)new Serializable(this, unbounded){
                public static final long serialVersionUID = 0L;
                private final Iterator unbounded$1;

                public final Iterator<Product> apply() {
                    return this.unbounded$1;
                }
                {
                    this.unbounded$1 = unbounded$1;
                }
            });
        }
        throw new MatchError((Object)z3IndexValues);
    }

    @Override
    public Iterator<package.ByteRange> getRangeBytes(Iterator<package.ScanRange<package.Z3IndexKey>> ranges, boolean tier) {
        return this.sharding().length() == 0 ? ranges.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final package.ByteRange apply(package.ScanRange<package.Z3IndexKey> x0$3) {
                package.ScanRange<package.Z3IndexKey> scanRange;
                block6: {
                    package.BoundedByteRange boundedByteRange;
                    block3: {
                        block5: {
                            block4: {
                                block2: {
                                    scanRange = x0$3;
                                    if (!(scanRange instanceof package.BoundedRange)) break block2;
                                    package.BoundedRange boundedRange = (package.BoundedRange)scanRange;
                                    package.Z3IndexKey lo = (package.Z3IndexKey)boundedRange.lower();
                                    package.Z3IndexKey hi = (package.Z3IndexKey)boundedRange.upper();
                                    boundedByteRange = new package.BoundedByteRange(ByteArrays$.MODULE$.toBytes(lo.bin(), lo.z()), ByteArrays$.MODULE$.toBytesFollowingPrefix(hi.bin(), hi.z()));
                                    break block3;
                                }
                                if (!(scanRange instanceof package.LowerBoundedRange)) break block4;
                                package.LowerBoundedRange lowerBoundedRange = (package.LowerBoundedRange)scanRange;
                                package.Z3IndexKey lo = (package.Z3IndexKey)lowerBoundedRange.lower();
                                boundedByteRange = new package.BoundedByteRange(ByteArrays$.MODULE$.toBytes(lo.bin(), lo.z()), package$ByteRange$.MODULE$.UnboundedUpperRange());
                                break block3;
                            }
                            if (!(scanRange instanceof package.UpperBoundedRange)) break block5;
                            package.UpperBoundedRange upperBoundedRange = (package.UpperBoundedRange)scanRange;
                            package.Z3IndexKey hi = (package.Z3IndexKey)upperBoundedRange.upper();
                            boundedByteRange = new package.BoundedByteRange(package$ByteRange$.MODULE$.UnboundedLowerRange(), ByteArrays$.MODULE$.toBytesFollowingPrefix(hi.bin(), hi.z()));
                            break block3;
                        }
                        if (!(scanRange instanceof package.UnboundedRange)) break block6;
                        boundedByteRange = new package.BoundedByteRange(package$ByteRange$.MODULE$.UnboundedLowerRange(), package$ByteRange$.MODULE$.UnboundedUpperRange());
                    }
                    return boundedByteRange;
                }
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected range type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{scanRange})));
            }
        }) : ranges.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Z3IndexKeySpace $outer;

            public final GenTraversableOnce<package.ByteRange> apply(package.ScanRange<package.Z3IndexKey> x0$4) {
                package.ScanRange<package.Z3IndexKey> scanRange;
                block6: {
                    GenTraversable genTraversable;
                    block3: {
                        block5: {
                            block4: {
                                block2: {
                                    scanRange = x0$4;
                                    if (!(scanRange instanceof package.BoundedRange)) break block2;
                                    package.BoundedRange boundedRange = (package.BoundedRange)scanRange;
                                    package.Z3IndexKey lo = (package.Z3IndexKey)boundedRange.lower();
                                    package.Z3IndexKey hi = (package.Z3IndexKey)boundedRange.upper();
                                    byte[] lower = ByteArrays$.MODULE$.toBytes(lo.bin(), lo.z());
                                    byte[] upper = ByteArrays$.MODULE$.toBytesFollowingPrefix(hi.bin(), hi.z());
                                    genTraversable = (GenTraversableOnce)this.$outer.sharding().shards().map((Function1)new Serializable(this, lower, upper){
                                        public static final long serialVersionUID = 0L;
                                        private final byte[] lower$1;
                                        private final byte[] upper$1;

                                        public final package.BoundedByteRange apply(byte[] p) {
                                            return new package.BoundedByteRange(ByteArrays$.MODULE$.concat(p, this.lower$1), ByteArrays$.MODULE$.concat(p, this.upper$1));
                                        }
                                        {
                                            this.lower$1 = lower$1;
                                            this.upper$1 = upper$1;
                                        }
                                    }, Seq$.MODULE$.canBuildFrom());
                                    break block3;
                                }
                                if (!(scanRange instanceof package.LowerBoundedRange)) break block4;
                                package.LowerBoundedRange lowerBoundedRange = (package.LowerBoundedRange)scanRange;
                                package.Z3IndexKey lo = (package.Z3IndexKey)lowerBoundedRange.lower();
                                byte[] lower = ByteArrays$.MODULE$.toBytes(lo.bin(), lo.z());
                                byte[] upper = package$ByteRange$.MODULE$.UnboundedUpperRange();
                                genTraversable = (GenTraversableOnce)this.$outer.sharding().shards().map((Function1)new Serializable(this, lower, upper){
                                    public static final long serialVersionUID = 0L;
                                    private final byte[] lower$2;
                                    private final byte[] upper$2;

                                    public final package.BoundedByteRange apply(byte[] p) {
                                        return new package.BoundedByteRange(ByteArrays$.MODULE$.concat(p, this.lower$2), ByteArrays$.MODULE$.concat(p, this.upper$2));
                                    }
                                    {
                                        this.lower$2 = lower$2;
                                        this.upper$2 = upper$2;
                                    }
                                }, Seq$.MODULE$.canBuildFrom());
                                break block3;
                            }
                            if (!(scanRange instanceof package.UpperBoundedRange)) break block5;
                            package.UpperBoundedRange upperBoundedRange = (package.UpperBoundedRange)scanRange;
                            package.Z3IndexKey hi = (package.Z3IndexKey)upperBoundedRange.upper();
                            byte[] lower = package$ByteRange$.MODULE$.UnboundedLowerRange();
                            byte[] upper = ByteArrays$.MODULE$.toBytesFollowingPrefix(hi.bin(), hi.z());
                            genTraversable = (GenTraversableOnce)this.$outer.sharding().shards().map((Function1)new Serializable(this, lower, upper){
                                public static final long serialVersionUID = 0L;
                                private final byte[] lower$3;
                                private final byte[] upper$3;

                                public final package.BoundedByteRange apply(byte[] p) {
                                    return new package.BoundedByteRange(ByteArrays$.MODULE$.concat(p, this.lower$3), ByteArrays$.MODULE$.concat(p, this.upper$3));
                                }
                                {
                                    this.lower$3 = lower$3;
                                    this.upper$3 = upper$3;
                                }
                            }, Seq$.MODULE$.canBuildFrom());
                            break block3;
                        }
                        if (!(scanRange instanceof package.UnboundedRange)) break block6;
                        genTraversable = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new package.BoundedByteRange[]{new package.BoundedByteRange(package$ByteRange$.MODULE$.UnboundedLowerRange(), package$ByteRange$.MODULE$.UnboundedUpperRange())}));
                    }
                    return genTraversable;
                }
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected range type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{scanRange})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Override
    public boolean useFullFilter(Option<package.Z3IndexValues> values2, Option<GeoMesaDataStoreFactory.GeoMesaDataStoreConfig> config, Hints hints) {
        boolean looseBBox = BoxesRunTime.unboxToBoolean((Object)Option$.MODULE$.apply(hints.get((Object)QueryHints$.MODULE$.LOOSE_BBOX())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Object x) {
                return BoxesRunTime.unboxToBoolean((Object)x);
            }
        }).getOrElse((Function0)new Serializable(this, config){
            public static final long serialVersionUID = 0L;
            private final Option config$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.config$1.forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(GeoMesaDataStoreFactory.GeoMesaDataStoreConfig x$7) {
                        return x$7.looseBBox();
                    }
                });
            }
            {
                this.config$1 = config$1;
            }
        }));
        return !looseBBox || this.unboundedDates$1(values2) || this.complexGeoms$1(values2);
    }

    public final Seq org$locationtech$geomesa$index$index$z3$Z3IndexKeySpace$$toZRanges$1(Seq t, Z3SFC z3$1, Seq xy$1, Option target$1) {
        return z3$1.ranges(xy$1, t, 64, target$1);
    }

    private final Seq wholePeriodRanges$lzycompute$1(Z3SFC z3$1, Seq xy$1, Option target$1, ObjectRef wholePeriodRanges$lzy$1, VolatileByteRef bitmap$0$1) {
        Z3IndexKeySpace z3IndexKeySpace = this;
        synchronized (z3IndexKeySpace) {
            if ((byte)(bitmap$0$1.elem & 1) == 0) {
                wholePeriodRanges$lzy$1.elem = this.org$locationtech$geomesa$index$index$z3$Z3IndexKeySpace$$toZRanges$1(z3$1.wholePeriod(), z3$1, xy$1, target$1);
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
            }
            return (Seq)wholePeriodRanges$lzy$1.elem;
        }
    }

    public final Seq org$locationtech$geomesa$index$index$z3$Z3IndexKeySpace$$wholePeriodRanges$1(Z3SFC z3$1, Seq xy$1, Option target$1, ObjectRef wholePeriodRanges$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 1) == 0 ? this.wholePeriodRanges$lzycompute$1(z3$1, xy$1, target$1, wholePeriodRanges$lzy$1, bitmap$0$1) : (Seq)wholePeriodRanges$lzy$1.elem;
    }

    private final boolean unboundedDates$1(Option values$1) {
        return values$1.exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(package.Z3IndexValues x$8) {
                return x$8.temporalUnbounded().nonEmpty();
            }
        });
    }

    private final boolean complexGeoms$1(Option values$1) {
        return values$1.exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(package.Z3IndexValues x$9) {
                return x$9.geometries().values().exists((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Geometry g) {
                        return !GeometryUtils$.MODULE$.isRectangular(g);
                    }
                });
            }
        });
    }

    public Z3IndexKeySpace(SimpleFeatureType sft, ShardStrategy sharding, String geomField, String dtgField) {
        this.sft = sft;
        this.sharding = sharding;
        this.org$locationtech$geomesa$index$index$z3$Z3IndexKeySpace$$geomField = geomField;
        this.org$locationtech$geomesa$index$index$z3$Z3IndexKeySpace$$dtgField = dtgField;
        IndexKeySpace$class.$init$(this);
        LazyLogging.class.$init$((LazyLogging)this);
        Predef$.MODULE$.require(Point.class.isAssignableFrom(sft.getDescriptor(geomField).getType().getBinding()), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Z3IndexKeySpace $outer;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected field ", " to have a point binding, but instead it has: "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$locationtech$geomesa$index$index$z3$Z3IndexKeySpace$$geomField}))).append((Object)this.$outer.sft().getDescriptor(this.$outer.org$locationtech$geomesa$index$index$z3$Z3IndexKeySpace$$geomField).getType().getBinding().getSimpleName()).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Predef$.MODULE$.require(Date.class.isAssignableFrom(sft.getDescriptor(dtgField).getType().getBinding()), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Z3IndexKeySpace $outer;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected field ", " to have a date binding, but instead it has: "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$locationtech$geomesa$index$index$z3$Z3IndexKeySpace$$dtgField}))).append((Object)this.$outer.sft().getDescriptor(this.$outer.org$locationtech$geomesa$index$index$z3$Z3IndexKeySpace$$dtgField).getType().getBinding().getSimpleName()).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.sfc = Z3SFC$.MODULE$.apply(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getZ3Interval$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        this.geomIndex = sft.indexOf(geomField);
        this.dtgIndex = sft.indexOf(dtgField);
        this.timeToIndex = BinnedTime$.MODULE$.timeToBinnedTime(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getZ3Interval$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        this.org$locationtech$geomesa$index$index$z3$Z3IndexKeySpace$$dateToIndex = BinnedTime$.MODULE$.dateToBinnedTime(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getZ3Interval$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        this.org$locationtech$geomesa$index$index$z3$Z3IndexKeySpace$$boundsToDates = BinnedTime$.MODULE$.boundsToIndexableDates(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getZ3Interval$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        this.attributes = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{geomField, dtgField}));
        this.indexKeyByteLength = package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToInteger((int)(10 + sharding.length())));
        this.sharing = (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte());
    }
}

