/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.tools.export;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.InputStream;
import org.geotools.data.Query;
import org.geotools.factory.Hints;
import org.locationtech.geomesa.convert.EvaluationContext;
import org.locationtech.geomesa.convert.EvaluationContext$;
import org.locationtech.geomesa.convert2.SimpleFeatureConverter;
import org.locationtech.geomesa.filter.package$;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.index.metadata.GeoMesaMetadata;
import org.locationtech.geomesa.index.metadata.NoOpMetadata;
import org.locationtech.geomesa.index.planning.LocalQueryRunner;
import org.locationtech.geomesa.index.planning.LocalQueryRunner$;
import org.locationtech.geomesa.index.stats.GeoMesaStats;
import org.locationtech.geomesa.index.stats.MetadataBackedStats;
import org.locationtech.geomesa.tools.export.ConvertCommand;
import org.locationtech.geomesa.tools.export.ConvertCommand$$anon$1$;
import org.locationtech.geomesa.tools.export.ConvertCommand$$anonfun$org$locationtech$geomesa$tools$export$ConvertCommand$;
import org.locationtech.geomesa.tools.export.ConvertCommand$$anonfun$org$locationtech$geomesa$tools$export$ConvertCommand$$convert$1$2$;
import org.locationtech.geomesa.tools.export.ExportCommand$;
import org.locationtech.geomesa.tools.export.formats.ArrowExporter;
import org.locationtech.geomesa.tools.export.formats.AvroExporter;
import org.locationtech.geomesa.tools.export.formats.BinExporter;
import org.locationtech.geomesa.tools.export.formats.DelimitedExporter$;
import org.locationtech.geomesa.tools.export.formats.ExportFormats$;
import org.locationtech.geomesa.tools.export.formats.FeatureExporter;
import org.locationtech.geomesa.tools.export.formats.FileSystemExporter;
import org.locationtech.geomesa.tools.export.formats.GeoJsonExporter;
import org.locationtech.geomesa.tools.export.formats.GmlExporter;
import org.locationtech.geomesa.tools.export.formats.LeafletMapExporter;
import org.locationtech.geomesa.tools.export.formats.NullExporter$;
import org.locationtech.geomesa.tools.export.formats.ShapefileExporter;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.locationtech.geomesa.utils.collection.CloseableIterator$;
import org.locationtech.geomesa.utils.io.WithClose$;
import org.locationtech.geomesa.utils.io.fs.FileSystemDelegate;
import org.locationtech.geomesa.utils.stats.SeqStat;
import org.locationtech.geomesa.utils.stats.Stat;
import org.locationtech.geomesa.utils.stats.Stat$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.IncludeFilter;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;
import scala.runtime.Nothing$;
import scala.runtime.VolatileByteRef;

public final class ConvertCommand$
implements LazyLogging {
    public static final ConvertCommand$ MODULE$;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new ConvertCommand$();
    }

    private Logger logger$lzycompute() {
        ConvertCommand$ convertCommand$ = this;
        synchronized (convertCommand$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public FeatureExporter getExporter(ConvertCommand.ConvertParameters params, Enumeration.Value format, Hints hints) {
        block21: {
            FeatureExporter featureExporter;
            block10: {
                Enumeration.Value value;
                VolatileByteRef bitmap$0;
                BooleanRef fids$lzy;
                block20: {
                    block19: {
                        block18: {
                            block17: {
                                block16: {
                                    boolean bl;
                                    block15: {
                                        boolean bl2;
                                        block14: {
                                            boolean bl3;
                                            block13: {
                                                block12: {
                                                    block11: {
                                                        IntRef avroCompression$lzy;
                                                        block9: {
                                                            fids$lzy = BooleanRef.zero();
                                                            avroCompression$lzy = IntRef.zero();
                                                            bitmap$0 = VolatileByteRef.create((byte)0);
                                                            value = format;
                                                            Enumeration.Value value2 = ExportFormats$.MODULE$.Arrow();
                                                            Enumeration.Value value3 = value;
                                                            if (value2 != null ? !value2.equals(value3) : value3 != null) break block9;
                                                            featureExporter = new ArrowExporter(hints, ExportCommand$.MODULE$.createOutputStream(params), (Function0<Map<String, Object[]>>)new Serializable(){
                                                                public static final long serialVersionUID = 0L;

                                                                public final Map<String, Nothing$> apply() {
                                                                    return Predef$.MODULE$.Map().empty();
                                                                }
                                                            });
                                                            break block10;
                                                        }
                                                        Enumeration.Value value4 = ExportFormats$.MODULE$.Avro();
                                                        Enumeration.Value value5 = value;
                                                        if (value4 != null ? !value4.equals(value5) : value5 != null) break block11;
                                                        featureExporter = new AvroExporter(this.avroCompression$1(params, avroCompression$lzy, bitmap$0), ExportCommand$.MODULE$.createOutputStream(params));
                                                        break block10;
                                                    }
                                                    Enumeration.Value value6 = ExportFormats$.MODULE$.Bin();
                                                    Enumeration.Value value7 = value;
                                                    if (value6 != null ? !value6.equals(value7) : value7 != null) break block12;
                                                    featureExporter = new BinExporter(hints, ExportCommand$.MODULE$.createOutputStream(params));
                                                    break block10;
                                                }
                                                Enumeration.Value value8 = ExportFormats$.MODULE$.Csv();
                                                Enumeration.Value value9 = value;
                                                if (value8 != null ? !value8.equals(value9) : value9 != null) break block13;
                                                featureExporter = DelimitedExporter$.MODULE$.csv(ExportCommand$.MODULE$.createWriter(params), !params.noHeader(), this.fids$1(hints, fids$lzy, bitmap$0));
                                                break block10;
                                            }
                                            Enumeration.Value value10 = ExportFormats$.MODULE$.GeoJson();
                                            Enumeration.Value value11 = value;
                                            if (!(value10 != null ? !value10.equals(value11) : value11 != null)) {
                                                bl3 = true;
                                            } else {
                                                Enumeration.Value value12 = ExportFormats$.MODULE$.Json();
                                                Enumeration.Value value13 = value;
                                                bl3 = !(value12 != null ? !value12.equals(value13) : value13 != null);
                                            }
                                            if (!bl3) break block14;
                                            featureExporter = new GeoJsonExporter(ExportCommand$.MODULE$.createWriter(params));
                                            break block10;
                                        }
                                        Enumeration.Value value14 = ExportFormats$.MODULE$.Gml();
                                        Enumeration.Value value15 = value;
                                        if (!(value14 != null ? !value14.equals(value15) : value15 != null)) {
                                            bl2 = true;
                                        } else {
                                            Enumeration.Value value16 = ExportFormats$.MODULE$.Xml();
                                            Enumeration.Value value17 = value;
                                            bl2 = !(value16 != null ? !value16.equals(value17) : value17 != null);
                                        }
                                        if (!bl2) break block15;
                                        featureExporter = new GmlExporter(ExportCommand$.MODULE$.createOutputStream(params));
                                        break block10;
                                    }
                                    Enumeration.Value value18 = ExportFormats$.MODULE$.Html();
                                    Enumeration.Value value19 = value;
                                    if (!(value18 != null ? !value18.equals(value19) : value19 != null)) {
                                        bl = true;
                                    } else {
                                        Enumeration.Value value20 = ExportFormats$.MODULE$.Leaflet();
                                        Enumeration.Value value21 = value;
                                        bl = !(value20 != null ? !value20.equals(value21) : value21 != null);
                                    }
                                    if (!bl) break block16;
                                    featureExporter = new LeafletMapExporter(params);
                                    break block10;
                                }
                                Enumeration.Value value22 = ExportFormats$.MODULE$.Null();
                                Enumeration.Value value23 = value;
                                if (value22 != null ? !value22.equals(value23) : value23 != null) break block17;
                                featureExporter = NullExporter$.MODULE$;
                                break block10;
                            }
                            Enumeration.Value value24 = ExportFormats$.MODULE$.Orc();
                            Enumeration.Value value25 = value;
                            if (value24 != null ? !value24.equals(value25) : value25 != null) break block18;
                            featureExporter = new FileSystemExporter.OrcFileSystemExporter(ExportCommand$.MODULE$.ensureOutputFile(params, format));
                            break block10;
                        }
                        Enumeration.Value value26 = ExportFormats$.MODULE$.Parquet();
                        Enumeration.Value value27 = value;
                        if (value26 != null ? !value26.equals(value27) : value27 != null) break block19;
                        featureExporter = new FileSystemExporter.ParquetFileSystemExporter(ExportCommand$.MODULE$.ensureOutputFile(params, format));
                        break block10;
                    }
                    Enumeration.Value value28 = ExportFormats$.MODULE$.Shp();
                    Enumeration.Value value29 = value;
                    if (value28 != null ? !value28.equals(value29) : value29 != null) break block20;
                    featureExporter = new ShapefileExporter(new File(ExportCommand$.MODULE$.ensureOutputFile(params, format)));
                    break block10;
                }
                Enumeration.Value value30 = ExportFormats$.MODULE$.Tsv();
                Enumeration.Value value31 = value;
                if (value30 != null ? !value30.equals(value31) : value31 != null) break block21;
                featureExporter = DelimitedExporter$.MODULE$.tsv(ExportCommand$.MODULE$.createWriter(params), !params.noHeader(), this.fids$1(hints, fids$lzy, bitmap$0));
            }
            return featureExporter;
        }
        throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Format ", " can't be exported"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{format})));
    }

    public CloseableIterator<SimpleFeature> convertFeatures(Iterator<FileSystemDelegate.FileHandle> files, SimpleFeatureConverter converter, EvaluationContext ec, Query query) {
        return this.transform$1(this.org$locationtech$geomesa$tools$export$ConvertCommand$$limit$1(this.org$locationtech$geomesa$tools$export$ConvertCommand$$filter$1(this.org$locationtech$geomesa$tools$export$ConvertCommand$$convert$1(files, converter, ec), query), query), files, converter, ec, query);
    }

    private final boolean fids$lzycompute$1(Hints hints$1, BooleanRef fids$lzy$1, VolatileByteRef bitmap$0$1) {
        ConvertCommand$ convertCommand$ = this;
        synchronized (convertCommand$) {
            if ((byte)(bitmap$0$1.elem & 1) == 0) {
                fids$lzy$1.elem = !Option$.MODULE$.apply(hints$1.get((Object)QueryHints$.MODULE$.ARROW_INCLUDE_FID())).contains((Object)Boolean.FALSE);
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
            }
            return fids$lzy$1.elem;
        }
    }

    private final boolean fids$1(Hints hints$1, BooleanRef fids$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 1) == 0 ? this.fids$lzycompute$1(hints$1, fids$lzy$1, bitmap$0$1) : fids$lzy$1.elem;
    }

    private final int avroCompression$lzycompute$1(ConvertCommand.ConvertParameters params$1, IntRef avroCompression$lzy$1, VolatileByteRef bitmap$0$1) {
        ConvertCommand$ convertCommand$ = this;
        synchronized (convertCommand$) {
            if ((byte)(bitmap$0$1.elem & 2) == 0) {
                int n;
                if (params$1.gzip() == null) {
                    n = -1;
                } else {
                    int compression = Predef$.MODULE$.Integer2int(params$1.gzip());
                    params$1.gzip_$eq(null);
                    n = compression;
                }
                avroCompression$lzy$1.elem = n;
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 2);
            }
            return avroCompression$lzy$1.elem;
        }
    }

    private final int avroCompression$1(ConvertCommand.ConvertParameters params$1, IntRef avroCompression$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 2) == 0 ? this.avroCompression$lzycompute$1(params$1, avroCompression$lzy$1, bitmap$0$1) : avroCompression$lzy$1.elem;
    }

    public final CloseableIterator org$locationtech$geomesa$tools$export$ConvertCommand$$convert$1(Iterator files$2, SimpleFeatureConverter converter$1, EvaluationContext ec$2) {
        return CloseableIterator$.MODULE$.apply(files$2, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                CloseableIterator$.MODULE$.apply$default$2();
            }
        }).flatMap((Function1)new Serializable(converter$1, ec$2){
            public static final long serialVersionUID = 0L;
            public final SimpleFeatureConverter converter$1;
            public final EvaluationContext ec$2;

            public final CloseableIterator<SimpleFeature> apply(FileSystemDelegate.FileHandle file2) {
                return file2.open().flatMap((Function1)new Serializable(this, file2){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun$org$locationtech$geomesa$tools$export$ConvertCommand$$convert$1$2 $outer;
                    public final FileSystemDelegate.FileHandle file$1;

                    public final GenTraversableOnce<SimpleFeature> apply(Tuple2<Option<String>, InputStream> x0$2) {
                        Tuple2<Option<String>, InputStream> tuple2 = x0$2;
                        if (tuple2 != null) {
                            Option name = (Option)tuple2._1();
                            InputStream is = (InputStream)tuple2._2();
                            EvaluationContext.RichEvaluationContext$.MODULE$.setInputFilePath$extension(EvaluationContext$.MODULE$.RichEvaluationContext(this.$outer.ec$2), (String)name.getOrElse((Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun$org$locationtech$geomesa$tools$export$ConvertCommand$$convert$1$2$$anonfun$apply$3 $outer;

                                public final String apply() {
                                    return this.$outer.file$1.path();
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            }));
                            CloseableIterator closeableIterator = this.$outer.converter$1.process(is, this.$outer.ec$2);
                            return closeableIterator;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.file$1 = file$1;
                    }
                });
            }
            {
                this.converter$1 = converter$1;
                this.ec$2 = ec$2;
            }
        });
    }

    public final CloseableIterator org$locationtech$geomesa$tools$export$ConvertCommand$$filter$1(CloseableIterator iter, Query query$2) {
        CloseableIterator closeableIterator;
        Filter filter2 = query$2.getFilter();
        IncludeFilter includeFilter = Filter.INCLUDE;
        if (!(filter2 != null ? !filter2.equals(includeFilter) : includeFilter != null)) {
            closeableIterator = iter;
        } else {
            Filter filter3 = query$2.getFilter();
            closeableIterator = iter.filter((Function1)new Serializable(filter3){
                public static final long serialVersionUID = 0L;
                private final Filter eta$0$1$1;

                public final boolean apply(Object x$1) {
                    return this.eta$0$1$1.evaluate(x$1);
                }
                {
                    this.eta$0$1$1 = eta$0$1$1;
                }
            });
        }
        return closeableIterator;
    }

    public final CloseableIterator org$locationtech$geomesa$tools$export$ConvertCommand$$limit$1(CloseableIterator iter, Query query$2) {
        return query$2.isMaxFeaturesUnlimited() ? iter : iter.take(query$2.getMaxFeatures());
    }

    private final CloseableIterator transform$1(CloseableIterator iter, Iterator files$2, SimpleFeatureConverter converter$1, EvaluationContext ec$2, Query query$2) {
        MetadataBackedStats stats = new MetadataBackedStats(files$2, converter$1, ec$2, query$2){
            private final Iterator files$2;
            private final SimpleFeatureConverter converter$1;
            private final EvaluationContext ec$2;
            private final Query query$2;

            public <T extends Stat> Seq<T> runStats(SimpleFeatureType sft, String stats, Filter ignored) {
                Seq seq;
                Stat stat = Stat$.MODULE$.apply(sft, stats);
                try {
                    Seq seq2;
                    WithClose$.MODULE$.apply((Object)ConvertCommand$.MODULE$.org$locationtech$geomesa$tools$export$ConvertCommand$$limit$1(ConvertCommand$.MODULE$.org$locationtech$geomesa$tools$export$ConvertCommand$$filter$1(ConvertCommand$.MODULE$.org$locationtech$geomesa$tools$export$ConvertCommand$$convert$1(this.files$2, this.converter$1, this.ec$2), this.query$2), this.query$2), (Function1)new Serializable(this, stat){
                        public static final long serialVersionUID = 0L;
                        public final Stat stat$1;

                        public final void apply(CloseableIterator<SimpleFeature> x$1) {
                            x$1.foreach((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anon$1$$anonfun$runStats$1 $outer;

                                public final void apply(SimpleFeature sf) {
                                    this.$outer.stat$1.observe(sf);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            });
                        }
                        {
                            this.stat$1 = stat$1;
                        }
                    });
                    Stat stat2 = stat;
                    if (stat2 instanceof SeqStat) {
                        SeqStat seqStat = (SeqStat)stat2;
                        seq2 = seqStat.stats();
                    } else {
                        seq2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Stat[]{stat2}));
                    }
                    seq = seq2;
                }
                catch (Exception exception) {
                    BoxedUnit boxedUnit;
                    if (this.logger().underlying().isErrorEnabled()) {
                        this.logger().underlying().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error running stats query with stats '", "' and filter '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{stats, package$.MODULE$.filterToString(ignored)})), (Throwable)exception);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    seq = (Seq)Seq$.MODULE$.empty();
                }
                return seq;
            }

            public void write(String typeName, Seq<MetadataBackedStats.WritableStat> stats) {
            }
            {
                this.files$2 = files$2;
                this.converter$1 = converter$1;
                this.ec$2 = ec$2;
                this.query$2 = query$2;
                super(null, (GeoMesaMetadata)new NoOpMetadata(), false);
            }
        };
        Some hook = new Some((Object)new LocalQueryRunner.ArrowDictionaryHook((GeoMesaStats)stats, Option$.MODULE$.apply((Object)query$2.getFilter()).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Filter x$2) {
                Filter filter2 = x$2;
                IncludeFilter includeFilter = Filter.INCLUDE;
                return filter2 != null ? !filter2.equals(includeFilter) : includeFilter != null;
            }
        })));
        return LocalQueryRunner$.MODULE$.transform(converter$1.targetSft(), iter, QueryHints$.MODULE$.RichHints(query$2.getHints()).getTransform(), query$2.getHints(), (Option)hook);
    }

    private ConvertCommand$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
    }
}

