/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.tools.export;

import java.io.File;
import org.geotools.data.DataStore;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.tools.Command$;
import org.locationtech.geomesa.tools.TypeNameParam;
import org.locationtech.geomesa.tools.export.ExportCommand;
import org.locationtech.geomesa.tools.export.ExportCommand$;
import org.locationtech.geomesa.tools.export.formats.ArrowExporter;
import org.locationtech.geomesa.tools.export.formats.ArrowExporter$;
import org.locationtech.geomesa.tools.export.formats.AvroExporter;
import org.locationtech.geomesa.tools.export.formats.BinExporter;
import org.locationtech.geomesa.tools.export.formats.DelimitedExporter$;
import org.locationtech.geomesa.tools.export.formats.ExportFormats$;
import org.locationtech.geomesa.tools.export.formats.FeatureExporter;
import org.locationtech.geomesa.tools.export.formats.FileSystemExporter;
import org.locationtech.geomesa.tools.export.formats.GeoJsonExporter;
import org.locationtech.geomesa.tools.export.formats.GmlExporter;
import org.locationtech.geomesa.tools.export.formats.LeafletMapExporter;
import org.locationtech.geomesa.tools.export.formats.NullExporter$;
import org.locationtech.geomesa.tools.export.formats.ShapefileExporter;
import org.locationtech.geomesa.utils.collection.CloseableIterator$;
import org.locationtech.geomesa.utils.io.CloseWithLogging$;
import org.locationtech.geomesa.utils.io.WithClose$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.VolatileByteRef;
import scala.util.control.NonFatal$;

public abstract class ExportCommand$class {
    public static void execute(ExportCommand $this) {
        $this.profile((Function2)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExportCommand $outer;

            public final void apply(Option<Object> count, long time) {
                ExportCommand$class.complete$1(this.$outer, count, time);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExportCommand $outer;

            public final Option<Object> apply() {
                return (Option)this.$outer.withDataStore(new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ExportCommand$.anonfun.execute.2 $outer;

                    public final Option<Object> apply(DS ds) {
                        return this.$outer.org$locationtech$geomesa$tools$export$ExportCommand$$anonfun$$$outer().export(ds);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ ExportCommand org$locationtech$geomesa$tools$export$ExportCommand$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public static Option export(ExportCommand $this, DataStore ds) {
        void var6_6;
        block26: {
            Option<Object> option;
            FeatureExporter featureExporter;
            SimpleFeatureCollection features;
            block15: {
                Enumeration.Value value;
                Query query;
                VolatileByteRef bitmap$0;
                BooleanRef fids$lzy;
                block25: {
                    Enumeration.Value format;
                    block24: {
                        block23: {
                            block22: {
                                block21: {
                                    boolean bl;
                                    block20: {
                                        boolean bl2;
                                        block19: {
                                            boolean bl3;
                                            block18: {
                                                block17: {
                                                    block16: {
                                                        IntRef avroCompression$lzy;
                                                        block14: {
                                                            Enumeration.Value value2;
                                                            Enumeration.Value value3;
                                                            fids$lzy = BooleanRef.zero();
                                                            ObjectRef dictionaries$lzy = ObjectRef.zero();
                                                            avroCompression$lzy = IntRef.zero();
                                                            bitmap$0 = VolatileByteRef.create((byte)0);
                                                            format = ExportCommand$.MODULE$.getOutputFormat($this.params());
                                                            query = ExportCommand$.MODULE$.createQuery((Function0<SimpleFeatureType>)new Serializable($this, ds){
                                                                public static final long serialVersionUID = 0L;
                                                                private final /* synthetic */ ExportCommand $outer;
                                                                private final DataStore ds$1;

                                                                public final SimpleFeatureType apply() {
                                                                    return this.$outer.getSchema(this.ds$1);
                                                                }
                                                                {
                                                                    if ($outer == null) {
                                                                        throw null;
                                                                    }
                                                                    this.$outer = $outer;
                                                                    this.ds$1 = ds$1;
                                                                }
                                                            }, format, $this.params());
                                                            try {
                                                                features = $this.getFeatures(ds, query);
                                                                value = format;
                                                                value3 = ExportFormats$.MODULE$.Arrow();
                                                                value2 = value;
                                                            }
                                                            catch (Throwable throwable) {
                                                                Throwable throwable2 = throwable;
                                                                Option option2 = NonFatal$.MODULE$.unapply(throwable2);
                                                                if (option2.isEmpty()) {
                                                                    throw throwable;
                                                                }
                                                                Throwable e = (Throwable)option2.get();
                                                                throw new RuntimeException("Could not execute export query. Please ensure that all arguments are correct", e);
                                                            }
                                                            if (value3 != null ? !value3.equals(value2) : value2 != null) break block14;
                                                            featureExporter = new ArrowExporter(query.getHints(), ExportCommand$.MODULE$.createOutputStream($this.params()), (Function0<Map<String, Object[]>>)new Serializable($this, query, dictionaries$lzy, ds, bitmap$0){
                                                                public static final long serialVersionUID = 0L;
                                                                private final /* synthetic */ ExportCommand $outer;
                                                                private final Query query$1;
                                                                private final ObjectRef dictionaries$lzy$1;
                                                                private final DataStore ds$1;
                                                                private final VolatileByteRef bitmap$0$2;

                                                                public final Map<String, Object[]> apply() {
                                                                    return ExportCommand$class.dictionaries$1(this.$outer, this.query$1, this.dictionaries$lzy$1, this.ds$1, this.bitmap$0$2);
                                                                }
                                                                {
                                                                    void var5_5;
                                                                    void var4_4;
                                                                    void var3_3;
                                                                    if ($outer == null) {
                                                                        throw null;
                                                                    }
                                                                    this.$outer = $outer;
                                                                    this.query$1 = query$1;
                                                                    this.dictionaries$lzy$1 = var3_3;
                                                                    this.ds$1 = var4_4;
                                                                    this.bitmap$0$2 = var5_5;
                                                                }
                                                            });
                                                            break block15;
                                                        }
                                                        Enumeration.Value value4 = ExportFormats$.MODULE$.Avro();
                                                        Enumeration.Value value5 = value;
                                                        if (value4 != null ? !value4.equals(value5) : value5 != null) break block16;
                                                        featureExporter = new AvroExporter(ExportCommand$class.avroCompression$1($this, avroCompression$lzy, bitmap$0), ExportCommand$.MODULE$.createOutputStream($this.params()));
                                                        break block15;
                                                    }
                                                    Enumeration.Value value6 = ExportFormats$.MODULE$.Bin();
                                                    Enumeration.Value value7 = value;
                                                    if (value6 != null ? !value6.equals(value7) : value7 != null) break block17;
                                                    featureExporter = new BinExporter(query.getHints(), ExportCommand$.MODULE$.createOutputStream($this.params()));
                                                    break block15;
                                                }
                                                Enumeration.Value value8 = ExportFormats$.MODULE$.Csv();
                                                Enumeration.Value value9 = value;
                                                if (value8 != null ? !value8.equals(value9) : value9 != null) break block18;
                                                featureExporter = DelimitedExporter$.MODULE$.csv(ExportCommand$.MODULE$.createWriter($this.params()), !$this.params().noHeader(), ExportCommand$class.fids$1($this, query, fids$lzy, bitmap$0));
                                                break block15;
                                            }
                                            Enumeration.Value value10 = ExportFormats$.MODULE$.GeoJson();
                                            Enumeration.Value value11 = value;
                                            if (!(value10 != null ? !value10.equals(value11) : value11 != null)) {
                                                bl3 = true;
                                            } else {
                                                Enumeration.Value value12 = ExportFormats$.MODULE$.Json();
                                                Enumeration.Value value13 = value;
                                                bl3 = !(value12 != null ? !value12.equals(value13) : value13 != null);
                                            }
                                            if (!bl3) break block19;
                                            featureExporter = new GeoJsonExporter(ExportCommand$.MODULE$.createWriter($this.params()));
                                            break block15;
                                        }
                                        Enumeration.Value value14 = ExportFormats$.MODULE$.Gml();
                                        Enumeration.Value value15 = value;
                                        if (!(value14 != null ? !value14.equals(value15) : value15 != null)) {
                                            bl2 = true;
                                        } else {
                                            Enumeration.Value value16 = ExportFormats$.MODULE$.Xml();
                                            Enumeration.Value value17 = value;
                                            bl2 = !(value16 != null ? !value16.equals(value17) : value17 != null);
                                        }
                                        if (!bl2) break block20;
                                        featureExporter = new GmlExporter(ExportCommand$.MODULE$.createOutputStream($this.params()));
                                        break block15;
                                    }
                                    Enumeration.Value value18 = ExportFormats$.MODULE$.Html();
                                    Enumeration.Value value19 = value;
                                    if (!(value18 != null ? !value18.equals(value19) : value19 != null)) {
                                        bl = true;
                                    } else {
                                        Enumeration.Value value20 = ExportFormats$.MODULE$.Leaflet();
                                        Enumeration.Value value21 = value;
                                        bl = !(value20 != null ? !value20.equals(value21) : value21 != null);
                                    }
                                    if (!bl) break block21;
                                    featureExporter = new LeafletMapExporter($this.params());
                                    break block15;
                                }
                                Enumeration.Value value22 = ExportFormats$.MODULE$.Null();
                                Enumeration.Value value23 = value;
                                if (value22 != null ? !value22.equals(value23) : value23 != null) break block22;
                                featureExporter = NullExporter$.MODULE$;
                                break block15;
                            }
                            Enumeration.Value value24 = ExportFormats$.MODULE$.Orc();
                            Enumeration.Value value25 = value;
                            if (value24 != null ? !value24.equals(value25) : value25 != null) break block23;
                            featureExporter = new FileSystemExporter.OrcFileSystemExporter(ExportCommand$.MODULE$.ensureOutputFile($this.params(), format));
                            break block15;
                        }
                        Enumeration.Value value26 = ExportFormats$.MODULE$.Parquet();
                        Enumeration.Value value27 = value;
                        if (value26 != null ? !value26.equals(value27) : value27 != null) break block24;
                        featureExporter = new FileSystemExporter.ParquetFileSystemExporter(ExportCommand$.MODULE$.ensureOutputFile($this.params(), format));
                        break block15;
                    }
                    Enumeration.Value value28 = ExportFormats$.MODULE$.Shp();
                    Enumeration.Value value29 = value;
                    if (value28 != null ? !value28.equals(value29) : value29 != null) break block25;
                    featureExporter = new ShapefileExporter(new File(ExportCommand$.MODULE$.ensureOutputFile($this.params(), format)));
                    break block15;
                }
                Enumeration.Value value30 = ExportFormats$.MODULE$.Tsv();
                Enumeration.Value value31 = value;
                if (value30 != null ? !value30.equals(value31) : value31 != null) break block26;
                featureExporter = DelimitedExporter$.MODULE$.tsv(ExportCommand$.MODULE$.createWriter($this.params()), !$this.params().noHeader(), ExportCommand$class.fids$1($this, query, fids$lzy, bitmap$0));
            }
            ArrowExporter exporter = featureExporter;
            try {
                exporter.start((SimpleFeatureType)features.getSchema());
                option = $this.export(exporter, features);
            }
            catch (Throwable throwable) {
                void var14_29;
                CloseWithLogging$.MODULE$.apply((Object)var14_29);
                throw throwable;
            }
            CloseWithLogging$.MODULE$.apply((Object)exporter);
            return option;
        }
        throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Format ", " can't be exported"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var6_6})));
    }

    public static Option export(ExportCommand $this, FeatureExporter exporter, SimpleFeatureCollection collection) {
        return (Option)WithClose$.MODULE$.apply((Object)CloseableIterator$.MODULE$.apply((FeatureIterator)collection.features()), (Function1)new Serializable($this, exporter){
            public static final long serialVersionUID = 0L;
            private final FeatureExporter exporter$1;

            public final Option<Object> apply(Iterator<SimpleFeature> features) {
                return this.exporter$1.export(features);
            }
            {
                this.exporter$1 = exporter$1;
            }
        });
    }

    public static SimpleFeatureType getSchema(ExportCommand $this, DataStore ds) {
        ExportCommand.ExportParams exportParams = $this.params();
        if (exportParams instanceof TypeNameParam) {
            ExportCommand.ExportParams exportParams2 = exportParams;
            SimpleFeatureType simpleFeatureType = ds.getSchema(((TypeNameParam)((Object)exportParams2)).featureName());
            return simpleFeatureType;
        }
        throw new MatchError((Object)exportParams);
    }

    public static SimpleFeatureCollection getFeatures(ExportCommand $this, DataStore ds, Query query) {
        return ds.getFeatureSource(query.getTypeName()).getFeatures(query);
    }

    public static final void complete$1(ExportCommand $this, Option count, long time) {
        Command$.MODULE$.user().info(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Feature export complete to ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Option$.MODULE$.apply((Object)$this.params().file()).getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "standard out";
            }
        })}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"in ", "ms", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)time), count.map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(long x$1) {
                return new StringBuilder().append((Object)" for ").append((Object)BoxesRunTime.boxToLong((long)x$1)).append((Object)" features").toString();
            }
        }).getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        })}))).toString());
    }

    private static final boolean fids$lzycompute$1(ExportCommand $this, Query query$1, BooleanRef fids$lzy$1, VolatileByteRef bitmap$0$2) {
        ExportCommand exportCommand = $this;
        synchronized (exportCommand) {
            if ((byte)(bitmap$0$2.elem & 1) == 0) {
                fids$lzy$1.elem = !Option$.MODULE$.apply(query$1.getHints().get((Object)QueryHints$.MODULE$.ARROW_INCLUDE_FID())).contains((Object)Boolean.FALSE);
                bitmap$0$2.elem = (byte)(bitmap$0$2.elem | 1);
            }
            return fids$lzy$1.elem;
        }
    }

    private static final boolean fids$1(ExportCommand $this, Query query$1, BooleanRef fids$lzy$1, VolatileByteRef bitmap$0$2) {
        return (byte)(bitmap$0$2.elem & 1) == 0 ? ExportCommand$class.fids$lzycompute$1($this, query$1, fids$lzy$1, bitmap$0$2) : fids$lzy$1.elem;
    }

    private static final Map dictionaries$lzycompute$1(ExportCommand $this, Query query$1, ObjectRef dictionaries$lzy$1, DataStore ds$1, VolatileByteRef bitmap$0$2) {
        ExportCommand exportCommand = $this;
        synchronized (exportCommand) {
            if ((byte)(bitmap$0$2.elem & 2) == 0) {
                dictionaries$lzy$1.elem = ArrowExporter$.MODULE$.queryDictionaries(ds$1, query$1);
                bitmap$0$2.elem = (byte)(bitmap$0$2.elem | 2);
            }
            return (Map)dictionaries$lzy$1.elem;
        }
    }

    public static final Map dictionaries$1(ExportCommand $this, Query query$1, ObjectRef dictionaries$lzy$1, DataStore ds$1, VolatileByteRef bitmap$0$2) {
        return (byte)(bitmap$0$2.elem & 2) == 0 ? ExportCommand$class.dictionaries$lzycompute$1($this, query$1, dictionaries$lzy$1, ds$1, bitmap$0$2) : (Map)dictionaries$lzy$1.elem;
    }

    private static final int avroCompression$lzycompute$1(ExportCommand $this, IntRef avroCompression$lzy$1, VolatileByteRef bitmap$0$2) {
        ExportCommand exportCommand = $this;
        synchronized (exportCommand) {
            if ((byte)(bitmap$0$2.elem & 4) == 0) {
                int n;
                if ($this.params().gzip() == null) {
                    n = -1;
                } else {
                    int compression = Predef$.MODULE$.Integer2int($this.params().gzip());
                    $this.params().gzip_$eq(null);
                    n = compression;
                }
                avroCompression$lzy$1.elem = n;
                bitmap$0$2.elem = (byte)(bitmap$0$2.elem | 4);
            }
            return avroCompression$lzy$1.elem;
        }
    }

    private static final int avroCompression$1(ExportCommand $this, IntRef avroCompression$lzy$1, VolatileByteRef bitmap$0$2) {
        return (byte)(bitmap$0$2.elem & 4) == 0 ? ExportCommand$class.avroCompression$lzycompute$1($this, avroCompression$lzy$1, bitmap$0$2) : avroCompression$lzy$1.elem;
    }

    public static void $init$(ExportCommand $this) {
        $this.org$locationtech$geomesa$tools$export$ExportCommand$_setter_$name_$eq("export");
    }
}

