/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.tools.export.formats;

import com.typesafe.scalalogging.Logger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.locationtech.geomesa.fs.storage.api.FileSystemStorage;
import org.locationtech.geomesa.fs.storage.common.jobs.StorageConfiguration$;
import org.locationtech.geomesa.fs.storage.orc.OrcFileSystemWriter;
import org.locationtech.geomesa.parquet.ParquetFileSystemStorage;
import org.locationtech.geomesa.tools.export.formats.FeatureExporter;
import org.locationtech.geomesa.tools.export.formats.FileSystemExporter$;
import org.locationtech.geomesa.utils.io.PathUtils$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;

@ScalaSignature(bytes="\u0006\u0001\u0005]c!B\u0001\u0003\u0003\u0003y!A\u0005$jY\u0016\u001c\u0016p\u001d;f[\u0016C\bo\u001c:uKJT!a\u0001\u0003\u0002\u000f\u0019|'/\\1ug*\u0011QAB\u0001\u0007Kb\u0004xN\u001d;\u000b\u0005\u001dA\u0011!\u0002;p_2\u001c(BA\u0005\u000b\u0003\u001d9Wm\\7fg\u0006T!a\u0003\u0007\u0002\u00191|7-\u0019;j_:$Xm\u00195\u000b\u00035\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\t\u0019!\t\tb#D\u0001\u0013\u0015\t\u0019B#\u0001\u0003mC:<'\"A\u000b\u0002\t)\fg/Y\u0005\u0003/I\u0011aa\u00142kK\u000e$\bCA\r\u001b\u001b\u0005\u0011\u0011BA\u000e\u0003\u0005=1U-\u0019;ve\u0016,\u0005\u0010]8si\u0016\u0014\b\"B\u000f\u0001\t\u0003q\u0012A\u0002\u001fj]&$h\bF\u0001 !\tI\u0002\u0001C\u0005\"\u0001\u0001\u0007\t\u0019!C\u0005E\u00051qO]5uKJ,\u0012a\t\t\u0003Iqr!!J\u001d\u000f\u0005\u00192dBA\u00144\u001d\tA\u0013G\u0004\u0002*a9\u0011!f\f\b\u0003W9j\u0011\u0001\f\u0006\u0003[9\ta\u0001\u0010:p_Rt\u0014\"A\u0007\n\u0005-a\u0011BA\u0005\u000b\u0013\t\u0011\u0004\"\u0001\u0002gg&\u0011A'N\u0001\bgR|'/Y4f\u0015\t\u0011\u0004\"\u0003\u00028q\u0005\u0019\u0011\r]5\u000b\u0005Q*\u0014B\u0001\u001e<\u0003E1\u0015\u000e\\3TsN$X-\\*u_J\fw-\u001a\u0006\u0003oaJ!!\u0010 \u0003!\u0019KG.Z*zgR,Wn\u0016:ji\u0016\u0014(B\u0001\u001e<\u0011%\u0001\u0005\u00011AA\u0002\u0013%\u0011)\u0001\u0006xe&$XM]0%KF$\"A\u0011%\u0011\u0005\r3U\"\u0001#\u000b\u0003\u0015\u000bQa]2bY\u0006L!a\u0012#\u0003\tUs\u0017\u000e\u001e\u0005\b\u0013~\n\t\u00111\u0001$\u0003\rAH%\r\u0005\u0007\u0017\u0002\u0001\u000b\u0015B\u0012\u0002\u000f]\u0014\u0018\u000e^3sA!)Q\n\u0001D\t\u001d\u0006a1M]3bi\u0016<&/\u001b;feR\u00111e\u0014\u0005\u0006!2\u0003\r!U\u0001\u0004g\u001a$\bC\u0001*Z\u001b\u0005\u0019&B\u0001+V\u0003\u0019\u0019\u0018.\u001c9mK*\u0011akV\u0001\bM\u0016\fG/\u001e:f\u0015\tAF\"A\u0004pa\u0016tw-[:\n\u0005i\u001b&!E*j[BdWMR3biV\u0014X\rV=qK\")A\f\u0001C!;\u0006)1\u000f^1siR\u0011!I\u0018\u0005\u0006!n\u0003\r!\u0015\u0005\u0006\u000b\u0001!\t\u0005\u0019\u000b\u0003C\u001e\u00042a\u00112e\u0013\t\u0019GI\u0001\u0004PaRLwN\u001c\t\u0003\u0007\u0016L!A\u001a#\u0003\t1{gn\u001a\u0005\u0006Q~\u0003\r![\u0001\tM\u0016\fG/\u001e:fgB\u0019!n\u001c:\u000f\u0005-lgBA\u0016m\u0013\u0005)\u0015B\u00018E\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001]9\u0003\u0011%#XM]1u_JT!A\u001c#\u0011\u0005I\u001b\u0018B\u0001;T\u00055\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sK\")a\u000f\u0001C!o\u0006)1\r\\8tKR\t!iB\u0003z\u0005!\u0005!0\u0001\nGS2,7+_:uK6,\u0005\u0010]8si\u0016\u0014\bCA\r|\r\u0015\t!\u0001#\u0001}'\u0011YX0!\u0001\u0011\u0005\rs\u0018BA@E\u0005\u0019\te.\u001f*fMB!\u00111AA\t\u001b\t\t)A\u0003\u0003\u0002\b\u0005%\u0011\u0001D:dC2\fGn\\4hS:<'\u0002BA\u0006\u0003\u001b\t\u0001\u0002^=qKN\fg-\u001a\u0006\u0003\u0003\u001f\t1aY8n\u0013\u0011\t\u0019\"!\u0002\u0003\u00171\u000b'0\u001f'pO\u001eLgn\u001a\u0005\u0007;m$\t!a\u0006\u0015\u0003i4a!a\u0007|\u0001\u0005u!!\u0007)beF,X\r\u001e$jY\u0016\u001c\u0016p\u001d;f[\u0016C\bo\u001c:uKJ\u001c2!!\u0007 \u0011-\t\t#!\u0007\u0003\u0002\u0003\u0006I!a\t\u0002\tA\fG\u000f\u001b\t\u0005\u0003K\tYCD\u0002D\u0003OI1!!\u000bE\u0003\u0019\u0001&/\u001a3fM&!\u0011QFA\u0018\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011\u0006#\t\u000fu\tI\u0002\"\u0001\u00024Q!\u0011QGA\u001d!\u0011\t9$!\u0007\u000e\u0003mD\u0001\"!\t\u00022\u0001\u0007\u00111\u0005\u0005\b\u001b\u0006eA\u0011KA\u001f)\r\u0019\u0013q\b\u0005\u0007!\u0006m\u0002\u0019A)\u0007\r\u0005\r3\u0010AA#\u0005Uy%o\u0019$jY\u0016\u001c\u0016p\u001d;f[\u0016C\bo\u001c:uKJ\u001c2!!\u0011 \u0011-\t\t#!\u0011\u0003\u0002\u0003\u0006I!a\t\t\u000fu\t\t\u0005\"\u0001\u0002LQ!\u0011QJA(!\u0011\t9$!\u0011\t\u0011\u0005\u0005\u0012\u0011\na\u0001\u0003GAq!TA!\t#\n\u0019\u0006F\u0002$\u0003+Ba\u0001UA)\u0001\u0004\t\u0006")
public abstract class FileSystemExporter
implements FeatureExporter {
    private FileSystemStorage.FileSystemWriter org$locationtech$geomesa$tools$export$formats$FileSystemExporter$$writer;

    public static Logger logger() {
        return FileSystemExporter$.MODULE$.logger();
    }

    public FileSystemStorage.FileSystemWriter org$locationtech$geomesa$tools$export$formats$FileSystemExporter$$writer() {
        return this.org$locationtech$geomesa$tools$export$formats$FileSystemExporter$$writer;
    }

    private void org$locationtech$geomesa$tools$export$formats$FileSystemExporter$$writer_$eq(FileSystemStorage.FileSystemWriter x$1) {
        this.org$locationtech$geomesa$tools$export$formats$FileSystemExporter$$writer = x$1;
    }

    public abstract FileSystemStorage.FileSystemWriter createWriter(SimpleFeatureType var1);

    @Override
    public void start(SimpleFeatureType sft) {
        if (this.org$locationtech$geomesa$tools$export$formats$FileSystemExporter$$writer() != null) {
            this.org$locationtech$geomesa$tools$export$formats$FileSystemExporter$$writer().close();
        }
        this.org$locationtech$geomesa$tools$export$formats$FileSystemExporter$$writer_$eq(this.createWriter(sft));
    }

    @Override
    public Option<Object> export(Iterator<SimpleFeature> features) {
        Predef$.MODULE$.require(this.org$locationtech$geomesa$tools$export$formats$FileSystemExporter$$writer() != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Must call 'start' before 'export'";
            }
        });
        LongRef i = LongRef.create((long)0L);
        features.foreach((Function1)new Serializable(this, i){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileSystemExporter $outer;
            private final LongRef i$1;

            public final void apply(SimpleFeature f) {
                this.$outer.org$locationtech$geomesa$tools$export$formats$FileSystemExporter$$writer().write(f);
                ++this.i$1.elem;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.i$1 = i$1;
            }
        });
        return new Some((Object)BoxesRunTime.boxToLong((long)i.elem));
    }

    @Override
    public void close() {
        if (this.org$locationtech$geomesa$tools$export$formats$FileSystemExporter$$writer() != null) {
            this.org$locationtech$geomesa$tools$export$formats$FileSystemExporter$$writer().close();
        }
    }

    public static class OrcFileSystemExporter
    extends FileSystemExporter {
        private final String path;

        @Override
        public FileSystemStorage.FileSystemWriter createWriter(SimpleFeatureType sft) {
            return new OrcFileSystemWriter(sft, new Configuration(), new Path(PathUtils$.MODULE$.getUrl(this.path).toURI()));
        }

        public OrcFileSystemExporter(String path) {
            this.path = path;
        }
    }

    public static class ParquetFileSystemExporter
    extends FileSystemExporter {
        private final String path;

        @Override
        public FileSystemStorage.FileSystemWriter createWriter(SimpleFeatureType sft) {
            BoxedUnit boxedUnit;
            Configuration conf = new Configuration();
            StorageConfiguration$.MODULE$.setSft(conf, sft);
            try {
                boxedUnit = Class.forName("org.xerial.snappy.Snappy");
            }
            catch (ClassNotFoundException classNotFoundException) {
                BoxedUnit boxedUnit2;
                if (FileSystemExporter$.MODULE$.logger().underlying().isWarnEnabled()) {
                    FileSystemExporter$.MODULE$.logger().underlying().warn("SNAPPY compression is not available on the classpath - falling back to GZIP");
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                conf.set("parquet.compression", "GZIP");
                boxedUnit = BoxedUnit.UNIT;
            }
            return new ParquetFileSystemStorage.ParquetFileSystemWriter(sft, new Path(PathUtils$.MODULE$.getUrl(this.path).toURI()), conf);
        }

        public ParquetFileSystemExporter(String path) {
            this.path = path;
        }
    }
}

