/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.tools.ingest;

import com.beust.jcommander.ParameterException;
import com.typesafe.config.Config;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.geotools.data.DataStore;
import org.locationtech.geomesa.tools.Command$;
import org.locationtech.geomesa.tools.DistributedRunParam$RunModes$;
import org.locationtech.geomesa.tools.ingest.AbstractConverterIngest;
import org.locationtech.geomesa.tools.ingest.DistributedCombineConverterIngest;
import org.locationtech.geomesa.tools.ingest.DistributedConverterIngest;
import org.locationtech.geomesa.tools.ingest.IngestCommand;
import org.locationtech.geomesa.tools.ingest.IngestCommand$;
import org.locationtech.geomesa.tools.ingest.LocalConverterIngest;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.locationtech.geomesa.utils.io.PathUtils$;
import org.locationtech.geomesa.utils.io.WithClose$;
import org.locationtech.geomesa.utils.io.fs.FileSystemDelegate;
import org.locationtech.geomesa.utils.io.fs.LocalDelegate;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.NotImplementedError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.Buffer$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public abstract class IngestCommand$class {
    public static void execute(IngestCommand $this) {
        block18: {
            block20: {
                Enumeration.Value mode;
                Option<String> format;
                Seq inputs;
                block19: {
                    block17: {
                        block16: {
                            Enumeration.Value value;
                            Seq seq;
                            if ($this.params().files().isEmpty() && !LocalDelegate.StdInHandle$.MODULE$.isAvailable()) {
                                throw new ParameterException("Missing option: <files>... is required");
                            }
                            if ($this.params().srcList()) {
                                List lists = $this.params().files().isEmpty() ? LocalDelegate.StdInHandle$.MODULE$.available().toList() : ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter($this.params().files()).asScala()).flatMap((Function1)new Serializable($this){
                                    public static final long serialVersionUID = 0L;

                                    public final Seq<FileSystemDelegate.FileHandle> apply(String path) {
                                        return PathUtils$.MODULE$.interpretPath(path);
                                    }
                                }, Buffer$.MODULE$.canBuildFrom())).toList();
                                seq = (Seq)lists.flatMap((Function1)new Serializable($this){
                                    public static final long serialVersionUID = 0L;

                                    public final List<String> apply(FileSystemDelegate.FileHandle file2) {
                                        return (List)WithClose$.MODULE$.apply((Object)file2.open(), (Function1)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final List<String> apply(CloseableIterator<Tuple2<Option<String>, InputStream>> iter) {
                                                return iter.flatMap((Function1)new Serializable(this){
                                                    public static final long serialVersionUID = 0L;

                                                    public final Iterator<String> apply(Tuple2<Option<String>, InputStream> x0$1) {
                                                        Tuple2<Option<String>, InputStream> tuple2 = x0$1;
                                                        if (tuple2 != null) {
                                                            InputStream is = (InputStream)tuple2._2();
                                                            Iterator iterator = (Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter((java.util.Iterator)IOUtils.lineIterator((InputStream)is, (Charset)StandardCharsets.UTF_8)).asScala();
                                                            return iterator;
                                                        }
                                                        throw new MatchError(tuple2);
                                                    }
                                                }).toList();
                                            }
                                        });
                                    }
                                }, List$.MODULE$.canBuildFrom());
                            } else {
                                seq = (Seq)JavaConverters$.MODULE$.asScalaBufferConverter($this.params().files()).asScala();
                            }
                            inputs = seq;
                            format = IngestCommand$.MODULE$.getDataFormat($this.params(), (Seq<String>)inputs);
                            boolean remote = inputs.exists((Function1)new Serializable($this){
                                public static final long serialVersionUID = 0L;

                                public final boolean apply(String path) {
                                    return PathUtils$.MODULE$.isRemote(path);
                                }
                            });
                            if (remote) {
                                String prefix = ((String)inputs.head()).split("/")[0].toLowerCase();
                                if (!((IterableLike)inputs.drop(1)).forall((Function1)new Serializable($this, prefix){
                                    public static final long serialVersionUID = 0L;
                                    private final String prefix$1;

                                    public final boolean apply(String x$1) {
                                        return x$1.toLowerCase().startsWith(this.prefix$1);
                                    }
                                    {
                                        this.prefix$1 = prefix$1;
                                    }
                                })) {
                                    throw new ParameterException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Files must all be on the same file system: (", ") or all be local"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{prefix})));
                                }
                            }
                            if (format.contains((Object)"shp")) {
                                if (Option$.MODULE$.apply((Object)$this.params().mode()).exists((Function1)new Serializable($this){
                                    public static final long serialVersionUID = 0L;

                                    public final boolean apply(Enumeration.Value x$2) {
                                        Enumeration.Value value = x$2;
                                        Enumeration.Value value2 = DistributedRunParam$RunModes$.MODULE$.Local();
                                        return value != null ? !value.equals(value2) : value2 != null;
                                    }
                                })) {
                                    Command$.MODULE$.user().warn("Forcing run mode to local for shapefile ingestion");
                                }
                                value = DistributedRunParam$RunModes$.MODULE$.Local();
                            } else if (remote) {
                                value = (Enumeration.Value)Option$.MODULE$.apply((Object)$this.params().mode()).getOrElse((Function0)new Serializable($this){
                                    public static final long serialVersionUID = 0L;

                                    public final Enumeration.Value apply() {
                                        return DistributedRunParam$RunModes$.MODULE$.Distributed();
                                    }
                                });
                            } else {
                                if (Option$.MODULE$.apply((Object)$this.params().mode()).exists((Function1)new Serializable($this){
                                    public static final long serialVersionUID = 0L;

                                    public final boolean apply(Enumeration.Value x$3) {
                                        Enumeration.Value value = x$3;
                                        Enumeration.Value value2 = DistributedRunParam$RunModes$.MODULE$.Local();
                                        return value != null ? !value.equals(value2) : value2 != null;
                                    }
                                })) {
                                    throw new ParameterException("Input files must be in a distributed file system to run in distributed mode");
                                }
                                value = DistributedRunParam$RunModes$.MODULE$.Local();
                            }
                            Enumeration.Value value2 = mode = value;
                            Enumeration.Value value3 = DistributedRunParam$RunModes$.MODULE$.Local();
                            if (value2 != null ? !value2.equals(value3) : value3 != null) break block16;
                            if (!$this.params().waitForCompletion()) {
                                throw new ParameterException("Tracking must be enabled when running in local mode");
                            }
                            break block17;
                        }
                        if (!BoxesRunTime.equalsNumObject((Number)$this.params().threads(), (Object)BoxesRunTime.boxToInteger((int)1))) break block18;
                    }
                    if ($this.params().maxSplitSize() == null) break block19;
                    Enumeration.Value value = mode;
                    Enumeration.Value value4 = DistributedRunParam$RunModes$.MODULE$.DistributedCombine();
                    if (value != null ? !value.equals(value4) : value4 != null) break block20;
                }
                ((Option)IngestCommand$.MODULE$.getSftAndConverter($this.params(), (Seq<String>)inputs, format, (Option<Function0<DataStore>>)new Some((Object)new Serializable($this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ IngestCommand $outer;

                    public final DS apply() {
                        return this.$outer.loadDataStore();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                })).get()).foreach((Function1)new Serializable($this, inputs, mode){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ IngestCommand $outer;
                    private final Seq inputs$2;
                    private final Enumeration.Value mode$1;

                    public final void apply(Tuple2<SimpleFeatureType, Config> x0$2) {
                        Tuple2<SimpleFeatureType, Config> tuple2 = x0$2;
                        if (tuple2 != null) {
                            SimpleFeatureType sft = (SimpleFeatureType)tuple2._1();
                            Config converter = (Config)tuple2._2();
                            this.$outer.createIngest(this.mode$1, sft, converter, (Seq<String>)this.inputs$2).run();
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        void var3_3;
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.inputs$2 = inputs$2;
                        this.mode$1 = var3_3;
                    }
                });
                return;
            }
            throw new ParameterException("Split size can only be specified in distributed-combine mode");
        }
        throw new ParameterException("Threads can only be specified in local mode");
    }

    public static Runnable createIngest(IngestCommand $this, Enumeration.Value mode, SimpleFeatureType sft, Config converter, Seq inputs) {
        block5: {
            AbstractConverterIngest abstractConverterIngest;
            block3: {
                Enumeration.Value value;
                block4: {
                    block2: {
                        value = mode;
                        Enumeration.Value value2 = DistributedRunParam$RunModes$.MODULE$.Local();
                        Enumeration.Value value3 = value;
                        if (value2 != null ? !value2.equals(value3) : value3 != null) break block2;
                        abstractConverterIngest = new LocalConverterIngest($this.connection(), sft, converter, (Seq<String>)inputs, Predef$.MODULE$.Integer2int($this.params().threads()));
                        break block3;
                    }
                    Enumeration.Value value4 = DistributedRunParam$RunModes$.MODULE$.Distributed();
                    Enumeration.Value value5 = value;
                    if (value4 != null ? !value4.equals(value5) : value5 != null) break block4;
                    abstractConverterIngest = new DistributedConverterIngest($this.connection(), sft, converter, (Seq<String>)inputs, $this.libjarsFile(), $this.libjarsPaths(), $this.params().waitForCompletion());
                    break block3;
                }
                Enumeration.Value value6 = DistributedRunParam$RunModes$.MODULE$.DistributedCombine();
                Enumeration.Value value7 = value;
                if (value6 != null ? !value6.equals(value7) : value7 != null) break block5;
                abstractConverterIngest = new DistributedCombineConverterIngest($this.connection(), sft, converter, (Seq<String>)inputs, $this.libjarsFile(), $this.libjarsPaths(), (Option<Integer>)Option$.MODULE$.apply((Object)$this.params().maxSplitSize()), $this.params().waitForCompletion());
            }
            return abstractConverterIngest;
        }
        throw new NotImplementedError(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Missing implementation for mode ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{mode})));
    }

    public static void $init$(IngestCommand $this) {
        $this.org$locationtech$geomesa$tools$ingest$IngestCommand$_setter_$name_$eq("ingest");
    }
}

