/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml2.bindings;

import java.util.List;
import javax.xml.namespace.QName;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.gml2.GML;
import org.geotools.gml2.bindings.GML2EncodingUtils;
import org.geotools.xml.AbstractComplexBinding;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.Node;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Envelope;

public class GMLBoxTypeBinding
extends AbstractComplexBinding {
    public QName getTarget() {
        return GML.BoxType;
    }

    public Class getType() {
        return Envelope.class;
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        List coordinates = node.getChildren("coord");
        if (!coordinates.isEmpty() && coordinates.size() == 2) {
            Node n1 = (Node)coordinates.get(0);
            Node n2 = (Node)coordinates.get(1);
            Coordinate c1 = (Coordinate)n1.getValue();
            Coordinate c2 = (Coordinate)n2.getValue();
            return new Envelope(c1.x, c2.x, c1.y, c2.y);
        }
        if (!coordinates.isEmpty()) {
            throw new RuntimeException("Envelope can have only two coordinates");
        }
        if (node.getChild("coordinates") != null) {
            CoordinateSequence cs = (CoordinateSequence)node.getChild("coordinates").getValue();
            if (cs.size() != 2) {
                throw new RuntimeException("Envelope can have only two coordinates");
            }
            return new Envelope(cs.getX(0), cs.getX(1), cs.getY(0), cs.getY(1));
        }
        throw new RuntimeException("Could not find coordinates for envelope");
    }

    public Object getProperty(Object object, QName name) throws Exception {
        Envelope e = (Envelope)object;
        if (GML.coord.equals(name)) {
            return new Coordinate[]{new Coordinate(e.getMinX(), e.getMinY()), new Coordinate(e.getMaxX(), e.getMaxY())};
        }
        if ("srsName".equals(name.getLocalPart()) && e instanceof ReferencedEnvelope) {
            return GML2EncodingUtils.toURI(((ReferencedEnvelope)e).getCoordinateReferenceSystem());
        }
        return null;
    }
}

