/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.projection;

import java.util.List;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.referencing.operation.projection.Mercator;
import org.geotools.resources.i18n.Vocabulary;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.CylindricalProjection;
import org.opengis.referencing.operation.MathTransform;
import si.uom.NonSI;

public class MercatorPseudoProvider
extends MapProjection.AbstractProvider {
    private static final long serialVersionUID = 118002069939741891L;
    public static final ParameterDescriptor AUXILIARY_SPHERE_TYPE = MercatorPseudoProvider.createDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.ESRI, "Auxiliary_sphere_type")}, 0.0, 0.0, 0.0, null);
    public static final ParameterDescriptor FAKE_ESRI_STANDARD_PARALLELL = MercatorPseudoProvider.createDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.ESRI, "Standard_parallel_1")}, 0.0, 0.0, 0.0, NonSI.DEGREE_ANGLE);
    static final ParameterDescriptorGroup PARAMETERS = MercatorPseudoProvider.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(Citations.EPSG, "Popular Visualisation Pseudo Mercator"), new NamedIdentifier(Citations.EPSG, "1024"), new NamedIdentifier(Citations.ESRI, "Mercator_Auxiliary_Sphere"), new NamedIdentifier(Citations.GEOTOOLS, Vocabulary.formatInternational((int)34))}, (GeneralParameterDescriptor[])new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, LATITUDE_OF_ORIGIN, CENTRAL_MERIDIAN, SCALE_FACTOR, FALSE_EASTING, FALSE_NORTHING, FAKE_ESRI_STANDARD_PARALLELL, AUXILIARY_SPHERE_TYPE});
    static final ParameterDescriptorGroup BASE_PARAMETERS = MercatorPseudoProvider.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(Citations.EPSG, "Popular Visualisation Pseudo Mercator"), new NamedIdentifier(Citations.EPSG, "1024"), new NamedIdentifier(Citations.GEOTOOLS, Vocabulary.formatInternational((int)34))}, (GeneralParameterDescriptor[])new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, LATITUDE_OF_ORIGIN, CENTRAL_MERIDIAN, SCALE_FACTOR, FALSE_EASTING, FALSE_NORTHING});

    public MercatorPseudoProvider() {
        super(PARAMETERS);
    }

    public Class<CylindricalProjection> getOperationType() {
        return CylindricalProjection.class;
    }

    @Override
    protected MathTransform createMathTransform(ParameterValueGroup parameters) throws ParameterNotFoundException {
        parameters.parameter("semi_minor").setValue(parameters.parameter("semi_major").getValue());
        return new Spherical(parameters);
    }

    private static final class Spherical
    extends Mercator.Spherical {
        private static final long serialVersionUID = -7583892502939355783L;

        protected Spherical(ParameterValueGroup parameters) throws ParameterNotFoundException {
            super(parameters);
        }

        @Override
        public ParameterValueGroup getParameterValues() {
            ParameterDescriptorGroup descriptor = BASE_PARAMETERS;
            List expected = descriptor.descriptors();
            ParameterValueGroup values = descriptor.createValue();
            this.set(expected, MapProjection.AbstractProvider.SEMI_MAJOR, values, this.semiMajor);
            this.set(expected, MapProjection.AbstractProvider.SEMI_MINOR, values, this.semiMinor);
            this.set(expected, MapProjection.AbstractProvider.CENTRAL_MERIDIAN, values, this.centralMeridian);
            this.set(expected, MapProjection.AbstractProvider.LATITUDE_OF_ORIGIN, values, this.latitudeOfOrigin);
            this.set(expected, MapProjection.AbstractProvider.SCALE_FACTOR, values, this.scaleFactor);
            this.set(expected, MapProjection.AbstractProvider.FALSE_EASTING, values, this.falseEasting);
            this.set(expected, MapProjection.AbstractProvider.FALSE_NORTHING, values, this.falseNorthing);
            if (!Double.isNaN(this.standardParallel)) {
                this.set(expected, MapProjection.AbstractProvider.STANDARD_PARALLEL_1, values, this.standardParallel);
            }
            return values;
        }

        @Override
        public ParameterDescriptorGroup getParameterDescriptors() {
            return PARAMETERS;
        }

        @Override
        protected double getToleranceForAssertions(double longitude, double latitude) {
            double delta = Math.abs(longitude - this.centralMeridian) / 2.0 + Math.abs(latitude - this.latitudeOfOrigin);
            if (delta > 40.0) {
                return 1.0;
            }
            return 0.1;
        }
    }
}

