/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.scale;

import com.sun.media.jai.util.ImageUtil;
import com.sun.media.jai.util.Rational;
import it.geosolutions.jaiext.interpolators.InterpolationBicubic;
import it.geosolutions.jaiext.interpolators.InterpolationBilinear;
import it.geosolutions.jaiext.interpolators.InterpolationNearest;
import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.scale.JaiI18N;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.ParameterBlock;
import java.math.BigInteger;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.GeometricOpImage;
import javax.media.jai.ImageLayout;
import javax.media.jai.IntegerSequence;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.RenderedOp;

public abstract class Scale2OpImage
extends GeometricOpImage {
    protected double scaleX;
    protected double scaleY;
    protected double transX;
    protected double transY;
    protected Rational scaleXRational;
    protected Rational scaleYRational;
    protected BigInteger scaleXRationalNum;
    protected BigInteger scaleXRationalDenom;
    protected BigInteger scaleYRationalNum;
    protected BigInteger scaleYRationalDenom;
    protected Rational invScaleXRational;
    protected Rational invScaleYRational;
    protected BigInteger invScaleXRationalNum;
    protected BigInteger invScaleXRationalDenom;
    protected BigInteger invScaleYRationalNum;
    protected BigInteger invScaleYRationalDenom;
    protected Rational transXRational;
    protected Rational transYRational;
    protected BigInteger transXRationalNum;
    protected BigInteger transXRationalDenom;
    protected BigInteger transYRationalNum;
    protected BigInteger transYRationalDenom;
    protected static float rationalTolerance = 1.0E-8f;
    private int lpad;
    private int rpad;
    private int tpad;
    private int bpad;
    protected final ROI srcROI;
    protected final PlanarImage srcROIImage;
    protected final boolean hasROI;
    protected final Rectangle roiBounds;
    protected boolean useRoiAccessor;
    protected long invScaleXInt;
    protected BigInteger invScaleXFrac;
    protected long invScaleYInt;
    protected BigInteger invScaleYFrac;
    protected Interpolation interpolator = null;
    protected boolean isBinary;
    protected int subsampleBits;
    protected int one;
    protected int interp_width;
    protected int interp_height;
    protected int interp_left;
    protected int interp_top;
    protected int shift;
    protected int shift2;
    protected int round2;
    protected int precisionBits;
    protected int round;
    protected int dataType;
    protected Range noData;
    protected boolean hasNoData = false;
    protected byte[] destinationNoDataByte;
    protected short[] destinationNoDataUShort;
    protected short[] destinationNoDataShort;
    protected int[] destinationNoDataInt;
    protected float[] destinationNoDataFloat;
    protected double[] destinationNoDataDouble;
    protected boolean isNegativeInf = false;
    protected boolean isPositiveInf = false;
    protected boolean isRangeNaN = false;
    protected boolean isNearestNew = false;
    protected boolean isBilinearNew = false;
    protected boolean isBicubicNew = false;
    protected boolean caseA;
    protected boolean caseB;
    protected boolean caseC;
    protected RenderedOp srcROIImgExt;
    protected RenderedOp extendedIMG;
    protected Rectangle roiRect;
    static final BigInteger ZERO = BigInteger.valueOf(0L);
    static final BigInteger ONE = BigInteger.valueOf(1L);
    static final BigInteger TWO = BigInteger.valueOf(2L);
    static final BigInteger THREE = BigInteger.valueOf(3L);
    static final BorderExtender ROI_EXTENDER = BorderExtender.createInstance((int)0);

    private static ImageLayout layoutHelper(RenderedImage source, double scaleX, double scaleY, double transX, double transY, Interpolation interp, ImageLayout il) {
        Rational scaleXRational = Rational.approximate((double)scaleX, (double)rationalTolerance);
        Rational scaleYRational = Rational.approximate((double)scaleY, (double)rationalTolerance);
        BigInteger scaleXRationalNum = BigInteger.valueOf(scaleXRational.num);
        BigInteger scaleXRationalDenom = BigInteger.valueOf(scaleXRational.denom);
        BigInteger scaleYRationalNum = BigInteger.valueOf(scaleYRational.num);
        BigInteger scaleYRationalDenom = BigInteger.valueOf(scaleYRational.denom);
        Rational transXRational = Rational.approximate((double)transX, (double)rationalTolerance);
        Rational transYRational = Rational.approximate((double)transY, (double)rationalTolerance);
        BigInteger transXRationalNum = BigInteger.valueOf(transXRational.num);
        BigInteger transXRationalDenom = BigInteger.valueOf(transXRational.denom);
        BigInteger transYRationalNum = BigInteger.valueOf(transYRational.num);
        BigInteger transYRationalDenom = BigInteger.valueOf(transYRational.denom);
        ImageLayout layout = il == null ? new ImageLayout() : (ImageLayout)il.clone();
        int x0 = source.getMinX();
        int y0 = source.getMinY();
        int w = source.getWidth();
        int h = source.getHeight();
        BigInteger dx0Num = BigInteger.valueOf(x0);
        BigInteger dx0Denom = ONE;
        BigInteger dy0Num = BigInteger.valueOf(y0);
        BigInteger dy0Denom = ONE;
        BigInteger dx1Num = BigInteger.valueOf(x0 + w);
        BigInteger dx1Denom = ONE;
        BigInteger dy1Num = BigInteger.valueOf(y0 + h);
        BigInteger dy1Denom = ONE;
        dx0Num = dx0Num.multiply(scaleXRationalNum);
        dx0Denom = dx0Denom.multiply(scaleXRationalDenom);
        dy0Num = dy0Num.multiply(scaleYRationalNum);
        dy0Denom = dy0Denom.multiply(scaleYRationalDenom);
        dx1Num = dx1Num.multiply(scaleXRationalNum);
        dx1Denom = dx1Denom.multiply(scaleXRationalDenom);
        dy1Num = dy1Num.multiply(scaleYRationalNum);
        dy1Denom = dy1Denom.multiply(scaleYRationalDenom);
        dx0Num = dx0Num.multiply(TWO).subtract(dx0Denom);
        dx0Denom = dx0Denom.multiply(TWO);
        dy0Num = dy0Num.multiply(TWO).subtract(dy0Denom);
        dy0Denom = dy0Denom.multiply(TWO);
        dx1Num = dx1Num.multiply(TWO).subtract(dx1Denom.multiply(THREE));
        dx1Denom = dx1Denom.multiply(TWO);
        dy1Num = dy1Num.multiply(TWO).subtract(dy1Denom.multiply(THREE));
        dy1Denom = dy1Denom.multiply(TWO);
        dx0Num = dx0Num.multiply(transXRationalDenom).add(transXRationalNum.multiply(dx0Denom));
        dx0Denom = dx0Denom.multiply(transXRationalDenom);
        dy0Num = dy0Num.multiply(transYRationalDenom).add(transYRationalNum.multiply(dy0Denom));
        dy0Denom = dy0Denom.multiply(transYRationalDenom);
        dx1Num = dx1Num.multiply(transXRationalDenom).add(transXRationalNum.multiply(dx1Denom));
        dx1Denom = dx1Denom.multiply(transXRationalDenom);
        dy1Num = dy1Num.multiply(transYRationalDenom).add(transYRationalNum.multiply(dy1Denom));
        dy1Denom = dy1Denom.multiply(transYRationalDenom);
        int l_x0 = Rational.ceil((long)dx0Num.longValue(), (long)dx0Denom.longValue());
        int l_y0 = Rational.ceil((long)dy0Num.longValue(), (long)dy0Denom.longValue());
        int l_x1 = Rational.ceil((long)dx1Num.longValue(), (long)dx1Denom.longValue());
        int l_y1 = Rational.ceil((long)dy1Num.longValue(), (long)dy1Denom.longValue());
        layout.setMinX(l_x0);
        layout.setMinY(l_y0);
        int width = l_x1 - l_x0 + 1;
        int height = l_y1 - l_y0 + 1;
        if (width < 1) {
            width = 1;
        }
        if (height < 1) {
            height = 1;
        }
        layout.setWidth(width);
        layout.setHeight(height);
        return layout;
    }

    protected final void preComputePositionsInt(Rectangle destRect, int srcRectX, int srcRectY, int srcPixelStride, int srcScanlineStride, int[] xpos, int[] ypos, int[] xfracvalues, int[] yfracvalues, int roiScanlineStride, int[] yposRoi) {
        int i;
        int dwidth = destRect.width;
        int dheight = destRect.height;
        int dx = destRect.x;
        int dy = destRect.y;
        BigInteger syNum = BigInteger.valueOf(dy);
        BigInteger syDenom = ONE;
        syNum = syNum.multiply(this.transYRationalDenom).subtract(this.transYRationalNum.multiply(syDenom));
        syDenom = syDenom.multiply(this.transYRationalDenom);
        syNum = syNum.multiply(TWO).add(syDenom);
        syDenom = syDenom.multiply(TWO);
        syNum = syNum.multiply(this.invScaleYRationalNum);
        syDenom = syDenom.multiply(this.invScaleYRationalDenom);
        if (this.isBilinearNew || this.isBicubicNew) {
            syNum = syNum.multiply(TWO).subtract(syDenom);
            syDenom = syDenom.multiply(TWO);
        }
        int srcYInt = Rational.floor((long)syNum.longValue(), (long)syDenom.longValue());
        BigInteger srcYFrac = syNum.mod(syDenom);
        if (srcYInt < 0) {
            srcYFrac = syDenom.add(srcYFrac);
        }
        BigInteger commonYDenom = syDenom.multiply(this.invScaleYRationalDenom);
        srcYFrac = srcYFrac.multiply(this.invScaleYRationalDenom);
        BigInteger newInvScaleYFrac = this.invScaleYFrac.multiply(syDenom);
        BigInteger sxNum = BigInteger.valueOf(dx);
        BigInteger sxDenom = ONE;
        sxNum = sxNum.multiply(this.transXRationalDenom).subtract(this.transXRationalNum.multiply(sxDenom));
        sxDenom = sxDenom.multiply(this.transXRationalDenom);
        sxNum = sxNum.multiply(TWO).add(sxDenom);
        sxDenom = sxDenom.multiply(TWO);
        sxNum = sxNum.multiply(this.invScaleXRationalNum);
        sxDenom = sxDenom.multiply(this.invScaleXRationalDenom);
        if (this.isBilinearNew || this.isBicubicNew) {
            sxNum = sxNum.multiply(TWO).subtract(sxDenom);
            sxDenom = sxDenom.multiply(TWO);
        }
        int srcXInt = Rational.floor((long)sxNum.longValue(), (long)sxDenom.longValue());
        BigInteger srcXFrac = sxNum.mod(sxDenom);
        if (srcXInt < 0) {
            srcXFrac = sxDenom.add(srcXFrac);
        }
        BigInteger commonXDenom = sxDenom.multiply(this.invScaleXRationalDenom);
        srcXFrac = srcXFrac.multiply(this.invScaleXRationalDenom);
        BigInteger newInvScaleXFrac = this.invScaleXFrac.multiply(sxDenom);
        for (i = 0; i < dwidth; ++i) {
            xpos[i] = this.isBinary ? srcXInt : (srcXInt - srcRectX) * srcPixelStride;
            if (this.isBilinearNew || this.isBicubicNew) {
                xfracvalues[i] = (int)(1.0f * srcXFrac.floatValue() / commonXDenom.floatValue() * (float)this.one);
            }
            srcXInt = (int)((long)srcXInt + this.invScaleXInt);
            if ((srcXFrac = srcXFrac.add(newInvScaleXFrac)).compareTo(commonXDenom) < 0) continue;
            ++srcXInt;
            srcXFrac = srcXFrac.subtract(commonXDenom);
        }
        for (i = 0; i < dheight; ++i) {
            ypos[i] = this.isBinary ? srcYInt : (srcYInt - srcRectY) * srcScanlineStride;
            if (this.useRoiAccessor) {
                yposRoi[i] = this.isBinary ? srcYInt : (srcYInt - srcRectY) * roiScanlineStride;
            }
            if (this.isBilinearNew || this.isBicubicNew) {
                yfracvalues[i] = (int)(1.0f * srcYFrac.floatValue() / commonYDenom.floatValue() * (float)this.one);
            }
            srcYInt = (int)((long)srcYInt + this.invScaleYInt);
            if ((srcYFrac = srcYFrac.add(newInvScaleYFrac)).compareTo(commonYDenom) < 0) continue;
            ++srcYInt;
            srcYFrac = srcYFrac.subtract(commonYDenom);
        }
    }

    protected final void preComputePositionsFloat(Rectangle destRect, int srcRectX, int srcRectY, int srcPixelStride, int srcScanlineStride, int[] xpos, int[] ypos, float[] xfracvalues, float[] yfracvalues, int roiScanlineStride, int[] yposRoi) {
        int i;
        int dwidth = destRect.width;
        int dheight = destRect.height;
        int dx = destRect.x;
        int dy = destRect.y;
        BigInteger syNum = BigInteger.valueOf(dy);
        BigInteger syDenom = ONE;
        syNum = syNum.multiply(this.transYRationalDenom).subtract(this.transYRationalNum.multiply(syDenom));
        syDenom = syDenom.multiply(this.transYRationalDenom);
        syNum = syNum.multiply(TWO).add(syDenom);
        syDenom = syDenom.multiply(TWO);
        syNum = syNum.multiply(this.invScaleYRationalNum);
        syDenom = syDenom.multiply(this.invScaleYRationalDenom);
        if (this.isBilinearNew || this.isBicubicNew) {
            syNum = syNum.multiply(TWO).subtract(syDenom);
            syDenom = syDenom.multiply(TWO);
        }
        int srcYInt = Rational.floor((long)syNum.longValue(), (long)syDenom.longValue());
        BigInteger srcYFrac = syNum.mod(syDenom);
        if (srcYInt < 0) {
            srcYFrac = syDenom.add(srcYFrac);
        }
        BigInteger commonYDenom = syDenom.multiply(this.invScaleYRationalDenom);
        srcYFrac = srcYFrac.multiply(this.invScaleYRationalDenom);
        BigInteger newInvScaleYFrac = this.invScaleYFrac.multiply(syDenom);
        BigInteger sxNum = BigInteger.valueOf(dx);
        BigInteger sxDenom = ONE;
        sxNum = sxNum.multiply(this.transXRationalDenom).subtract(this.transXRationalNum.multiply(sxDenom));
        sxDenom = sxDenom.multiply(this.transXRationalDenom);
        sxNum = sxNum.multiply(TWO).add(sxDenom);
        sxDenom = sxDenom.multiply(TWO);
        sxNum = sxNum.multiply(this.invScaleXRationalNum);
        sxDenom = sxDenom.multiply(this.invScaleXRationalDenom);
        if (this.isBilinearNew || this.isBicubicNew) {
            sxNum = sxNum.multiply(TWO).subtract(sxDenom);
            sxDenom = sxDenom.multiply(TWO);
        }
        int srcXInt = Rational.floor((long)sxNum.longValue(), (long)sxDenom.longValue());
        BigInteger srcXFrac = sxNum.mod(sxDenom);
        if (srcXInt < 0) {
            srcXFrac = sxDenom.add(srcXFrac);
        }
        BigInteger commonXDenom = sxDenom.multiply(this.invScaleXRationalDenom);
        srcXFrac = srcXFrac.multiply(this.invScaleXRationalDenom);
        BigInteger newInvScaleXFrac = this.invScaleXFrac.multiply(sxDenom);
        for (i = 0; i < dwidth; ++i) {
            xpos[i] = this.isBinary ? srcXInt : (srcXInt - srcRectX) * srcPixelStride;
            if (this.isBilinearNew || this.isBicubicNew) {
                xfracvalues[i] = 1.0f * srcXFrac.floatValue() / commonXDenom.floatValue();
            }
            srcXInt = (int)((long)srcXInt + this.invScaleXInt);
            if ((srcXFrac = srcXFrac.add(newInvScaleXFrac)).compareTo(commonXDenom) < 0) continue;
            ++srcXInt;
            srcXFrac = srcXFrac.subtract(commonXDenom);
        }
        for (i = 0; i < dheight; ++i) {
            ypos[i] = this.isBinary ? srcYInt : (srcYInt - srcRectY) * srcScanlineStride;
            if (this.useRoiAccessor) {
                yposRoi[i] = this.isBinary ? srcYInt : (srcYInt - srcRectY) * roiScanlineStride;
            }
            if (this.isBilinearNew || this.isBicubicNew) {
                yfracvalues[i] = 1.0f * srcYFrac.floatValue() / commonYDenom.floatValue();
            }
            srcYInt = (int)((long)srcYInt + this.invScaleYInt);
            if ((srcYFrac = srcYFrac.add(newInvScaleYFrac)).compareTo(commonYDenom) < 0) continue;
            ++srcYInt;
            srcYFrac = srcYFrac.subtract(commonYDenom);
        }
    }

    private static Map<Object, Object> configHelper(RenderedImage source, Map<Object, Object> configuration, Interpolation interp) {
        RenderingHints config = configuration;
        if (ImageUtil.isBinary((SampleModel)source.getSampleModel()) && (interp == null || interp instanceof InterpolationNearest || interp instanceof InterpolationBilinear)) {
            if (configuration == null) {
                config = new RenderingHints(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.FALSE);
            } else if (!config.containsKey(JAI.KEY_REPLACE_INDEX_COLOR_MODEL)) {
                RenderingHints hints = new RenderingHints(null);
                hints.putAll((Map<?, ?>)configuration);
                config = hints;
                config.put(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.TRUE);
            }
        }
        return config;
    }

    public Scale2OpImage(RenderedImage source, ImageLayout layout, Map configuration, boolean cobbleSources, BorderExtender extender, Interpolation interp, double scaleX, double scaleY, double transX, double transY, boolean useRoiAccessor, double[] backgroundValues) {
        super(Scale2OpImage.vectorize((RenderedImage)source), Scale2OpImage.layoutHelper(source, scaleX, scaleY, transX, transY, interp, layout), Scale2OpImage.configHelper(source, configuration, interp), cobbleSources, extender, interp, backgroundValues);
        this.scaleX = scaleX;
        this.scaleY = scaleY;
        this.transX = transX;
        this.transY = transY;
        this.scaleXRational = Rational.approximate((double)scaleX, (double)rationalTolerance);
        this.scaleYRational = Rational.approximate((double)scaleY, (double)rationalTolerance);
        this.scaleXRationalNum = BigInteger.valueOf(this.scaleXRational.num);
        this.scaleXRationalDenom = BigInteger.valueOf(this.scaleXRational.denom);
        this.scaleYRationalNum = BigInteger.valueOf(this.scaleYRational.num);
        this.scaleYRationalDenom = BigInteger.valueOf(this.scaleYRational.denom);
        this.transXRational = Rational.approximate((double)transX, (double)rationalTolerance);
        this.transYRational = Rational.approximate((double)transY, (double)rationalTolerance);
        this.transXRationalNum = BigInteger.valueOf(this.transXRational.num);
        this.transXRationalDenom = BigInteger.valueOf(this.transXRational.denom);
        this.transYRationalNum = BigInteger.valueOf(this.transYRational.num);
        this.transYRationalDenom = BigInteger.valueOf(this.transYRational.denom);
        this.invScaleXRational = new Rational(this.scaleXRational);
        this.invScaleXRational.invert();
        this.invScaleYRational = new Rational(this.scaleYRational);
        this.invScaleYRational.invert();
        this.invScaleXRationalNum = BigInteger.valueOf(this.invScaleXRational.num);
        this.invScaleXRationalDenom = BigInteger.valueOf(this.invScaleXRational.denom);
        this.invScaleYRationalNum = BigInteger.valueOf(this.invScaleYRational.num);
        this.invScaleYRationalDenom = BigInteger.valueOf(this.invScaleYRational.denom);
        this.lpad = interp.getLeftPadding();
        this.rpad = interp.getRightPadding();
        this.tpad = interp.getTopPadding();
        this.bpad = interp.getBottomPadding();
        if (extender == null) {
            int l_y1;
            BigInteger dy1Denom;
            BigInteger dy1Num;
            BigInteger dx1Denom;
            BigInteger dx1Num;
            BigInteger dy0Denom;
            BigInteger dy0Num;
            BigInteger dx0Denom;
            BigInteger dx0Num;
            int x0 = source.getMinX();
            int y0 = source.getMinY();
            int w = source.getWidth();
            int h = source.getHeight();
            BigInteger x0Big = BigInteger.valueOf(x0);
            BigInteger y0Big = BigInteger.valueOf(y0);
            BigInteger wBig = BigInteger.valueOf(w);
            BigInteger hBig = BigInteger.valueOf(h);
            if (interp instanceof InterpolationNearest) {
                dx0Num = BigInteger.valueOf(x0);
                dx0Denom = ONE;
                dy0Num = BigInteger.valueOf(y0);
                dy0Denom = ONE;
                dx1Num = x0Big.add(wBig);
                dx1Denom = ONE;
                dy1Num = y0Big.add(hBig);
                dy1Denom = ONE;
            } else {
                dx0Num = x0Big.multiply(TWO).add(ONE);
                dx0Denom = TWO;
                dy0Num = y0Big.multiply(TWO).add(ONE);
                dy0Denom = TWO;
                dx1Num = x0Big.multiply(TWO).add(wBig.multiply(TWO)).add(ONE);
                dx1Denom = TWO;
                dy1Num = y0Big.multiply(TWO).add(hBig.multiply(TWO)).add(ONE);
                dy1Denom = TWO;
                dx0Num = dx0Denom.multiply(BigInteger.valueOf(this.lpad)).add(dx0Num);
                dy0Num = dy0Denom.multiply(BigInteger.valueOf(this.tpad)).add(dy0Num);
                dx1Num = dx1Num.subtract(dx1Denom.multiply(BigInteger.valueOf(this.rpad)));
                dy1Num = dy1Num.subtract(dy1Denom.multiply(BigInteger.valueOf(this.bpad)));
            }
            dx0Num = dx0Num.multiply(this.scaleXRationalNum);
            dx0Denom = dx0Denom.multiply(this.scaleXRationalDenom);
            dx0Num = dx0Num.multiply(this.transXRationalDenom).add(this.transXRationalNum.multiply(dx0Denom));
            dx0Denom = dx0Denom.multiply(this.transXRationalDenom);
            dy0Num = dy0Num.multiply(this.scaleYRationalNum);
            dy0Denom = dy0Denom.multiply(this.scaleYRationalDenom);
            dy0Num = dy0Num.multiply(this.transYRationalDenom).add(this.transYRationalNum.multiply(dy0Denom));
            dy0Denom = dy0Denom.multiply(this.transYRationalDenom);
            dx1Num = dx1Num.multiply(this.scaleXRationalNum);
            dx1Denom = dx1Denom.multiply(this.scaleXRationalDenom);
            dx1Num = dx1Num.multiply(this.transXRationalDenom).add(this.transXRationalNum.multiply(dx1Denom));
            dx1Denom = dx1Denom.multiply(this.transXRationalDenom);
            dy1Num = dy1Num.multiply(this.scaleYRationalNum);
            dy1Denom = dy1Denom.multiply(this.scaleYRationalDenom);
            dy1Num = dy1Num.multiply(this.transYRationalDenom).add(this.transYRationalNum.multiply(dy1Denom));
            dy1Denom = dy1Denom.multiply(this.transYRationalDenom);
            dx0Num = dx0Num.multiply(TWO).subtract(dx0Denom);
            dx0Denom = dx0Denom.multiply(TWO);
            dy0Num = dy0Num.multiply(TWO).subtract(dy0Denom);
            dy0Denom = dy0Denom.multiply(TWO);
            int l_x0 = Rational.ceil((long)dx0Num.longValue(), (long)dx0Denom.longValue());
            int l_y0 = Rational.ceil((long)dy0Num.longValue(), (long)dy0Denom.longValue());
            dx1Num = dx1Num.multiply(TWO).subtract(dx1Denom);
            dx1Denom = dx1Denom.multiply(TWO);
            dy1Num = dy1Num.multiply(TWO).subtract(dy1Denom);
            dy1Denom = dy1Denom.multiply(TWO);
            int l_x1 = Rational.floor((long)dx1Num.longValue(), (long)dx1Denom.longValue());
            if (dx1Num.equals(dx1Denom.multiply(BigInteger.valueOf(l_x1)))) {
                --l_x1;
            }
            if (dy1Num.equals(dy1Denom.multiply(BigInteger.valueOf(l_y1 = Rational.floor((long)dy1Num.longValue(), (long)dy1Denom.longValue()))))) {
                --l_y1;
            }
            this.computableBounds = new Rectangle(l_x0, l_y0, l_x1 - l_x0 + 1, l_y1 - l_y0 + 1);
        } else {
            this.computableBounds = this.getBounds();
            ParameterBlock pb = new ParameterBlock();
            pb.setSource(source, 0);
            int leftPadding = this.lpad;
            int topPadding = this.tpad;
            if (interp instanceof InterpolationBilinear || interp instanceof InterpolationBicubic) {
                ++leftPadding;
                ++topPadding;
            }
            pb.set(leftPadding, 0);
            pb.set(this.rpad, 1);
            pb.set(topPadding, 2);
            pb.set(this.bpad, 3);
            pb.set(extender, 4);
            this.extendedIMG = JAI.create((String)"border", (ParameterBlock)pb);
        }
        Object property = source.getProperty("ROI");
        if (property instanceof ROI) {
            this.srcROI = (ROI)property;
            this.srcROIImage = this.srcROI.getAsImage();
            this.roiRect = new Rectangle(this.srcROIImage.getMinX() - this.lpad, this.srcROIImage.getMinY() - this.tpad, this.srcROIImage.getWidth() + this.lpad + this.rpad, this.srcROIImage.getHeight() + this.tpad + this.bpad);
            this.roiBounds = this.srcROIImage.getBounds();
            Rectangle srcRect = new Rectangle(source.getMinX() - this.lpad, source.getMinY() - this.tpad, source.getWidth() + this.lpad + this.rpad, source.getHeight() + this.tpad + this.bpad);
            int deltaX0 = this.roiBounds.x - srcRect.x;
            int leftP = deltaX0 > 0 ? deltaX0 : 0;
            int deltaY0 = this.roiBounds.y - srcRect.y;
            int topP = deltaY0 > 0 ? deltaY0 : 0;
            int deltaX1 = srcRect.x + srcRect.width - this.roiBounds.x - this.roiBounds.width;
            int rightP = deltaX1 > 0 ? deltaX1 : 0;
            int deltaY1 = srcRect.y + srcRect.height - this.roiBounds.y - this.roiBounds.height;
            int bottomP = deltaY1 > 0 ? deltaY1 : 0;
            ParameterBlock pb = new ParameterBlock();
            pb.setSource(this.srcROIImage, 0);
            pb.set(leftP, 0);
            pb.set(rightP, 1);
            pb.set(topP, 2);
            pb.set(bottomP, 3);
            pb.set(ROI_EXTENDER, 4);
            this.srcROIImgExt = JAI.create((String)"border", (ParameterBlock)pb);
            this.hasROI = true;
            this.useRoiAccessor = useRoiAccessor;
        } else {
            this.srcROI = null;
            this.srcROIImage = null;
            this.roiBounds = null;
            this.hasROI = false;
        }
    }

    public Point2D mapDestPoint(Point2D destPt, int sourceIndex) {
        if (destPt == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (sourceIndex != 0) {
            throw new IndexOutOfBoundsException(JaiI18N.getString("Generic1"));
        }
        Point2D pt = (Point2D)destPt.clone();
        pt.setLocation((destPt.getX() - this.transX + 0.5) / this.scaleX - 0.5, (destPt.getY() - this.transY + 0.5) / this.scaleY - 0.5);
        return pt;
    }

    public Point2D mapSourcePoint(Point2D sourcePt, int sourceIndex) {
        if (sourcePt == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (sourceIndex != 0) {
            throw new IndexOutOfBoundsException(JaiI18N.getString("Generic1"));
        }
        Point2D pt = (Point2D)sourcePt.clone();
        pt.setLocation(this.scaleX * (sourcePt.getX() + 0.5) + this.transX - 0.5, this.scaleY * (sourcePt.getY() + 0.5) + this.transY - 0.5);
        return pt;
    }

    protected Rectangle forwardMapRect(Rectangle sourceRect, int sourceIndex) {
        int l_y1;
        BigInteger dy1Denom;
        BigInteger dy1Num;
        BigInteger dx1Denom;
        BigInteger dx1Num;
        BigInteger dy0Denom;
        BigInteger dy0Num;
        BigInteger dx0Denom;
        BigInteger dx0Num;
        if (sourceRect == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (sourceIndex != 0) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic1"));
        }
        int x0 = sourceRect.x;
        int y0 = sourceRect.y;
        int w = sourceRect.width;
        int h = sourceRect.height;
        BigInteger x0Big = BigInteger.valueOf(x0);
        BigInteger y0Big = BigInteger.valueOf(y0);
        BigInteger wBig = BigInteger.valueOf(w);
        BigInteger hBig = BigInteger.valueOf(h);
        if (this.interp instanceof InterpolationNearest) {
            dx0Num = BigInteger.valueOf(x0);
            dx0Denom = ONE;
            dy0Num = BigInteger.valueOf(y0);
            dy0Denom = ONE;
            dx1Num = x0Big.add(wBig);
            dx1Denom = ONE;
            dy1Num = y0Big.add(hBig);
            dy1Denom = ONE;
        } else {
            dx0Num = x0Big.multiply(TWO).add(ONE);
            dx0Denom = TWO;
            dy0Num = y0Big.multiply(TWO).add(ONE);
            dy0Denom = TWO;
            dx1Num = x0Big.multiply(TWO).add(wBig.multiply(TWO)).add(ONE);
            dx1Denom = TWO;
            dy1Num = y0Big.multiply(TWO).add(hBig.multiply(TWO)).add(ONE);
            dy1Denom = TWO;
            dx0Num = dx0Denom.multiply(BigInteger.valueOf(this.lpad)).add(dx0Num);
            dy0Num = dy0Denom.multiply(BigInteger.valueOf(this.tpad)).add(dy0Num);
            dx1Num = dx1Num.subtract(dx1Denom.multiply(BigInteger.valueOf(this.rpad)));
            dy1Num = dy1Num.subtract(dy1Denom.multiply(BigInteger.valueOf(this.bpad)));
        }
        dx0Num = dx0Num.multiply(this.scaleXRationalNum);
        dx0Denom = dx0Denom.multiply(this.scaleXRationalDenom);
        dx0Num = dx0Num.multiply(this.transXRationalDenom).add(this.transXRationalNum.multiply(dx0Denom));
        dx0Denom = dx0Denom.multiply(this.transXRationalDenom);
        dy0Num = dy0Num.multiply(this.scaleYRationalNum);
        dy0Denom = dy0Denom.multiply(this.scaleYRationalDenom);
        dy0Num = dy0Num.multiply(this.transYRationalDenom).add(this.transYRationalNum.multiply(dy0Denom));
        dy0Denom = dy0Denom.multiply(this.transYRationalDenom);
        dx1Num = dx1Num.multiply(this.scaleXRationalNum);
        dx1Denom = dx1Denom.multiply(this.scaleXRationalDenom);
        dx1Num = dx1Num.multiply(this.transXRationalDenom).add(this.transXRationalNum.multiply(dx1Denom));
        dx1Denom = dx1Denom.multiply(this.transXRationalDenom);
        dy1Num = dy1Num.multiply(this.scaleYRationalNum);
        dy1Denom = dy1Denom.multiply(this.scaleYRationalDenom);
        dy1Num = dy1Num.multiply(this.transYRationalDenom).add(this.transYRationalNum.multiply(dy1Denom));
        dy1Denom = dy1Denom.multiply(this.transYRationalDenom);
        dx0Num = dx0Num.multiply(TWO).subtract(dx0Denom);
        dx0Denom = dx0Denom.multiply(TWO);
        dy0Num = dy0Num.multiply(TWO).subtract(dy0Denom);
        dy0Denom = dy0Denom.multiply(TWO);
        int l_x0 = Rational.ceil((long)dx0Num.longValue(), (long)dx0Denom.longValue());
        int l_y0 = Rational.ceil((long)dy0Num.longValue(), (long)dy0Denom.longValue());
        dx1Num = dx1Num.multiply(TWO).subtract(dx1Denom);
        dx1Denom = dx1Denom.multiply(TWO);
        dy1Num = dy1Num.multiply(TWO).subtract(dy1Denom);
        dy1Denom = dy1Denom.multiply(TWO);
        int l_x1 = Rational.floor((long)dx1Num.longValue(), (long)dx1Denom.longValue());
        if (dx1Num.equals(dx1Denom.multiply(BigInteger.valueOf(l_x1)))) {
            --l_x1;
        }
        if (dy1Num.equals(dy1Denom.multiply(BigInteger.valueOf(l_y1 = Rational.floor((long)dy1Num.longValue(), (long)dy1Denom.longValue()))))) {
            --l_y1;
        }
        return new Rectangle(l_x0, l_y0, l_x1 - l_x0 + 1, l_y1 - l_y0 + 1);
    }

    protected Rectangle backwardMapRect(Rectangle destRect, int sourceIndex) {
        if (destRect == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (sourceIndex != 0) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic1"));
        }
        int x0 = destRect.x;
        int y0 = destRect.y;
        int w = destRect.width;
        int h = destRect.height;
        BigInteger x0Big = BigInteger.valueOf(x0);
        BigInteger y0Big = BigInteger.valueOf(y0);
        BigInteger wBig = BigInteger.valueOf(w);
        BigInteger hBig = BigInteger.valueOf(h);
        BigInteger sx0Num = x0Big.multiply(TWO).add(ONE);
        BigInteger sx0Denom = TWO;
        BigInteger sy0Num = y0Big.multiply(TWO).add(ONE);
        BigInteger sy0Denom = TWO;
        BigInteger sx1Num = x0Big.multiply(TWO).add(wBig.multiply(TWO)).subtract(ONE);
        BigInteger sx1Denom = TWO;
        BigInteger sy1Num = y0Big.multiply(TWO).add(hBig.multiply(TWO)).subtract(ONE);
        BigInteger sy1Denom = TWO;
        sx0Num = sx0Num.multiply(this.transXRationalDenom).subtract(this.transXRationalNum.multiply(sx0Denom));
        sx0Denom = sx0Denom.multiply(this.transXRationalDenom);
        sy0Num = sy0Num.multiply(this.transYRationalDenom).subtract(this.transYRationalNum.multiply(sy0Denom));
        sy0Denom = sy0Denom.multiply(this.transYRationalDenom);
        sx1Num = sx1Num.multiply(this.transXRationalDenom).subtract(this.transXRationalNum.multiply(sx1Denom));
        sx1Denom = sx1Denom.multiply(this.transXRationalDenom);
        sy1Num = sy1Num.multiply(this.transYRationalDenom).subtract(this.transYRationalNum.multiply(sy1Denom));
        sy1Denom = sy1Denom.multiply(this.transYRationalDenom);
        sx0Num = sx0Num.multiply(this.invScaleXRationalNum);
        sx0Denom = sx0Denom.multiply(this.invScaleXRationalDenom);
        sy0Num = sy0Num.multiply(this.invScaleYRationalNum);
        sy0Denom = sy0Denom.multiply(this.invScaleYRationalDenom);
        sx1Num = sx1Num.multiply(this.invScaleXRationalNum);
        sx1Denom = sx1Denom.multiply(this.invScaleXRationalDenom);
        sy1Num = sy1Num.multiply(this.invScaleYRationalNum);
        sy1Denom = sy1Denom.multiply(this.invScaleYRationalDenom);
        int s_x0 = 0;
        int s_y0 = 0;
        int s_x1 = 0;
        int s_y1 = 0;
        if (this.interp instanceof InterpolationNearest) {
            s_x0 = Rational.floor((long)sx0Num.longValue(), (long)sx0Denom.longValue());
            s_y0 = Rational.floor((long)sy0Num.longValue(), (long)sy0Denom.longValue());
            s_x1 = Rational.floor((long)sx1Num.longValue(), (long)sx1Denom.longValue());
            s_y1 = Rational.floor((long)sy1Num.longValue(), (long)sy1Denom.longValue());
        } else {
            s_x0 = Rational.floor((long)sx0Num.multiply(TWO).subtract(sx0Denom).longValue(), (long)sx0Denom.multiply(TWO).longValue());
            s_y0 = Rational.floor((long)sy0Num.multiply(TWO).subtract(sy0Denom).longValue(), (long)sy0Denom.multiply(TWO).longValue());
            long sx1Num05 = sx1Num.multiply(TWO).subtract(sx1Denom).longValue();
            long sx1Denom2 = sx1Denom.multiply(TWO).longValue();
            long sy1Num05 = sy1Num.multiply(TWO).subtract(sy1Denom).longValue();
            long sy1Denom2 = sy1Denom.multiply(TWO).longValue();
            if (this.extender != null) {
                s_x1 = Rational.ceil((long)sx1Num05, (long)sx1Denom2);
                s_y1 = Rational.ceil((long)sy1Num05, (long)sy1Denom2);
            } else {
                s_x1 = Rational.floor((long)sx1Num05, (long)sx1Denom2);
                s_y1 = Rational.floor((long)sy1Num05, (long)sy1Denom2);
            }
        }
        return new Rectangle(s_x0, s_y0, s_x1 - s_x0 + 1, s_y1 - s_y0 + 1);
    }

    public Raster computeTile(int tileX, int tileY) {
        if (!this.cobbleSources) {
            return super.computeTile(tileX, tileY);
        }
        int orgX = this.tileXToX(tileX);
        int orgY = this.tileYToY(tileY);
        WritableRaster dest = this.createWritableRaster(this.sampleModel, new Point(orgX, orgY));
        Rectangle rect = new Rectangle(orgX, orgY, this.tileWidth, this.tileHeight);
        Rectangle destRect = rect.intersection(this.computableBounds);
        if (destRect.width <= 0 || destRect.height <= 0) {
            return dest;
        }
        Rectangle srcRect = this.mapDestRect(destRect, 0);
        Raster[] sources = new Raster[1];
        PlanarImage source0 = this.getSourceImage(0);
        IntegerSequence srcXSplits = new IntegerSequence();
        IntegerSequence srcYSplits = new IntegerSequence();
        source0.getSplits(srcXSplits, srcYSplits, srcRect);
        if (srcXSplits.getNumElements() == 1 && srcYSplits.getNumElements() == 1) {
            sources[0] = this.extender == null ? source0.getData(srcRect) : (source0.getBounds().contains(srcRect) ? source0.getData(srcRect) : this.extendedIMG.getData(srcRect));
            this.computeRect(sources, dest, destRect);
        } else {
            int srcTileWidth = source0.getTileWidth();
            int srcTileHeight = source0.getTileHeight();
            srcYSplits.startEnumeration();
            while (srcYSplits.hasMoreElements()) {
                int ysplit = srcYSplits.nextElement();
                srcXSplits.startEnumeration();
                while (srcXSplits.hasMoreElements()) {
                    int xsplit = srcXSplits.nextElement();
                    Rectangle srcTile = new Rectangle(xsplit, ysplit, srcTileWidth, srcTileHeight);
                    Rectangle newSrcRect = srcRect.intersection(srcTile);
                    if (!(this.interp instanceof InterpolationNearest)) {
                        if (newSrcRect.width <= this.interp.getWidth()) {
                            Rectangle wSrcRect = new Rectangle();
                            wSrcRect.x = newSrcRect.x;
                            wSrcRect.y = newSrcRect.y - this.tpad - 1;
                            wSrcRect.width = 2 * (this.lpad + this.rpad + 1);
                            wSrcRect.height = newSrcRect.height + this.bpad + this.tpad + 2;
                            wSrcRect = wSrcRect.intersection(source0.getBounds());
                            Rectangle wDestRect = this.mapSourceRect(wSrcRect, 0);
                            wDestRect = wDestRect.intersection(destRect);
                            if (wDestRect.width > 0 && wDestRect.height > 0) {
                                sources[0] = this.extender == null ? source0.getData(wSrcRect) : (source0.getBounds().contains(srcRect) ? source0.getData(srcRect) : this.extendedIMG.getData(srcRect));
                                this.computeRect(sources, dest, wDestRect);
                            }
                        }
                        if (newSrcRect.height <= this.interp.getHeight()) {
                            Rectangle hSrcRect = new Rectangle();
                            hSrcRect.x = newSrcRect.x - this.lpad - 1;
                            hSrcRect.y = newSrcRect.y;
                            hSrcRect.width = newSrcRect.width + this.lpad + this.rpad + 2;
                            hSrcRect.height = 2 * (this.tpad + this.bpad + 1);
                            hSrcRect = hSrcRect.intersection(source0.getBounds());
                            Rectangle hDestRect = this.mapSourceRect(hSrcRect, 0);
                            hDestRect = hDestRect.intersection(destRect);
                            if (hDestRect.width > 0 && hDestRect.height > 0) {
                                sources[0] = this.extender == null ? source0.getData(hSrcRect) : (source0.getBounds().contains(srcRect) ? source0.getData(srcRect) : this.extendedIMG.getData(srcRect));
                                this.computeRect(sources, dest, hDestRect);
                            }
                        }
                    }
                    if (newSrcRect.width <= 0 || newSrcRect.height <= 0) continue;
                    Rectangle newDestRect = this.mapSourceRect(newSrcRect, 0);
                    newDestRect = newDestRect.intersection(destRect);
                    if (newDestRect.width > 0 && newDestRect.height > 0) {
                        sources[0] = this.extender == null ? source0.getData(newSrcRect) : (source0.getBounds().contains(srcRect) ? source0.getData(srcRect) : this.extendedIMG.getData(srcRect));
                        this.computeRect(sources, dest, newDestRect);
                    }
                    if (this.interp instanceof InterpolationNearest) continue;
                    Rectangle RTSrcRect = new Rectangle();
                    RTSrcRect.x = newSrcRect.x + newSrcRect.width - 1 - this.rpad - this.lpad;
                    RTSrcRect.y = newSrcRect.y;
                    RTSrcRect.width = 2 * (this.lpad + this.rpad + 1);
                    RTSrcRect.height = newSrcRect.height;
                    Rectangle RTDestRect = this.mapSourceRect(RTSrcRect, 0);
                    RTDestRect = RTDestRect.intersection(destRect);
                    RTSrcRect = this.mapDestRect(RTDestRect, 0);
                    if (RTDestRect.width > 0 && RTDestRect.height > 0) {
                        sources[0] = this.extender == null ? source0.getData(RTSrcRect) : (source0.getBounds().contains(srcRect) ? source0.getData(srcRect) : this.extendedIMG.getData(srcRect));
                        this.computeRect(sources, dest, RTDestRect);
                    }
                    Rectangle BTSrcRect = new Rectangle();
                    BTSrcRect.x = newSrcRect.x;
                    BTSrcRect.y = newSrcRect.y + newSrcRect.height - 1 - this.bpad - this.tpad;
                    BTSrcRect.width = newSrcRect.width;
                    BTSrcRect.height = 2 * (this.tpad + this.bpad + 1);
                    Rectangle BTDestRect = this.mapSourceRect(BTSrcRect, 0);
                    BTDestRect = BTDestRect.intersection(destRect);
                    BTSrcRect = this.mapDestRect(BTDestRect, 0);
                    if (BTDestRect.width > 0 && BTDestRect.height > 0) {
                        sources[0] = this.extender == null ? source0.getData(BTSrcRect) : (source0.getBounds().contains(srcRect) ? source0.getData(srcRect) : this.extendedIMG.getData(srcRect));
                        this.computeRect(sources, dest, BTDestRect);
                    }
                    Rectangle LRTSrcRect = new Rectangle();
                    LRTSrcRect.x = newSrcRect.x + newSrcRect.width - 1 - this.rpad - this.lpad;
                    LRTSrcRect.y = newSrcRect.y + newSrcRect.height - 1 - this.bpad - this.tpad;
                    LRTSrcRect.width = 2 * (this.rpad + this.lpad + 1);
                    LRTSrcRect.height = 2 * (this.tpad + this.bpad + 1);
                    Rectangle LRTDestRect = this.mapSourceRect(LRTSrcRect, 0);
                    LRTDestRect = LRTDestRect.intersection(destRect);
                    LRTSrcRect = this.mapDestRect(LRTDestRect, 0);
                    if (LRTDestRect.width <= 0 || LRTDestRect.height <= 0) continue;
                    sources[0] = this.extender == null ? source0.getData(LRTSrcRect) : (source0.getBounds().contains(srcRect) ? source0.getData(srcRect) : this.extendedIMG.getData(srcRect));
                    this.computeRect(sources, dest, LRTDestRect);
                }
            }
        }
        return dest;
    }

    public synchronized void dispose() {
        if (this.srcROIImage != null) {
            this.srcROIImage.dispose();
        }
        if (this.srcROIImgExt != null) {
            this.srcROIImgExt.dispose();
        }
        super.dispose();
    }
}

