/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import javax.xml.transform.TransformerException;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trans.XPathException;

public class TransformerReceiver
extends ProxyReceiver {
    private Controller controller;
    private Builder builder;
    private Receiver destination;

    public TransformerReceiver(Controller controller) {
        super(controller.makeBuilder());
        this.controller = controller;
        this.builder = (Builder)this.getUnderlyingReceiver();
    }

    public void open() throws XPathException {
        this.builder.setSystemId(this.systemId);
        Receiver stripper = this.controller.makeStripper(this.builder);
        if (this.controller.getExecutable().stripsInputTypeAnnotations()) {
            stripper = this.controller.getConfiguration().getAnnotationStripper(stripper);
        }
        this.setUnderlyingReceiver(stripper);
        this.nextReceiver.open();
    }

    public Controller getController() {
        return this.controller;
    }

    public void setSystemId(String systemId) {
        super.setSystemId(systemId);
        this.controller.setBaseOutputURI(systemId);
    }

    public void setDestination(Receiver destination) {
        this.destination = destination;
    }

    public Receiver getDestination() {
        return this.destination;
    }

    public void close() throws XPathException {
        this.nextReceiver.close();
        NodeInfo doc = this.builder.getCurrentRoot();
        this.builder.reset();
        this.builder = null;
        if (doc == null) {
            throw new XPathException("No source document has been built");
        }
        if (this.destination == null) {
            throw new XPathException("No output destination has been supplied");
        }
        try {
            this.controller.setGlobalContextItem(doc);
            this.controller.transformDocument(doc, this.destination);
        }
        catch (TransformerException e) {
            throw XPathException.makeXPathException(e);
        }
    }
}

