/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.mosaic;

import com.sun.media.jai.util.ImageUtil;
import it.geosolutions.jaiext.lookup.LookupTable;
import it.geosolutions.jaiext.lookup.LookupTableFactory;
import it.geosolutions.jaiext.mosaic.ImageMosaicBean;
import it.geosolutions.jaiext.mosaic.RasterAccessorExt;
import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.range.RangeFactory;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.PackedColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.ParameterBlock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.media.jai.BorderExtender;
import javax.media.jai.BorderExtenderConstant;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.OpImage;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.MosaicDescriptor;
import javax.media.jai.operator.MosaicType;

public class MosaicOpImage
extends OpImage {
    public static final double[] DEFAULT_DESTINATION_NO_DATA_VALUE = new double[]{0.0};
    private MosaicType mosaicTypeSelected;
    private int numBands;
    private final ImageMosaicBean[] imageBeans;
    private boolean roiPresent;
    private boolean isAlphaBitmaskUsed;
    private boolean alphaPresent;
    private BorderExtender sourceBorderExtender;
    private BorderExtender zeroBorderExtender;
    private byte[] destinationNoDataByte;
    private short[] destinationNoDataUShort;
    private short[] destinationNoDataShort;
    private int[] destinationNoDataInt;
    private float[] destinationNoDataFloat;
    private double[] destinationNoDataDouble;
    protected byte[][][] byteLookupTable;
    private final boolean[] hasNoData;
    private RasterFormatTag rasterFormatTag;

    private static final ImageLayout checkLayout(List sources, ImageLayout layout, Range[] noDatas) {
        SampleModel targetSampleModel = null;
        ColorModel targetColorModel = null;
        int numSources = sources.size();
        if (numSources > 0) {
            ImageLayout tmp = MosaicOpImage.getTargetSampleColorModel(sources, noDatas);
            targetColorModel = tmp.getColorModel(null);
            targetSampleModel = tmp.getSampleModel(null);
        } else if (layout != null && layout.isValid(268)) {
            targetSampleModel = layout.getSampleModel(null);
        } else {
            throw new IllegalArgumentException("Layout not valid");
        }
        if (targetSampleModel == null) {
            throw new IllegalArgumentException("No sample model present");
        }
        if (numSources < 1) {
            return (ImageLayout)layout.clone();
        }
        ImageLayout mosaicLayout = layout == null ? new ImageLayout() : (ImageLayout)layout.clone();
        Rectangle mosaicBounds = new Rectangle();
        if (mosaicLayout.isValid(15)) {
            mosaicBounds.setBounds(mosaicLayout.getMinX(null), mosaicLayout.getMinY(null), mosaicLayout.getWidth(null), mosaicLayout.getHeight(null));
        } else if (numSources > 0) {
            RenderedImage source = (RenderedImage)sources.get(0);
            mosaicBounds.setBounds(source.getMinX(), source.getMinY(), source.getWidth(), source.getHeight());
            for (int i = 1; i < numSources; ++i) {
                source = (RenderedImage)sources.get(i);
                Rectangle sourceBounds = new Rectangle(source.getMinX(), source.getMinY(), source.getWidth(), source.getHeight());
                mosaicBounds = mosaicBounds.union(sourceBounds);
            }
        }
        mosaicLayout.setMinX(mosaicBounds.x);
        mosaicLayout.setMinY(mosaicBounds.y);
        mosaicLayout.setWidth(mosaicBounds.width);
        mosaicLayout.setHeight(mosaicBounds.height);
        mosaicLayout.setSampleModel(targetSampleModel);
        if (targetColorModel != null) {
            mosaicLayout.setColorModel(targetColorModel);
        }
        return mosaicLayout;
    }

    private static ImageLayout getTargetSampleColorModel(List sources, Range[] noDatas) {
        int sourceDataType;
        int numSources = sources.size();
        RenderedImage first = (RenderedImage)sources.get(0);
        ColorModel firstColorModel = first.getColorModel();
        SampleModel firstSampleModel = first.getSampleModel();
        ImageLayout result = new ImageLayout();
        result.setSampleModel(firstSampleModel);
        if (numSources == 1) {
            result.setColorModel(firstColorModel);
            return result;
        }
        int firstDataType = firstSampleModel.getDataType();
        int firstBands = firstSampleModel.getNumBands();
        int firstSampleSize = firstSampleModel.getSampleSize()[0];
        boolean heterogeneous = false;
        boolean hasIndexedColorModels = firstColorModel instanceof IndexColorModel;
        boolean hasComponentColorModels = firstColorModel instanceof ComponentColorModel;
        boolean hasPackedColorModels = firstColorModel instanceof PackedColorModel;
        boolean hasUnrecognizedColorModels = !hasComponentColorModels && !hasIndexedColorModels && !hasPackedColorModels;
        boolean hasUnsupportedTypes = false;
        int maxBands = firstBands;
        for (int i = 1; i < numSources; ++i) {
            RenderedImage source = (RenderedImage)sources.get(i);
            SampleModel sourceSampleModel = source.getSampleModel();
            ColorModel sourceColorModel = source.getColorModel();
            int sourceBands = sourceSampleModel.getNumBands();
            sourceDataType = sourceSampleModel.getDataType();
            if (sourceDataType == 32) {
                hasUnsupportedTypes = true;
            }
            if (sourceBands > maxBands) {
                maxBands = sourceBands;
            }
            if (sourceColorModel instanceof IndexColorModel) {
                hasIndexedColorModels = true;
            } else if (sourceColorModel instanceof ComponentColorModel) {
                hasComponentColorModels = true;
            } else if (sourceColorModel instanceof PackedColorModel) {
                hasPackedColorModels = true;
            } else {
                hasUnrecognizedColorModels = true;
            }
            if (sourceDataType != firstDataType || sourceBands != firstBands) {
                heterogeneous = true;
            }
            for (int j = 0; j < sourceBands; ++j) {
                if (sourceSampleModel.getSampleSize(j) == firstSampleSize) continue;
                heterogeneous = true;
            }
        }
        int colorModelsTypes = (hasIndexedColorModels ? 1 : 0) + (hasComponentColorModels ? 1 : 0) + (hasPackedColorModels ? 1 : 0);
        if (!heterogeneous && colorModelsTypes == 1) {
            boolean uniformPalettes;
            if (hasIndexedColorModels && !(uniformPalettes = MosaicOpImage.hasUniformPalettes(sources, noDatas))) {
                MosaicOpImage.setRGBLayout(result, first);
            }
            return result;
        }
        if (hasUnrecognizedColorModels || hasUnsupportedTypes) {
            throw new IllegalArgumentException("Cannot mosaic the input images, the mix of provided color and sample models is not supported");
        }
        if (maxBands == 1 && !hasIndexedColorModels) {
            SampleModel sm = firstSampleModel;
            for (int i = 1; i < numSources; ++i) {
                RenderedImage source = (RenderedImage)sources.get(i);
                SampleModel sourceSampleModel = source.getSampleModel();
                sourceDataType = sourceSampleModel.getDataType();
                if (sourceDataType <= sm.getDataType()) continue;
                sm = sourceSampleModel;
            }
            result.setSampleModel(sm);
        } else {
            MosaicOpImage.setRGBLayout(result, first);
        }
        return result;
    }

    private static void setRGBLayout(ImageLayout result, RenderedImage reference) {
        ColorSpace cs = ColorSpace.getInstance(1000);
        int[] nBits = new int[]{8, 8, 8};
        ComponentColorModel cm = new ComponentColorModel(cs, nBits, false, false, 1, 0);
        SampleModel sm = ((ColorModel)cm).createCompatibleSampleModel(reference.getSampleModel().getWidth(), reference.getSampleModel().getWidth());
        result.setColorModel((ColorModel)cm);
        result.setSampleModel(sm);
    }

    private static boolean hasUniformPalettes(List sources, Range[] noDatas) {
        RenderedImage first = (RenderedImage)sources.get(0);
        Range firstNoData = noDatas != null ? noDatas[0] : null;
        IndexColorModel reference = (IndexColorModel)first.getColorModel();
        int mapSize = reference.getMapSize();
        byte[] reference_reds = new byte[mapSize];
        byte[] reference_greens = new byte[mapSize];
        byte[] reference_blues = new byte[mapSize];
        byte[] reference_alphas = new byte[mapSize];
        byte[] reds = new byte[mapSize];
        byte[] greens = new byte[mapSize];
        byte[] blues = new byte[mapSize];
        byte[] alphas = new byte[mapSize];
        reference.getReds(reference_reds);
        reference.getGreens(reference_greens);
        reference.getBlues(reference_blues);
        reference.getAlphas(reference_alphas);
        boolean uniformPalettes = true;
        int numSources = sources.size();
        for (int i = 1; i < numSources; ++i) {
            Range noData;
            RenderedImage source = (RenderedImage)sources.get(i);
            Range range = noData = noDatas == null ? null : noDatas[i];
            if (firstNoData == null ? noData != null : noData == null || !noData.equals((Object)firstNoData)) {
                return false;
            }
            IndexColorModel sourceColorModel = (IndexColorModel)source.getColorModel();
            if (reference.getNumColorComponents() != sourceColorModel.getNumColorComponents()) {
                throw new IllegalArgumentException("Cannot mosaic togheter images with index color models having different numbers of color components:\n " + reference + "\n" + sourceColorModel);
            }
            if (!reference.getColorSpace().equals(reference.getColorSpace())) {
                return false;
            }
            if (!sourceColorModel.equals(reference) || sourceColorModel.getMapSize() != mapSize) {
                uniformPalettes = false;
                break;
            }
            sourceColorModel.getReds(reds);
            sourceColorModel.getGreens(greens);
            sourceColorModel.getBlues(blues);
            sourceColorModel.getAlphas(alphas);
            if (Arrays.equals(reds, reference_reds) && Arrays.equals(greens, reference_greens) && Arrays.equals(blues, reference_blues) && Arrays.equals(alphas, reference_alphas)) continue;
            uniformPalettes = false;
            break;
        }
        return uniformPalettes;
    }

    public MosaicOpImage(List sources, ImageLayout layout, Map renderingHints, MosaicType mosaicTypeSelected, PlanarImage[] alphaImgs, ROI[] rois, double[][] thresholds, double[] destinationNoData, Range[] noDatas) {
        int i;
        int dataType;
        Rectangle totalBounds;
        boolean nodataExists;
        boolean alphaExists;
        boolean roiExists;
        int numSources;
        block58: {
            block57: {
                super((Vector)sources, MosaicOpImage.checkLayout(sources, layout, noDatas), renderingHints, true);
                this.numBands = this.sampleModel.getNumBands();
                numSources = this.getNumSources();
                this.mosaicTypeSelected = mosaicTypeSelected;
                this.roiPresent = false;
                this.alphaPresent = false;
                roiExists = rois != null;
                alphaExists = alphaImgs != null;
                boolean bl = nodataExists = noDatas != null;
                if (roiExists && rois.length != numSources) {
                    throw new IllegalArgumentException("roi number is not equal to the source number");
                }
                if (alphaExists && alphaImgs.length != numSources) {
                    throw new IllegalArgumentException("alpha bands number is not equal to the source number");
                }
                if (nodataExists && noDatas.length != numSources) {
                    throw new IllegalArgumentException("no data number is not equal to the source number");
                }
                totalBounds = this.getBounds();
                dataType = this.sampleModel.getDataType();
                this.zeroBorderExtender = BorderExtender.createInstance((int)0);
                if (destinationNoData != null) break block57;
                this.destinationNoDataDouble = DEFAULT_DESTINATION_NO_DATA_VALUE;
                switch (dataType) {
                    case 0: {
                        this.destinationNoDataInt = new int[numSources];
                        Arrays.fill(this.destinationNoDataInt, Integer.MIN_VALUE);
                        this.destinationNoDataByte = new byte[numSources];
                        Arrays.fill(this.destinationNoDataByte, (byte)0);
                        break block58;
                    }
                    case 1: {
                        this.destinationNoDataInt = new int[numSources];
                        Arrays.fill(this.destinationNoDataInt, Integer.MIN_VALUE);
                        this.destinationNoDataUShort = new short[numSources];
                        Arrays.fill(this.destinationNoDataUShort, (short)0);
                        break block58;
                    }
                    case 2: {
                        this.destinationNoDataInt = new int[numSources];
                        Arrays.fill(this.destinationNoDataInt, Integer.MIN_VALUE);
                        this.destinationNoDataShort = new short[numSources];
                        Arrays.fill(this.destinationNoDataShort, (short)Short.MIN_VALUE);
                        break block58;
                    }
                    case 3: {
                        this.destinationNoDataInt = new int[numSources];
                        Arrays.fill(this.destinationNoDataInt, Integer.MIN_VALUE);
                        break block58;
                    }
                    case 4: {
                        this.destinationNoDataFloat = new float[numSources];
                        Arrays.fill(this.destinationNoDataFloat, -3.4028235E38f);
                        break block58;
                    }
                    case 5: {
                        Arrays.fill(this.destinationNoDataDouble, -1.7976931348623157E308);
                        break block58;
                    }
                    default: {
                        throw new IllegalArgumentException("Wrong data Type");
                    }
                }
            }
            this.destinationNoDataDouble = new double[this.numBands];
            if (destinationNoData.length < this.numBands) {
                Arrays.fill(this.destinationNoDataDouble, destinationNoData[0]);
            } else {
                System.arraycopy(destinationNoData, 0, this.destinationNoDataDouble, 0, this.numBands);
            }
            switch (dataType) {
                case 0: {
                    int i2;
                    this.destinationNoDataByte = new byte[this.numBands];
                    if (destinationNoData.length < this.numBands) {
                        Arrays.fill(this.destinationNoDataByte, (byte)destinationNoData[0]);
                    } else {
                        for (i2 = 0; i2 < this.numBands; ++i2) {
                            this.destinationNoDataByte[i2] = (byte)destinationNoData[i2];
                        }
                    }
                    this.destinationNoDataInt = new int[this.numBands];
                    for (i2 = 0; i2 < this.destinationNoDataInt.length; ++i2) {
                        this.destinationNoDataInt[i2] = this.destinationNoDataByte[i2];
                    }
                    break;
                }
                case 1: {
                    int i2;
                    this.destinationNoDataUShort = new short[this.numBands];
                    if (destinationNoData.length < this.numBands) {
                        Arrays.fill(this.destinationNoDataUShort, (short)((short)destinationNoData[0] & 0xFFFF));
                    } else {
                        for (i2 = 0; i2 < this.numBands; ++i2) {
                            this.destinationNoDataUShort[i2] = (short)((short)destinationNoData[i2] & 0xFFFF);
                        }
                    }
                    this.destinationNoDataInt = new int[this.numBands];
                    for (i2 = 0; i2 < this.destinationNoDataInt.length; ++i2) {
                        this.destinationNoDataInt[i2] = this.destinationNoDataUShort[i2];
                    }
                    break;
                }
                case 2: {
                    int i2;
                    this.destinationNoDataShort = new short[this.numBands];
                    if (destinationNoData.length < this.numBands) {
                        Arrays.fill(this.destinationNoDataShort, (short)destinationNoData[0]);
                    } else {
                        for (i2 = 0; i2 < this.numBands; ++i2) {
                            this.destinationNoDataShort[i2] = (short)destinationNoData[i2];
                        }
                    }
                    this.destinationNoDataInt = new int[this.numBands];
                    for (i2 = 0; i2 < this.destinationNoDataInt.length; ++i2) {
                        this.destinationNoDataInt[i2] = this.destinationNoDataShort[i2];
                    }
                    break;
                }
                case 3: {
                    int i2;
                    this.destinationNoDataInt = new int[this.numBands];
                    if (destinationNoData.length < this.numBands) {
                        Arrays.fill(this.destinationNoDataInt, (int)destinationNoData[0]);
                        break;
                    }
                    for (i2 = 0; i2 < this.numBands; ++i2) {
                        this.destinationNoDataInt[i2] = (int)destinationNoData[i2];
                    }
                    break;
                }
                case 4: {
                    int i2;
                    this.destinationNoDataFloat = new float[this.numBands];
                    if (destinationNoData.length < this.numBands) {
                        Arrays.fill(this.destinationNoDataFloat, (float)destinationNoData[0]);
                        break;
                    }
                    for (i2 = 0; i2 < this.numBands; ++i2) {
                        this.destinationNoDataFloat[i2] = (float)destinationNoData[i2];
                    }
                    break;
                }
                case 5: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Wrong data Type");
                }
            }
        }
        double sourceExtensionBorder = noDatas != null && noDatas.length > 0 && noDatas[0] != null ? noDatas[0].getMin().doubleValue() : this.destinationNoDataDouble[0];
        this.sourceBorderExtender = sourceExtensionBorder == 0.0 ? BorderExtender.createInstance((int)0) : new BorderExtenderConstant(new double[]{sourceExtensionBorder});
        this.hasNoData = new boolean[numSources];
        ArrayList<PlanarImage> alphaList = new ArrayList<PlanarImage>();
        this.byteLookupTable = new byte[numSources][this.numBands][256];
        this.imageBeans = new ImageMosaicBean[numSources];
        for (int i3 = 0; i3 < numSources; ++i3) {
            this.imageBeans[i3] = new ImageMosaicBean();
        }
        RasterFormatTag[] tags = this.getRasterFormatTags();
        for (i = 0; i < numSources; ++i) {
            int formatDataType;
            RenderedImage image;
            Range expandedNoDataRage;
            Range convertedNoDataRange;
            Range noDataRange;
            RenderedOp create;
            ParameterBlock pb;
            int[] pads;
            ROI roi;
            PlanarImage img = this.getSourceImage(i);
            int[] padding = this.calculatePadding((RenderedImage)img, totalBounds);
            if (padding != null) {
                ParameterBlock pb2 = new ParameterBlock();
                pb2.setSource(img, 0);
                pb2.set(padding[0], 0);
                pb2.set(padding[1], 1);
                pb2.set(padding[2], 2);
                pb2.set(padding[3], 3);
                pb2.set(this.sourceBorderExtender, 4);
                RenderedOp create2 = JAI.create((String)"border", (ParameterBlock)pb2);
                this.imageBeans[i].setImage((RenderedImage)create2);
            } else {
                this.imageBeans[i].setImage((RenderedImage)img);
            }
            PlanarImage alpha = alphaExists ? alphaImgs[i] : null;
            alphaList.add(alpha);
            ROI rOI = roi = roiExists ? rois[i] : null;
            if (alpha != null) {
                this.alphaPresent = true;
                SampleModel alphaSampleModel = alpha.getSampleModel();
                pads = this.calculatePadding((RenderedImage)alpha, totalBounds);
                if (pads != null) {
                    pb = new ParameterBlock();
                    pb.setSource(alpha, 0);
                    pb.set(pads[0], 0);
                    pb.set(pads[1], 1);
                    pb.set(pads[2], 2);
                    pb.set(pads[3], 3);
                    pb.set(this.zeroBorderExtender, 4);
                    create = JAI.create((String)"border", (ParameterBlock)pb);
                    this.imageBeans[i].setAlphaChannel((PlanarImage)create);
                } else {
                    this.imageBeans[i].setAlphaChannel(alpha);
                }
                if (alphaSampleModel.getNumBands() != 1) {
                    throw new IllegalArgumentException("Alpha bands number must be 1");
                }
                if (alphaSampleModel.getDataType() != this.sampleModel.getDataType()) {
                    throw new IllegalArgumentException("Alpha sample model dataType and Source sample model dataTypes must be equal");
                }
                if (alphaSampleModel.getSampleSize(0) != this.sampleModel.getSampleSize(0)) {
                    throw new IllegalArgumentException("Alpha sample model sampleSize and Source sample model sampleSize must be equal");
                }
            }
            if (roi != null) {
                this.roiPresent = true;
                PlanarImage roiIMG = roi.getAsImage();
                pads = this.calculatePadding((RenderedImage)roiIMG, totalBounds);
                if (pads != null) {
                    pb = new ParameterBlock();
                    pb.setSource(roiIMG, 0);
                    pb.set(pads[0], 0);
                    pb.set(pads[1], 1);
                    pb.set(pads[2], 2);
                    pb.set(pads[3], 3);
                    pb.set(this.zeroBorderExtender, 4);
                    create = JAI.create((String)"border", (ParameterBlock)pb);
                    this.imageBeans[i].setRoiImage((RenderedImage)create);
                } else {
                    this.imageBeans[i].setRoiImage((RenderedImage)roiIMG);
                }
                this.imageBeans[i].setRoi(roi);
            }
            this.imageBeans[i].setRasterFormatTag(tags[i]);
            Range range = noDataRange = nodataExists ? noDatas[i] : null;
            if (noDataRange == null || (convertedNoDataRange = RangeFactory.convert((Range)(expandedNoDataRage = RasterAccessorExt.expandNoData(noDataRange, tags[i], image = this.imageBeans[i].getImage(), (RenderedImage)((Object)this))), (int)(formatDataType = tags[i].getFormatTagID() & 0x7F))) == null) continue;
            this.hasNoData[i] = true;
            this.imageBeans[i].setSourceNoData(convertedNoDataRange);
            if (RasterAccessorExt.isPaletteExpansionRequired(image, tags[i].getFormatTagID())) {
                ImageLayout il = new ImageLayout();
                byte[] arr = new byte[]{0, -1};
                IndexColorModel binaryCm = new IndexColorModel(1, 2, arr, arr, arr);
                MultiPixelPackedSampleModel binarySm = new MultiPixelPackedSampleModel(0, image.getWidth(), image.getHeight(), 1);
                il.setColorModel((ColorModel)binaryCm);
                il.setSampleModel((SampleModel)binarySm);
                RenderingHints hints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, il);
                hints.put(JAI.KEY_TRANSFORM_ON_COLORMAP, (Object)false);
                LookupTable lt = this.buildNoDataLookupTable(dataType, noDataRange);
                ParameterBlock pb3 = new ParameterBlock();
                pb3.setSource(image, 0);
                pb3.set(lt, 0);
                RenderedOp noDataMask = JAI.create((String)"lookup", (ParameterBlock)pb3, (RenderingHints)hints);
                noDataMask.getTile(0, 0);
                ROI noDataRoi = new ROI((RenderedImage)noDataMask);
                if (this.imageBeans[i].getRoi() == null) {
                    this.roiPresent = true;
                    this.imageBeans[i].setRoi(noDataRoi);
                    this.imageBeans[i].setRoiImage((RenderedImage)noDataRoi.getAsImage());
                } else {
                    ROI intersection = noDataRoi.intersect(this.imageBeans[i].getRoi());
                    this.imageBeans[i].setRoi(intersection);
                    this.imageBeans[i].setRoiImage((RenderedImage)intersection.getAsImage());
                }
                this.imageBeans[i].setSourceNoData(null);
                this.hasNoData[i] = false;
                continue;
            }
            if (dataType != 0) continue;
            Range noDataByte = expandedNoDataRage;
            for (int b = 0; b < this.numBands; ++b) {
                for (int z = 0; z < this.byteLookupTable[i][0].length; ++z) {
                    this.byteLookupTable[i][b][z] = noDataByte != null && noDataByte.contains(z) ? this.destinationNoDataByte[b] : (byte)z;
                }
            }
        }
        this.rasterFormatTag = tags[this.getNumSources()];
        if (!this.isAlphaBitmaskUsed) {
            for (i = 0; i < numSources; ++i) {
                if (alphaList.get(i) != null) continue;
                this.isAlphaBitmaskUsed = true;
                break;
            }
        }
    }

    private LookupTable buildNoDataLookupTable(int dataType, Range noDataRange) {
        byte[] table;
        switch (dataType) {
            case 0: {
                table = new byte[256];
                for (int i = 0; i < table.length; ++i) {
                    table[i] = noDataRange.contains(i) ? (byte)0 : 1;
                }
                break;
            }
            case 1: {
                table = new byte[65536];
                for (int i = 0; i < table.length; ++i) {
                    table[i] = noDataRange.contains(i) ? (byte)0 : 1;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unable to handle a index color model based on data type " + dataType);
            }
        }
        return LookupTableFactory.create((byte[])table);
    }

    private RasterFormatTag[] getRasterFormatTags() {
        int numSources = this.getNumSources();
        RenderedImage[] sources = new RenderedImage[numSources];
        for (int i = 0; i < numSources; ++i) {
            sources[i] = this.getSourceImage(i);
        }
        return RasterAccessorExt.findCompatibleTags(sources, (RenderedImage)((Object)this));
    }

    private int[] calculatePadding(RenderedImage src, Rectangle totalBounds) {
        int bottomP;
        int deltaX0 = src.getMinX() - totalBounds.x;
        int leftP = deltaX0 > 0 ? deltaX0 : 0;
        int deltaY0 = src.getMinY() - totalBounds.y;
        int topP = deltaY0 > 0 ? deltaY0 : 0;
        int deltaX1 = totalBounds.x + totalBounds.width - src.getMinX() - src.getWidth();
        int rightP = deltaX1 > 0 ? deltaX1 : 0;
        int deltaY1 = totalBounds.y + totalBounds.height - src.getMinY() - src.getHeight();
        int n = bottomP = deltaY1 > 0 ? deltaY1 : 0;
        if (leftP + rightP + topP + bottomP == 0) {
            return null;
        }
        return new int[]{leftP, rightP, topP, bottomP};
    }

    public Raster computeTile(int tileX, int tileY) {
        int i;
        WritableRaster destRaster = this.createWritableRaster(this.sampleModel, new Point(this.tileXToX(tileX), this.tileYToY(tileY)));
        Rectangle destRectangle = this.getTileRect(tileX, tileY);
        int numSources = this.getNumSources();
        Raster[] sourceRasters = new Raster[numSources];
        RasterFormatTag[] sourceTags = new RasterFormatTag[numSources];
        ColorModel[] sourceColorModels = new ColorModel[numSources];
        Raster[] alphaRasters = new Raster[numSources];
        Raster[] roiRasters = new Raster[numSources];
        Range[] noDataRanges = new Range[numSources];
        ColorModel[] alphaChannelColorModels = new ColorModel[numSources];
        int intersectingSourceCount = 0;
        for (i = 0; i < numSources; ++i) {
            PlanarImage source = this.getSourceImage(i);
            Rectangle srcRect = this.mapDestRect(destRectangle, i);
            Raster data = null;
            if (srcRect == null || !srcRect.isEmpty()) {
                data = source.getBounds().contains(destRectangle) ? source.getData(destRectangle) : this.imageBeans[i].getImage().getData(destRectangle);
            }
            if (data == null) continue;
            sourceRasters[intersectingSourceCount] = data;
            sourceTags[intersectingSourceCount] = this.imageBeans[i].getRasterFormatTag();
            sourceColorModels[intersectingSourceCount] = this.imageBeans[i].getColorModel();
            noDataRanges[intersectingSourceCount] = this.imageBeans[i].getSourceNoData();
            PlanarImage alpha = this.imageBeans[i].getAlphaChannel();
            if (this.alphaPresent && alpha != null) {
                alphaRasters[intersectingSourceCount] = alpha.getData(destRectangle);
                alphaChannelColorModels[intersectingSourceCount] = this.imageBeans[i].getAlphaChannel().getColorModel();
            }
            RenderedImage roi = this.imageBeans[i].getRoiImage();
            if (this.roiPresent && roi != null) {
                roiRasters[intersectingSourceCount] = roi.getData(destRectangle);
            }
            ++intersectingSourceCount;
        }
        this.computeRect(sourceRasters, sourceTags, sourceColorModels, destRaster, destRectangle, alphaRasters, roiRasters, noDataRanges, alphaChannelColorModels, intersectingSourceCount);
        for (i = 0; i < intersectingSourceCount; ++i) {
            PlanarImage source;
            Raster sourceData = sourceRasters[i];
            if (sourceData == null || !(source = this.getSourceImage(i)).overlapsMultipleTiles(sourceData.getBounds())) continue;
            this.recycleTile(sourceData);
        }
        return destRaster;
    }

    private void computeRect(Raster[] sourceRasters, RasterFormatTag[] rasterFormatTags, ColorModel[] sourceColorModels, WritableRaster destRaster, Rectangle destRectangle, Raster[] alphaRasters, Raster[] roiRasters, Range[] noDataRanges, ColorModel[] alphaChannelColorModels, int sourcesNumber) {
        if (sourcesNumber == 0) {
            ImageUtil.fillBackground((WritableRaster)destRaster, (Rectangle)destRectangle, (double[])this.destinationNoDataDouble);
            return;
        }
        RasterBeanAccessor[] sourceAccessorsArrayBean = new RasterBeanAccessor[sourcesNumber];
        for (int i = 0; i < sourcesNumber; ++i) {
            Raster alphaRaster;
            RasterBeanAccessor helpAccessor = new RasterBeanAccessor();
            if (sourceRasters[i] != null) {
                helpAccessor.setDataRasterAccessor(new RasterAccessorExt(sourceRasters[i], destRectangle, rasterFormatTags[i], sourceColorModels[i], this.getNumBands(), this.getSampleModel().getDataType()));
            }
            if ((alphaRaster = alphaRasters[i]) != null) {
                SampleModel alphaSampleModel = alphaRaster.getSampleModel();
                int alphaFormatTagID = RasterAccessor.findCompatibleTag(null, (SampleModel)alphaSampleModel);
                RasterFormatTag alphaFormatTag = new RasterFormatTag(alphaSampleModel, alphaFormatTagID);
                helpAccessor.setAlphaRasterAccessor(new RasterAccessor(alphaRaster, destRectangle, alphaFormatTag, alphaChannelColorModels[i]));
            }
            helpAccessor.setRoiRaster(roiRasters[i]);
            helpAccessor.setSourceNoDataRangeRasterAccessor(noDataRanges[i]);
            sourceAccessorsArrayBean[i] = helpAccessor;
        }
        RasterAccessor destinationAccessor = new RasterAccessor((Raster)destRaster, destRectangle, this.rasterFormatTag, null);
        int dataType = destinationAccessor.getDataType();
        switch (dataType) {
            case 0: {
                this.byteLoop(sourceAccessorsArrayBean, destinationAccessor);
                break;
            }
            case 1: {
                this.ushortLoop(sourceAccessorsArrayBean, destinationAccessor);
                break;
            }
            case 2: {
                this.shortLoop(sourceAccessorsArrayBean, destinationAccessor);
                break;
            }
            case 3: {
                this.intLoop(sourceAccessorsArrayBean, destinationAccessor);
                break;
            }
            case 4: {
                this.floatLoop(sourceAccessorsArrayBean, destinationAccessor);
                break;
            }
            case 5: {
                this.doubleLoop(sourceAccessorsArrayBean, destinationAccessor);
            }
        }
        destinationAccessor.copyDataToRaster();
    }

    private void byteLoop(RasterBeanAccessor[] srcBean, RasterAccessor dst) {
        int dstY;
        Object aBandDataByte;
        Object alfaDataByte;
        int[] aPixelOffsets;
        int[] aLineOffsets;
        Object alfaBandOffsets;
        int[] alfaPixelStride;
        int[] alfaLineStride;
        int sourcesNumber = srcBean.length;
        int[] srcLineStride = new int[sourcesNumber];
        int[] srcPixelStride = new int[sourcesNumber];
        int[][] srcBandOffsets = new int[sourcesNumber][];
        int[][] sLineOffsetsS = new int[sourcesNumber][];
        int[][] sPixelOffsetsS = new int[sourcesNumber][];
        byte[][][] srcDataByte = new byte[sourcesNumber][][];
        byte[][] dstDataByte = dst.getByteDataArrays();
        byte[][][] sBandDataByteS = new byte[sourcesNumber][][];
        boolean alphaPresentinRaster = false;
        for (int i = 0; i < sourcesNumber; ++i) {
            if (srcBean[i].getAlphaRasterAccessor() == null) continue;
            alphaPresentinRaster = true;
            break;
        }
        if (alphaPresentinRaster) {
            alfaLineStride = new int[sourcesNumber];
            alfaPixelStride = new int[sourcesNumber];
            alfaBandOffsets = new int[sourcesNumber][];
            aLineOffsets = new int[sourcesNumber];
            aPixelOffsets = new int[sourcesNumber];
            alfaDataByte = new byte[sourcesNumber][][];
            aBandDataByte = new byte[sourcesNumber][];
        } else {
            alfaLineStride = null;
            alfaPixelStride = null;
            alfaBandOffsets = null;
            aLineOffsets = null;
            aPixelOffsets = null;
            alfaDataByte = null;
            aBandDataByte = null;
        }
        WeightType[] weightTypesUsed = new WeightType[sourcesNumber];
        for (int i = 0; i < sourcesNumber; ++i) {
            weightTypesUsed[i] = WeightType.WEIGHT_TYPE_NODATA;
            RasterAccessor dataRA = srcBean[i].getDataRasterAccessor();
            if (dataRA == null) continue;
            srcLineStride[i] = dataRA.getScanlineStride();
            srcPixelStride[i] = dataRA.getPixelStride();
            srcBandOffsets[i] = dataRA.getBandOffsets();
            srcDataByte[i] = dataRA.getByteDataArrays();
            RasterAccessor alphaRA = srcBean[i].getAlphaRasterAccessor();
            if (alphaPresentinRaster & alphaRA != null) {
                alfaDataByte[i] = alphaRA.getByteDataArrays();
                alfaBandOffsets[i] = alphaRA.getBandOffsets();
                alfaPixelStride[i] = alphaRA.getPixelStride();
                alfaLineStride[i] = alphaRA.getScanlineStride();
            }
            if (alphaRA != null) {
                weightTypesUsed[i] = WeightType.WEIGHT_TYPE_ALPHA;
                continue;
            }
            if (!this.roiPresent || srcBean[i].getRoiRaster() == null) continue;
            weightTypesUsed[i] = WeightType.WEIGHT_TYPE_ROI;
        }
        int dstMinX = dst.getX();
        int dstMinY = dst.getY();
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstMaxX = dstMinX + dstWidth;
        int dstMaxY = dstMinY + dstHeight;
        int dstBands = dst.getNumBands();
        int dstLineStride = dst.getScanlineStride();
        int dstPixelStride = dst.getPixelStride();
        int[] dstBandOffsets = dst.getBandOffsets();
        for (int s = 0; s < sourcesNumber; ++s) {
            sLineOffsetsS[s] = new int[dstBands];
            sPixelOffsetsS[s] = new int[dstBands];
            sBandDataByteS[s] = new byte[dstBands][];
            if (srcBean[s].getDataRasterAccessor() != null) {
                for (int b = 0; b < dstBands; ++b) {
                    sBandDataByteS[s][b] = srcDataByte[s][b];
                    sLineOffsetsS[s][b] = srcBandOffsets[s][b];
                }
            }
            if (weightTypesUsed[s] != WeightType.WEIGHT_TYPE_ALPHA) continue;
            aBandDataByte[s] = alfaDataByte[s][0];
            aLineOffsets[s] = alfaBandOffsets[s][0];
        }
        byte[][] dBandDataByteS = dstDataByte;
        int[] dLineOffsetS = new int[dstBands];
        int[] dPixelOffsetS = new int[dstBands];
        for (int b = 0; b < dstBands; ++b) {
            dLineOffsetS[b] = dstBandOffsets[b];
        }
        if (this.mosaicTypeSelected == MosaicDescriptor.MOSAIC_TYPE_OVERLAY) {
            for (dstY = dstMinY; dstY < dstMaxY; ++dstY) {
                for (int s = 0; s < sourcesNumber; ++s) {
                    if (srcBean[s].getDataRasterAccessor() != null) {
                        int b = 0;
                        while (b < dstBands) {
                            sPixelOffsetsS[s][b] = sLineOffsetsS[s][b];
                            int[] nArray = sLineOffsetsS[s];
                            int n = b++;
                            nArray[n] = nArray[n] + srcLineStride[s];
                        }
                    }
                    if (srcBean[s].getAlphaRasterAccessor() == null) continue;
                    aPixelOffsets[s] = aLineOffsets[s];
                    int n = s;
                    aLineOffsets[n] = aLineOffsets[n] + alfaLineStride[s];
                }
                int b = 0;
                while (b < dstBands) {
                    dPixelOffsetS[b] = dLineOffsetS[b];
                    int n = b++;
                    dLineOffsetS[n] = dLineOffsetS[n] + dstLineStride;
                }
                for (int dstX = dstMinX; dstX < dstMaxX; ++dstX) {
                    boolean setDestinationFlag = false;
                    int[] sourceValueByteS = new int[dstBands];
                    for (int s = 0; s < sourcesNumber; ++s) {
                        int b2;
                        RasterAccessor dataRA = srcBean[s].getDataRasterAccessor();
                        if (dataRA == null) continue;
                        int b3 = 0;
                        while (b3 < dstBands) {
                            sourceValueByteS[b3] = sBandDataByteS[s][b3][sPixelOffsetsS[s][b3]];
                            int[] nArray = sPixelOffsetsS[s];
                            int n = b3++;
                            nArray[n] = nArray[n] + srcPixelStride[s];
                        }
                        int dataCount = dstBands;
                        if (this.hasNoData[s]) {
                            for (b2 = 0; b2 < dstBands; ++b2) {
                                if (this.byteLookupTable[s][b2][sourceValueByteS[b2] & 0xFF] != this.destinationNoDataByte[b2]) continue;
                                --dataCount;
                            }
                        }
                        if (dataCount == 0) {
                            setDestinationFlag = false;
                            if (weightTypesUsed[s] == WeightType.WEIGHT_TYPE_ALPHA) {
                                int n = s;
                                aPixelOffsets[n] = aPixelOffsets[n] + alfaPixelStride[s];
                            }
                        } else {
                            switch (weightTypesUsed[s]) {
                                case WEIGHT_TYPE_ALPHA: {
                                    setDestinationFlag = aBandDataByte[s][aPixelOffsets[s]] != 0;
                                    int n = s;
                                    aPixelOffsets[n] = aPixelOffsets[n] + alfaPixelStride[s];
                                    break;
                                }
                                case WEIGHT_TYPE_ROI: {
                                    setDestinationFlag = srcBean[s].getRoiRaster().getSample(dstX, dstY, 0) > 0;
                                    break;
                                }
                                default: {
                                    setDestinationFlag = true;
                                }
                            }
                        }
                        if (!setDestinationFlag) continue;
                        for (b2 = 0; b2 < dstBands; ++b2) {
                            dBandDataByteS[b2][dPixelOffsetS[b2]] = (byte)(sourceValueByteS[b2] & 0xFF);
                            for (int k = s + 1; k < sourcesNumber; ++k) {
                                if (dataRA == null) continue;
                                int[] nArray = sPixelOffsetsS[k];
                                int n = b2;
                                nArray[n] = nArray[n] + srcPixelStride[k];
                            }
                        }
                        for (int k = s + 1; k < sourcesNumber; ++k) {
                            if (srcBean[k].getAlphaRasterAccessor() == null) continue;
                            int n = k;
                            aPixelOffsets[n] = aPixelOffsets[n] + alfaPixelStride[k];
                        }
                        break;
                    }
                    int b4 = 0;
                    while (b4 < dstBands) {
                        if (!setDestinationFlag) {
                            dBandDataByteS[b4][dPixelOffsetS[b4]] = this.destinationNoDataByte[b4];
                        }
                        int n = b4++;
                        dPixelOffsetS[n] = dPixelOffsetS[n] + dstPixelStride;
                    }
                }
            }
        } else {
            for (dstY = dstMinY; dstY < dstMaxY; ++dstY) {
                for (int s = 0; s < sourcesNumber; ++s) {
                    if (srcBean[s].getDataRasterAccessor() != null) {
                        int b = 0;
                        while (b < dstBands) {
                            sPixelOffsetsS[s][b] = sLineOffsetsS[s][b];
                            int[] nArray = sLineOffsetsS[s];
                            int n = b++;
                            nArray[n] = nArray[n] + srcLineStride[s];
                        }
                    }
                    if (weightTypesUsed[s] != WeightType.WEIGHT_TYPE_ALPHA) continue;
                    aPixelOffsets[s] = aLineOffsets[s];
                    int n = s;
                    aLineOffsets[n] = aLineOffsets[n] + alfaLineStride[s];
                }
                int b = 0;
                while (b < dstBands) {
                    dPixelOffsetS[b] = dLineOffsetS[b];
                    int n = b++;
                    dLineOffsetS[n] = dLineOffsetS[n] + dstLineStride;
                }
                for (int dstX = dstMinX; dstX < dstMaxX; ++dstX) {
                    int b5;
                    double[] numerator = new double[dstBands];
                    double[] denominator = new double[dstBands];
                    int[] sourceValueByteS = new int[dstBands];
                    for (int s = 0; s < sourcesNumber; ++s) {
                        int b6;
                        if (srcBean[s].getDataRasterAccessor() == null) continue;
                        int b7 = 0;
                        while (b7 < dstBands) {
                            sourceValueByteS[b7] = sBandDataByteS[s][b7][sPixelOffsetsS[s][b7]];
                            int[] nArray = sPixelOffsetsS[s];
                            int n = b7++;
                            nArray[n] = nArray[n] + srcPixelStride[s];
                        }
                        double weight = 0.0;
                        int dataCount = dstBands;
                        if (this.hasNoData[s]) {
                            for (b6 = 0; b6 < dstBands; ++b6) {
                                if (this.byteLookupTable[s][b6][sourceValueByteS[b6] & 0xFF] != this.destinationNoDataByte[b6]) continue;
                                --dataCount;
                            }
                        }
                        if (dataCount == 0) {
                            weight = 0.0;
                            if (weightTypesUsed[s] == WeightType.WEIGHT_TYPE_ALPHA) {
                                int n = s;
                                aPixelOffsets[n] = aPixelOffsets[n] + alfaPixelStride[s];
                            }
                        } else {
                            switch (weightTypesUsed[s]) {
                                case WEIGHT_TYPE_ALPHA: {
                                    weight = aBandDataByte[s][aPixelOffsets[s]] & 0xFF;
                                    weight = weight > 0.0 && this.isAlphaBitmaskUsed ? 1.0 : (weight /= 255.0);
                                    int n = s;
                                    aPixelOffsets[n] = aPixelOffsets[n] + alfaPixelStride[s];
                                    break;
                                }
                                case WEIGHT_TYPE_ROI: {
                                    weight = srcBean[s].getRoiRaster().getSample(dstX, dstY, 0) > 0 ? 1.0 : 0.0;
                                    break;
                                }
                                default: {
                                    weight = 1.0;
                                }
                            }
                        }
                        b6 = 0;
                        while (b6 < dstBands) {
                            int n = b6;
                            numerator[n] = numerator[n] + weight * (double)(sourceValueByteS[b6] & 0xFF);
                            int n2 = b6++;
                            denominator[n2] = denominator[n2] + weight;
                        }
                    }
                    double denominatorSum = 0.0;
                    for (b5 = 0; b5 < dstBands; ++b5) {
                        denominatorSum += denominator[b5];
                    }
                    b5 = 0;
                    while (b5 < dstBands) {
                        dBandDataByteS[b5][dPixelOffsetS[b5]] = denominatorSum == 0.0 ? this.destinationNoDataByte[b5] : ImageUtil.clampRoundByte((double)(numerator[b5] / denominator[b5]));
                        int n = b5++;
                        dPixelOffsetS[n] = dPixelOffsetS[n] + dstPixelStride;
                    }
                }
            }
        }
    }

    private void ushortLoop(RasterBeanAccessor[] srcBean, RasterAccessor dst) {
        int dstY;
        Object aBandDataUshort;
        Object alfaDataUshort;
        int[] aPixelOffsets;
        int[] aLineOffsets;
        Object alfaBandOffsets;
        int[] alfaPixelStride;
        int[] alfaLineStride;
        int sourcesNumber = srcBean.length;
        int[] srcLineStride = new int[sourcesNumber];
        int[] srcPixelStride = new int[sourcesNumber];
        int[][] srcBandOffsets = new int[sourcesNumber][];
        int[][] sLineOffsetsS = new int[sourcesNumber][];
        int[][] sPixelOffsetsS = new int[sourcesNumber][];
        short[][][] srcDataUshort = new short[sourcesNumber][][];
        short[][] dstDataUshort = dst.getShortDataArrays();
        short[][][] sBandDataUshortS = new short[sourcesNumber][][];
        boolean alphaPresentinRaster = false;
        for (int i = 0; i < sourcesNumber; ++i) {
            if (srcBean[i].getAlphaRasterAccessor() == null) continue;
            alphaPresentinRaster = true;
            break;
        }
        if (alphaPresentinRaster) {
            alfaLineStride = new int[sourcesNumber];
            alfaPixelStride = new int[sourcesNumber];
            alfaBandOffsets = new int[sourcesNumber][];
            aLineOffsets = new int[sourcesNumber];
            aPixelOffsets = new int[sourcesNumber];
            alfaDataUshort = new short[sourcesNumber][][];
            aBandDataUshort = new short[sourcesNumber][];
        } else {
            alfaLineStride = null;
            alfaPixelStride = null;
            alfaBandOffsets = null;
            aLineOffsets = null;
            aPixelOffsets = null;
            alfaDataUshort = null;
            aBandDataUshort = null;
        }
        WeightType[] weightTypesUsed = new WeightType[sourcesNumber];
        for (int i = 0; i < sourcesNumber; ++i) {
            weightTypesUsed[i] = WeightType.WEIGHT_TYPE_NODATA;
            RasterAccessor dataRA = srcBean[i].getDataRasterAccessor();
            if (dataRA == null) continue;
            srcLineStride[i] = dataRA.getScanlineStride();
            srcPixelStride[i] = dataRA.getPixelStride();
            srcBandOffsets[i] = dataRA.getBandOffsets();
            srcDataUshort[i] = dataRA.getShortDataArrays();
            RasterAccessor alphaRA = srcBean[i].getAlphaRasterAccessor();
            if (alphaPresentinRaster & alphaRA != null) {
                alfaDataUshort[i] = alphaRA.getShortDataArrays();
                alfaBandOffsets[i] = alphaRA.getBandOffsets();
                alfaPixelStride[i] = alphaRA.getPixelStride();
                alfaLineStride[i] = alphaRA.getScanlineStride();
            }
            if (alphaRA != null) {
                weightTypesUsed[i] = WeightType.WEIGHT_TYPE_ALPHA;
                continue;
            }
            if (!this.roiPresent || srcBean[i].getRoiRaster() == null) continue;
            weightTypesUsed[i] = WeightType.WEIGHT_TYPE_ROI;
        }
        int dstMinX = dst.getX();
        int dstMinY = dst.getY();
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstMaxX = dstMinX + dstWidth;
        int dstMaxY = dstMinY + dstHeight;
        int dstBands = dst.getNumBands();
        int dstLineStride = dst.getScanlineStride();
        int dstPixelStride = dst.getPixelStride();
        int[] dstBandOffsets = dst.getBandOffsets();
        for (int s = 0; s < sourcesNumber; ++s) {
            sLineOffsetsS[s] = new int[dstBands];
            sPixelOffsetsS[s] = new int[dstBands];
            sBandDataUshortS[s] = new short[dstBands][];
            if (srcBean[s].getDataRasterAccessor() != null) {
                for (int b = 0; b < dstBands; ++b) {
                    sBandDataUshortS[s][b] = srcDataUshort[s][b];
                    sLineOffsetsS[s][b] = srcBandOffsets[s][b];
                }
            }
            if (weightTypesUsed[s] != WeightType.WEIGHT_TYPE_ALPHA) continue;
            aBandDataUshort[s] = alfaDataUshort[s][0];
            aLineOffsets[s] = alfaBandOffsets[s][0];
        }
        short[][] dBandDataUshortS = dstDataUshort;
        int[] dLineOffsetS = new int[dstBands];
        int[] dPixelOffsetS = new int[dstBands];
        for (int b = 0; b < dstBands; ++b) {
            dLineOffsetS[b] = dstBandOffsets[b];
        }
        if (this.mosaicTypeSelected == MosaicDescriptor.MOSAIC_TYPE_OVERLAY) {
            for (dstY = dstMinY; dstY < dstMaxY; ++dstY) {
                for (int s = 0; s < sourcesNumber; ++s) {
                    if (srcBean[s].getDataRasterAccessor() != null) {
                        int b = 0;
                        while (b < dstBands) {
                            sPixelOffsetsS[s][b] = sLineOffsetsS[s][b];
                            int[] nArray = sLineOffsetsS[s];
                            int n = b++;
                            nArray[n] = nArray[n] + srcLineStride[s];
                        }
                    }
                    if (srcBean[s].getAlphaRasterAccessor() == null) continue;
                    aPixelOffsets[s] = aLineOffsets[s];
                    int n = s;
                    aLineOffsets[n] = aLineOffsets[n] + alfaLineStride[s];
                }
                int b = 0;
                while (b < dstBands) {
                    dPixelOffsetS[b] = dLineOffsetS[b];
                    int n = b++;
                    dLineOffsetS[n] = dLineOffsetS[n] + dstLineStride;
                }
                for (int dstX = dstMinX; dstX < dstMaxX; ++dstX) {
                    boolean setDestinationFlag = false;
                    short[] valueS = new short[dstBands];
                    int[] sourceValueUshortS = new int[dstBands];
                    for (int s = 0; s < sourcesNumber; ++s) {
                        RasterAccessor dataRA = srcBean[s].getDataRasterAccessor();
                        if (dataRA == null) continue;
                        int b2 = 0;
                        while (b2 < dstBands) {
                            valueS[b2] = sBandDataUshortS[s][b2][sPixelOffsetsS[s][b2]];
                            sourceValueUshortS[b2] = valueS[b2] & 0xFFFF;
                            int[] nArray = sPixelOffsetsS[s];
                            int n = b2++;
                            nArray[n] = nArray[n] + srcPixelStride[s];
                        }
                        int dataCount = dstBands;
                        if (this.hasNoData[s]) {
                            Range noDataRangeUShort = srcBean[s].getSourceNoDataRangeRasterAccessor();
                            for (int b3 = 0; b3 < dstBands; ++b3) {
                                if (noDataRangeUShort == null || !noDataRangeUShort.contains(sourceValueUshortS[b3])) continue;
                                --dataCount;
                            }
                        }
                        if (dataCount == 0) {
                            setDestinationFlag = false;
                            if (weightTypesUsed[s] == WeightType.WEIGHT_TYPE_ALPHA) {
                                int n = s;
                                aPixelOffsets[n] = aPixelOffsets[n] + alfaPixelStride[s];
                            }
                        } else {
                            switch (weightTypesUsed[s]) {
                                case WEIGHT_TYPE_ALPHA: {
                                    setDestinationFlag = aBandDataUshort[s][aPixelOffsets[s]] != 0;
                                    int n = s;
                                    aPixelOffsets[n] = aPixelOffsets[n] + alfaPixelStride[s];
                                    break;
                                }
                                case WEIGHT_TYPE_ROI: {
                                    setDestinationFlag = srcBean[s].getRoiRaster().getSample(dstX, dstY, 0) > 0;
                                    break;
                                }
                                default: {
                                    setDestinationFlag = true;
                                }
                            }
                        }
                        if (!setDestinationFlag) continue;
                        for (int b4 = 0; b4 < dstBands; ++b4) {
                            dBandDataUshortS[b4][dPixelOffsetS[b4]] = valueS[b4];
                            for (int k = s + 1; k < sourcesNumber; ++k) {
                                if (dataRA == null) continue;
                                int[] nArray = sPixelOffsetsS[k];
                                int n = b4;
                                nArray[n] = nArray[n] + srcPixelStride[k];
                            }
                        }
                        for (int k = s + 1; k < sourcesNumber; ++k) {
                            if (srcBean[k].getAlphaRasterAccessor() == null) continue;
                            int n = k;
                            aPixelOffsets[n] = aPixelOffsets[n] + alfaPixelStride[k];
                        }
                        break;
                    }
                    int b5 = 0;
                    while (b5 < dstBands) {
                        if (!setDestinationFlag) {
                            dBandDataUshortS[b5][dPixelOffsetS[b5]] = this.destinationNoDataUShort[b5];
                        }
                        int n = b5++;
                        dPixelOffsetS[n] = dPixelOffsetS[n] + dstPixelStride;
                    }
                }
            }
        } else {
            for (dstY = dstMinY; dstY < dstMaxY; ++dstY) {
                for (int s = 0; s < sourcesNumber; ++s) {
                    if (srcBean[s].getDataRasterAccessor() != null) {
                        int b = 0;
                        while (b < dstBands) {
                            sPixelOffsetsS[s][b] = sLineOffsetsS[s][b];
                            int[] nArray = sLineOffsetsS[s];
                            int n = b++;
                            nArray[n] = nArray[n] + srcLineStride[s];
                        }
                    }
                    if (weightTypesUsed[s] != WeightType.WEIGHT_TYPE_ALPHA) continue;
                    aPixelOffsets[s] = aLineOffsets[s];
                    int n = s;
                    aLineOffsets[n] = aLineOffsets[n] + alfaLineStride[s];
                }
                int b = 0;
                while (b < dstBands) {
                    dPixelOffsetS[b] = dLineOffsetS[b];
                    int n = b++;
                    dLineOffsetS[n] = dLineOffsetS[n] + dstLineStride;
                }
                for (int dstX = dstMinX; dstX < dstMaxX; ++dstX) {
                    int b6;
                    double[] numerator = new double[dstBands];
                    double[] denominator = new double[dstBands];
                    short[] sourceValueUshortS = new short[dstBands];
                    for (int s = 0; s < sourcesNumber; ++s) {
                        int b7;
                        if (srcBean[s].getDataRasterAccessor() == null) continue;
                        int b8 = 0;
                        while (b8 < dstBands) {
                            sourceValueUshortS[b8] = (short)(sBandDataUshortS[s][b8][sPixelOffsetsS[s][b8]] & 0xFFFF);
                            int[] nArray = sPixelOffsetsS[s];
                            int n = b8++;
                            nArray[n] = nArray[n] + srcPixelStride[s];
                        }
                        double weight = 0.0;
                        int dataCount = dstBands;
                        if (this.hasNoData[s]) {
                            for (b7 = 0; b7 < dstBands; ++b7) {
                                Range noDataRangeUShort = srcBean[s].getSourceNoDataRangeRasterAccessor();
                                if (noDataRangeUShort == null || !noDataRangeUShort.contains(sourceValueUshortS[b7])) continue;
                                --dataCount;
                            }
                        }
                        if (dataCount == 0) {
                            weight = 0.0;
                            if (weightTypesUsed[s] == WeightType.WEIGHT_TYPE_ALPHA) {
                                int n = s;
                                aPixelOffsets[n] = aPixelOffsets[n] + alfaPixelStride[s];
                            }
                        } else {
                            switch (weightTypesUsed[s]) {
                                case WEIGHT_TYPE_ALPHA: {
                                    weight = aBandDataUshort[s][aPixelOffsets[s]] & 0xFFFF;
                                    weight = weight > 0.0 && this.isAlphaBitmaskUsed ? 1.0 : (weight /= 255.0);
                                    int n = s;
                                    aPixelOffsets[n] = aPixelOffsets[n] + alfaPixelStride[s];
                                    break;
                                }
                                case WEIGHT_TYPE_ROI: {
                                    weight = srcBean[s].getRoiRaster().getSample(dstX, dstY, 0) > 0 ? 1.0 : 0.0;
                                    break;
                                }
                                default: {
                                    weight = 1.0;
                                }
                            }
                        }
                        b7 = 0;
                        while (b7 < dstBands) {
                            int n = b7;
                            numerator[n] = numerator[n] + weight * (double)sourceValueUshortS[b7];
                            int n2 = b7++;
                            denominator[n2] = denominator[n2] + weight;
                        }
                    }
                    double denominatorSum = 0.0;
                    for (b6 = 0; b6 < dstBands; ++b6) {
                        denominatorSum += denominator[b6];
                    }
                    for (b6 = 0; b6 < dstBands; ++b6) {
                        if (denominatorSum == 0.0) {
                            dBandDataUshortS[b6][dPixelOffsetS[b6]] = this.destinationNoDataUShort[b6];
                            continue;
                        }
                        dBandDataUshortS[b6][dPixelOffsetS[b6]] = ImageUtil.clampRoundUShort((double)(numerator[b6] / denominator[b6]));
                        int n = b6;
                        dPixelOffsetS[n] = dPixelOffsetS[n] + dstPixelStride;
                    }
                }
            }
        }
    }

    private void shortLoop(RasterBeanAccessor[] srcBean, RasterAccessor dst) {
        int dstY;
        Object aBandDataShort;
        Object alfaDataShort;
        int[] aPixelOffsets;
        int[] aLineOffsets;
        Object alfaBandOffsets;
        int[] alfaPixelStride;
        int[] alfaLineStride;
        int sourcesNumber = srcBean.length;
        int[] srcLineStride = new int[sourcesNumber];
        int[] srcPixelStride = new int[sourcesNumber];
        int[][] srcBandOffsets = new int[sourcesNumber][];
        int[][] sLineOffsetsS = new int[sourcesNumber][];
        int[][] sPixelOffsetsS = new int[sourcesNumber][];
        short[][][] srcDataShort = new short[sourcesNumber][][];
        short[][] dstDataShort = dst.getShortDataArrays();
        short[][][] sBandDataShortS = new short[sourcesNumber][][];
        boolean alphaPresentinRaster = false;
        for (int i = 0; i < sourcesNumber; ++i) {
            if (srcBean[i].getAlphaRasterAccessor() == null) continue;
            alphaPresentinRaster = true;
            break;
        }
        if (alphaPresentinRaster) {
            alfaLineStride = new int[sourcesNumber];
            alfaPixelStride = new int[sourcesNumber];
            alfaBandOffsets = new int[sourcesNumber][];
            aLineOffsets = new int[sourcesNumber];
            aPixelOffsets = new int[sourcesNumber];
            alfaDataShort = new short[sourcesNumber][][];
            aBandDataShort = new short[sourcesNumber][];
        } else {
            alfaLineStride = null;
            alfaPixelStride = null;
            alfaBandOffsets = null;
            aLineOffsets = null;
            aPixelOffsets = null;
            alfaDataShort = null;
            aBandDataShort = null;
        }
        WeightType[] weightTypesUsed = new WeightType[sourcesNumber];
        for (int i = 0; i < sourcesNumber; ++i) {
            weightTypesUsed[i] = WeightType.WEIGHT_TYPE_NODATA;
            RasterAccessor dataRA = srcBean[i].getDataRasterAccessor();
            if (dataRA == null) continue;
            srcLineStride[i] = dataRA.getScanlineStride();
            srcPixelStride[i] = dataRA.getPixelStride();
            srcBandOffsets[i] = dataRA.getBandOffsets();
            srcDataShort[i] = dataRA.getShortDataArrays();
            RasterAccessor alphaRA = srcBean[i].getAlphaRasterAccessor();
            if (alphaPresentinRaster & alphaRA != null) {
                alfaDataShort[i] = alphaRA.getShortDataArrays();
                alfaBandOffsets[i] = alphaRA.getBandOffsets();
                alfaPixelStride[i] = alphaRA.getPixelStride();
                alfaLineStride[i] = alphaRA.getScanlineStride();
            }
            if (alphaRA != null) {
                weightTypesUsed[i] = WeightType.WEIGHT_TYPE_ALPHA;
                continue;
            }
            if (!this.roiPresent || srcBean[i].getRoiRaster() == null) continue;
            weightTypesUsed[i] = WeightType.WEIGHT_TYPE_ROI;
        }
        int dstMinX = dst.getX();
        int dstMinY = dst.getY();
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstMaxX = dstMinX + dstWidth;
        int dstMaxY = dstMinY + dstHeight;
        int dstBands = dst.getNumBands();
        int dstLineStride = dst.getScanlineStride();
        int dstPixelStride = dst.getPixelStride();
        int[] dstBandOffsets = dst.getBandOffsets();
        for (int s = 0; s < sourcesNumber; ++s) {
            sLineOffsetsS[s] = new int[dstBands];
            sPixelOffsetsS[s] = new int[dstBands];
            sBandDataShortS[s] = new short[dstBands][];
            if (srcBean[s].getDataRasterAccessor() != null) {
                for (int b = 0; b < dstBands; ++b) {
                    sBandDataShortS[s][b] = srcDataShort[s][b];
                    sLineOffsetsS[s][b] = srcBandOffsets[s][b];
                }
            }
            if (weightTypesUsed[s] != WeightType.WEIGHT_TYPE_ALPHA) continue;
            aBandDataShort[s] = alfaDataShort[s][0];
            aLineOffsets[s] = alfaBandOffsets[s][0];
        }
        short[][] dBandDataShortS = dstDataShort;
        int[] dLineOffsetS = new int[dstBands];
        int[] dPixelOffsetS = new int[dstBands];
        for (int b = 0; b < dstBands; ++b) {
            dLineOffsetS[b] = dstBandOffsets[b];
        }
        if (this.mosaicTypeSelected == MosaicDescriptor.MOSAIC_TYPE_OVERLAY) {
            for (dstY = dstMinY; dstY < dstMaxY; ++dstY) {
                for (int s = 0; s < sourcesNumber; ++s) {
                    if (srcBean[s].getDataRasterAccessor() != null) {
                        int b = 0;
                        while (b < dstBands) {
                            sPixelOffsetsS[s][b] = sLineOffsetsS[s][b];
                            int[] nArray = sLineOffsetsS[s];
                            int n = b++;
                            nArray[n] = nArray[n] + srcLineStride[s];
                        }
                    }
                    if (srcBean[s].getAlphaRasterAccessor() == null) continue;
                    aPixelOffsets[s] = aLineOffsets[s];
                    int n = s;
                    aLineOffsets[n] = aLineOffsets[n] + alfaLineStride[s];
                }
                int b = 0;
                while (b < dstBands) {
                    dPixelOffsetS[b] = dLineOffsetS[b];
                    int n = b++;
                    dLineOffsetS[n] = dLineOffsetS[n] + dstLineStride;
                }
                for (int dstX = dstMinX; dstX < dstMaxX; ++dstX) {
                    boolean setDestinationFlag = false;
                    short[] sourceValueShortS = new short[dstBands];
                    for (int s = 0; s < sourcesNumber; ++s) {
                        RasterAccessor dataRA = srcBean[s].getDataRasterAccessor();
                        if (dataRA == null) continue;
                        int b2 = 0;
                        while (b2 < dstBands) {
                            sourceValueShortS[b2] = sBandDataShortS[s][b2][sPixelOffsetsS[s][b2]];
                            int[] nArray = sPixelOffsetsS[s];
                            int n = b2++;
                            nArray[n] = nArray[n] + srcPixelStride[s];
                        }
                        int dataCount = dstBands;
                        if (this.hasNoData[s]) {
                            Range noDataRangeShort = srcBean[s].getSourceNoDataRangeRasterAccessor();
                            for (int b3 = 0; b3 < dstBands; ++b3) {
                                if (noDataRangeShort == null || !noDataRangeShort.contains(sourceValueShortS[b3])) continue;
                                --dataCount;
                            }
                        }
                        if (dataCount == 0) {
                            setDestinationFlag = false;
                            if (weightTypesUsed[s] == WeightType.WEIGHT_TYPE_ALPHA) {
                                int n = s;
                                aPixelOffsets[n] = aPixelOffsets[n] + alfaPixelStride[s];
                            }
                        } else {
                            switch (weightTypesUsed[s]) {
                                case WEIGHT_TYPE_ALPHA: {
                                    setDestinationFlag = aBandDataShort[s][aPixelOffsets[s]] != 0;
                                    int n = s;
                                    aPixelOffsets[n] = aPixelOffsets[n] + alfaPixelStride[s];
                                    break;
                                }
                                case WEIGHT_TYPE_ROI: {
                                    setDestinationFlag = srcBean[s].getRoiRaster().getSample(dstX, dstY, 0) > 0;
                                    break;
                                }
                                default: {
                                    setDestinationFlag = true;
                                }
                            }
                        }
                        if (!setDestinationFlag) continue;
                        for (int b4 = 0; b4 < dstBands; ++b4) {
                            dBandDataShortS[b4][dPixelOffsetS[b4]] = sourceValueShortS[b4];
                            for (int k = s + 1; k < sourcesNumber; ++k) {
                                if (dataRA == null) continue;
                                int[] nArray = sPixelOffsetsS[k];
                                int n = b4;
                                nArray[n] = nArray[n] + srcPixelStride[k];
                            }
                        }
                        for (int k = s + 1; k < sourcesNumber; ++k) {
                            if (srcBean[k].getAlphaRasterAccessor() == null) continue;
                            int n = k;
                            aPixelOffsets[n] = aPixelOffsets[n] + alfaPixelStride[k];
                        }
                        break;
                    }
                    int b5 = 0;
                    while (b5 < dstBands) {
                        if (!setDestinationFlag) {
                            dBandDataShortS[b5][dPixelOffsetS[b5]] = this.destinationNoDataShort[b5];
                        }
                        int n = b5++;
                        dPixelOffsetS[n] = dPixelOffsetS[n] + dstPixelStride;
                    }
                }
            }
        } else {
            for (dstY = dstMinY; dstY < dstMaxY; ++dstY) {
                for (int s = 0; s < sourcesNumber; ++s) {
                    if (srcBean[s].getDataRasterAccessor() != null) {
                        int b = 0;
                        while (b < dstBands) {
                            sPixelOffsetsS[s][b] = sLineOffsetsS[s][b];
                            int[] nArray = sLineOffsetsS[s];
                            int n = b++;
                            nArray[n] = nArray[n] + srcLineStride[s];
                        }
                    }
                    if (weightTypesUsed[s] != WeightType.WEIGHT_TYPE_ALPHA) continue;
                    aPixelOffsets[s] = aLineOffsets[s];
                    int n = s;
                    aLineOffsets[n] = aLineOffsets[n] + alfaLineStride[s];
                }
                int b = 0;
                while (b < dstBands) {
                    dPixelOffsetS[b] = dLineOffsetS[b];
                    int n = b++;
                    dLineOffsetS[n] = dLineOffsetS[n] + dstLineStride;
                }
                for (int dstX = dstMinX; dstX < dstMaxX; ++dstX) {
                    int b6;
                    double[] numerator = new double[dstBands];
                    double[] denominator = new double[dstBands];
                    short[] sourceValueShortS = new short[dstBands];
                    for (int s = 0; s < sourcesNumber; ++s) {
                        int b7;
                        if (srcBean[s].getDataRasterAccessor() == null) continue;
                        int b8 = 0;
                        while (b8 < dstBands) {
                            sourceValueShortS[b8] = sBandDataShortS[s][b8][sPixelOffsetsS[s][b8]];
                            int[] nArray = sPixelOffsetsS[s];
                            int n = b8++;
                            nArray[n] = nArray[n] + srcPixelStride[s];
                        }
                        double weight = 0.0;
                        int dataCount = dstBands;
                        if (this.hasNoData[s]) {
                            for (b7 = 0; b7 < dstBands; ++b7) {
                                Range noDataRangeShort = srcBean[s].getSourceNoDataRangeRasterAccessor();
                                if (noDataRangeShort == null || !noDataRangeShort.contains(sourceValueShortS[b7])) continue;
                                --dataCount;
                            }
                        }
                        if (dataCount == 0) {
                            weight = 0.0;
                            if (weightTypesUsed[s] == WeightType.WEIGHT_TYPE_ALPHA) {
                                int n = s;
                                aPixelOffsets[n] = aPixelOffsets[n] + alfaPixelStride[s];
                            }
                        } else {
                            switch (weightTypesUsed[s]) {
                                case WEIGHT_TYPE_ALPHA: {
                                    weight = aBandDataShort[s][aPixelOffsets[s]];
                                    weight = weight > 0.0 && this.isAlphaBitmaskUsed ? 1.0 : (weight /= 255.0);
                                    int n = s;
                                    aPixelOffsets[n] = aPixelOffsets[n] + alfaPixelStride[s];
                                    break;
                                }
                                case WEIGHT_TYPE_ROI: {
                                    weight = srcBean[s].getRoiRaster().getSample(dstX, dstY, 0) > 0 ? 1.0 : 0.0;
                                    break;
                                }
                                default: {
                                    weight = 1.0;
                                }
                            }
                        }
                        b7 = 0;
                        while (b7 < dstBands) {
                            int n = b7;
                            numerator[n] = numerator[n] + weight * (double)sourceValueShortS[b7];
                            int n2 = b7++;
                            denominator[n2] = denominator[n2] + weight;
                        }
                    }
                    double denominatorSum = 0.0;
                    for (b6 = 0; b6 < dstBands; ++b6) {
                        denominatorSum += denominator[b6];
                    }
                    for (b6 = 0; b6 < dstBands; ++b6) {
                        if (denominatorSum == 0.0) {
                            dBandDataShortS[b6][dPixelOffsetS[b6]] = this.destinationNoDataShort[b6];
                            continue;
                        }
                        dBandDataShortS[b6][dPixelOffsetS[b6]] = ImageUtil.clampRoundShort((double)(numerator[b6] / denominator[b6]));
                        int n = b6;
                        dPixelOffsetS[n] = dPixelOffsetS[n] + dstPixelStride;
                    }
                }
            }
        }
    }

    private void intLoop(RasterBeanAccessor[] srcBean, RasterAccessor dst) {
        int dstY;
        Object aBandDataInt;
        Object alfaDataInt;
        int[] aPixelOffsets;
        int[] aLineOffsets;
        Object alfaBandOffsets;
        int[] alfaPixelStride;
        int[] alfaLineStride;
        int sourcesNumber = srcBean.length;
        int[] srcLineStride = new int[sourcesNumber];
        int[] srcPixelStride = new int[sourcesNumber];
        int[][] srcBandOffsets = new int[sourcesNumber][];
        int[][] sLineOffsetsS = new int[sourcesNumber][];
        int[][] sPixelOffsetsS = new int[sourcesNumber][];
        int[][][] srcDataInt = new int[sourcesNumber][][];
        int[][] dstDataInt = dst.getIntDataArrays();
        int[][][] sBandDataIntS = new int[sourcesNumber][][];
        boolean alphaPresentinRaster = false;
        for (int i = 0; i < sourcesNumber; ++i) {
            if (srcBean[i].getAlphaRasterAccessor() == null) continue;
            alphaPresentinRaster = true;
            break;
        }
        if (alphaPresentinRaster) {
            alfaLineStride = new int[sourcesNumber];
            alfaPixelStride = new int[sourcesNumber];
            alfaBandOffsets = new int[sourcesNumber][];
            aLineOffsets = new int[sourcesNumber];
            aPixelOffsets = new int[sourcesNumber];
            alfaDataInt = new int[sourcesNumber][][];
            aBandDataInt = new int[sourcesNumber][];
        } else {
            alfaLineStride = null;
            alfaPixelStride = null;
            alfaBandOffsets = null;
            aLineOffsets = null;
            aPixelOffsets = null;
            alfaDataInt = null;
            aBandDataInt = null;
        }
        WeightType[] weightTypesUsed = new WeightType[sourcesNumber];
        for (int i = 0; i < sourcesNumber; ++i) {
            weightTypesUsed[i] = WeightType.WEIGHT_TYPE_NODATA;
            RasterAccessor dataRA = srcBean[i].getDataRasterAccessor();
            if (dataRA == null) continue;
            srcLineStride[i] = dataRA.getScanlineStride();
            srcPixelStride[i] = dataRA.getPixelStride();
            srcBandOffsets[i] = dataRA.getBandOffsets();
            srcDataInt[i] = dataRA.getIntDataArrays();
            RasterAccessor alphaRA = srcBean[i].getAlphaRasterAccessor();
            if (alphaPresentinRaster & alphaRA != null) {
                alfaDataInt[i] = alphaRA.getIntDataArrays();
                alfaBandOffsets[i] = alphaRA.getBandOffsets();
                alfaPixelStride[i] = alphaRA.getPixelStride();
                alfaLineStride[i] = alphaRA.getScanlineStride();
            }
            if (alphaRA != null) {
                weightTypesUsed[i] = WeightType.WEIGHT_TYPE_ALPHA;
                continue;
            }
            if (!this.roiPresent || srcBean[i].getRoiRaster() == null) continue;
            weightTypesUsed[i] = WeightType.WEIGHT_TYPE_ROI;
        }
        int dstMinX = dst.getX();
        int dstMinY = dst.getY();
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstMaxX = dstMinX + dstWidth;
        int dstMaxY = dstMinY + dstHeight;
        int dstBands = dst.getNumBands();
        int dstLineStride = dst.getScanlineStride();
        int dstPixelStride = dst.getPixelStride();
        int[] dstBandOffsets = dst.getBandOffsets();
        for (int s = 0; s < sourcesNumber; ++s) {
            sLineOffsetsS[s] = new int[dstBands];
            sPixelOffsetsS[s] = new int[dstBands];
            sBandDataIntS[s] = new int[dstBands][];
            if (srcBean[s].getDataRasterAccessor() != null) {
                for (int b = 0; b < dstBands; ++b) {
                    sBandDataIntS[s][b] = srcDataInt[s][b];
                    sLineOffsetsS[s][b] = srcBandOffsets[s][b];
                }
            }
            if (weightTypesUsed[s] != WeightType.WEIGHT_TYPE_ALPHA) continue;
            aBandDataInt[s] = alfaDataInt[s][0];
            aLineOffsets[s] = alfaBandOffsets[s][0];
        }
        int[][] dBandDataIntS = dstDataInt;
        int[] dLineOffsetS = new int[dstBands];
        int[] dPixelOffsetS = new int[dstBands];
        for (int b = 0; b < dstBands; ++b) {
            dLineOffsetS[b] = dstBandOffsets[b];
        }
        if (this.mosaicTypeSelected == MosaicDescriptor.MOSAIC_TYPE_OVERLAY) {
            for (dstY = dstMinY; dstY < dstMaxY; ++dstY) {
                for (int s = 0; s < sourcesNumber; ++s) {
                    if (srcBean[s].getDataRasterAccessor() != null) {
                        int b = 0;
                        while (b < dstBands) {
                            sPixelOffsetsS[s][b] = sLineOffsetsS[s][b];
                            int[] nArray = sLineOffsetsS[s];
                            int n = b++;
                            nArray[n] = nArray[n] + srcLineStride[s];
                        }
                    }
                    if (srcBean[s].getAlphaRasterAccessor() == null) continue;
                    aPixelOffsets[s] = aLineOffsets[s];
                    int n = s;
                    aLineOffsets[n] = aLineOffsets[n] + alfaLineStride[s];
                }
                int b = 0;
                while (b < dstBands) {
                    dPixelOffsetS[b] = dLineOffsetS[b];
                    int n = b++;
                    dLineOffsetS[n] = dLineOffsetS[n] + dstLineStride;
                }
                for (int dstX = dstMinX; dstX < dstMaxX; ++dstX) {
                    boolean setDestinationFlag = false;
                    int[] sourceValueIntS = new int[dstBands];
                    for (int s = 0; s < sourcesNumber; ++s) {
                        RasterAccessor dataRA = srcBean[s].getDataRasterAccessor();
                        if (dataRA == null) continue;
                        int b2 = 0;
                        while (b2 < dstBands) {
                            sourceValueIntS[b2] = sBandDataIntS[s][b2][sPixelOffsetsS[s][b2]];
                            int[] nArray = sPixelOffsetsS[s];
                            int n = b2++;
                            nArray[n] = nArray[n] + srcPixelStride[s];
                        }
                        int dataCount = dstBands;
                        if (this.hasNoData[s]) {
                            Range noDataRangeInt = srcBean[s].getSourceNoDataRangeRasterAccessor();
                            for (int b3 = 0; b3 < dstBands; ++b3) {
                                if (noDataRangeInt == null || !noDataRangeInt.contains(sourceValueIntS[b3])) continue;
                                --dataCount;
                            }
                        }
                        if (dataCount == 0) {
                            setDestinationFlag = false;
                            if (weightTypesUsed[s] == WeightType.WEIGHT_TYPE_ALPHA) {
                                int n = s;
                                aPixelOffsets[n] = aPixelOffsets[n] + alfaPixelStride[s];
                            }
                        } else {
                            switch (weightTypesUsed[s]) {
                                case WEIGHT_TYPE_ALPHA: {
                                    setDestinationFlag = aBandDataInt[s][aPixelOffsets[s]] != 0;
                                    int n = s;
                                    aPixelOffsets[n] = aPixelOffsets[n] + alfaPixelStride[s];
                                    break;
                                }
                                case WEIGHT_TYPE_ROI: {
                                    setDestinationFlag = srcBean[s].getRoiRaster().getSample(dstX, dstY, 0) > 0;
                                    break;
                                }
                                default: {
                                    setDestinationFlag = true;
                                }
                            }
                        }
                        if (!setDestinationFlag) continue;
                        for (int b4 = 0; b4 < dstBands; ++b4) {
                            dBandDataIntS[b4][dPixelOffsetS[b4]] = sourceValueIntS[b4];
                            for (int k = s + 1; k < sourcesNumber; ++k) {
                                if (dataRA == null) continue;
                                int[] nArray = sPixelOffsetsS[k];
                                int n = b4;
                                nArray[n] = nArray[n] + srcPixelStride[k];
                            }
                        }
                        for (int k = s + 1; k < sourcesNumber; ++k) {
                            if (srcBean[k].getAlphaRasterAccessor() == null) continue;
                            int n = k;
                            aPixelOffsets[n] = aPixelOffsets[n] + alfaPixelStride[k];
                        }
                        break;
                    }
                    int b5 = 0;
                    while (b5 < dstBands) {
                        if (!setDestinationFlag) {
                            dBandDataIntS[b5][dPixelOffsetS[b5]] = this.destinationNoDataInt[b5];
                        }
                        int n = b5++;
                        dPixelOffsetS[n] = dPixelOffsetS[n] + dstPixelStride;
                    }
                }
            }
        } else {
            for (dstY = dstMinY; dstY < dstMaxY; ++dstY) {
                for (int s = 0; s < sourcesNumber; ++s) {
                    if (srcBean[s].getDataRasterAccessor() != null) {
                        int b = 0;
                        while (b < dstBands) {
                            sPixelOffsetsS[s][b] = sLineOffsetsS[s][b];
                            int[] nArray = sLineOffsetsS[s];
                            int n = b++;
                            nArray[n] = nArray[n] + srcLineStride[s];
                        }
                    }
                    if (weightTypesUsed[s] != WeightType.WEIGHT_TYPE_ALPHA) continue;
                    aPixelOffsets[s] = aLineOffsets[s];
                    int n = s;
                    aLineOffsets[n] = aLineOffsets[n] + alfaLineStride[s];
                }
                int b = 0;
                while (b < dstBands) {
                    dPixelOffsetS[b] = dLineOffsetS[b];
                    int n = b++;
                    dLineOffsetS[n] = dLineOffsetS[n] + dstLineStride;
                }
                for (int dstX = dstMinX; dstX < dstMaxX; ++dstX) {
                    int b6;
                    double[] numerator = new double[dstBands];
                    double[] denominator = new double[dstBands];
                    int[] sourceValueIntS = new int[dstBands];
                    for (int s = 0; s < sourcesNumber; ++s) {
                        int b7;
                        if (srcBean[s].getDataRasterAccessor() == null) continue;
                        int b8 = 0;
                        while (b8 < dstBands) {
                            sourceValueIntS[b8] = sBandDataIntS[s][b8][sPixelOffsetsS[s][b8]];
                            int[] nArray = sPixelOffsetsS[s];
                            int n = b8++;
                            nArray[n] = nArray[n] + srcPixelStride[s];
                        }
                        double weight = 0.0;
                        int dataCount = dstBands;
                        if (this.hasNoData[s]) {
                            for (b7 = 0; b7 < dstBands; ++b7) {
                                Range noDataRangeInt = srcBean[s].getSourceNoDataRangeRasterAccessor();
                                if (noDataRangeInt == null || !noDataRangeInt.contains(sourceValueIntS[b7])) continue;
                                --dataCount;
                            }
                        }
                        if (dataCount == 0) {
                            weight = 0.0;
                            if (weightTypesUsed[s] == WeightType.WEIGHT_TYPE_ALPHA) {
                                int n = s;
                                aPixelOffsets[n] = aPixelOffsets[n] + alfaPixelStride[s];
                            }
                        } else {
                            switch (weightTypesUsed[s]) {
                                case WEIGHT_TYPE_ALPHA: {
                                    weight = aBandDataInt[s][aPixelOffsets[s]];
                                    weight = weight > 0.0 && this.isAlphaBitmaskUsed ? 1.0 : (weight /= 255.0);
                                    int n = s;
                                    aPixelOffsets[n] = aPixelOffsets[n] + alfaPixelStride[s];
                                    break;
                                }
                                case WEIGHT_TYPE_ROI: {
                                    weight = srcBean[s].getRoiRaster().getSample(dstX, dstY, 0) > 0 ? 1.0 : 0.0;
                                    break;
                                }
                                default: {
                                    weight = 1.0;
                                }
                            }
                        }
                        b7 = 0;
                        while (b7 < dstBands) {
                            int n = b7;
                            numerator[n] = numerator[n] + weight * (double)sourceValueIntS[b7];
                            int n2 = b7++;
                            denominator[n2] = denominator[n2] + weight;
                        }
                    }
                    double denominatorSum = 0.0;
                    for (b6 = 0; b6 < dstBands; ++b6) {
                        denominatorSum += denominator[b6];
                    }
                    for (b6 = 0; b6 < dstBands; ++b6) {
                        if (denominatorSum == 0.0) {
                            dBandDataIntS[b6][dPixelOffsetS[b6]] = this.destinationNoDataInt[b6];
                            continue;
                        }
                        dBandDataIntS[b6][dPixelOffsetS[b6]] = ImageUtil.clampRoundInt((double)(numerator[b6] / denominator[b6]));
                        int n = b6;
                        dPixelOffsetS[n] = dPixelOffsetS[n] + dstPixelStride;
                    }
                }
            }
        }
    }

    private void floatLoop(RasterBeanAccessor[] srcBean, RasterAccessor dst) {
        int dstY;
        Object aBandDataFloat;
        Object alfaDataFloat;
        int[] aPixelOffsets;
        int[] aLineOffsets;
        Object alfaBandOffsets;
        int[] alfaPixelStride;
        int[] alfaLineStride;
        int sourcesNumber = srcBean.length;
        int[] srcLineStride = new int[sourcesNumber];
        int[] srcPixelStride = new int[sourcesNumber];
        int[][] srcBandOffsets = new int[sourcesNumber][];
        int[][] sLineOffsetsS = new int[sourcesNumber][];
        int[][] sPixelOffsetsS = new int[sourcesNumber][];
        float[][][] srcDataFloat = new float[sourcesNumber][][];
        float[][] dstDataFloat = dst.getFloatDataArrays();
        float[][][] sBandDataFloatS = new float[sourcesNumber][][];
        boolean alphaPresentinRaster = false;
        for (int i = 0; i < sourcesNumber; ++i) {
            if (srcBean[i].getAlphaRasterAccessor() == null) continue;
            alphaPresentinRaster = true;
            break;
        }
        if (alphaPresentinRaster) {
            alfaLineStride = new int[sourcesNumber];
            alfaPixelStride = new int[sourcesNumber];
            alfaBandOffsets = new int[sourcesNumber][];
            aLineOffsets = new int[sourcesNumber];
            aPixelOffsets = new int[sourcesNumber];
            alfaDataFloat = new float[sourcesNumber][][];
            aBandDataFloat = new float[sourcesNumber][];
        } else {
            alfaLineStride = null;
            alfaPixelStride = null;
            alfaBandOffsets = null;
            aLineOffsets = null;
            aPixelOffsets = null;
            alfaDataFloat = null;
            aBandDataFloat = null;
        }
        WeightType[] weightTypesUsed = new WeightType[sourcesNumber];
        for (int i = 0; i < sourcesNumber; ++i) {
            weightTypesUsed[i] = WeightType.WEIGHT_TYPE_NODATA;
            RasterAccessor dataRA = srcBean[i].getDataRasterAccessor();
            if (dataRA == null) continue;
            srcLineStride[i] = dataRA.getScanlineStride();
            srcPixelStride[i] = dataRA.getPixelStride();
            srcBandOffsets[i] = dataRA.getBandOffsets();
            srcDataFloat[i] = dataRA.getFloatDataArrays();
            RasterAccessor alphaRA = srcBean[i].getAlphaRasterAccessor();
            if (alphaPresentinRaster & alphaRA != null) {
                alfaDataFloat[i] = alphaRA.getFloatDataArrays();
                alfaBandOffsets[i] = alphaRA.getBandOffsets();
                alfaPixelStride[i] = alphaRA.getPixelStride();
                alfaLineStride[i] = alphaRA.getScanlineStride();
            }
            if (alphaRA != null) {
                weightTypesUsed[i] = WeightType.WEIGHT_TYPE_ALPHA;
                continue;
            }
            if (!this.roiPresent || srcBean[i].getRoiRaster() == null) continue;
            weightTypesUsed[i] = WeightType.WEIGHT_TYPE_ROI;
        }
        int dstMinX = dst.getX();
        int dstMinY = dst.getY();
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstMaxX = dstMinX + dstWidth;
        int dstMaxY = dstMinY + dstHeight;
        int dstBands = dst.getNumBands();
        int dstLineStride = dst.getScanlineStride();
        int dstPixelStride = dst.getPixelStride();
        int[] dstBandOffsets = dst.getBandOffsets();
        for (int s = 0; s < sourcesNumber; ++s) {
            sLineOffsetsS[s] = new int[dstBands];
            sPixelOffsetsS[s] = new int[dstBands];
            sBandDataFloatS[s] = new float[dstBands][];
            if (srcBean[s].getDataRasterAccessor() != null) {
                for (int b = 0; b < dstBands; ++b) {
                    sBandDataFloatS[s][b] = srcDataFloat[s][b];
                    sLineOffsetsS[s][b] = srcBandOffsets[s][b];
                }
            }
            if (weightTypesUsed[s] != WeightType.WEIGHT_TYPE_ALPHA) continue;
            aBandDataFloat[s] = alfaDataFloat[s][0];
            aLineOffsets[s] = alfaBandOffsets[s][0];
        }
        float[][] dBandDataFloatS = dstDataFloat;
        int[] dLineOffsetS = new int[dstBands];
        int[] dPixelOffsetS = new int[dstBands];
        for (int b = 0; b < dstBands; ++b) {
            dLineOffsetS[b] = dstBandOffsets[b];
        }
        if (this.mosaicTypeSelected == MosaicDescriptor.MOSAIC_TYPE_OVERLAY) {
            for (dstY = dstMinY; dstY < dstMaxY; ++dstY) {
                for (int s = 0; s < sourcesNumber; ++s) {
                    if (srcBean[s].getDataRasterAccessor() != null) {
                        int b = 0;
                        while (b < dstBands) {
                            sPixelOffsetsS[s][b] = sLineOffsetsS[s][b];
                            int[] nArray = sLineOffsetsS[s];
                            int n = b++;
                            nArray[n] = nArray[n] + srcLineStride[s];
                        }
                    }
                    if (srcBean[s].getAlphaRasterAccessor() == null) continue;
                    aPixelOffsets[s] = aLineOffsets[s];
                    int n = s;
                    aLineOffsets[n] = aLineOffsets[n] + alfaLineStride[s];
                }
                int b = 0;
                while (b < dstBands) {
                    dPixelOffsetS[b] = dLineOffsetS[b];
                    int n = b++;
                    dLineOffsetS[n] = dLineOffsetS[n] + dstLineStride;
                }
                for (int dstX = dstMinX; dstX < dstMaxX; ++dstX) {
                    boolean setDestinationFlag = false;
                    float[] sourceValueFloatS = new float[dstBands];
                    for (int s = 0; s < sourcesNumber; ++s) {
                        RasterAccessor dataRA = srcBean[s].getDataRasterAccessor();
                        if (dataRA == null) continue;
                        int b2 = 0;
                        while (b2 < dstBands) {
                            sourceValueFloatS[b2] = sBandDataFloatS[s][b2][sPixelOffsetsS[s][b2]];
                            int[] nArray = sPixelOffsetsS[s];
                            int n = b2++;
                            nArray[n] = nArray[n] + srcPixelStride[s];
                        }
                        int dataCount = dstBands;
                        if (this.hasNoData[s]) {
                            Range noDataRangeFloat = srcBean[s].getSourceNoDataRangeRasterAccessor();
                            for (int b3 = 0; b3 < dstBands; ++b3) {
                                if (noDataRangeFloat == null || !noDataRangeFloat.contains(sourceValueFloatS[b3])) continue;
                                --dataCount;
                            }
                        }
                        if (dataCount == 0) {
                            setDestinationFlag = false;
                            if (weightTypesUsed[s] == WeightType.WEIGHT_TYPE_ALPHA) {
                                int n = s;
                                aPixelOffsets[n] = aPixelOffsets[n] + alfaPixelStride[s];
                            }
                        } else {
                            switch (weightTypesUsed[s]) {
                                case WEIGHT_TYPE_ALPHA: {
                                    setDestinationFlag = aBandDataFloat[s][aPixelOffsets[s]] != 0.0f;
                                    int n = s;
                                    aPixelOffsets[n] = aPixelOffsets[n] + alfaPixelStride[s];
                                    break;
                                }
                                case WEIGHT_TYPE_ROI: {
                                    setDestinationFlag = srcBean[s].getRoiRaster().getSample(dstX, dstY, 0) > 0;
                                    break;
                                }
                                default: {
                                    setDestinationFlag = true;
                                }
                            }
                        }
                        if (!setDestinationFlag) continue;
                        for (int b4 = 0; b4 < dstBands; ++b4) {
                            dBandDataFloatS[b4][dPixelOffsetS[b4]] = sourceValueFloatS[b4];
                            for (int k = s + 1; k < sourcesNumber; ++k) {
                                if (dataRA == null) continue;
                                int[] nArray = sPixelOffsetsS[k];
                                int n = b4;
                                nArray[n] = nArray[n] + srcPixelStride[k];
                            }
                        }
                        for (int k = s + 1; k < sourcesNumber; ++k) {
                            if (srcBean[k].getAlphaRasterAccessor() == null) continue;
                            int n = k;
                            aPixelOffsets[n] = aPixelOffsets[n] + alfaPixelStride[k];
                        }
                        break;
                    }
                    int b5 = 0;
                    while (b5 < dstBands) {
                        if (!setDestinationFlag) {
                            dBandDataFloatS[b5][dPixelOffsetS[b5]] = this.destinationNoDataFloat[b5];
                        }
                        int n = b5++;
                        dPixelOffsetS[n] = dPixelOffsetS[n] + dstPixelStride;
                    }
                }
            }
        } else {
            for (dstY = dstMinY; dstY < dstMaxY; ++dstY) {
                for (int s = 0; s < sourcesNumber; ++s) {
                    if (srcBean[s].getDataRasterAccessor() != null) {
                        int b = 0;
                        while (b < dstBands) {
                            sPixelOffsetsS[s][b] = sLineOffsetsS[s][b];
                            int[] nArray = sLineOffsetsS[s];
                            int n = b++;
                            nArray[n] = nArray[n] + srcLineStride[s];
                        }
                    }
                    if (weightTypesUsed[s] != WeightType.WEIGHT_TYPE_ALPHA) continue;
                    aPixelOffsets[s] = aLineOffsets[s];
                    int n = s;
                    aLineOffsets[n] = aLineOffsets[n] + alfaLineStride[s];
                }
                int b = 0;
                while (b < dstBands) {
                    dPixelOffsetS[b] = dLineOffsetS[b];
                    int n = b++;
                    dLineOffsetS[n] = dLineOffsetS[n] + dstLineStride;
                }
                for (int dstX = dstMinX; dstX < dstMaxX; ++dstX) {
                    int b6;
                    double[] numerator = new double[dstBands];
                    double[] denominator = new double[dstBands];
                    float[] sourceValueFloatS = new float[dstBands];
                    for (int s = 0; s < sourcesNumber; ++s) {
                        int b7;
                        if (srcBean[s].getDataRasterAccessor() == null) continue;
                        int b8 = 0;
                        while (b8 < dstBands) {
                            sourceValueFloatS[b8] = sBandDataFloatS[s][b8][sPixelOffsetsS[s][b8]];
                            int[] nArray = sPixelOffsetsS[s];
                            int n = b8++;
                            nArray[n] = nArray[n] + srcPixelStride[s];
                        }
                        double weight = 0.0;
                        int dataCount = dstBands;
                        if (this.hasNoData[s]) {
                            for (b7 = 0; b7 < dstBands; ++b7) {
                                Range noDataRangeFloat = srcBean[s].getSourceNoDataRangeRasterAccessor();
                                if (noDataRangeFloat == null || !noDataRangeFloat.contains(sourceValueFloatS[b7])) continue;
                                --dataCount;
                            }
                        }
                        if (dataCount == 0) {
                            weight = 0.0;
                            if (weightTypesUsed[s] == WeightType.WEIGHT_TYPE_ALPHA) {
                                int n = s;
                                aPixelOffsets[n] = aPixelOffsets[n] + alfaPixelStride[s];
                            }
                        } else {
                            switch (weightTypesUsed[s]) {
                                case WEIGHT_TYPE_ALPHA: {
                                    weight = aBandDataFloat[s][aPixelOffsets[s]];
                                    weight = weight > 0.0 && this.isAlphaBitmaskUsed ? 1.0 : (weight /= 255.0);
                                    int n = s;
                                    aPixelOffsets[n] = aPixelOffsets[n] + alfaPixelStride[s];
                                    break;
                                }
                                case WEIGHT_TYPE_ROI: {
                                    weight = srcBean[s].getRoiRaster().getSample(dstX, dstY, 0) > 0 ? 1.0 : 0.0;
                                    break;
                                }
                                default: {
                                    weight = 1.0;
                                }
                            }
                        }
                        b7 = 0;
                        while (b7 < dstBands) {
                            int n = b7;
                            numerator[n] = numerator[n] + (weight > 0.0 ? weight * (double)sourceValueFloatS[b7] : 0.0);
                            int n2 = b7++;
                            denominator[n2] = denominator[n2] + weight;
                        }
                    }
                    double denominatorSum = 0.0;
                    for (b6 = 0; b6 < dstBands; ++b6) {
                        denominatorSum += denominator[b6];
                    }
                    for (b6 = 0; b6 < dstBands; ++b6) {
                        if (denominatorSum == 0.0) {
                            dBandDataFloatS[b6][dPixelOffsetS[b6]] = this.destinationNoDataFloat[b6];
                            continue;
                        }
                        dBandDataFloatS[b6][dPixelOffsetS[b6]] = ImageUtil.clampFloat((double)(numerator[b6] / denominator[b6]));
                        int n = b6;
                        dPixelOffsetS[n] = dPixelOffsetS[n] + dstPixelStride;
                    }
                }
            }
        }
    }

    private void doubleLoop(RasterBeanAccessor[] srcBean, RasterAccessor dst) {
        int dstY;
        Object aBandDataDouble;
        Object alfaDataDouble;
        int[] aPixelOffsets;
        int[] aLineOffsets;
        Object alfaBandOffsets;
        int[] alfaPixelStride;
        int[] alfaLineStride;
        int sourcesNumber = srcBean.length;
        int[] srcLineStride = new int[sourcesNumber];
        int[] srcPixelStride = new int[sourcesNumber];
        int[][] srcBandOffsets = new int[sourcesNumber][];
        int[][] sLineOffsetsS = new int[sourcesNumber][];
        int[][] sPixelOffsetsS = new int[sourcesNumber][];
        double[][][] srcDataDouble = new double[sourcesNumber][][];
        double[][] dstDataDouble = dst.getDoubleDataArrays();
        double[][][] sBandDataDoubleS = new double[sourcesNumber][][];
        boolean alphaPresentinRaster = false;
        for (int i = 0; i < sourcesNumber; ++i) {
            if (srcBean[i].getAlphaRasterAccessor() == null) continue;
            alphaPresentinRaster = true;
            break;
        }
        if (alphaPresentinRaster) {
            alfaLineStride = new int[sourcesNumber];
            alfaPixelStride = new int[sourcesNumber];
            alfaBandOffsets = new int[sourcesNumber][];
            aLineOffsets = new int[sourcesNumber];
            aPixelOffsets = new int[sourcesNumber];
            alfaDataDouble = new double[sourcesNumber][][];
            aBandDataDouble = new double[sourcesNumber][];
        } else {
            alfaLineStride = null;
            alfaPixelStride = null;
            alfaBandOffsets = null;
            aLineOffsets = null;
            aPixelOffsets = null;
            alfaDataDouble = null;
            aBandDataDouble = null;
        }
        WeightType[] weightTypesUsed = new WeightType[sourcesNumber];
        for (int i = 0; i < sourcesNumber; ++i) {
            weightTypesUsed[i] = WeightType.WEIGHT_TYPE_NODATA;
            RasterAccessor dataRA = srcBean[i].getDataRasterAccessor();
            if (dataRA == null) continue;
            srcLineStride[i] = dataRA.getScanlineStride();
            srcPixelStride[i] = dataRA.getPixelStride();
            srcBandOffsets[i] = dataRA.getBandOffsets();
            srcDataDouble[i] = dataRA.getDoubleDataArrays();
            RasterAccessor alphaRA = srcBean[i].getAlphaRasterAccessor();
            if (alphaPresentinRaster & alphaRA != null) {
                alfaDataDouble[i] = alphaRA.getDoubleDataArrays();
                alfaBandOffsets[i] = alphaRA.getBandOffsets();
                alfaPixelStride[i] = alphaRA.getPixelStride();
                alfaLineStride[i] = alphaRA.getScanlineStride();
            }
            if (alphaRA != null) {
                weightTypesUsed[i] = WeightType.WEIGHT_TYPE_ALPHA;
                continue;
            }
            if (!this.roiPresent || srcBean[i].getRoiRaster() == null) continue;
            weightTypesUsed[i] = WeightType.WEIGHT_TYPE_ROI;
        }
        int dstMinX = dst.getX();
        int dstMinY = dst.getY();
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstMaxX = dstMinX + dstWidth;
        int dstMaxY = dstMinY + dstHeight;
        int dstBands = dst.getNumBands();
        int dstLineStride = dst.getScanlineStride();
        int dstPixelStride = dst.getPixelStride();
        int[] dstBandOffsets = dst.getBandOffsets();
        for (int s = 0; s < sourcesNumber; ++s) {
            sLineOffsetsS[s] = new int[dstBands];
            sPixelOffsetsS[s] = new int[dstBands];
            sBandDataDoubleS[s] = new double[dstBands][];
            if (srcBean[s].getDataRasterAccessor() != null) {
                for (int b = 0; b < dstBands; ++b) {
                    sBandDataDoubleS[s][b] = srcDataDouble[s][b];
                    sLineOffsetsS[s][b] = srcBandOffsets[s][b];
                }
            }
            if (weightTypesUsed[s] != WeightType.WEIGHT_TYPE_ALPHA) continue;
            aBandDataDouble[s] = alfaDataDouble[s][0];
            aLineOffsets[s] = alfaBandOffsets[s][0];
        }
        double[][] dBandDataDoubleS = dstDataDouble;
        int[] dLineOffsetS = new int[dstBands];
        int[] dPixelOffsetS = new int[dstBands];
        for (int b = 0; b < dstBands; ++b) {
            dLineOffsetS[b] = dstBandOffsets[b];
        }
        if (this.mosaicTypeSelected == MosaicDescriptor.MOSAIC_TYPE_OVERLAY) {
            for (dstY = dstMinY; dstY < dstMaxY; ++dstY) {
                for (int s = 0; s < sourcesNumber; ++s) {
                    if (srcBean[s].getDataRasterAccessor() != null) {
                        int b = 0;
                        while (b < dstBands) {
                            sPixelOffsetsS[s][b] = sLineOffsetsS[s][b];
                            int[] nArray = sLineOffsetsS[s];
                            int n = b++;
                            nArray[n] = nArray[n] + srcLineStride[s];
                        }
                    }
                    if (srcBean[s].getAlphaRasterAccessor() == null) continue;
                    aPixelOffsets[s] = aLineOffsets[s];
                    int n = s;
                    aLineOffsets[n] = aLineOffsets[n] + alfaLineStride[s];
                }
                int b = 0;
                while (b < dstBands) {
                    dPixelOffsetS[b] = dLineOffsetS[b];
                    int n = b++;
                    dLineOffsetS[n] = dLineOffsetS[n] + dstLineStride;
                }
                for (int dstX = dstMinX; dstX < dstMaxX; ++dstX) {
                    boolean setDestinationFlag = false;
                    double[] sourceValueDoubleS = new double[dstBands];
                    for (int s = 0; s < sourcesNumber; ++s) {
                        RasterAccessor dataRA = srcBean[s].getDataRasterAccessor();
                        if (dataRA == null) continue;
                        int b2 = 0;
                        while (b2 < dstBands) {
                            sourceValueDoubleS[b2] = sBandDataDoubleS[s][b2][sPixelOffsetsS[s][b2]];
                            int[] nArray = sPixelOffsetsS[s];
                            int n = b2++;
                            nArray[n] = nArray[n] + srcPixelStride[s];
                        }
                        int dataCount = dstBands;
                        if (this.hasNoData[s]) {
                            Range noDataRangeDouble = srcBean[s].getSourceNoDataRangeRasterAccessor();
                            for (int b3 = 0; b3 < dstBands; ++b3) {
                                if (noDataRangeDouble == null || !noDataRangeDouble.contains(sourceValueDoubleS[b3])) continue;
                                --dataCount;
                            }
                        }
                        if (dataCount == 0) {
                            setDestinationFlag = false;
                            if (weightTypesUsed[s] == WeightType.WEIGHT_TYPE_ALPHA) {
                                int n = s;
                                aPixelOffsets[n] = aPixelOffsets[n] + alfaPixelStride[s];
                            }
                        } else {
                            switch (weightTypesUsed[s]) {
                                case WEIGHT_TYPE_ALPHA: {
                                    setDestinationFlag = aBandDataDouble[s][aPixelOffsets[s]] != 0.0;
                                    int n = s;
                                    aPixelOffsets[n] = aPixelOffsets[n] + alfaPixelStride[s];
                                    break;
                                }
                                case WEIGHT_TYPE_ROI: {
                                    setDestinationFlag = srcBean[s].getRoiRaster().getSample(dstX, dstY, 0) > 0;
                                    break;
                                }
                                default: {
                                    setDestinationFlag = true;
                                }
                            }
                        }
                        if (!setDestinationFlag) continue;
                        for (int b4 = 0; b4 < dstBands; ++b4) {
                            dBandDataDoubleS[b4][dPixelOffsetS[b4]] = sourceValueDoubleS[b4];
                            for (int k = s + 1; k < sourcesNumber; ++k) {
                                if (dataRA == null) continue;
                                int[] nArray = sPixelOffsetsS[k];
                                int n = b4;
                                nArray[n] = nArray[n] + srcPixelStride[k];
                            }
                        }
                        for (int k = s + 1; k < sourcesNumber; ++k) {
                            if (srcBean[k].getAlphaRasterAccessor() == null) continue;
                            int n = k;
                            aPixelOffsets[n] = aPixelOffsets[n] + alfaPixelStride[k];
                        }
                        break;
                    }
                    int b5 = 0;
                    while (b5 < dstBands) {
                        if (!setDestinationFlag) {
                            dBandDataDoubleS[b5][dPixelOffsetS[b5]] = this.destinationNoDataDouble[b5];
                        }
                        int n = b5++;
                        dPixelOffsetS[n] = dPixelOffsetS[n] + dstPixelStride;
                    }
                }
            }
        } else {
            for (dstY = dstMinY; dstY < dstMaxY; ++dstY) {
                for (int s = 0; s < sourcesNumber; ++s) {
                    if (srcBean[s].getDataRasterAccessor() != null) {
                        int b = 0;
                        while (b < dstBands) {
                            sPixelOffsetsS[s][b] = sLineOffsetsS[s][b];
                            int[] nArray = sLineOffsetsS[s];
                            int n = b++;
                            nArray[n] = nArray[n] + srcLineStride[s];
                        }
                    }
                    if (weightTypesUsed[s] != WeightType.WEIGHT_TYPE_ALPHA) continue;
                    aPixelOffsets[s] = aLineOffsets[s];
                    int n = s;
                    aLineOffsets[n] = aLineOffsets[n] + alfaLineStride[s];
                }
                int b = 0;
                while (b < dstBands) {
                    dPixelOffsetS[b] = dLineOffsetS[b];
                    int n = b++;
                    dLineOffsetS[n] = dLineOffsetS[n] + dstLineStride;
                }
                for (int dstX = dstMinX; dstX < dstMaxX; ++dstX) {
                    int b6;
                    double[] numerator = new double[dstBands];
                    double[] denominator = new double[dstBands];
                    double[] sourceValueDoubleS = new double[dstBands];
                    for (int s = 0; s < sourcesNumber; ++s) {
                        int b7;
                        if (srcBean[s].getDataRasterAccessor() == null) continue;
                        int b8 = 0;
                        while (b8 < dstBands) {
                            sourceValueDoubleS[b8] = sBandDataDoubleS[s][b8][sPixelOffsetsS[s][b8]];
                            int[] nArray = sPixelOffsetsS[s];
                            int n = b8++;
                            nArray[n] = nArray[n] + srcPixelStride[s];
                        }
                        double weight = 0.0;
                        int dataCount = dstBands;
                        if (this.hasNoData[s]) {
                            for (b7 = 0; b7 < dstBands; ++b7) {
                                Range noDataRangeDouble = srcBean[s].getSourceNoDataRangeRasterAccessor();
                                if (noDataRangeDouble == null || !noDataRangeDouble.contains(sourceValueDoubleS[b7])) continue;
                                --dataCount;
                            }
                        }
                        if (dataCount == 0) {
                            weight = 0.0;
                            if (weightTypesUsed[s] == WeightType.WEIGHT_TYPE_ALPHA) {
                                int n = s;
                                aPixelOffsets[n] = aPixelOffsets[n] + alfaPixelStride[s];
                            }
                        } else {
                            switch (weightTypesUsed[s]) {
                                case WEIGHT_TYPE_ALPHA: {
                                    weight = aBandDataDouble[s][aPixelOffsets[s]];
                                    weight = weight > 0.0 && this.isAlphaBitmaskUsed ? 1.0 : (weight /= 255.0);
                                    int n = s;
                                    aPixelOffsets[n] = aPixelOffsets[n] + alfaPixelStride[s];
                                    break;
                                }
                                case WEIGHT_TYPE_ROI: {
                                    weight = srcBean[s].getRoiRaster().getSample(dstX, dstY, 0) > 0 ? 1.0 : 0.0;
                                    break;
                                }
                                default: {
                                    weight = 1.0;
                                }
                            }
                        }
                        b7 = 0;
                        while (b7 < dstBands) {
                            int n = b7;
                            numerator[n] = numerator[n] + (weight > 0.0 ? weight * sourceValueDoubleS[b7] : 0.0);
                            int n2 = b7++;
                            denominator[n2] = denominator[n2] + weight;
                        }
                    }
                    double denominatorSum = 0.0;
                    for (b6 = 0; b6 < dstBands; ++b6) {
                        denominatorSum += denominator[b6];
                    }
                    for (b6 = 0; b6 < dstBands; ++b6) {
                        if (denominatorSum == 0.0) {
                            dBandDataDoubleS[b6][dPixelOffsetS[b6]] = this.destinationNoDataDouble[b6];
                            continue;
                        }
                        dBandDataDoubleS[b6][dPixelOffsetS[b6]] = numerator[b6] / denominator[b6];
                        int n = b6;
                        dPixelOffsetS[n] = dPixelOffsetS[n] + dstPixelStride;
                    }
                }
            }
        }
    }

    public Rectangle mapDestRect(Rectangle destRectangle, int sourceRasterIndex) {
        if (destRectangle == null) {
            throw new IllegalArgumentException("Destination rectangle is not defined");
        }
        if (sourceRasterIndex < 0 || sourceRasterIndex >= this.getNumSources()) {
            throw new IllegalArgumentException("Source index must be between 0 and source dimension-1");
        }
        return destRectangle.intersection(this.getSourceImage(sourceRasterIndex).getBounds());
    }

    public Rectangle mapSourceRect(Rectangle sourceRectangle, int sourceRasterIndex) {
        if (sourceRectangle == null) {
            throw new IllegalArgumentException("Destination rectangle is not defined");
        }
        if (sourceRasterIndex < 0 || sourceRasterIndex >= this.getNumSources()) {
            throw new IllegalArgumentException("Source index must be between 0 and source dimension-1");
        }
        return sourceRectangle.intersection(this.getBounds());
    }

    public synchronized void dispose() {
        if (this.imageBeans != null) {
            for (ImageMosaicBean bean : this.imageBeans) {
                this.dispose(bean.getImage());
                this.dispose(bean.getRoiImage());
                this.dispose((RenderedImage)bean.getAlphaChannel());
            }
        }
        super.dispose();
    }

    private void dispose(RenderedImage image) {
        if (image instanceof RenderedOp) {
            ((RenderedOp)image).dispose();
        }
    }

    private static class RasterBeanAccessor {
        private RasterAccessor dataRasterAccessor;
        private RasterAccessor alphaRasterAccessor;
        private Raster roiRaster;
        private Range sourceNoDataRangeRasterAccessor;

        RasterBeanAccessor() {
        }

        public RasterAccessor getDataRasterAccessor() {
            return this.dataRasterAccessor;
        }

        public void setDataRasterAccessor(RasterAccessor dataRasterAccessor) {
            this.dataRasterAccessor = dataRasterAccessor;
        }

        public RasterAccessor getAlphaRasterAccessor() {
            return this.alphaRasterAccessor;
        }

        public void setAlphaRasterAccessor(RasterAccessor alphaRasterAccessor) {
            this.alphaRasterAccessor = alphaRasterAccessor;
        }

        public Raster getRoiRaster() {
            return this.roiRaster;
        }

        public void setRoiRaster(Raster roiRaster) {
            this.roiRaster = roiRaster;
        }

        public Range getSourceNoDataRangeRasterAccessor() {
            return this.sourceNoDataRangeRasterAccessor;
        }

        public void setSourceNoDataRangeRasterAccessor(Range sourceNoDataRangeRasterAccessor) {
            this.sourceNoDataRangeRasterAccessor = sourceNoDataRangeRasterAccessor;
        }
    }

    public static enum WeightType {
        WEIGHT_TYPE_ALPHA,
        WEIGHT_TYPE_ROI,
        WEIGHT_TYPE_NODATA;

    }
}

