/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.cassandra.tools.export;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.geotools.data.DataStore;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.locationtech.geomesa.cassandra.data.CassandraDataStore;
import org.locationtech.geomesa.cassandra.tools.CassandraConnectionParams;
import org.locationtech.geomesa.cassandra.tools.CassandraConnectionParams$class;
import org.locationtech.geomesa.cassandra.tools.CassandraDataStoreCommand;
import org.locationtech.geomesa.cassandra.tools.CassandraDataStoreCommand$class;
import org.locationtech.geomesa.tools.CatalogParam;
import org.locationtech.geomesa.tools.DataStoreCommand;
import org.locationtech.geomesa.tools.OptionalCqlFilterParam;
import org.locationtech.geomesa.tools.OptionalCredentialsParams;
import org.locationtech.geomesa.tools.PasswordParams;
import org.locationtech.geomesa.tools.QueryHintsParams;
import org.locationtech.geomesa.tools.RequiredTypeNameParam;
import org.locationtech.geomesa.tools.export.ExportCommand;
import org.locationtech.geomesa.tools.export.PlaybackCommand;
import org.locationtech.geomesa.tools.export.formats.FeatureExporter;
import org.locationtech.geomesa.tools.utils.ParameterConverters;
import org.locationtech.geomesa.utils.stats.MethodProfiling;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Tuple2;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001=4A!\u0001\u0002\u0001\u001f\tA2)Y:tC:$'/\u0019)mCf\u0014\u0017mY6D_6l\u0017M\u001c3\u000b\u0005\r!\u0011AB3ya>\u0014HO\u0003\u0002\u0006\r\u0005)Ao\\8mg*\u0011q\u0001C\u0001\nG\u0006\u001c8/\u00198ee\u0006T!!\u0003\u0006\u0002\u000f\u001d,w.\\3tC*\u00111\u0002D\u0001\rY>\u001c\u0017\r^5p]R,7\r\u001b\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M!\u0001\u0001\u0005\f#!\t\tB#D\u0001\u0013\u0015\u0005\u0019\u0012!B:dC2\f\u0017BA\u000b\u0013\u0005\u0019\te.\u001f*fMB\u0019qC\u0007\u000f\u000e\u0003aQ!aA\r\u000b\u0005\u0015A\u0011BA\u000e\u0019\u0005=\u0001F.Y=cC\u000e\\7i\\7nC:$\u0007CA\u000f!\u001b\u0005q\"BA\u0010\u0007\u0003\u0011!\u0017\r^1\n\u0005\u0005r\"AE\"bgN\fg\u000e\u001a:b\t\u0006$\u0018m\u0015;pe\u0016\u0004\"a\t\u0013\u000e\u0003\u0011I!!\n\u0003\u00033\r\u000b7o]1oIJ\fG)\u0019;b'R|'/Z\"p[6\fg\u000e\u001a\u0005\u0006O\u0001!\t\u0001K\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003%\u0002\"A\u000b\u0001\u000e\u0003\tAq\u0001\f\u0001C\u0002\u0013\u0005S&\u0001\u0004qCJ\fWn]\u000b\u0002]A\u0011qF\u0012\b\u0003a}r!!\r \u000f\u0005IjdBA\u001a=\u001d\t!4H\u0004\u00026u9\u0011a'O\u0007\u0002o)\u0011\u0001HD\u0001\u0007yI|w\u000e\u001e \n\u00035I!a\u0003\u0007\n\u0005%Q\u0011BA\u0004\t\u0013\t)a!\u0003\u0002\u0004\t\u001d)\u0001I\u0001E\u0001\u0003\u0006A2)Y:tC:$'/\u0019)mCf\u0014\u0017mY6D_6l\u0017M\u001c3\u0011\u0005)\u0012e!B\u0001\u0003\u0011\u0003\u00195C\u0001\"\u0011\u0011\u00159#\t\"\u0001F)\u0005\te\u0001B$C\u0001!\u0013qcQ1tg\u0006tGM]1QY\u0006L(-Y2l!\u0006\u0014\u0018-\\:\u0014\u000b\u0019\u0003\u0012\nV,\u0011\u0005)\u000bfBA&P\u001d\taeJ\u0004\u00024\u001b&\u0011Q\u0001C\u0005\u0003\u0007eI!\u0001\u0015\r\u0002\u001fAc\u0017-\u001f2bG.\u001cu.\\7b]\u0012L!AU*\u0003\u001dAc\u0017-\u001f2bG.\u0004\u0016M]1ng*\u0011\u0001\u000b\u0007\t\u0003GUK!A\u0016\u0003\u00033\r\u000b7o]1oIJ\f7i\u001c8oK\u000e$\u0018n\u001c8QCJ\fWn\u001d\t\u00031fk\u0011!G\u0005\u00035f\u0011AbQ1uC2|w\rU1sC6DQa\n$\u0005\u0002q#\u0012!\u0018\t\u0003=\u001ak\u0011A\u0011\u0015\u0005\r\u0002T7\u000e\u0005\u0002bQ6\t!M\u0003\u0002dI\u0006Q!nY8n[\u0006tG-\u001a:\u000b\u0005\u00154\u0017!\u00022fkN$(\"A4\u0002\u0007\r|W.\u0003\u0002jE\nQ\u0001+\u0019:b[\u0016$XM]:\u0002%\r|W.\\1oI\u0012+7o\u0019:jaRLwN\\\u0011\u0002Y\u00061\u0005\u000b\\1zE\u0006\u001c7\u000e\t4fCR,(/Z:!MJ|W\u000eI1!\u000f\u0016|W*Z:bA\u0011\fG/\u0019\u0011ti>\u0014X\r\f\u0011cCN,G\rI8oAQDW\r\t4fCR,(/\u001a\u0011eCR,\u0007B\u00028\u0001A\u0003%a&A\u0004qCJ\fWn\u001d\u0011")
public class CassandraPlaybackCommand
implements PlaybackCommand<CassandraDataStore>,
CassandraDataStoreCommand {
    private final CassandraPlaybackParams params;
    private final String name;
    private final Logger logger;
    private volatile boolean bitmap$0;

    @Override
    public scala.collection.immutable.Map<String, String> connection() {
        return CassandraDataStoreCommand$class.connection(this);
    }

    public String name() {
        return this.name;
    }

    public void org$locationtech$geomesa$tools$export$PlaybackCommand$_setter_$name_$eq(String x$1) {
        this.name = x$1;
    }

    public SimpleFeatureCollection getFeatures(DataStore ds, Query query) {
        return PlaybackCommand.class.getFeatures((PlaybackCommand)this, (DataStore)ds, (Query)query);
    }

    public void org$locationtech$geomesa$tools$export$ExportCommand$_setter_$name_$eq(String x$1) {
    }

    public void execute() {
        ExportCommand.class.execute((ExportCommand)this);
    }

    public Option export(DataStore ds) {
        return ExportCommand.class.export((ExportCommand)this, (DataStore)ds);
    }

    public Option<Object> export(FeatureExporter exporter, SimpleFeatureCollection collection) {
        return ExportCommand.class.export((ExportCommand)this, (FeatureExporter)exporter, (SimpleFeatureCollection)collection);
    }

    public SimpleFeatureType getSchema(DataStore ds) {
        return ExportCommand.class.getSchema((ExportCommand)this, (DataStore)ds);
    }

    public <R> R profile(Function1<Object, BoxedUnit> onComplete, Function0<R> code) {
        return (R)MethodProfiling.class.profile((MethodProfiling)this, onComplete, code);
    }

    public <R> R profile(Function2<R, Object, BoxedUnit> onComplete, Function0<R> code) {
        return (R)MethodProfiling.class.profile((MethodProfiling)this, onComplete, code);
    }

    public <R> R profile(String message, Function0<R> code) {
        return (R)MethodProfiling.class.profile((MethodProfiling)this, (String)message, code);
    }

    private Logger logger$lzycompute() {
        CassandraPlaybackCommand cassandraPlaybackCommand = this;
        synchronized (cassandraPlaybackCommand) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public <T> T withDataStore(Function1<CassandraDataStore, T> method) throws ParameterException {
        return (T)DataStoreCommand.class.withDataStore((DataStoreCommand)this, method);
    }

    public DataStore loadDataStore() throws ParameterException {
        return DataStoreCommand.class.loadDataStore((DataStoreCommand)this);
    }

    @Override
    public CassandraPlaybackParams params() {
        return this.params;
    }

    public CassandraPlaybackCommand() {
        DataStoreCommand.class.$init$((DataStoreCommand)this);
        LazyLogging.class.$init$((LazyLogging)this);
        MethodProfiling.class.$init$((MethodProfiling)this);
        ExportCommand.class.$init$((ExportCommand)this);
        PlaybackCommand.class.$init$((PlaybackCommand)this);
        CassandraDataStoreCommand$class.$init$(this);
        this.params = new CassandraPlaybackParams();
    }

    @Parameters(commandDescription="Playback features from a GeoMesa data store, based on the feature date")
    public static class CassandraPlaybackParams
    implements PlaybackCommand.PlaybackParams,
    CassandraConnectionParams,
    CatalogParam {
        @Parameter(names={"-c", "--catalog"}, description="Catalog table for GeoMesa datastore", required=true)
        private String catalog;
        @Parameter(names={"-P", "--contact-point"}, description="Cassandra contact point (address of a Cassandra node)", required=true)
        private String contactPoint;
        @Parameter(names={"-k", "--key-space"}, description="Cassandra key space (must already exist)", required=true)
        private String keySpace;
        @Parameter(names={"-u", "--user"}, description="Connection user name")
        private String user;
        @Parameter(names={"-p", "--password"}, description="Connection password")
        private String password;
        @Parameter(names={"--interval"}, description="Date interval to query, in the format yyyy-MM-dd'T'HH:mm:ss.SSSZ/yyyy-MM-dd'T'HH:mm:ss.SSSZ", required=true, converter=ParameterConverters.IntervalConverter.class)
        private Tuple2<Date, Date> interval;
        @Parameter(names={"--dtg"}, description="Date attribute to base playback on")
        private String dtg;
        @Parameter(names={"--step-window"}, description="Query the interval in discrete chunks instead of all at once ('10 minutes', '30 seconds', etc)", converter=ParameterConverters.DurationConverter.class)
        private Duration window;
        @Parameter(names={"--rate"}, description="Rate multiplier to speed-up (or slow down) features being returned")
        private Float rate;
        @Parameter(names={"-f", "--feature-name"}, description="Simple Feature Type name on which to operate", required=true)
        private String featureName;
        @Parameter(names={"-o", "--output"}, description="Output to a file instead of std out")
        private String file;
        @Parameter(names={"--gzip"}, description="Level of gzip compression to apply to output, from 1-9")
        private Integer gzip;
        @Parameter(names={"-F", "--output-format"}, description="File format of output files (csv|tsv|gml|json|shp|avro|leaflet|orc|parquet|arrow)", required=false, converter=ParameterConverters.ExportFormatConverter.class)
        private Enumeration.Value outputFormat;
        @Parameter(names={"--no-header"}, description="Export as a delimited text format (csv|tsv) without a type header", required=false)
        private boolean noHeader;
        @Parameter(names={"-m", "--max-features"}, description="Maximum number of features to return. default: Unlimited")
        private Integer maxFeatures;
        @Parameter(names={"-a", "--attributes"}, description="Attributes from feature to export (comma-separated)...Comma-separated expressions with each in the format attribute[=filter_function_expression]|derived-attribute=filter_function_expression|'id'. 'id' will export the feature ID, filter_function_expression is an expression of filter function applied to attributes, literals and filter functions, i.e. can be nested")
        private List<String> attributes;
        @Parameter(names={"--hints"}, description="Query hints to set, in the form key1=value1;key2=value2", required=false, converter=ParameterConverters.HintConverter.class)
        private Map<String, String> hints;
        @Parameter(names={"-q", "--cql"}, description="CQL predicate", converter=ParameterConverters.FilterConverter.class)
        private Filter cqlFilter;

        public String catalog() {
            return this.catalog;
        }

        public void catalog_$eq(String x$1) {
            this.catalog = x$1;
        }

        @Override
        public String contactPoint() {
            return this.contactPoint;
        }

        @Override
        @TraitSetter
        public void contactPoint_$eq(String x$1) {
            this.contactPoint = x$1;
        }

        @Override
        public String keySpace() {
            return this.keySpace;
        }

        @Override
        @TraitSetter
        public void keySpace_$eq(String x$1) {
            this.keySpace = x$1;
        }

        public String user() {
            return this.user;
        }

        public void user_$eq(String x$1) {
            this.user = x$1;
        }

        public String password() {
            return this.password;
        }

        public void password_$eq(String x$1) {
            this.password = x$1;
        }

        public Tuple2<Date, Date> interval() {
            return this.interval;
        }

        public void interval_$eq(Tuple2<Date, Date> x$1) {
            this.interval = x$1;
        }

        public String dtg() {
            return this.dtg;
        }

        public void dtg_$eq(String x$1) {
            this.dtg = x$1;
        }

        public Duration window() {
            return this.window;
        }

        public void window_$eq(Duration x$1) {
            this.window = x$1;
        }

        public Float rate() {
            return this.rate;
        }

        public void rate_$eq(Float x$1) {
            this.rate = x$1;
        }

        public String featureName() {
            return this.featureName;
        }

        public void featureName_$eq(String x$1) {
            this.featureName = x$1;
        }

        public String file() {
            return this.file;
        }

        public void file_$eq(String x$1) {
            this.file = x$1;
        }

        public Integer gzip() {
            return this.gzip;
        }

        public void gzip_$eq(Integer x$1) {
            this.gzip = x$1;
        }

        public Enumeration.Value outputFormat() {
            return this.outputFormat;
        }

        public void outputFormat_$eq(Enumeration.Value x$1) {
            this.outputFormat = x$1;
        }

        public boolean noHeader() {
            return this.noHeader;
        }

        public void noHeader_$eq(boolean x$1) {
            this.noHeader = x$1;
        }

        public Integer maxFeatures() {
            return this.maxFeatures;
        }

        public void maxFeatures_$eq(Integer x$1) {
            this.maxFeatures = x$1;
        }

        public List<String> attributes() {
            return this.attributes;
        }

        public void attributes_$eq(List<String> x$1) {
            this.attributes = x$1;
        }

        public Map<String, String> hints() {
            return this.hints;
        }

        public void hints_$eq(Map<String, String> x$1) {
            this.hints = x$1;
        }

        public Filter cqlFilter() {
            return this.cqlFilter;
        }

        public void cqlFilter_$eq(Filter x$1) {
            this.cqlFilter = x$1;
        }

        public CassandraPlaybackParams() {
            OptionalCqlFilterParam.class.$init$((OptionalCqlFilterParam)this);
            QueryHintsParams.class.$init$((QueryHintsParams)this);
            ExportCommand.ExportParams.class.$init$((ExportCommand.ExportParams)this);
            RequiredTypeNameParam.class.$init$((RequiredTypeNameParam)this);
            PlaybackCommand.PlaybackParams.class.$init$((PlaybackCommand.PlaybackParams)this);
            PasswordParams.class.$init$((PasswordParams)this);
            OptionalCredentialsParams.class.$init$((OptionalCredentialsParams)this);
            CassandraConnectionParams$class.$init$(this);
            CatalogParam.class.$init$((CatalogParam)this);
        }
    }
}

