/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.process.knn;

import org.locationtech.geomesa.process.knn.GeoHashAutoSize;
import org.locationtech.geomesa.process.knn.GeoHashAutoSize$class;
import org.locationtech.geomesa.process.knn.GeoHashSpiral;
import org.locationtech.geomesa.process.knn.GeoHashWithDistance;
import org.locationtech.geomesa.utils.geohash.GeoHash;
import org.locationtech.geomesa.utils.geohash.GeohashUtils$;
import org.locationtech.geomesa.utils.geohash.GeomDistance;
import org.locationtech.geomesa.utils.geohash.VincentyModel$;
import org.locationtech.geomesa.utils.geotools.Conversions;
import org.locationtech.geomesa.utils.geotools.Conversions$;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeature;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.mutable.PriorityQueue;
import scala.math.Ordering;
import scala.package$;

public final class GeoHashSpiral$
implements GeoHashAutoSize {
    public static final GeoHashSpiral$ MODULE$;

    static {
        new GeoHashSpiral$();
    }

    @Override
    public GeoHash geoHashToSize(Point pointInside, double desiredSizeInMeters) {
        return GeoHashAutoSize$class.geoHashToSize(this, pointInside, desiredSizeInMeters);
    }

    public GeoHashSpiral apply(SimpleFeature centerFeature, double distanceGuess, double maxDistance2) {
        Point point = Conversions.RichSimpleFeature$.MODULE$.point$extension(Conversions$.MODULE$.RichSimpleFeature(centerFeature));
        if (point != null) {
            Point point2 = point;
            GeoHashSpiral geoHashSpiral = this.apply(point2, distanceGuess, maxDistance2);
            return geoHashSpiral;
        }
        throw new RuntimeException("GeoHashSpiral not implemented for non-point geometries");
    }

    public GeoHashSpiral apply(Point centerPoint, double distanceGuess, double maxDistance2) {
        GeoHash seedGH = this.geoHashToSize(centerPoint, distanceGuess);
        GeoHashWithDistance seedWithDistance = new GeoHashWithDistance(seedGH, 0.0);
        Ordering orderedGH = package$.MODULE$.Ordering().by((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(GeoHashWithDistance x$1) {
                return x$1.dist();
            }
        }, (Ordering)Ordering.Double$.MODULE$);
        PriorityQueue<GeoHashWithDistance> ghPQ = new PriorityQueue<GeoHashWithDistance>(seedWithDistance, orderedGH){
            {
                this.enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GeoHashWithDistance[]{seedWithDistance$1}));
            }
        };
        return new GeoHashSpiral(ghPQ, (Function1<GeoHash, Object>)new Serializable(centerPoint){
            public static final long serialVersionUID = 0L;
            private final Point centerPoint$1;

            public final double apply(GeoHash gh) {
                return VincentyModel$.MODULE$.Distance().distance2double(GeoHashSpiral$.MODULE$.org$locationtech$geomesa$process$knn$GeoHashSpiral$$distanceCalc$1(gh, this.centerPoint$1));
            }
            {
                this.centerPoint$1 = centerPoint$1;
            }
        }, maxDistance2);
    }

    public final GeomDistance.Distance org$locationtech$geomesa$process$knn$GeoHashSpiral$$distanceCalc$1(GeoHash gh, Point centerPoint$1) {
        return GeohashUtils$.MODULE$.getMinimumGeodeticDistance(gh.bbox(), centerPoint$1, true);
    }

    private GeoHashSpiral$() {
        MODULE$ = this;
        GeoHashAutoSize$class.$init$(this);
    }
}

