/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.fs.storage.orc.jobs;

import org.apache.hadoop.conf.Configuration;
import org.apache.orc.mapreduce.OrcInputFormat;
import org.apache.orc.storage.ql.io.sarg.SearchArgument;
import org.geotools.data.Query;
import org.geotools.filter.text.ecql.ECQL;
import org.locationtech.geomesa.filter.factory.FastFilterFactory$;
import org.locationtech.geomesa.fs.storage.common.jobs.StorageConfiguration$;
import org.locationtech.geomesa.fs.storage.orc.OrcFileSystemReader;
import org.locationtech.geomesa.fs.storage.orc.OrcFileSystemReader$;
import org.locationtech.geomesa.fs.storage.orc.jobs.OrcSimpleFeatureInputFormat$;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.index.planning.QueryRunner$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.IncludeFilter;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;

public final class OrcSimpleFeatureInputFormat$ {
    public static final OrcSimpleFeatureInputFormat$ MODULE$;
    private final String FilterConfig;
    private final String TransformSpecConfig;
    private final String TransformDefinitionConfig;
    private final String ReadColumnsConfig;

    static {
        new OrcSimpleFeatureInputFormat$();
    }

    public String FilterConfig() {
        return this.FilterConfig;
    }

    public String TransformSpecConfig() {
        return this.TransformSpecConfig;
    }

    public String TransformDefinitionConfig() {
        return this.TransformDefinitionConfig;
    }

    public String ReadColumnsConfig() {
        return this.ReadColumnsConfig;
    }

    public void configure(Configuration conf, SimpleFeatureType sft, Filter filter, String[] transforms) {
        Query query = new Query(sft.getTypeName(), filter, transforms);
        Query q = QueryRunner$.MODULE$.configureDefaultQuery(sft, query);
        Option f = Option$.MODULE$.apply((Object)q.getFilter()).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Filter x$1) {
                Filter filter = x$1;
                IncludeFilter includeFilter = Filter.INCLUDE;
                return filter != null ? !filter.equals(includeFilter) : includeFilter != null;
            }
        });
        Option transform = QueryHints$.MODULE$.RichHints(q.getHints()).getTransform();
        StorageConfiguration$.MODULE$.setSft(conf, sft);
        f.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Filter x$1) {
                return ECQL.toCQL((Filter)x$1);
            }
        }).foreach((Function1)new Serializable(conf){
            public static final long serialVersionUID = 0L;
            private final Configuration conf$1;

            public final void apply(String x$2) {
                this.conf$1.set(OrcSimpleFeatureInputFormat$.MODULE$.FilterConfig(), x$2);
            }
            {
                this.conf$1 = conf$1;
            }
        });
        transform.foreach((Function1)new Serializable(conf){
            public static final long serialVersionUID = 0L;
            private final Configuration conf$1;

            public final void apply(Tuple2<String, SimpleFeatureType> x0$1) {
                Tuple2<String, SimpleFeatureType> tuple2 = x0$1;
                if (tuple2 != null) {
                    String tdefs = (String)tuple2._1();
                    SimpleFeatureType tsft = (SimpleFeatureType)tuple2._2();
                    this.conf$1.set(OrcSimpleFeatureInputFormat$.MODULE$.TransformDefinitionConfig(), tdefs);
                    this.conf$1.set(OrcSimpleFeatureInputFormat$.MODULE$.TransformSpecConfig(), SimpleFeatureTypes$.MODULE$.encodeType(tsft, true));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.conf$1 = conf$1;
            }
        });
        OrcFileSystemReader.OrcReadOptions options = OrcFileSystemReader$.MODULE$.readOptions(sft, (Option<Filter>)f, (Option<Tuple2<String, SimpleFeatureType>>)transform);
        options.pushDown().foreach((Function1)new Serializable(conf){
            public static final long serialVersionUID = 0L;
            private final Configuration conf$1;

            public final void apply(Tuple2<SearchArgument, String[]> x0$2) {
                Tuple2<SearchArgument, String[]> tuple2 = x0$2;
                if (tuple2 != null) {
                    SearchArgument sargs = (SearchArgument)tuple2._1();
                    String[] names = (String[])tuple2._2();
                    OrcInputFormat.setSearchArgument((Configuration)this.conf$1, (SearchArgument)sargs, (String[])names);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.conf$1 = conf$1;
            }
        });
        Seq cols = (Seq)options.columns().map((Function1)new Serializable(sft){
            public static final long serialVersionUID = 0L;
            public final SimpleFeatureType sft$1;

            public final Seq<Object> apply(Set<String> x$3) {
                return (Seq)x$3.toSeq().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.2 $outer;

                    public final int apply(String x$1) {
                        return this.$outer.sft$1.indexOf(x$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
            {
                this.sft$1 = sft$1;
            }
        }).getOrElse((Function0)new Serializable(sft){
            public static final long serialVersionUID = 0L;
            private final SimpleFeatureType sft$1;

            public final Range apply() {
                return package$.MODULE$.Range().apply(0, this.sft$1.getAttributeCount());
            }
            {
                this.sft$1 = sft$1;
            }
        });
        conf.set(this.ReadColumnsConfig(), cols.mkString(","));
    }

    public String[] configure$default$4() {
        return null;
    }

    public Option<Filter> getFilter(Configuration conf, SimpleFeatureType sft) {
        return Option$.MODULE$.apply((Object)conf.get(this.FilterConfig())).map((Function1)new Serializable(sft){
            public static final long serialVersionUID = 0L;
            private final SimpleFeatureType sft$2;

            public final Filter apply(String x$4) {
                return FastFilterFactory$.MODULE$.toFilter(this.sft$2, x$4);
            }
            {
                this.sft$2 = sft$2;
            }
        });
    }

    public Option<Tuple2<String, SimpleFeatureType>> getTransforms(Configuration conf) {
        return Option$.MODULE$.apply((Object)conf.get(this.TransformDefinitionConfig())).flatMap((Function1)new Serializable(conf){
            public static final long serialVersionUID = 0L;
            private final Configuration conf$2;

            public final Option<Tuple2<String, SimpleFeatureType>> apply(String defs) {
                return Option$.MODULE$.apply((Object)this.conf$2.get(OrcSimpleFeatureInputFormat$.MODULE$.TransformSpecConfig())).map((Function1)new Serializable(this, defs){
                    public static final long serialVersionUID = 0L;
                    private final String defs$1;

                    public final Tuple2<String, SimpleFeatureType> apply(String spec) {
                        return new Tuple2((Object)this.defs$1, (Object)SimpleFeatureTypes$.MODULE$.createType("", spec));
                    }
                    {
                        this.defs$1 = defs$1;
                    }
                });
            }
            {
                this.conf$2 = conf$2;
            }
        });
    }

    public Option<Set<Object>> getReadColumns(Configuration conf) {
        return Option$.MODULE$.apply((Object)conf.get(this.ReadColumnsConfig())).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$5) {
                return new StringOps(Predef$.MODULE$.augmentString(x$5)).nonEmpty();
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Set<Object> apply(String x$6) {
                return Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.refArrayOps((Object[])x$6.split(",")).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(String x$7) {
                        return new StringOps(Predef$.MODULE$.augmentString(x$7)).toInt();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))).toSet();
            }
        });
    }

    private OrcSimpleFeatureInputFormat$() {
        MODULE$ = this;
        this.FilterConfig = "geomesa.fs.filter";
        this.TransformSpecConfig = "geomesa.fs.transform.spec";
        this.TransformDefinitionConfig = "geomesa.fs.transform.defs";
        this.ReadColumnsConfig = "geomesa.fs.orc.columns";
    }
}

