/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.sort;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBReader;
import org.locationtech.jts.io.WKBWriter;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;

public class SimpleFeatureIO {
    RandomAccessFile raf;
    SimpleFeatureType schema;
    SimpleFeatureBuilder builder;
    File file;

    public SimpleFeatureIO(File file, SimpleFeatureType schema) throws FileNotFoundException {
        this.file = file;
        this.raf = new RandomAccessFile(file, "rw");
        this.schema = schema;
        this.builder = new SimpleFeatureBuilder(schema);
    }

    public void write(SimpleFeature sf) throws IOException {
        List attributes = this.schema.getAttributeDescriptors();
        this.raf.writeUTF(sf.getID());
        for (AttributeDescriptor ad : attributes) {
            Object value = sf.getAttribute(ad.getLocalName());
            this.writeAttribute(ad, value);
        }
    }

    void writeAttribute(AttributeDescriptor ad, Object value) throws IOException {
        if (value == null) {
            this.raf.writeBoolean(true);
        } else {
            this.raf.writeBoolean(false);
            Class binding = ad.getType().getBinding();
            if (binding == Boolean.class) {
                this.raf.writeBoolean((Boolean)value);
            } else if (binding == Byte.class || binding == Byte.TYPE) {
                this.raf.writeByte(((Byte)value).byteValue());
            } else if (binding == Short.class || binding == Short.TYPE) {
                this.raf.writeShort(((Short)value).shortValue());
            } else if (binding == Integer.class || binding == Integer.TYPE) {
                this.raf.writeInt((Integer)value);
            } else if (binding == Long.class || binding == Long.TYPE) {
                this.raf.writeLong((Long)value);
            } else if (binding == Float.class || binding == Float.TYPE) {
                this.raf.writeFloat(((Float)value).floatValue());
            } else if (binding == Double.class || binding == Double.TYPE) {
                this.raf.writeDouble((Double)value);
            } else if (binding == String.class) {
                this.raf.writeUTF((String)value);
            } else if (binding == Date.class || binding == Time.class || binding == Timestamp.class || binding == java.util.Date.class) {
                this.raf.writeLong(((java.util.Date)value).getTime());
            } else if (Geometry.class.isAssignableFrom(binding)) {
                WKBWriter writer = new WKBWriter();
                byte[] buffer = writer.write((Geometry)value);
                int length = buffer.length;
                this.raf.writeInt(length);
                this.raf.write(buffer);
            } else {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                oos.writeObject(value);
                oos.flush();
                byte[] bytes = bos.toByteArray();
                this.raf.writeInt(bytes.length);
                this.raf.write(bytes);
            }
        }
    }

    public SimpleFeature read() throws IOException {
        String fid = this.raf.readUTF();
        for (AttributeDescriptor ad : this.schema.getAttributeDescriptors()) {
            Object att = this.readAttribute(ad);
            this.builder.add(att);
        }
        return this.builder.buildFeature(fid);
    }

    Object readAttribute(AttributeDescriptor ad) throws IOException {
        boolean isNull = this.raf.readBoolean();
        if (isNull) {
            return null;
        }
        Class binding = ad.getType().getBinding();
        if (binding == Boolean.class) {
            return this.raf.readBoolean();
        }
        if (binding == Byte.class || binding == Byte.TYPE) {
            return this.raf.readByte();
        }
        if (binding == Short.class || binding == Short.TYPE) {
            return this.raf.readShort();
        }
        if (binding == Integer.class || binding == Integer.TYPE) {
            return this.raf.readInt();
        }
        if (binding == Long.class || binding == Long.TYPE) {
            return this.raf.readLong();
        }
        if (binding == Float.class || binding == Float.TYPE) {
            return Float.valueOf(this.raf.readFloat());
        }
        if (binding == Double.class || binding == Double.TYPE) {
            return this.raf.readDouble();
        }
        if (binding == String.class) {
            return this.raf.readUTF();
        }
        if (binding == Date.class) {
            return new Date(this.raf.readLong());
        }
        if (binding == Time.class) {
            return new Time(this.raf.readLong());
        }
        if (binding == Timestamp.class) {
            return new Timestamp(this.raf.readLong());
        }
        if (binding == java.util.Date.class) {
            return new java.util.Date(this.raf.readLong());
        }
        if (Geometry.class.isAssignableFrom(binding)) {
            WKBReader reader = new WKBReader();
            int length = this.raf.readInt();
            byte[] buffer = new byte[length];
            this.raf.read(buffer);
            try {
                return reader.read(buffer);
            }
            catch (ParseException e) {
                throw new IOException("Failed to parse the geometry WKB", e);
            }
        }
        int length = this.raf.readInt();
        byte[] buffer = new byte[length];
        this.raf.read(buffer);
        ByteArrayInputStream bis = new ByteArrayInputStream(buffer);
        ObjectInputStream ois = new ObjectInputStream(bis);
        try {
            return ois.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Could not read back object", e);
        }
    }

    public void seek(long offset) throws IOException {
        this.raf.seek(offset);
    }

    public long getOffset() throws IOException {
        return this.raf.getFilePointer();
    }

    public boolean endOfFile() throws IOException {
        return this.getOffset() >= this.raf.length();
    }

    public void close(boolean deleteFile) throws IOException {
        try {
            this.raf.close();
        }
        finally {
            if (deleteFile) {
                this.file.delete();
            }
        }
    }

    public String toString() {
        return "SimpleFeatureIO [schema=" + this.schema + ", file=" + this.file + "]";
    }
}

