/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.collection;

import org.locationtech.geomesa.utils.collection.CircularByteQueue$;
import scala.Array$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001q4A!\u0001\u0002\u0001\u001b\t\t2)\u001b:dk2\f'OQ=uKF+X-^3\u000b\u0005\r!\u0011AC2pY2,7\r^5p]*\u0011QAB\u0001\u0006kRLGn\u001d\u0006\u0003\u000f!\tqaZ3p[\u0016\u001c\u0018M\u0003\u0002\n\u0015\u0005aAn\\2bi&|g\u000e^3dQ*\t1\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001\u001dA\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t1\u0011I\\=SK\u001aD\u0001\"\u0006\u0001\u0003\u0002\u0003\u0006IAF\u0001\fS:LG/[1m'&TX\r\u0005\u0002\u0010/%\u0011\u0001\u0004\u0005\u0002\u0004\u0013:$\b\"\u0002\u000e\u0001\t\u0003Y\u0012A\u0002\u001fj]&$h\b\u0006\u0002\u001d=A\u0011Q\u0004A\u0007\u0002\u0005!9Q#\u0007I\u0001\u0002\u00041\u0002b\u0002\u0011\u0001\u0001\u0004%I!I\u0001\u0006CJ\u0014\u0018-_\u000b\u0002EA\u0019qbI\u0013\n\u0005\u0011\u0002\"!B!se\u0006L\bCA\b'\u0013\t9\u0003C\u0001\u0003CsR,\u0007bB\u0015\u0001\u0001\u0004%IAK\u0001\nCJ\u0014\u0018-_0%KF$\"a\u000b\u0018\u0011\u0005=a\u0013BA\u0017\u0011\u0005\u0011)f.\u001b;\t\u000f=B\u0013\u0011!a\u0001E\u0005\u0019\u0001\u0010J\u0019\t\rE\u0002\u0001\u0015)\u0003#\u0003\u0019\t'O]1zA!91\u0007\u0001a\u0001\n\u0013!\u0014!B:uCJ$X#\u0001\f\t\u000fY\u0002\u0001\u0019!C\u0005o\u0005I1\u000f^1si~#S-\u001d\u000b\u0003WaBqaL\u001b\u0002\u0002\u0003\u0007a\u0003\u0003\u0004;\u0001\u0001\u0006KAF\u0001\u0007gR\f'\u000f\u001e\u0011\t\u000fq\u0002\u0001\u0019!C\u0005i\u00051A.\u001a8hi\"DqA\u0010\u0001A\u0002\u0013%q(\u0001\u0006mK:<G\u000f[0%KF$\"a\u000b!\t\u000f=j\u0014\u0011!a\u0001-!1!\t\u0001Q!\nY\tq\u0001\\3oORD\u0007\u0005C\u0003E\u0001\u0011\u0005A'\u0001\u0003tSj,\u0007\"\u0002$\u0001\t\u0003!\u0014\u0001C2ba\u0006\u001c\u0017\u000e^=\t\u000b!\u0003A\u0011A%\u0002\u0011\u0011\u0002H.^:%KF$\"a\u000b&\t\u000b-;\u0005\u0019A\u0013\u0002\t\tLH/\u001a\u0005\u0006\u001b\u0002!\tAT\u0001\u000eIAdWo\u001d\u0013qYV\u001cH%Z9\u0015\u0005-z\u0005\"\u0002)M\u0001\u0004\u0011\u0013!\u00022zi\u0016\u001c\b\"\u0002*\u0001\t\u0003\u0019\u0016aB3ocV,W/\u001a\u000b\u0003WQCQaS)A\u0002\u0015BQA\u0015\u0001\u0005\u0002Y#BaK,Y5\")\u0001+\u0016a\u0001E!)\u0011,\u0016a\u0001-\u00051qN\u001a4tKRDQaW+A\u0002Y\tQaY8v]RDQ!\u0018\u0001\u0005\u0002y\u000bq\u0001Z3rk\u0016,X\r\u0006\u0002#?\")1\f\u0018a\u0001-!)\u0011\r\u0001C\u0001E\u0006!AM]8q)\tY3\rC\u0003\\A\u0002\u0007a\u0003C\u0003f\u0001\u0011%a-\u0001\u0004f]N,(/\u001a\u000b\u0003W\u001dDQa\u00173A\u0002Y9q!\u001b\u0002\u0002\u0002#\u0005!.A\tDSJ\u001cW\u000f\\1s\u0005f$X-U;fk\u0016\u0004\"!H6\u0007\u000f\u0005\u0011\u0011\u0011!E\u0001YN\u00111N\u0004\u0005\u00065-$\tA\u001c\u000b\u0002U\"9\u0001o[I\u0001\n\u0003\t\u0018a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013'F\u0001sU\t12oK\u0001u!\t)(0D\u0001w\u0015\t9\b0A\u0005v]\u000eDWmY6fI*\u0011\u0011\u0010E\u0001\u000bC:tw\u000e^1uS>t\u0017BA>w\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class CircularByteQueue {
    private byte[] array;
    private int start;
    private int length;

    public static int $lessinit$greater$default$1() {
        return CircularByteQueue$.MODULE$.$lessinit$greater$default$1();
    }

    private byte[] array() {
        return this.array;
    }

    private void array_$eq(byte[] x$1) {
        this.array = x$1;
    }

    private int start() {
        return this.start;
    }

    private void start_$eq(int x$1) {
        this.start = x$1;
    }

    private int length() {
        return this.length;
    }

    private void length_$eq(int x$1) {
        this.length = x$1;
    }

    public int size() {
        return this.length();
    }

    public int capacity() {
        return this.array().length - this.length();
    }

    public void $plus$eq(byte by) {
        this.enqueue(by);
    }

    public void $plus$plus$eq(byte[] bytes) {
        this.enqueue(bytes, 0, bytes.length);
    }

    public void enqueue(byte by) {
        this.ensure(1);
        int last = this.start() + this.length();
        if (last >= this.array().length) {
            last -= this.array().length;
        }
        this.array()[last] = by;
        this.length_$eq(this.length() + 1);
    }

    public void enqueue(byte[] bytes, int offset, int count2) {
        this.ensure(count2);
        int first = this.start() + this.length();
        if (first >= this.array().length) {
            first -= this.array().length;
        }
        if (first + count2 < this.array().length) {
            System.arraycopy(bytes, offset, this.array(), first, count2);
        } else {
            int tail = this.array().length - first;
            System.arraycopy(bytes, offset, this.array(), first, tail);
            System.arraycopy(bytes, offset + tail, this.array(), 0, count2 - tail);
        }
        this.length_$eq(this.length() + count2);
    }

    /*
     * WARNING - void declaration
     */
    public byte[] dequeue(int count2) {
        void var3_3;
        int total = package$.MODULE$.min(this.length(), count2);
        byte[] result = (byte[])Array$.MODULE$.ofDim(total, ClassTag$.MODULE$.Byte());
        if (this.start() + total <= this.array().length) {
            System.arraycopy(this.array(), this.start(), result, 0, total);
        } else {
            int tail = this.array().length - this.start();
            System.arraycopy(this.array(), this.start(), result, 0, tail);
            System.arraycopy(this.array(), 0, result, tail, total - tail);
        }
        this.start_$eq(this.start() + total);
        if (this.start() >= this.array().length) {
            this.start_$eq(this.start() - this.array().length);
        }
        this.length_$eq(this.length() - total);
        return var3_3;
    }

    public void drop(int count2) {
        int total = package$.MODULE$.min(this.length(), count2);
        this.start_$eq(this.start() + total);
        if (this.start() >= this.array().length) {
            this.start_$eq(this.start() - this.array().length);
        }
        this.length_$eq(this.length() - total);
    }

    private void ensure(int count2) {
        if (this.length() + count2 > this.array().length) {
            int newSize;
            for (newSize = this.array().length * 2; newSize < this.length() + count2; newSize *= 2) {
            }
            byte[] tmp = (byte[])Array$.MODULE$.ofDim(newSize, ClassTag$.MODULE$.Byte());
            if (this.start() + this.length() <= this.array().length) {
                System.arraycopy(this.array(), this.start(), tmp, 0, this.length());
            } else {
                int tailBytes = this.array().length - this.start();
                System.arraycopy(this.array(), this.start(), tmp, 0, tailBytes);
                System.arraycopy(this.array(), 0, tmp, tailBytes, this.length() - tailBytes);
            }
            this.array_$eq(tmp);
            this.start_$eq(0);
        }
    }

    public CircularByteQueue(int initialSize) {
        this.array = (byte[])Array$.MODULE$.ofDim(initialSize, ClassTag$.MODULE$.Byte());
        this.start = 0;
        this.length = 0;
    }
}

