/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.stats;

import com.clearspring.analytics.stream.Counter;
import com.clearspring.analytics.stream.cardinality.HyperLogLog;
import com.clearspring.analytics.stream.cardinality.RegisterSet;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.lang.reflect.Field;
import java.util.Date;
import org.locationtech.geomesa.curve.TimePeriod$;
import org.locationtech.geomesa.utils.cache.SoftThreadLocal;
import org.locationtech.geomesa.utils.clearspring.CountMinSketch;
import org.locationtech.geomesa.utils.clearspring.HyperLogLog$;
import org.locationtech.geomesa.utils.clearspring.StreamSummary;
import org.locationtech.geomesa.utils.clearspring.StreamSummary$;
import org.locationtech.geomesa.utils.stats.BinnedArray;
import org.locationtech.geomesa.utils.stats.BinnedLongArray;
import org.locationtech.geomesa.utils.stats.CountStat;
import org.locationtech.geomesa.utils.stats.DescriptiveStats;
import org.locationtech.geomesa.utils.stats.EnumerationStat;
import org.locationtech.geomesa.utils.stats.Frequency;
import org.locationtech.geomesa.utils.stats.GroupBy;
import org.locationtech.geomesa.utils.stats.Histogram;
import org.locationtech.geomesa.utils.stats.ImmutableStat;
import org.locationtech.geomesa.utils.stats.ImmutableStat$class;
import org.locationtech.geomesa.utils.stats.IteratorStackCount;
import org.locationtech.geomesa.utils.stats.MinMax;
import org.locationtech.geomesa.utils.stats.MinMax$MinMaxDefaults$;
import org.locationtech.geomesa.utils.stats.SeqStat;
import org.locationtech.geomesa.utils.stats.Stat;
import org.locationtech.geomesa.utils.stats.TopK;
import org.locationtech.geomesa.utils.stats.TopK$;
import org.locationtech.geomesa.utils.stats.Z3Frequency;
import org.locationtech.geomesa.utils.stats.Z3Histogram;
import org.locationtech.geomesa.utils.text.WKBUtils$;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.NotImplementedError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Map;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class KryoStatSerializer$ {
    public static final KryoStatSerializer$ MODULE$;
    private final SoftThreadLocal<Input> org$locationtech$geomesa$utils$stats$KryoStatSerializer$$inputs;
    private final SoftThreadLocal<Output> org$locationtech$geomesa$utils$stats$KryoStatSerializer$$outputs;
    private final byte SeqStatByte;
    private final byte CountByte;
    private final byte IteratorStackByte;
    private final byte MinMaxByteV1;
    private final byte MinMaxByteV2;
    private final byte MinMaxByte;
    private final byte EnumerationByteV1;
    private final byte EnumerationByte;
    private final byte HistogramByteV1;
    private final byte HistogramByte;
    private final byte FrequencyByteV1;
    private final byte FrequencyByteV2;
    private final byte FrequencyByte;
    private final byte Z3HistogramByteV1;
    private final byte Z3HistogramByteV2;
    private final byte Z3HistogramByte;
    private final byte Z3FrequencyByteV1;
    private final byte Z3FrequencyByteV2;
    private final byte Z3FrequencyByte;
    private final byte DescriptiveStatByteV1;
    private final byte DescriptiveStatByte;
    private final byte GroupByByteV1;
    private final byte GroupByByte;
    private final byte TopKByteV1;
    private final byte TopKByteV2;
    private final byte TopKByte;

    static {
        new KryoStatSerializer$();
    }

    public SoftThreadLocal<Input> org$locationtech$geomesa$utils$stats$KryoStatSerializer$$inputs() {
        return this.org$locationtech$geomesa$utils$stats$KryoStatSerializer$$inputs;
    }

    public SoftThreadLocal<Output> org$locationtech$geomesa$utils$stats$KryoStatSerializer$$outputs() {
        return this.org$locationtech$geomesa$utils$stats$KryoStatSerializer$$outputs;
    }

    private byte SeqStatByte() {
        return this.SeqStatByte;
    }

    private byte CountByte() {
        return this.CountByte;
    }

    private byte IteratorStackByte() {
        return this.IteratorStackByte;
    }

    private byte MinMaxByteV1() {
        return this.MinMaxByteV1;
    }

    private byte MinMaxByteV2() {
        return this.MinMaxByteV2;
    }

    private byte MinMaxByte() {
        return this.MinMaxByte;
    }

    private byte EnumerationByteV1() {
        return this.EnumerationByteV1;
    }

    private byte EnumerationByte() {
        return this.EnumerationByte;
    }

    private byte HistogramByteV1() {
        return this.HistogramByteV1;
    }

    private byte HistogramByte() {
        return this.HistogramByte;
    }

    private byte FrequencyByteV1() {
        return this.FrequencyByteV1;
    }

    private byte FrequencyByteV2() {
        return this.FrequencyByteV2;
    }

    private byte FrequencyByte() {
        return this.FrequencyByte;
    }

    private byte Z3HistogramByteV1() {
        return this.Z3HistogramByteV1;
    }

    private byte Z3HistogramByteV2() {
        return this.Z3HistogramByteV2;
    }

    private byte Z3HistogramByte() {
        return this.Z3HistogramByte;
    }

    private byte Z3FrequencyByteV1() {
        return this.Z3FrequencyByteV1;
    }

    private byte Z3FrequencyByteV2() {
        return this.Z3FrequencyByteV2;
    }

    private byte Z3FrequencyByte() {
        return this.Z3FrequencyByte;
    }

    private byte DescriptiveStatByteV1() {
        return this.DescriptiveStatByteV1;
    }

    private byte DescriptiveStatByte() {
        return this.DescriptiveStatByte;
    }

    private byte GroupByByteV1() {
        return this.GroupByByteV1;
    }

    private byte GroupByByte() {
        return this.GroupByByte;
    }

    private byte TopKByteV1() {
        return this.TopKByteV1;
    }

    private byte TopKByteV2() {
        return this.TopKByteV2;
    }

    private byte TopKByte() {
        return this.TopKByte;
    }

    public void org$locationtech$geomesa$utils$stats$KryoStatSerializer$$write(Output output, SimpleFeatureType sft, Stat stat2) {
        block14: {
            block3: {
                Stat stat3;
                block13: {
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    block8: {
                                        block7: {
                                            block6: {
                                                block5: {
                                                    block4: {
                                                        block2: {
                                                            stat3 = stat2;
                                                            if (!(stat3 instanceof CountStat)) break block2;
                                                            CountStat countStat = (CountStat)stat3;
                                                            output.writeByte(this.CountByte());
                                                            this.writeCount(output, countStat);
                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                            break block3;
                                                        }
                                                        if (!(stat3 instanceof MinMax)) break block4;
                                                        MinMax minMax2 = (MinMax)stat3;
                                                        output.writeByte(this.MinMaxByte());
                                                        this.writeMinMax(output, sft, minMax2);
                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                        break block3;
                                                    }
                                                    if (!(stat3 instanceof EnumerationStat)) break block5;
                                                    EnumerationStat enumerationStat = (EnumerationStat)stat3;
                                                    output.writeByte(this.EnumerationByte());
                                                    this.writeEnumeration(output, sft, enumerationStat);
                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                    break block3;
                                                }
                                                if (!(stat3 instanceof TopK)) break block6;
                                                TopK topK2 = (TopK)stat3;
                                                output.writeByte(this.TopKByte());
                                                this.writeTopK(output, sft, topK2);
                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                break block3;
                                            }
                                            if (!(stat3 instanceof Histogram)) break block7;
                                            Histogram histogram2 = (Histogram)stat3;
                                            output.writeByte(this.HistogramByte());
                                            this.writeHistogram(output, sft, histogram2);
                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                            break block3;
                                        }
                                        if (!(stat3 instanceof Frequency)) break block8;
                                        Frequency frequency2 = (Frequency)stat3;
                                        output.writeByte(this.FrequencyByte());
                                        this.writeFrequency(output, sft, frequency2);
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        break block3;
                                    }
                                    if (!(stat3 instanceof Z3Histogram)) break block9;
                                    Z3Histogram z3Histogram2 = (Z3Histogram)stat3;
                                    output.writeByte(this.Z3HistogramByte());
                                    this.writeZ3Histogram(output, sft, z3Histogram2);
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    break block3;
                                }
                                if (!(stat3 instanceof Z3Frequency)) break block10;
                                Z3Frequency z3Frequency2 = (Z3Frequency)stat3;
                                output.writeByte(this.Z3FrequencyByte());
                                this.writeZ3Frequency(output, sft, z3Frequency2);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                break block3;
                            }
                            if (!(stat3 instanceof IteratorStackCount)) break block11;
                            IteratorStackCount iteratorStackCount = (IteratorStackCount)stat3;
                            output.writeByte(this.IteratorStackByte());
                            this.writeIteratorStackCount(output, iteratorStackCount);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block3;
                        }
                        if (!(stat3 instanceof SeqStat)) break block12;
                        SeqStat seqStat = (SeqStat)stat3;
                        output.writeByte(this.SeqStatByte());
                        this.writeSeqStat(output, sft, seqStat);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block3;
                    }
                    if (!(stat3 instanceof DescriptiveStats)) break block13;
                    DescriptiveStats descriptiveStats2 = (DescriptiveStats)stat3;
                    output.writeByte(this.DescriptiveStatByte());
                    this.writeDescriptiveStats(output, sft, descriptiveStats2);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!(stat3 instanceof GroupBy)) break block14;
                GroupBy groupBy2 = (GroupBy)stat3;
                output.writeByte(this.GroupByByte());
                this.writeGroupBy(output, sft, groupBy2);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new NotImplementedError(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unhandled stat ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{stat2})));
    }

    public Stat org$locationtech$geomesa$utils$stats$KryoStatSerializer$$read(Input input, SimpleFeatureType sft, boolean immutable2) {
        block28: {
            Stat stat2;
            block3: {
                byte by;
                block27: {
                    block26: {
                        block25: {
                            block24: {
                                block23: {
                                    block22: {
                                        block21: {
                                            block20: {
                                                block19: {
                                                    block18: {
                                                        block17: {
                                                            block16: {
                                                                block15: {
                                                                    block14: {
                                                                        block13: {
                                                                            block12: {
                                                                                block11: {
                                                                                    block10: {
                                                                                        block9: {
                                                                                            block8: {
                                                                                                block7: {
                                                                                                    block6: {
                                                                                                        block5: {
                                                                                                            block4: {
                                                                                                                block2: {
                                                                                                                    by = input.readByte();
                                                                                                                    if (this.CountByte() != by) break block2;
                                                                                                                    stat2 = this.readCount(input, sft, immutable2);
                                                                                                                    break block3;
                                                                                                                }
                                                                                                                if (this.MinMaxByte() != by) break block4;
                                                                                                                stat2 = this.readMinMax(input, sft, immutable2, 3);
                                                                                                                break block3;
                                                                                                            }
                                                                                                            if (this.EnumerationByte() != by) break block5;
                                                                                                            stat2 = this.readEnumeration(input, sft, immutable2, 2);
                                                                                                            break block3;
                                                                                                        }
                                                                                                        if (this.TopKByte() != by) break block6;
                                                                                                        stat2 = this.readTopK(input, sft, immutable2, 3);
                                                                                                        break block3;
                                                                                                    }
                                                                                                    if (this.HistogramByte() != by) break block7;
                                                                                                    stat2 = this.readHistogram(input, sft, immutable2, 2);
                                                                                                    break block3;
                                                                                                }
                                                                                                if (this.FrequencyByte() != by) break block8;
                                                                                                stat2 = this.readFrequency(input, sft, immutable2, 3);
                                                                                                break block3;
                                                                                            }
                                                                                            if (this.Z3HistogramByte() != by) break block9;
                                                                                            stat2 = this.readZ3Histogram(input, sft, immutable2, 3);
                                                                                            break block3;
                                                                                        }
                                                                                        if (this.Z3FrequencyByte() != by) break block10;
                                                                                        stat2 = this.readZ3Frequency(input, sft, immutable2, 3);
                                                                                        break block3;
                                                                                    }
                                                                                    if (this.IteratorStackByte() != by) break block11;
                                                                                    stat2 = this.readIteratorStackCount(input, sft, immutable2);
                                                                                    break block3;
                                                                                }
                                                                                if (this.SeqStatByte() != by) break block12;
                                                                                stat2 = this.readSeqStat(input, sft, immutable2);
                                                                                break block3;
                                                                            }
                                                                            if (this.DescriptiveStatByte() != by) break block13;
                                                                            stat2 = this.readDescriptiveStat(input, sft, immutable2, 2);
                                                                            break block3;
                                                                        }
                                                                        if (this.GroupByByte() != by) break block14;
                                                                        stat2 = this.readGroupBy(input, sft, immutable2, 2);
                                                                        break block3;
                                                                    }
                                                                    if (this.EnumerationByteV1() != by) break block15;
                                                                    stat2 = this.readEnumeration(input, sft, immutable2, 1);
                                                                    break block3;
                                                                }
                                                                if (this.HistogramByteV1() != by) break block16;
                                                                stat2 = this.readHistogram(input, sft, immutable2, 1);
                                                                break block3;
                                                            }
                                                            if (this.FrequencyByteV2() != by) break block17;
                                                            stat2 = this.readFrequency(input, sft, immutable2, 2);
                                                            break block3;
                                                        }
                                                        if (this.Z3HistogramByteV2() != by) break block18;
                                                        stat2 = this.readZ3Histogram(input, sft, immutable2, 2);
                                                        break block3;
                                                    }
                                                    if (this.Z3FrequencyByteV2() != by) break block19;
                                                    stat2 = this.readZ3Frequency(input, sft, immutable2, 2);
                                                    break block3;
                                                }
                                                if (this.DescriptiveStatByteV1() != by) break block20;
                                                stat2 = this.readDescriptiveStat(input, sft, immutable2, 1);
                                                break block3;
                                            }
                                            if (this.GroupByByteV1() != by) break block21;
                                            stat2 = this.readGroupBy(input, sft, immutable2, 1);
                                            break block3;
                                        }
                                        if (this.TopKByteV2() != by) break block22;
                                        stat2 = this.readTopK(input, sft, immutable2, 2);
                                        break block3;
                                    }
                                    if (this.MinMaxByteV2() != by) break block23;
                                    stat2 = this.readMinMax(input, sft, immutable2, 2);
                                    break block3;
                                }
                                if (this.FrequencyByteV1() != by) break block24;
                                stat2 = this.readFrequency(input, sft, immutable2, 1);
                                break block3;
                            }
                            if (this.Z3HistogramByteV1() != by) break block25;
                            stat2 = this.readZ3Histogram(input, sft, immutable2, 1);
                            break block3;
                        }
                        if (this.Z3FrequencyByteV1() != by) break block26;
                        stat2 = this.readZ3Frequency(input, sft, immutable2, 1);
                        break block3;
                    }
                    if (this.MinMaxByteV1() != by) break block27;
                    stat2 = this.readMinMax(input, sft, immutable2, 1);
                    break block3;
                }
                if (this.TopKByteV1() != by) break block28;
                stat2 = this.readTopK(input, sft, immutable2, 1);
            }
            return stat2;
        }
        throw new RuntimeException("Trying to read malformed or invalid serialized stat");
    }

    private void writeGroupBy(Output output, SimpleFeatureType sft, GroupBy<?> stat2) {
        output.writeAscii(stat2.property());
        output.writeString(stat2.stat());
        output.writeInt(stat2.groups().keys().size(), true);
        Function1<Object, BoxedUnit> keyWriter = this.writer(output, sft.getDescriptor(stat2.property()).getType().getBinding());
        stat2.groups().foreach((Function1)new Serializable(output, sft, keyWriter){
            public static final long serialVersionUID = 0L;
            private final Output output$9;
            private final SimpleFeatureType sft$3;
            private final Function1 keyWriter$1;

            public final void apply(Tuple2<Object, Stat> x0$1) {
                Tuple2<Object, Stat> tuple2 = x0$1;
                if (tuple2 != null) {
                    Object key2 = tuple2._1();
                    Stat groupedStat = (Stat)tuple2._2();
                    this.keyWriter$1.apply(key2);
                    KryoStatSerializer$.MODULE$.org$locationtech$geomesa$utils$stats$KryoStatSerializer$$write(this.output$9, this.sft$3, groupedStat);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.output$9 = output$9;
                this.sft$3 = sft$3;
                this.keyWriter$1 = keyWriter$1;
            }
        });
    }

    private GroupBy<?> readGroupBy(Input input, SimpleFeatureType sft, boolean immutable2, int version) {
        String string2;
        int n = version;
        switch (n) {
            default: {
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid group by serialization version: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)version)})));
            }
            case 1: {
                string2 = sft.getDescriptor(input.readInt(true)).getLocalName();
                break;
            }
            case 2: {
                string2 = input.readString();
            }
        }
        String attribute2 = string2;
        String exampleStat = input.readString();
        int keyLength = input.readInt(true);
        ClassTag classTag = ClassTag$.MODULE$.apply(sft.getDescriptor(attribute2).getType().getBinding());
        GroupBy stat2 = immutable2 ? new ImmutableStat(sft, attribute2, exampleStat, classTag){

            public void observe(SimpleFeature sf) {
                ImmutableStat$class.observe(this, sf);
            }

            public void unobserve(SimpleFeature sf) {
                ImmutableStat$class.unobserve(this, sf);
            }

            public void $plus$eq(Stat other) {
                ImmutableStat$class.$plus$eq(this, other);
            }

            public void clear() {
                ImmutableStat$class.clear(this);
            }
            {
                ImmutableStat$class.$init$(this);
            }
        } : new GroupBy(sft, attribute2, exampleStat, classTag);
        Function0<Object> keyReader = this.reader(input, sft.getDescriptor(attribute2).getType().getBinding());
        for (int i = 0; i < keyLength; ++i) {
            Object key2 = keyReader.apply();
            Stat groupedStat = this.org$locationtech$geomesa$utils$stats$KryoStatSerializer$$read(input, sft, immutable2);
            stat2.groups().put(key2, (Object)groupedStat);
        }
        return stat2;
    }

    private void writeDescriptiveStats(Output output, SimpleFeatureType sft, DescriptiveStats stat2) {
        output.writeInt(stat2.properties().size(), true);
        stat2.properties().foreach((Function1)new Serializable(output){
            public static final long serialVersionUID = 0L;
            private final Output output$8;

            public final void apply(String x$1) {
                this.output$8.writeAscii(x$1);
            }
            {
                this.output$8 = output$8;
            }
        });
        this.writeArray$1(stat2._min().getMatrix().data, output);
        this.writeArray$1(stat2._max().getMatrix().data, output);
        this.writeArray$1(stat2._sum().getMatrix().data, output);
        this.writeArray$1(stat2._mean().getMatrix().data, output);
        this.writeArray$1(stat2._m2n().getMatrix().data, output);
        this.writeArray$1(stat2._m3n().getMatrix().data, output);
        this.writeArray$1(stat2._m4n().getMatrix().data, output);
        this.writeArray$1(stat2._c2().getMatrix().data, output);
        output.writeLong(stat2._count(), true);
    }

    private DescriptiveStats readDescriptiveStat(Input input, SimpleFeatureType sft, boolean immutable2, int version) {
        Seq seq;
        int size2 = input.readInt(true);
        int n = version;
        switch (n) {
            default: {
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid descriptive stats serialization version: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)version)})));
            }
            case 1: {
                seq = (Seq)Seq$.MODULE$.fill(size2, (Function0)new Serializable(input, sft){
                    public static final long serialVersionUID = 0L;
                    private final Input input$5;
                    private final SimpleFeatureType sft$14;

                    public final String apply() {
                        return this.sft$14.getDescriptor(this.input$5.readInt(true)).getLocalName();
                    }
                    {
                        this.input$5 = input$5;
                        this.sft$14 = sft$14;
                    }
                });
                break;
            }
            case 2: {
                seq = (Seq)Seq$.MODULE$.fill(size2, (Function0)new Serializable(input){
                    public static final long serialVersionUID = 0L;
                    private final Input input$5;

                    public final String apply() {
                        return this.input$5.readString();
                    }
                    {
                        this.input$5 = input$5;
                    }
                });
            }
        }
        Seq attributes2 = seq;
        DescriptiveStats stats2 = immutable2 ? new ImmutableStat(sft, attributes2){

            public void observe(SimpleFeature sf) {
                ImmutableStat$class.observe(this, sf);
            }

            public void unobserve(SimpleFeature sf) {
                ImmutableStat$class.unobserve(this, sf);
            }

            public void $plus$eq(Stat other) {
                ImmutableStat$class.$plus$eq(this, other);
            }

            public void clear() {
                ImmutableStat$class.clear(this);
            }
            {
                ImmutableStat$class.$init$(this);
            }
        } : new DescriptiveStats(sft, (Seq<String>)attributes2);
        this.readArray$1(stats2._min().getMatrix().data, input);
        this.readArray$1(stats2._max().getMatrix().data, input);
        this.readArray$1(stats2._sum().getMatrix().data, input);
        this.readArray$1(stats2._mean().getMatrix().data, input);
        this.readArray$1(stats2._m2n().getMatrix().data, input);
        this.readArray$1(stats2._m3n().getMatrix().data, input);
        this.readArray$1(stats2._m4n().getMatrix().data, input);
        this.readArray$1(stats2._c2().getMatrix().data, input);
        stats2._count_$eq(input.readLong(true));
        return stats2;
    }

    private void writeSeqStat(Output output, SimpleFeatureType sft, SeqStat stat2) {
        stat2.stats().foreach((Function1)new Serializable(output, sft){
            public static final long serialVersionUID = 0L;
            private final Output output$7;
            private final SimpleFeatureType sft$2;

            public final void apply(Stat x$1) {
                KryoStatSerializer$.MODULE$.org$locationtech$geomesa$utils$stats$KryoStatSerializer$$write(this.output$7, this.sft$2, x$1);
            }
            {
                this.output$7 = output$7;
                this.sft$2 = sft$2;
            }
        });
    }

    private SeqStat readSeqStat(Input input, SimpleFeatureType sft, boolean immutable2) {
        ArrayBuffer stats2 = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        while (input.available() > 0) {
            stats2.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Stat[]{this.org$locationtech$geomesa$utils$stats$KryoStatSerializer$$read(input, sft, immutable2)}));
        }
        return immutable2 ? new ImmutableStat(sft, stats2){

            public void observe(SimpleFeature sf) {
                ImmutableStat$class.observe(this, sf);
            }

            public void unobserve(SimpleFeature sf) {
                ImmutableStat$class.unobserve(this, sf);
            }

            public void $plus$eq(Stat other) {
                ImmutableStat$class.$plus$eq(this, other);
            }

            public void clear() {
                ImmutableStat$class.clear(this);
            }
            {
                ImmutableStat$class.$init$(this);
            }
        } : new SeqStat(sft, (Seq<Stat>)stats2);
    }

    private void writeCount(Output output, CountStat stat2) {
        output.writeLong(stat2.counter(), true);
    }

    private CountStat readCount(Input input, SimpleFeatureType sft, boolean immutable2) {
        CountStat stat2 = immutable2 ? new ImmutableStat(sft){

            public void observe(SimpleFeature sf) {
                ImmutableStat$class.observe(this, sf);
            }

            public void unobserve(SimpleFeature sf) {
                ImmutableStat$class.unobserve(this, sf);
            }

            public void $plus$eq(Stat other) {
                ImmutableStat$class.$plus$eq(this, other);
            }

            public void clear() {
                ImmutableStat$class.clear(this);
            }
            {
                ImmutableStat$class.$init$(this);
            }
        } : new CountStat(sft);
        stat2.counter_$eq(input.readLong(true));
        return stat2;
    }

    private void writeMinMax(Output output, SimpleFeatureType sft, MinMax<?> stat2) {
        output.writeAscii(stat2.property());
        output.writeInt(stat2.hpp().log2m(), true);
        output.writeInt(stat2.hpp().registerSet().size(), true);
        Predef$.MODULE$.intArrayOps(stat2.hpp().registerSet().rawBits()).foreach((Function1)new Serializable(output){
            public static final long serialVersionUID = 0L;
            private final Output output$1;

            public final void apply(int x$1) {
                this.apply$mcVI$sp(x$1);
            }

            public void apply$mcVI$sp(int x$1) {
                this.output$1.writeInt(x$1);
            }
            {
                this.output$1 = output$1;
            }
        });
        Function1<Object, BoxedUnit> write = this.writer(output, sft.getDescriptor(stat2.property()).getType().getBinding());
        write.apply(stat2.minValue());
        write.apply(stat2.maxValue());
    }

    private MinMax<?> readMinMax(Input input, SimpleFeatureType sft, boolean immutable2, int version) {
        org.locationtech.geomesa.utils.clearspring.HyperLogLog hyperLogLog;
        String attribute2;
        int n = version;
        switch (n) {
            default: {
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid min/max serialization version: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)version)})));
            }
            case 1: 
            case 2: {
                String string2 = sft.getDescriptor(input.readInt(true)).getLocalName();
                break;
            }
            case 3: {
                String string2 = attribute2 = input.readString();
            }
        }
        if (version > 1) {
            int log2m = input.readInt(true);
            int size2 = input.readInt(true);
            int[] bytes = (int[])Array$.MODULE$.fill(size2, (Function0)new Serializable(input){
                public static final long serialVersionUID = 0L;
                private final Input input$1;

                public final int apply() {
                    return this.apply$mcI$sp();
                }

                public int apply$mcI$sp() {
                    return this.input$1.readInt();
                }
                {
                    this.input$1 = input$1;
                }
            }, ClassTag$.MODULE$.Int());
            hyperLogLog = HyperLogLog$.MODULE$.apply(log2m, bytes);
        } else {
            byte[] hppBytes = (byte[])Array$.MODULE$.ofDim(input.readInt(true), ClassTag$.MODULE$.Byte());
            input.read(hppBytes);
            HyperLogLog clearspring = HyperLogLog.Builder.build((byte[])hppBytes);
            int log2m = BoxesRunTime.unboxToInt((Object)this.getField$1("log2m", clearspring));
            int[] registerSet = ((RegisterSet)this.getField$1("registerSet", clearspring)).bits();
            hyperLogLog = HyperLogLog$.MODULE$.apply(log2m, registerSet);
        }
        org.locationtech.geomesa.utils.clearspring.HyperLogLog hpp = hyperLogLog;
        Class binding = sft.getDescriptor(attribute2).getType().getBinding();
        Function0<Object> read = this.reader(input, binding);
        Object min = read.apply();
        Object max = read.apply();
        MinMax.MinMaxDefaults defaults = MinMax$MinMaxDefaults$.MODULE$.apply(binding);
        return immutable2 ? new ImmutableStat(sft, attribute2, hpp, min, max, defaults){

            public void observe(SimpleFeature sf) {
                ImmutableStat$class.observe(this, sf);
            }

            public void unobserve(SimpleFeature sf) {
                ImmutableStat$class.unobserve(this, sf);
            }

            public void $plus$eq(Stat other) {
                ImmutableStat$class.$plus$eq(this, other);
            }

            public void clear() {
                ImmutableStat$class.clear(this);
            }
            {
                ImmutableStat$class.$init$(this);
            }
        } : new MinMax<Object>(sft, attribute2, min, max, hpp, defaults);
    }

    private void writeEnumeration(Output output, SimpleFeatureType sft, EnumerationStat<?> stat2) {
        output.writeAscii(stat2.property());
        output.writeInt(stat2.enumeration().size(), true);
        Function1<Object, BoxedUnit> write = this.writer(output, sft.getDescriptor(stat2.property()).getType().getBinding());
        stat2.enumeration().foreach((Function1)new Serializable(output, write){
            public static final long serialVersionUID = 0L;
            private final Output output$2;
            private final Function1 write$1;

            public final int apply(Tuple2<Object, Object> x0$2) {
                Tuple2<Object, Object> tuple2 = x0$2;
                if (tuple2 != null) {
                    Object key2 = tuple2._1();
                    long count2 = tuple2._2$mcJ$sp();
                    this.write$1.apply(key2);
                    int n = this.output$2.writeLong(count2, true);
                    return n;
                }
                throw new MatchError(tuple2);
            }
            {
                this.output$2 = output$2;
                this.write$1 = write$1;
            }
        });
    }

    private EnumerationStat<?> readEnumeration(Input input, SimpleFeatureType sft, boolean immutable2, int version) {
        String string2;
        int n = version;
        switch (n) {
            default: {
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid group by serialization version: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)version)})));
            }
            case 1: {
                string2 = sft.getDescriptor(input.readInt(true)).getLocalName();
                break;
            }
            case 2: {
                string2 = input.readString();
            }
        }
        String attribute2 = string2;
        int size2 = input.readInt(true);
        Class binding = sft.getDescriptor(attribute2).getType().getBinding();
        Function0<Object> read = this.reader(input, binding);
        ClassTag classTag = ClassTag$.MODULE$.apply(binding);
        EnumerationStat stat2 = immutable2 ? new ImmutableStat(sft, attribute2, classTag){

            public void observe(SimpleFeature sf) {
                ImmutableStat$class.observe(this, sf);
            }

            public void unobserve(SimpleFeature sf) {
                ImmutableStat$class.unobserve(this, sf);
            }

            public void $plus$eq(Stat other) {
                ImmutableStat$class.$plus$eq(this, other);
            }

            public void clear() {
                ImmutableStat$class.clear(this);
            }
            {
                ImmutableStat$class.$init$(this);
            }
        } : new EnumerationStat(sft, attribute2, classTag);
        for (int i = 0; i < size2; ++i) {
            stat2.enumeration().update(read.apply(), (Object)BoxesRunTime.boxToLong((long)input.readLong(true)));
        }
        return stat2;
    }

    private void writeTopK(Output output, SimpleFeatureType sft, TopK<?> stat2) {
        output.writeAscii(stat2.property());
        output.writeInt(stat2.size(), true);
        Function1<Object, BoxedUnit> write = this.writer(output, sft.getDescriptor(stat2.property()).getType().getBinding());
        stat2.topK(Integer.MAX_VALUE).foreach((Function1)new Serializable(output, write){
            public static final long serialVersionUID = 0L;
            private final Output output$3;
            private final Function1 write$2;

            public final int apply(Tuple2<Object, Object> x0$3) {
                Tuple2<Object, Object> tuple2 = x0$3;
                if (tuple2 != null) {
                    Object item = tuple2._1();
                    long count2 = tuple2._2$mcJ$sp();
                    this.write$2.apply(item);
                    int n = this.output$3.writeLong(count2, true);
                    return n;
                }
                throw new MatchError(tuple2);
            }
            {
                this.output$3 = output$3;
                this.write$2 = write$2;
            }
        });
    }

    private TopK<?> readTopK(Input input, SimpleFeatureType sft, boolean immutable2, int version) {
        StreamSummary streamSummary;
        String string2;
        int n = version;
        switch (n) {
            default: {
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid top-k serialization version: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)version)})));
            }
            case 1: 
            case 2: {
                string2 = sft.getDescriptor(input.readInt(true)).getLocalName();
                break;
            }
            case 3: {
                string2 = input.readString();
            }
        }
        String attribute2 = string2;
        Class binding = sft.getDescriptor(attribute2).getType().getBinding();
        Function0<Object> read = this.reader(input, binding);
        if (version > 1) {
            int size2 = input.readInt(true);
            IndexedSeq counters = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), size2).map((Function1)new Serializable(input, read){
                public static final long serialVersionUID = 0L;
                private final Input input$2;
                private final Function0 read$1;

                public final Tuple2<Object, Object> apply(int x$2) {
                    return new Tuple2(this.read$1.apply(), (Object)BoxesRunTime.boxToLong((long)this.input$2.readLong(true)));
                }
                {
                    this.input$2 = input$2;
                    this.read$1 = read$1;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom());
            streamSummary = StreamSummary$.MODULE$.apply(TopK$.MODULE$.StreamCapacity(), counters);
        } else {
            byte[] summaryBytes = input.readBytes(input.readInt(true));
            com.clearspring.analytics.stream.StreamSummary clearspring = new com.clearspring.analytics.stream.StreamSummary(summaryBytes);
            StreamSummary geomesa = StreamSummary$.MODULE$.apply(TopK$.MODULE$.StreamCapacity());
            JavaConversions$.MODULE$.asScalaBuffer(clearspring.topK(clearspring.size())).foreach((Function1)new Serializable(geomesa){
                public static final long serialVersionUID = 0L;
                private final StreamSummary geomesa$1;

                public final boolean apply(Counter<Object> c) {
                    return this.geomesa$1.offer(c.getItem(), c.getCount());
                }
                {
                    this.geomesa$1 = geomesa$1;
                }
            });
            streamSummary = geomesa;
        }
        StreamSummary summary = streamSummary;
        return immutable2 ? new ImmutableStat(sft, attribute2, summary){

            public void observe(SimpleFeature sf) {
                ImmutableStat$class.observe(this, sf);
            }

            public void unobserve(SimpleFeature sf) {
                ImmutableStat$class.unobserve(this, sf);
            }

            public void $plus$eq(Stat other) {
                ImmutableStat$class.$plus$eq(this, other);
            }

            public void clear() {
                ImmutableStat$class.clear(this);
            }
            {
                ImmutableStat$class.$init$(this);
            }
        } : new TopK(sft, attribute2, summary);
    }

    private void writeHistogram(Output output, SimpleFeatureType sft, Histogram<?> stat2) {
        output.writeAscii(stat2.property());
        output.writeInt(stat2.length(), true);
        Function1<Object, BoxedUnit> write = this.writer(output, sft.getDescriptor(stat2.property()).getType().getBinding());
        write.apply(stat2.bounds()._1());
        write.apply(stat2.bounds()._2());
        this.org$locationtech$geomesa$utils$stats$KryoStatSerializer$$writeCountArray(output, stat2.bins().counts());
    }

    private Histogram<?> readHistogram(Input input, SimpleFeatureType sft, boolean immutable2, int version) {
        String string2;
        int n = version;
        switch (n) {
            default: {
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid group by serialization version: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)version)})));
            }
            case 1: {
                string2 = sft.getDescriptor(input.readInt(true)).getLocalName();
                break;
            }
            case 2: {
                string2 = input.readString();
            }
        }
        String attribute2 = string2;
        int length2 = input.readInt(true);
        Class binding = sft.getDescriptor(attribute2).getType().getBinding();
        Function0<Object> read = this.reader(input, binding);
        Object min = read.apply();
        Object max = read.apply();
        MinMax.MinMaxDefaults defaults = MinMax$MinMaxDefaults$.MODULE$.apply(binding);
        ClassTag classTag = ClassTag$.MODULE$.apply(binding);
        Histogram stat2 = immutable2 ? new ImmutableStat(sft, attribute2, length2, min, max, defaults, classTag){

            public void observe(SimpleFeature sf) {
                ImmutableStat$class.observe(this, sf);
            }

            public void unobserve(SimpleFeature sf) {
                ImmutableStat$class.unobserve(this, sf);
            }

            public void $plus$eq(Stat other) {
                ImmutableStat$class.$plus$eq(this, other);
            }

            public void clear() {
                ImmutableStat$class.clear(this);
            }
            {
                ImmutableStat$class.$init$(this);
            }
        } : new Histogram(sft, attribute2, length2, new Tuple2(min, max), defaults, classTag);
        this.readCountArray(input, stat2.bins().counts());
        return stat2;
    }

    private void writeZ3Histogram(Output output, SimpleFeatureType sft, Z3Histogram stat2) {
        output.writeAscii(stat2.geom());
        output.writeAscii(stat2.dtg());
        output.writeAscii(stat2.period().toString());
        output.writeInt(stat2.length(), true);
        Map bins = (Map)stat2.binMap().filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, BinnedLongArray> x$3) {
                return Predef$.MODULE$.longArrayOps(((BinnedArray)x$3._2()).counts()).exists((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(long x$4) {
                        return this.apply$mcZJ$sp(x$4);
                    }

                    public boolean apply$mcZJ$sp(long x$4) {
                        return x$4 != 0L;
                    }
                });
            }
        });
        output.writeInt(bins.size(), true);
        bins.foreach((Function1)new Serializable(output){
            public static final long serialVersionUID = 0L;
            private final Output output$5;

            public final void apply(Tuple2<Object, BinnedLongArray> x0$4) {
                Tuple2<Object, BinnedLongArray> tuple2 = x0$4;
                if (tuple2 != null) {
                    short w = BoxesRunTime.unboxToShort((Object)tuple2._1());
                    BinnedLongArray bin = (BinnedLongArray)tuple2._2();
                    this.output$5.writeShort((int)w);
                    KryoStatSerializer$.MODULE$.org$locationtech$geomesa$utils$stats$KryoStatSerializer$$writeCountArray(this.output$5, bin.counts());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.output$5 = output$5;
            }
        });
    }

    private Z3Histogram readZ3Histogram(Input input, SimpleFeatureType sft, boolean immutable2, int version) {
        Seq seq;
        int n = version;
        switch (n) {
            default: {
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid z3 histogram serialization version: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)version)})));
            }
            case 1: 
            case 2: {
                seq = (Seq)Seq$.MODULE$.fill(2, (Function0)new Serializable(input, sft){
                    public static final long serialVersionUID = 0L;
                    private final Input input$3;
                    private final SimpleFeatureType sft$10;

                    public final String apply() {
                        return this.sft$10.getDescriptor(this.input$3.readInt(true)).getLocalName();
                    }
                    {
                        this.input$3 = input$3;
                        this.sft$10 = sft$10;
                    }
                });
                break;
            }
            case 3: {
                seq = (Seq)Seq$.MODULE$.fill(2, (Function0)new Serializable(input){
                    public static final long serialVersionUID = 0L;
                    private final Input input$3;

                    public final String apply() {
                        return this.input$3.readString();
                    }
                    {
                        this.input$3 = input$3;
                    }
                });
            }
        }
        Seq seq2 = seq;
        Some some = Seq$.MODULE$.unapplySeq(seq2);
        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
            Tuple2 tuple2;
            String geom = (String)((SeqLike)some.get()).apply(0);
            String dtg = (String)((SeqLike)some.get()).apply(1);
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)geom, (Object)dtg);
            String geom2 = (String)tuple22._1();
            String dtg2 = (String)tuple22._2();
            Enumeration.Value period = version > 1 ? TimePeriod$.MODULE$.withName(input.readString()) : TimePeriod$.MODULE$.Week();
            int length2 = input.readInt(true);
            Z3Histogram stat2 = immutable2 ? new ImmutableStat(sft, geom2, dtg2, period, length2){

                public void observe(SimpleFeature sf) {
                    ImmutableStat$class.observe(this, sf);
                }

                public void unobserve(SimpleFeature sf) {
                    ImmutableStat$class.unobserve(this, sf);
                }

                public void $plus$eq(Stat other) {
                    ImmutableStat$class.$plus$eq(this, other);
                }

                public void clear() {
                    ImmutableStat$class.clear(this);
                }
                {
                    ImmutableStat$class.$init$(this);
                }
            } : new Z3Histogram(sft, geom2, dtg2, period, length2);
            int numWeeks = input.readInt(true);
            for (int week = 0; week < numWeeks; ++week) {
                BinnedLongArray bins = stat2.newBins();
                stat2.binMap().put((Object)BoxesRunTime.boxToShort((short)input.readShort()), (Object)bins);
                this.readCountArray(input, bins.counts());
            }
            return stat2;
        }
        throw new MatchError((Object)seq2);
    }

    private void writeFrequency(Output output, SimpleFeatureType sft, Frequency<?> stat2) {
        output.writeAscii(stat2.property());
        output.writeAscii((String)stat2.dtg().orNull(Predef$.MODULE$.$conforms()));
        output.writeAscii(stat2.period().toString());
        output.writeInt(stat2.precision(), true);
        output.writeDouble(stat2.eps());
        output.writeDouble(stat2.confidence());
        Map sketches = (Map)stat2.sketchMap().filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, CountMinSketch> x$6) {
                return ((CountMinSketch)x$6._2()).size() > 0L;
            }
        });
        output.writeInt(sketches.size(), true);
        sketches.foreach((Function1)new Serializable(output){
            public static final long serialVersionUID = 0L;
            private final Output output$4;

            public final int apply(Tuple2<Object, CountMinSketch> x0$5) {
                Tuple2<Object, CountMinSketch> tuple2 = x0$5;
                if (tuple2 != null) {
                    short w = BoxesRunTime.unboxToShort((Object)tuple2._1());
                    CountMinSketch sketch = (CountMinSketch)tuple2._2();
                    this.output$4.writeShort((int)w);
                    for (int i = 0; i < sketch.table().length; ++i) {
                        KryoStatSerializer$.MODULE$.org$locationtech$geomesa$utils$stats$KryoStatSerializer$$writeCountArray(this.output$4, sketch.table()[i]);
                    }
                    int n = this.output$4.writeLong(sketch.size(), true);
                    return n;
                }
                throw new MatchError(tuple2);
            }
            {
                this.output$4 = output$4;
            }
        });
    }

    private Frequency<?> readFrequency(Input input, SimpleFeatureType sft, boolean immutable2, int version) {
        Tuple2 tuple2;
        int n = version;
        switch (n) {
            default: {
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid frequency serialization version: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)version)})));
            }
            case 1: 
            case 2: {
                Tuple2 tuple22 = new Tuple2((Object)this.org$locationtech$geomesa$utils$stats$KryoStatSerializer$$name$1(input.readInt(true), sft), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)input.readInt(true))).filter((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(int x$7) {
                        return this.apply$mcZI$sp(x$7);
                    }

                    public boolean apply$mcZI$sp(int x$7) {
                        return x$7 != -1;
                    }
                }).map((Function1)new Serializable(sft){
                    public static final long serialVersionUID = 0L;
                    private final SimpleFeatureType sft$9;

                    public final String apply(int i) {
                        return KryoStatSerializer$.MODULE$.org$locationtech$geomesa$utils$stats$KryoStatSerializer$$name$1(i, this.sft$9);
                    }
                    {
                        this.sft$9 = sft$9;
                    }
                }));
                break;
            }
            case 3: {
                Tuple2 tuple22 = tuple2 = new Tuple2((Object)input.readString(), (Object)Option$.MODULE$.apply((Object)input.readString()));
            }
        }
        if (tuple2 != null) {
            Tuple2 tuple23;
            String attribute2 = (String)tuple2._1();
            Option dtg = (Option)tuple2._2();
            Tuple2 tuple24 = tuple23 = new Tuple2((Object)attribute2, (Object)dtg);
            String attribute3 = (String)tuple24._1();
            Option dtg2 = (Option)tuple24._2();
            Enumeration.Value period = version > 1 ? TimePeriod$.MODULE$.withName(input.readString()) : TimePeriod$.MODULE$.Week();
            int precision = input.readInt(true);
            double eps = input.readDouble();
            double confidence = input.readDouble();
            Class binding = sft.getDescriptor(attribute3).getType().getBinding();
            Frequency stat2 = immutable2 ? new ImmutableStat(sft, attribute3, dtg2, period, precision, eps, confidence, binding){

                public void observe(SimpleFeature sf) {
                    ImmutableStat$class.observe(this, sf);
                }

                public void unobserve(SimpleFeature sf) {
                    ImmutableStat$class.unobserve(this, sf);
                }

                public void $plus$eq(Stat other) {
                    ImmutableStat$class.$plus$eq(this, other);
                }

                public void clear() {
                    ImmutableStat$class.clear(this);
                }
                {
                    ImmutableStat$class.$init$(this);
                }
            } : new Frequency(sft, attribute3, (Option<String>)dtg2, period, precision, eps, confidence, ClassTag$.MODULE$.apply(binding));
            int sketchCount = input.readInt(true);
            for (int c = 0; c < sketchCount; ++c) {
                short week = input.readShort();
                CountMinSketch sketch = stat2.newSketch();
                stat2.sketchMap().put((Object)BoxesRunTime.boxToShort((short)week), (Object)sketch);
                for (int i = 0; i < sketch.table().length; ++i) {
                    this.readCountArray(input, sketch.table()[i]);
                }
                sketch._size_$eq(input.readLong(true));
            }
            return stat2;
        }
        throw new MatchError((Object)tuple2);
    }

    private void writeZ3Frequency(Output output, SimpleFeatureType sft, Z3Frequency stat2) {
        output.writeAscii(stat2.geom());
        output.writeAscii(stat2.dtg());
        output.writeAscii(stat2.period().toString());
        output.writeInt(stat2.precision(), true);
        output.writeDouble(stat2.eps());
        output.writeDouble(stat2.confidence());
        Map sketches = (Map)stat2.sketches().filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, CountMinSketch> x$9) {
                return ((CountMinSketch)x$9._2()).size() > 0L;
            }
        });
        output.writeInt(sketches.size(), true);
        sketches.foreach((Function1)new Serializable(output){
            public static final long serialVersionUID = 0L;
            private final Output output$6;

            public final int apply(Tuple2<Object, CountMinSketch> x0$6) {
                Tuple2<Object, CountMinSketch> tuple2 = x0$6;
                if (tuple2 != null) {
                    short w = BoxesRunTime.unboxToShort((Object)tuple2._1());
                    CountMinSketch sketch = (CountMinSketch)tuple2._2();
                    this.output$6.writeShort((int)w);
                    for (int i = 0; i < sketch.table().length; ++i) {
                        KryoStatSerializer$.MODULE$.org$locationtech$geomesa$utils$stats$KryoStatSerializer$$writeCountArray(this.output$6, sketch.table()[i]);
                    }
                    int n = this.output$6.writeLong(sketch.size(), true);
                    return n;
                }
                throw new MatchError(tuple2);
            }
            {
                this.output$6 = output$6;
            }
        });
    }

    private Z3Frequency readZ3Frequency(Input input, SimpleFeatureType sft, boolean immutable2, int version) {
        Seq seq;
        int n = version;
        switch (n) {
            default: {
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid frequency serialization version: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)version)})));
            }
            case 1: 
            case 2: {
                seq = (Seq)Seq$.MODULE$.fill(2, (Function0)new Serializable(input, sft){
                    public static final long serialVersionUID = 0L;
                    private final Input input$4;
                    private final SimpleFeatureType sft$11;

                    public final String apply() {
                        return this.sft$11.getDescriptor(this.input$4.readInt(true)).getLocalName();
                    }
                    {
                        this.input$4 = input$4;
                        this.sft$11 = sft$11;
                    }
                });
                break;
            }
            case 3: {
                seq = (Seq)Seq$.MODULE$.fill(2, (Function0)new Serializable(input){
                    public static final long serialVersionUID = 0L;
                    private final Input input$4;

                    public final String apply() {
                        return this.input$4.readString();
                    }
                    {
                        this.input$4 = input$4;
                    }
                });
            }
        }
        Seq seq2 = seq;
        Some some = Seq$.MODULE$.unapplySeq(seq2);
        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
            Tuple2 tuple2;
            String geom = (String)((SeqLike)some.get()).apply(0);
            String dtg = (String)((SeqLike)some.get()).apply(1);
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)geom, (Object)dtg);
            String geom2 = (String)tuple22._1();
            String dtg2 = (String)tuple22._2();
            Enumeration.Value period = version > 1 ? TimePeriod$.MODULE$.withName(input.readString()) : TimePeriod$.MODULE$.Week();
            int precision = input.readInt(true);
            double eps = input.readDouble();
            double confidence = input.readDouble();
            Z3Frequency stat2 = immutable2 ? new ImmutableStat(sft, geom2, dtg2, period, precision, eps, confidence){

                public void observe(SimpleFeature sf) {
                    ImmutableStat$class.observe(this, sf);
                }

                public void unobserve(SimpleFeature sf) {
                    ImmutableStat$class.unobserve(this, sf);
                }

                public void $plus$eq(Stat other) {
                    ImmutableStat$class.$plus$eq(this, other);
                }

                public void clear() {
                    ImmutableStat$class.clear(this);
                }
                {
                    ImmutableStat$class.$init$(this);
                }
            } : new Z3Frequency(sft, geom2, dtg2, period, precision, eps, confidence);
            int numSketches = input.readInt(true);
            for (int sketchCount = 0; sketchCount < numSketches; ++sketchCount) {
                CountMinSketch sketch = stat2.newSketch();
                stat2.sketches().put((Object)BoxesRunTime.boxToShort((short)input.readShort()), (Object)sketch);
                for (int i = 0; i < sketch.table().length; ++i) {
                    this.readCountArray(input, sketch.table()[i]);
                }
                sketch._size_$eq(input.readLong(true));
            }
            return stat2;
        }
        throw new MatchError((Object)seq2);
    }

    private void writeIteratorStackCount(Output output, IteratorStackCount stat2) {
        output.writeLong(stat2.counter(), true);
    }

    private IteratorStackCount readIteratorStackCount(Input input, SimpleFeatureType sft, boolean immutable2) {
        IteratorStackCount stat2 = immutable2 ? new ImmutableStat(sft){

            public void observe(SimpleFeature sf) {
                ImmutableStat$class.observe(this, sf);
            }

            public void unobserve(SimpleFeature sf) {
                ImmutableStat$class.unobserve(this, sf);
            }

            public void $plus$eq(Stat other) {
                ImmutableStat$class.$plus$eq(this, other);
            }

            public void clear() {
                ImmutableStat$class.clear(this);
            }
            {
                ImmutableStat$class.$init$(this);
            }
        } : new IteratorStackCount(sft);
        stat2.counter_$eq(input.readLong(true));
        return stat2;
    }

    public void org$locationtech$geomesa$utils$stats$KryoStatSerializer$$writeCountArray(Output output, long[] counts) {
        int i = 0;
        while (i < counts.length) {
            long count2 = counts[i];
            if (count2 == 0L) {
                Object object;
                int nextNonZero;
                for (nextNonZero = i + 1; nextNonZero < counts.length && counts[nextNonZero] == 0L; ++nextNonZero) {
                }
                int numZeros = nextNonZero - i;
                if (numZeros > 4) {
                    output.writeLong(Long.MAX_VALUE, true);
                    object = BoxesRunTime.boxToInteger((int)output.writeInt(numZeros, true));
                } else {
                    if (numZeros > 0) {
                        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numZeros).foreach((Function1)new Serializable(output){
                            public static final long serialVersionUID = 0L;
                            private final Output output$11;

                            public final int apply(int x$11) {
                                return this.apply$mcII$sp(x$11);
                            }

                            public int apply$mcII$sp(int x$11) {
                                return this.output$11.writeLong(0L, true);
                            }
                            {
                                this.output$11 = output$11;
                            }
                        });
                    }
                    object = BoxedUnit.UNIT;
                }
                i = nextNonZero;
                continue;
            }
            output.writeLong(count2, true);
            ++i;
        }
    }

    private void readCountArray(Input input, long[] counts) {
        int i = 0;
        while (i < counts.length) {
            long count2 = input.readLong(true);
            if (count2 == Long.MAX_VALUE) {
                i += input.readInt(true);
                continue;
            }
            counts[i] = count2;
            ++i;
        }
    }

    private Function1<Object, BoxedUnit> writer(Output output, Class<?> binding) {
        block9: {
            Object object;
            block3: {
                block8: {
                    block7: {
                        block6: {
                            block5: {
                                block4: {
                                    block2: {
                                        Class<?> clazz = binding;
                                        Class<String> clazz2 = String.class;
                                        if (clazz != null ? !clazz.equals(clazz2) : clazz2 != null) break block2;
                                        object = new Serializable(output){
                                            public static final long serialVersionUID = 0L;
                                            private final Output output$10;

                                            public final void apply(Object value2) {
                                                this.output$10.writeString((String)value2);
                                            }
                                            {
                                                this.output$10 = output$10;
                                            }
                                        };
                                        break block3;
                                    }
                                    Class<?> clazz = binding;
                                    Class<Integer> clazz3 = Integer.class;
                                    if (clazz != null ? !clazz.equals(clazz3) : clazz3 != null) break block4;
                                    object = new Serializable(output){
                                        public static final long serialVersionUID = 0L;
                                        private final Output output$10;

                                        public final void apply(Object value2) {
                                            this.output$10.writeInt(Predef$.MODULE$.Integer2int((Integer)value2), true);
                                        }
                                        {
                                            this.output$10 = output$10;
                                        }
                                    };
                                    break block3;
                                }
                                Class<?> clazz = binding;
                                Class<Long> clazz4 = Long.class;
                                if (clazz != null ? !clazz.equals(clazz4) : clazz4 != null) break block5;
                                object = new Serializable(output){
                                    public static final long serialVersionUID = 0L;
                                    private final Output output$10;

                                    public final void apply(Object value2) {
                                        this.output$10.writeLong(Predef$.MODULE$.Long2long((Long)value2), true);
                                    }
                                    {
                                        this.output$10 = output$10;
                                    }
                                };
                                break block3;
                            }
                            Class<?> clazz = binding;
                            Class<Float> clazz5 = Float.class;
                            if (clazz != null ? !clazz.equals(clazz5) : clazz5 != null) break block6;
                            object = new Serializable(output){
                                public static final long serialVersionUID = 0L;
                                private final Output output$10;

                                public final void apply(Object value2) {
                                    this.output$10.writeFloat(Predef$.MODULE$.Float2float((Float)value2));
                                }
                                {
                                    this.output$10 = output$10;
                                }
                            };
                            break block3;
                        }
                        Class<?> clazz = binding;
                        Class<Double> clazz6 = Double.class;
                        if (clazz != null ? !clazz.equals(clazz6) : clazz6 != null) break block7;
                        object = new Serializable(output){
                            public static final long serialVersionUID = 0L;
                            private final Output output$10;

                            public final void apply(Object value2) {
                                this.output$10.writeDouble(Predef$.MODULE$.Double2double((Double)value2));
                            }
                            {
                                this.output$10 = output$10;
                            }
                        };
                        break block3;
                    }
                    if (!Date.class.isAssignableFrom(binding)) break block8;
                    object = new Serializable(output){
                        public static final long serialVersionUID = 0L;
                        private final Output output$10;

                        public final void apply(Object value2) {
                            this.output$10.writeLong(((Date)value2).getTime(), true);
                        }
                        {
                            this.output$10 = output$10;
                        }
                    };
                    break block3;
                }
                if (!Geometry.class.isAssignableFrom(binding)) break block9;
                object = new Serializable(output){
                    public static final long serialVersionUID = 0L;
                    private final Output output$10;

                    public final void apply(Object value2) {
                        byte[] b1 = WKBUtils$.MODULE$.write((Geometry)value2);
                        this.output$10.writeInt(b1.length, true);
                        this.output$10.write(b1);
                    }
                    {
                        this.output$10 = output$10;
                    }
                };
            }
            return object;
        }
        throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot serialize stat due to invalid type: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{binding})));
    }

    private Function0<Object> reader(Input input, Class<?> binding) {
        block9: {
            Serializable serializable;
            block3: {
                block8: {
                    block7: {
                        block6: {
                            block5: {
                                block4: {
                                    block2: {
                                        Class<?> clazz = binding;
                                        Class<String> clazz2 = String.class;
                                        if (clazz != null ? !clazz.equals(clazz2) : clazz2 != null) break block2;
                                        serializable = new Serializable(input){
                                            public static final long serialVersionUID = 0L;
                                            private final Input input$6;

                                            public final String apply() {
                                                return this.input$6.readString();
                                            }
                                            {
                                                this.input$6 = input$6;
                                            }
                                        };
                                        break block3;
                                    }
                                    Class<?> clazz = binding;
                                    Class<Integer> clazz3 = Integer.class;
                                    if (clazz != null ? !clazz.equals(clazz3) : clazz3 != null) break block4;
                                    serializable = new Serializable(input){
                                        public static final long serialVersionUID = 0L;
                                        private final Input input$6;

                                        public final int apply() {
                                            return this.apply$mcI$sp();
                                        }

                                        public int apply$mcI$sp() {
                                            return this.input$6.readInt(true);
                                        }
                                        {
                                            this.input$6 = input$6;
                                        }
                                    };
                                    break block3;
                                }
                                Class<?> clazz = binding;
                                Class<Long> clazz4 = Long.class;
                                if (clazz != null ? !clazz.equals(clazz4) : clazz4 != null) break block5;
                                serializable = new Serializable(input){
                                    public static final long serialVersionUID = 0L;
                                    private final Input input$6;

                                    public final long apply() {
                                        return this.apply$mcJ$sp();
                                    }

                                    public long apply$mcJ$sp() {
                                        return this.input$6.readLong(true);
                                    }
                                    {
                                        this.input$6 = input$6;
                                    }
                                };
                                break block3;
                            }
                            Class<?> clazz = binding;
                            Class<Float> clazz5 = Float.class;
                            if (clazz != null ? !clazz.equals(clazz5) : clazz5 != null) break block6;
                            serializable = new Serializable(input){
                                public static final long serialVersionUID = 0L;
                                private final Input input$6;

                                public final float apply() {
                                    return this.apply$mcF$sp();
                                }

                                public float apply$mcF$sp() {
                                    return this.input$6.readFloat();
                                }
                                {
                                    this.input$6 = input$6;
                                }
                            };
                            break block3;
                        }
                        Class<?> clazz = binding;
                        Class<Double> clazz6 = Double.class;
                        if (clazz != null ? !clazz.equals(clazz6) : clazz6 != null) break block7;
                        serializable = new Serializable(input){
                            public static final long serialVersionUID = 0L;
                            private final Input input$6;

                            public final double apply() {
                                return this.apply$mcD$sp();
                            }

                            public double apply$mcD$sp() {
                                return this.input$6.readDouble();
                            }
                            {
                                this.input$6 = input$6;
                            }
                        };
                        break block3;
                    }
                    if (!Date.class.isAssignableFrom(binding)) break block8;
                    serializable = new Serializable(input){
                        public static final long serialVersionUID = 0L;
                        private final Input input$6;

                        public final Date apply() {
                            return new Date(this.input$6.readLong(true));
                        }
                        {
                            this.input$6 = input$6;
                        }
                    };
                    break block3;
                }
                if (!Geometry.class.isAssignableFrom(binding)) break block9;
                serializable = new Serializable(input){
                    public static final long serialVersionUID = 0L;
                    private final Input input$6;

                    public final Geometry apply() {
                        byte[] b = (byte[])Array$.MODULE$.ofDim(this.input$6.readInt(true), ClassTag$.MODULE$.Byte());
                        this.input$6.read(b);
                        return WKBUtils$.MODULE$.read(b);
                    }
                    {
                        this.input$6 = input$6;
                    }
                };
            }
            return serializable;
        }
        throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot deserialize stat due to invalid type: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{binding})));
    }

    private final void writeArray$1(double[] array, Output output$8) {
        Predef$.MODULE$.doubleArrayOps(array).foreach((Function1)new Serializable(output$8){
            public static final long serialVersionUID = 0L;
            private final Output output$8;

            public final void apply(double v) {
                this.apply$mcVD$sp(v);
            }

            public void apply$mcVD$sp(double v) {
                this.output$8.writeDouble(v);
            }
            {
                this.output$8 = output$8;
            }
        });
    }

    private final void readArray$1(double[] array, Input input$5) {
        Predef$.MODULE$.doubleArrayOps(array).indices().foreach$mVc$sp((Function1)new Serializable(input$5, array){
            public static final long serialVersionUID = 0L;
            private final Input input$5;
            private final double[] array$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.array$1[i] = this.input$5.readDouble();
            }
            {
                this.input$5 = input$5;
                this.array$1 = array$1;
            }
        });
    }

    private final Object getField$1(String name2, HyperLogLog clearspring$1) {
        Field field = clearspring$1.getClass().getDeclaredField(name2);
        field.setAccessible(true);
        return field.get(clearspring$1);
    }

    public final String org$locationtech$geomesa$utils$stats$KryoStatSerializer$$name$1(int i, SimpleFeatureType sft$9) {
        return sft$9.getDescriptor(i).getLocalName();
    }

    private KryoStatSerializer$() {
        MODULE$ = this;
        this.org$locationtech$geomesa$utils$stats$KryoStatSerializer$$inputs = new SoftThreadLocal();
        this.org$locationtech$geomesa$utils$stats$KryoStatSerializer$$outputs = new SoftThreadLocal();
        this.SeqStatByte = 0;
        this.CountByte = 1;
        this.IteratorStackByte = (byte)3;
        this.MinMaxByteV1 = (byte)2;
        this.MinMaxByteV2 = (byte)16;
        this.MinMaxByte = (byte)25;
        this.EnumerationByteV1 = (byte)4;
        this.EnumerationByte = (byte)17;
        this.HistogramByteV1 = (byte)5;
        this.HistogramByte = (byte)18;
        this.FrequencyByteV1 = (byte)6;
        this.FrequencyByteV2 = (byte)10;
        this.FrequencyByte = (byte)19;
        this.Z3HistogramByteV1 = (byte)7;
        this.Z3HistogramByteV2 = (byte)11;
        this.Z3HistogramByte = (byte)20;
        this.Z3FrequencyByteV1 = (byte)8;
        this.Z3FrequencyByteV2 = (byte)12;
        this.Z3FrequencyByte = (byte)21;
        this.DescriptiveStatByteV1 = (byte)13;
        this.DescriptiveStatByte = (byte)22;
        this.GroupByByteV1 = (byte)14;
        this.GroupByByte = (byte)23;
        this.TopKByteV1 = (byte)9;
        this.TopKByteV2 = (byte)15;
        this.TopKByte = (byte)24;
    }
}

