/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.cassandra.data;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.exceptions.AlreadyExistsException;
import com.datastax.driver.core.querybuilder.Select;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.geotools.factory.Hints;
import org.locationtech.geomesa.cassandra.data.CassandraDataStore;
import org.locationtech.geomesa.cassandra.data.CassandraIndexAdapter$;
import org.locationtech.geomesa.cassandra.data.CassandraQueryPlan;
import org.locationtech.geomesa.cassandra.data.EmptyPlan;
import org.locationtech.geomesa.cassandra.data.StatementPlan;
import org.locationtech.geomesa.cassandra.index.CassandraColumnMapper;
import org.locationtech.geomesa.cassandra.index.CassandraColumnMapper$;
import org.locationtech.geomesa.cassandra.package;
import org.locationtech.geomesa.features.SerializationOption;
import org.locationtech.geomesa.features.kryo.KryoFeatureSerializer;
import org.locationtech.geomesa.features.kryo.KryoFeatureSerializer$;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex$;
import org.locationtech.geomesa.index.api.IndexAdapter;
import org.locationtech.geomesa.index.api.WritableFeature;
import org.locationtech.geomesa.index.api.WritableFeature$;
import org.locationtech.geomesa.index.api.package;
import org.locationtech.geomesa.index.conf.ColumnGroups;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.index.planning.LocalQueryRunner;
import org.locationtech.geomesa.index.planning.LocalQueryRunner$;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.locationtech.geomesa.utils.text.StringSerialization$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple5;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Builder;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t]e\u0001B\u0001\u0003\u00015\u0011QcQ1tg\u0006tGM]1J]\u0012,\u00070\u00113baR,'O\u0003\u0002\u0004\t\u0005!A-\u0019;b\u0015\t)a!A\u0005dCN\u001c\u0018M\u001c3sC*\u0011q\u0001C\u0001\bO\u0016|W.Z:b\u0015\tI!\"\u0001\u0007m_\u000e\fG/[8oi\u0016\u001c\u0007NC\u0001\f\u0003\ry'oZ\u0002\u0001'\u0011\u0001a\u0002\u0006\u0011\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g!\r)\"\u0004H\u0007\u0002-)\u0011q\u0003G\u0001\u0004CBL'BA\r\u0007\u0003\u0015Ig\u000eZ3y\u0013\tYbC\u0001\u0007J]\u0012,\u00070\u00113baR,'\u000f\u0005\u0002\u001e=5\t!!\u0003\u0002 \u0005\t\u00112)Y:tC:$'/\u0019#bi\u0006\u001cFo\u001c:f!\t\t\u0003&D\u0001#\u0015\t\u0019C%\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u0002&M\u0005AA/\u001f9fg\u00064WMC\u0001(\u0003\r\u0019w.\\\u0005\u0003S\t\u0012Qb\u0015;sS\u000e$Hj\\4hS:<\u0007\u0002C\u0016\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000f\u0002\u0005\u0011\u001c\b\"B\u0017\u0001\t\u0003q\u0013A\u0002\u001fj]&$h\b\u0006\u00020aA\u0011Q\u0004\u0001\u0005\u0006W1\u0002\r\u0001\b\u0005\u0006e\u0001!\teM\u0001\fGJ,\u0017\r^3UC\ndW\r\u0006\u00035o)3\u0006CA\b6\u0013\t1\u0004C\u0001\u0003V]&$\b\"B\r2\u0001\u0004A\u0004gA\u001d?\u0011B!QC\u000f\u001fH\u0013\tYdCA\nHK>lUm]1GK\u0006$XO]3J]\u0012,\u0007\u0010\u0005\u0002>}1\u0001A!C 8\u0003\u0003\u0005\tQ!\u0001A\u0005\ryF%M\t\u0003\u0003\u0012\u0003\"a\u0004\"\n\u0005\r\u0003\"a\u0002(pi\"Lgn\u001a\t\u0003\u001f\u0015K!A\u0012\t\u0003\u0007\u0005s\u0017\u0010\u0005\u0002>\u0011\u0012I\u0011jNA\u0001\u0002\u0003\u0015\t\u0001\u0011\u0002\u0004?\u0012\u0012\u0004\"B&2\u0001\u0004a\u0015!\u00039beRLG/[8o!\ryQjT\u0005\u0003\u001dB\u0011aa\u00149uS>t\u0007C\u0001)T\u001d\ty\u0011+\u0003\u0002S!\u00051\u0001K]3eK\u001aL!\u0001V+\u0003\rM#(/\u001b8h\u0015\t\u0011\u0006\u0003\u0003\u0004Xc\u0011\u0005\r\u0001W\u0001\u0007gBd\u0017\u000e^:\u0011\u0007=I6,\u0003\u0002[!\tAAHY=oC6,g\bE\u0002]I\u001et!!\u00182\u000f\u0005y\u000bW\"A0\u000b\u0005\u0001d\u0011A\u0002\u001fs_>$h(C\u0001\u0012\u0013\t\u0019\u0007#A\u0004qC\u000e\\\u0017mZ3\n\u0005\u00154'aA*fc*\u00111\r\u0005\t\u0004\u001f!T\u0017BA5\u0011\u0005\u0015\t%O]1z!\ty1.\u0003\u0002m!\t!!)\u001f;f\u0011\u0015q\u0007\u0001\"\u0011p\u00031!W\r\\3uKR\u000b'\r\\3t)\t!\u0004\u000fC\u0003r[\u0002\u0007!/\u0001\u0004uC\ndWm\u001d\t\u00049\u0012|\u0005\"\u0002;\u0001\t\u0003*\u0018aC2mK\u0006\u0014H+\u00192mKN$2\u0001\u000e<x\u0011\u0015\t8\u000f1\u0001s\u0011\u0015A8\u000f1\u0001z\u0003\u0019\u0001(/\u001a4jqB\u0019q\"T4\t\u000bm\u0004A\u0011\t?\u0002\u001f\r\u0014X-\u0019;f#V,'/\u001f)mC:$2!`A\u0001!\tib0\u0003\u0002\u0000\u0005\t\u00112)Y:tC:$'/Y)vKJL\b\u000b\\1o\u0011\u001d\t\u0019A\u001fa\u0001\u0003\u000b\t\u0001b\u001d;sCR,w-\u001f\t\u0005\u0003\u000f\tyB\u0004\u0003\u0002\n\u0005ua\u0002BA\u0006\u00037qA!!\u0004\u0002\u001a9!\u0011qBA\f\u001d\u0011\t\t\"!\u0006\u000f\u0007y\u000b\u0019\"C\u0001\f\u0013\tI!\"\u0003\u0002\b\u0011%\u0011\u0011DB\u0005\u0003/aI!a\u0019\f\n\t\u0005\u0005\u00121\u0005\u0002\u000e#V,'/_*ue\u0006$XmZ=\u000b\u0005\r4\u0002bBA\u0014\u0001\u0011\u0005\u0013\u0011F\u0001\rGJ,\u0017\r^3Xe&$XM\u001d\u000b\t\u0003W\u0011YG!!\u0003\u0016B!\u0011QFA?\u001d\u0011\ty#a\u000e\u000f\t\u0005E\u0012Q\u0007\b\u0005\u0003\u001b\t\u0019$\u0003\u0002\u0006\r%\u00111\u0001B\u0004\b\u0003s\u0011\u0001\u0012AA\u001e\u0003U\u0019\u0015m]:b]\u0012\u0014\u0018-\u00138eKb\fE-\u00199uKJ\u00042!HA\u001f\r\u0019\t!\u0001#\u0001\u0002@M\u0019\u0011Q\b\b\t\u000f5\ni\u0004\"\u0001\u0002DQ\u0011\u00111\b\u0005\t\u0003\u000f\ni\u0004\"\u0001\u0002J\u0005I1\u000f^1uK6,g\u000e\u001e\u000b\t\u0003\u0017\n\u0019'a\u001a\u0002lA!\u0011QJA0\u001b\t\tyE\u0003\u0003\u0002R\u0005M\u0013\u0001D9vKJL(-^5mI\u0016\u0014(\u0002BA+\u0003/\nAaY8sK*!\u0011\u0011LA.\u0003\u0019!'/\u001b<fe*\u0019\u0011Q\f\u0014\u0002\u0011\u0011\fG/Y:uCbLA!!\u0019\u0002P\t11+\u001a7fGRDq!!\u001a\u0002F\u0001\u0007q*\u0001\u0005lKf\u001c\b/Y2f\u0011\u001d\tI'!\u0012A\u0002=\u000bQ\u0001^1cY\u0016D\u0001\"!\u001c\u0002F\u0001\u0007\u0011qN\u0001\tGJLG/\u001a:jCB!A\fZA9!\u0011\t\u0019(a\u001e\u000f\t\u0005E\u0012QO\u0005\u0003G\u0012IA!!\u001f\u0002|\ta1i\u001c7v[:\u001cV\r\\3di*\u00111\r\u0002\u0004\b\u0003\u007f\ni\u0004AAA\u0005Q\u0019\u0015m]:b]\u0012\u0014\u0018-\u00138eKb<&/\u001b;feN)\u0011QPABAA!\u0011QQAF\u001d\u0011\tI!a\"\n\u0007\u0005%e#\u0001\u0007J]\u0012,\u00070\u00113baR,'/\u0003\u0003\u0002\u000e\u0006=%aC%oI\u0016DxK]5uKJT1!!#\u0017\u0011%Y\u0013Q\u0010B\u0001B\u0003%A\u0004C\u0007\u0002\u0016\u0006u$\u0011!Q\u0001\n\u0005]\u0015\u0011V\u0001\bS:$\u0017nY3t!\u0011aF-!'1\r\u0005m\u0015qTAS!\u0019)\"(!(\u0002$B\u0019Q(a(\u0005\u0017\u0005\u0005\u00161SA\u0001\u0002\u0003\u0015\t\u0001\u0011\u0002\u0004?\u0012*\u0004cA\u001f\u0002&\u0012Y\u0011qUAJ\u0003\u0003\u0005\tQ!\u0001A\u0005\ryFEN\u0005\u0005\u0003+\u000bY\tC\u0006\u0002.\u0006u$\u0011!Q\u0001\n\u0005=\u0016aB<sCB\u0004XM\u001d\t\u0005\u0003c\u000b9L\u0004\u0003\u0002\n\u0005M\u0016bAA[-\u0005yqK]5uC\ndWMR3biV\u0014X-\u0003\u0003\u0002:\u0006m&A\u0004$fCR,(/Z,sCB\u0004XM\u001d\u0006\u0004\u0003k3\u0002\"C&\u0002~\t\u0005\t\u0015!\u0003M\u0011\u001di\u0013Q\u0010C\u0001\u0003\u0003$\"\"a1\u0002H\u0006%\u0017\u0011\\An!\u0011\t)-! \u000e\u0005\u0005u\u0002BB\u0016\u0002@\u0002\u0007A\u0004\u0003\u0005\u0002\u0016\u0006}\u0006\u0019AAf!\u0011aF-!41\r\u0005=\u00171[Al!\u0019)\"(!5\u0002VB\u0019Q(a5\u0005\u0017\u0005\u0005\u0016\u0011ZA\u0001\u0002\u0003\u0015\t\u0001\u0011\t\u0004{\u0005]GaCAT\u0003\u0013\f\t\u0011!A\u0003\u0002\u0001C\u0001\"!,\u0002@\u0002\u0007\u0011q\u0016\u0005\u0007\u0017\u0006}\u0006\u0019\u0001'\t\u0015\u0005}\u0017Q\u0010b\u0001\n\u0013\t\t/A\u0004nCB\u0004XM]:\u0016\u0005\u0005\r\b\u0003B\bi\u0003K\u0004\u0012bDAt\u0003W\f)0!>\n\u0007\u0005%\bC\u0001\u0004UkBdWm\r\t\u0005\u0003[\f\t0\u0004\u0002\u0002p*\u0011\u0011\u0004B\u0005\u0005\u0003g\fyOA\u000bDCN\u001c\u0018M\u001c3sC\u000e{G.^7o\u001b\u0006\u0004\b/\u001a:\u0011\t\u0005]\u0018\u0011`\u0007\u0003\u0003'JA!a?\u0002T\t\t\u0002K]3qCJ,Gm\u0015;bi\u0016lWM\u001c;\t\u0013\u0005}\u0018Q\u0010Q\u0001\n\u0005\r\u0018\u0001C7baB,'o\u001d\u0011\t\u0015\t\r\u0011Q\u0010a\u0001\n\u0013\u0011)!A\u0001j+\t\u00119\u0001E\u0002\u0010\u0005\u0013I1Aa\u0003\u0011\u0005\rIe\u000e\u001e\u0005\u000b\u0005\u001f\ti\b1A\u0005\n\tE\u0011!B5`I\u0015\fHc\u0001\u001b\u0003\u0014!Q!Q\u0003B\u0007\u0003\u0003\u0005\rAa\u0002\u0002\u0007a$\u0013\u0007C\u0005\u0003\u001a\u0005u\u0004\u0015)\u0003\u0003\b\u0005\u0011\u0011\u000e\t\u0005\t\u0005;\ti\b\"\u0015\u0003 \u0005)qO]5uKR)AG!\t\u0003,!A!1\u0005B\u000e\u0001\u0004\u0011)#A\u0004gK\u0006$XO]3\u0011\u0007U\u00119#C\u0002\u0003*Y\u0011qb\u0016:ji\u0006\u0014G.\u001a$fCR,(/\u001a\u0005\t\u0005[\u0011Y\u00021\u0001\u00030\u00051a/\u00197vKN\u0004Ba\u00045\u00032A\"!1\u0007B\u001e!\u0019\t9A!\u000e\u0003:%!!qGA\u0012\u0005-\u0011vn^&fsZ\u000bG.^3\u0011\u0007u\u0012Y\u0004B\u0006\u0003>\t-\u0012\u0011!A\u0001\u0006\u0003\u0001%aA0%o!A!\u0011IA?\t#\u0012\u0019%\u0001\u0004eK2,G/\u001a\u000b\u0006i\t\u0015#q\t\u0005\t\u0005G\u0011y\u00041\u0001\u0003&!A!Q\u0006B \u0001\u0004\u0011I\u0005\u0005\u0003\u0010Q\n-\u0003\u0007\u0002B'\u0005#\u0002b!a\u0002\u00036\t=\u0003cA\u001f\u0003R\u0011Y!1\u000bB$\u0003\u0003\u0005\tQ!\u0001A\u0005\ryF\u0005\u000f\u0005\t\u0005/\ni\b\"\u0011\u0003Z\u0005)a\r\\;tQR\tA\u0007\u0003\u0005\u0003^\u0005uD\u0011\tB-\u0003\u0015\u0019Gn\\:f\u0011!\u0011\t'!\u0010\u0005\n\t\r\u0014!\u00023fEV<GcA(\u0003f!A!q\rB0\u0001\u0004\u0011I'\u0001\u0005cS:$\u0017N\\4t!\raFM\u0004\u0005\t\u0005[\n)\u00031\u0001\u0003p\u0005\u00191O\u001a;\u0011\t\tE$QP\u0007\u0003\u0005gRAA!\u001e\u0003x\u000511/[7qY\u0016TAAa\t\u0003z)\u0019!1\u0010\u0006\u0002\u000f=\u0004XM\\4jg&!!q\u0010B:\u0005E\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sKRK\b/\u001a\u0005\t\u0003+\u000b)\u00031\u0001\u0003\u0004B!A\f\u001aBCa\u0019\u00119Ia#\u0003\u0012B1QC\u000fBE\u0005\u001f\u00032!\u0010BF\t-\u0011iI!!\u0002\u0002\u0003\u0005)\u0011\u0001!\u0003\u0007}#3\u0007E\u0002>\u0005##1Ba%\u0003\u0002\u0006\u0005\t\u0011!B\u0001\u0001\n\u0019q\f\n\u001b\t\u0011-\u000b)\u0003%AA\u00021\u0003")
public class CassandraIndexAdapter
implements IndexAdapter<CassandraDataStore>,
StrictLogging {
    public final CassandraDataStore org$locationtech$geomesa$cassandra$data$CassandraIndexAdapter$$ds;
    private final Logger logger;
    private final ColumnGroups groups;

    public static Select statement(String string, String string2, Seq<package.ColumnSelect> seq) {
        return CassandraIndexAdapter$.MODULE$.statement(string, string2, seq);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public ColumnGroups groups() {
        return this.groups;
    }

    public void org$locationtech$geomesa$index$api$IndexAdapter$_setter_$groups_$eq(ColumnGroups x$1) {
        this.groups = x$1;
    }

    public Option<String> createWriter$default$3() {
        return IndexAdapter.class.createWriter$default$3((IndexAdapter)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void createTable(GeoMesaFeatureIndex<?, ?> index, Option<String> partition, Function0<Seq<byte[]>> splits) {
        BoxedUnit boxedUnit;
        Tuple2 tuple22;
        String key = index.tableNameKey(partition);
        String table = (String)this.org$locationtech$geomesa$cassandra$data$CassandraIndexAdapter$$ds.metadata().read(index.sft().getTypeName(), key, this.org$locationtech$geomesa$cassandra$data$CassandraIndexAdapter$$ds.metadata().read$default$3()).getOrElse((Function0)new Serializable(this, index, partition, key){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CassandraIndexAdapter $outer;
            public final GeoMesaFeatureIndex index$1;
            private final Option partition$1;
            private final String key$1;

            /*
             * WARNING - void declaration
             */
            public final String apply() {
                void var3_3;
                Builder builder = Seq$.MODULE$.newBuilder();
                builder.$plus$eq((Object)this.$outer.org$locationtech$geomesa$cassandra$data$CassandraIndexAdapter$$ds.config().catalog());
                builder.$plus$plus$eq((TraversableOnce)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.index$1.sft().getTypeName(), this.index$1.name()}))).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String input) {
                        return StringSerialization$.MODULE$.alphaNumericSafeString(input);
                    }
                }, Seq$.MODULE$.canBuildFrom()));
                builder.$plus$plus$eq((TraversableOnce)this.index$1.attributes().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$1 $outer;

                    public final String apply(String a) {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.index$1.sft().indexOf(a))}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Seq$.MODULE$.canBuildFrom()));
                builder.$plus$eq((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"v", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.index$1.version())})));
                String base = ((TraversableOnce)builder.result()).mkString("_");
                String name = (String)this.partition$1.map((Function1)new Serializable(this, base){
                    public static final long serialVersionUID = 0L;
                    private final String base$1;

                    public final String apply(String p) {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "_", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.base$1, p}));
                    }
                    {
                        this.base$1 = base$1;
                    }
                }).getOrElse((Function0)new Serializable(this, base){
                    public static final long serialVersionUID = 0L;
                    private final String base$1;

                    public final String apply() {
                        return this.base$1;
                    }
                    {
                        this.base$1 = base$1;
                    }
                });
                if (name.length() > 48) {
                    BoxedUnit boxedUnit;
                    if (this.$outer.logger().underlying().isWarnEnabled()) {
                        this.$outer.logger().underlying().warn("Table name length exceeds Cassandra limit, falling back to UUID: {}", new Object[]{name});
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    name = new StringBuilder().append((Object)"gm_").append((Object)new StringOps(Predef$.MODULE$.augmentString(UUID.randomUUID().toString())).replaceAllLiterally("-", "")).toString();
                }
                this.$outer.org$locationtech$geomesa$cassandra$data$CassandraIndexAdapter$$ds.metadata().insert(this.index$1.sft().getTypeName(), this.key$1, (Object)name);
                return var3_3;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.index$1 = index$1;
                this.partition$1 = partition$1;
                this.key$1 = key$1;
            }
        });
        Cluster cluster = this.org$locationtech$geomesa$cassandra$data$CassandraIndexAdapter$$ds.session().getCluster();
        if (cluster.getMetadata().getKeyspace(this.org$locationtech$geomesa$cassandra$data$CassandraIndexAdapter$$ds.session().getLoggedKeyspace()).getTable(table) != null) return;
        Seq<package.NamedColumn> columns = CassandraColumnMapper$.MODULE$.apply(index).columns();
        Tuple2 tuple2 = columns.partition((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(package.NamedColumn x$1) {
                return x$1.partition();
            }
        });
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Seq partitions = (Seq)tuple2._1();
        Seq pks = (Seq)tuple2._2();
        Tuple2 tuple23 = tuple22 = new Tuple2((Object)partitions, (Object)pks);
        Seq partitions2 = (Seq)tuple23._1();
        Seq pks2 = (Seq)tuple23._2();
        String create = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CREATE TABLE ", " (", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table, ((TraversableOnce)columns.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(package.NamedColumn c) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{c.name(), c.cType()}));
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(", ")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PRIMARY KEY (", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)partitions2.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(package.NamedColumn x$3) {
                return x$3.name();
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString("(", ", ", ")")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{pks2.nonEmpty() ? ((TraversableOnce)pks2.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(package.NamedColumn x$4) {
                return x$4.name();
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(", ", ", ", "") : ""}))).toString();
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(create);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        try {
            this.org$locationtech$geomesa$cassandra$data$CassandraIndexAdapter$$ds.session().execute(create);
            return;
        }
        catch (AlreadyExistsException alreadyExistsException) {}
    }

    public void deleteTables(Seq<String> tables) {
        tables.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CassandraIndexAdapter $outer;

            public final ResultSet apply(String table) {
                BoxedUnit boxedUnit;
                String delete2 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DROP TABLE IF EXISTS ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table}));
                if (this.$outer.logger().underlying().isDebugEnabled()) {
                    this.$outer.logger().underlying().debug(delete2);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return this.$outer.org$locationtech$geomesa$cassandra$data$CassandraIndexAdapter$$ds.session().execute(delete2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void clearTables(Seq<String> tables, Option<byte[]> prefix) {
        if (prefix.isDefined()) {
            throw new IllegalArgumentException("Received a range in `clearTables` but table sharing should be disabled");
        }
        tables.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CassandraIndexAdapter $outer;

            public final ResultSet apply(String table) {
                BoxedUnit boxedUnit;
                String truncate = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TRUNCATE ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table}));
                if (this.$outer.logger().underlying().isDebugEnabled()) {
                    this.$outer.logger().underlying().debug(truncate);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return this.$outer.org$locationtech$geomesa$cassandra$data$CassandraIndexAdapter$$ds.session().execute(truncate);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public CassandraQueryPlan createQueryPlan(package.QueryStrategy strategy) {
        package.QueryStrategy queryStrategy = strategy;
        if (queryStrategy != null) {
            CassandraQueryPlan cassandraQueryPlan;
            Tuple5 tuple5;
            package.FilterStrategy filter = queryStrategy.filter();
            Seq keyRanges = queryStrategy.keyRanges();
            Seq tieredKeyRanges = queryStrategy.tieredKeyRanges();
            Option ecql = queryStrategy.ecql();
            Hints hints = queryStrategy.hints();
            Tuple5 tuple52 = tuple5 = new Tuple5((Object)filter, (Object)keyRanges, (Object)tieredKeyRanges, (Object)ecql, (Object)hints);
            package.FilterStrategy filter2 = (package.FilterStrategy)tuple52._1();
            Seq keyRanges2 = (Seq)tuple52._2();
            Seq tieredKeyRanges2 = (Seq)tuple52._3();
            Option ecql2 = (Option)tuple52._4();
            Hints hints2 = (Hints)tuple52._5();
            if (keyRanges2.isEmpty()) {
                cassandraQueryPlan = new EmptyPlan(filter2);
            } else {
                String ks = this.org$locationtech$geomesa$cassandra$data$CassandraIndexAdapter$$ds.session().getLoggedKeyspace();
                CassandraColumnMapper mapper = CassandraColumnMapper$.MODULE$.apply(strategy.index());
                Seq ranges = (Seq)keyRanges2.flatMap((Function1)new Serializable(this, tieredKeyRanges2, mapper){
                    public static final long serialVersionUID = 0L;
                    private final Seq tieredKeyRanges$1;
                    private final CassandraColumnMapper mapper$1;

                    public final Seq<package.RowSelect> apply(package.ScanRange<?> x$6) {
                        return this.mapper$1.select(x$6, (Seq<package.ByteRange>)this.tieredKeyRanges$1);
                    }
                    {
                        this.tieredKeyRanges$1 = tieredKeyRanges$1;
                        this.mapper$1 = mapper$1;
                    }
                }, Seq$.MODULE$.canBuildFrom());
                Seq tables = strategy.index().getTablesForQuery(filter2.filter());
                Seq statements = (Seq)tables.flatMap((Function1)new Serializable(this, ks, ranges){
                    public static final long serialVersionUID = 0L;
                    public final String ks$1;
                    private final Seq ranges$1;

                    public final Seq<Select> apply(String table) {
                        return (Seq)this.ranges$1.map((Function1)new Serializable(this, table){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$9 $outer;
                            private final String table$1;

                            public final Select apply(package.RowSelect r) {
                                return CassandraIndexAdapter$.MODULE$.statement(this.$outer.ks$1, this.table$1, r.clauses());
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.table$1 = table$1;
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                    }
                    {
                        this.ks$1 = ks$1;
                        this.ranges$1 = ranges$1;
                    }
                }, Seq$.MODULE$.canBuildFrom());
                KryoFeatureSerializer serializer = KryoFeatureSerializer$.MODULE$.apply(strategy.index().sft(), SerializationOption.SerializationOptions$.MODULE$.builder().lazy().withoutId().build());
                Function4 idSerializer = GeoMesaFeatureIndex$.MODULE$.idFromBytes(strategy.index().sft());
                Some hook = new Some((Object)new LocalQueryRunner.ArrowDictionaryHook(this.org$locationtech$geomesa$cassandra$data$CassandraIndexAdapter$$ds.stats(), filter2.filter()));
                Serializable transform = new Serializable(this, strategy, hints2, hook){
                    public static final long serialVersionUID = 0L;
                    private final package.QueryStrategy strategy$1;
                    private final Hints hints$1;
                    private final Some hook$1;

                    public final CloseableIterator<SimpleFeature> apply(CloseableIterator<SimpleFeature> x$7) {
                        return LocalQueryRunner$.MODULE$.transform(this.strategy$1.index().sft(), x$7, QueryHints$.MODULE$.RichHints(this.hints$1).getTransform(), this.hints$1, (Option)this.hook$1);
                    }
                    {
                        this.strategy$1 = strategy$1;
                        this.hints$1 = hints$1;
                        this.hook$1 = hook$1;
                    }
                };
                Serializable rowsToFeatures = new Serializable(this, ecql2, serializer, idSerializer, (Function1)transform){
                    public static final long serialVersionUID = 0L;
                    private final Option ecql$1;
                    public final KryoFeatureSerializer serializer$1;
                    public final Function4 idSerializer$1;
                    private final Function1 transform$1;

                    public final CloseableIterator<SimpleFeature> apply(CloseableIterator<Row> rows) {
                        Option option;
                        block4: {
                            CloseableIterator closeableIterator;
                            block3: {
                                CloseableIterator features;
                                block2: {
                                    features = rows.map((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ $anonfun$11 $outer;

                                        public final SimpleFeature apply(Row row) {
                                            byte[] bytes = ((String)row.get(CassandraColumnMapper$.MODULE$.FeatureIdColumnName(), String.class)).getBytes(StandardCharsets.UTF_8);
                                            String fid = (String)this.$outer.idSerializer$1.apply((Object)bytes, (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)bytes.length), null);
                                            ByteBuffer sf = row.getBytes(CassandraColumnMapper$.MODULE$.SimpleFeatureColumnName());
                                            byte[] bytes2 = (byte[])Array$.MODULE$.ofDim(sf.limit(), ClassTag$.MODULE$.Byte());
                                            sf.get(bytes2);
                                            return this.$outer.serializer$1.deserialize(fid, bytes2);
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                        }
                                    });
                                    option = this.ecql$1;
                                    if (!None$.MODULE$.equals(option)) break block2;
                                    closeableIterator = (CloseableIterator)this.transform$1.apply((Object)features);
                                    break block3;
                                }
                                if (!(option instanceof Some)) break block4;
                                Some some = (Some)option;
                                Filter e = (Filter)some.x();
                                closeableIterator = (CloseableIterator)this.transform$1.apply((Object)features.filter((Function1)new Serializable(this, e){
                                    public static final long serialVersionUID = 0L;
                                    private final Filter e$1;

                                    public final boolean apply(Object x$1) {
                                        return this.e$1.evaluate(x$1);
                                    }
                                    {
                                        this.e$1 = e$1;
                                    }
                                }));
                            }
                            return closeableIterator;
                        }
                        throw new MatchError((Object)option);
                    }
                    {
                        this.ecql$1 = ecql$1;
                        this.serializer$1 = serializer$1;
                        this.idSerializer$1 = idSerializer$1;
                        this.transform$1 = transform$1;
                    }
                };
                cassandraQueryPlan = new StatementPlan(filter2, (Seq<String>)tables, (Seq<Statement>)statements, this.org$locationtech$geomesa$cassandra$data$CassandraIndexAdapter$$ds.config().queryThreads(), (Option<Filter>)ecql2, (Function1<CloseableIterator<Row>, CloseableIterator<SimpleFeature>>)rowsToFeatures);
            }
            return cassandraQueryPlan;
        }
        throw new MatchError((Object)queryStrategy);
    }

    public CassandraIndexWriter createWriter(SimpleFeatureType sft, Seq<GeoMesaFeatureIndex<?, ?>> indices, Option<String> partition) {
        return new CassandraIndexWriter(this.org$locationtech$geomesa$cassandra$data$CassandraIndexAdapter$$ds, indices, WritableFeature$.MODULE$.wrapper(sft, this.groups()), partition);
    }

    public CassandraIndexAdapter(CassandraDataStore ds) {
        this.org$locationtech$geomesa$cassandra$data$CassandraIndexAdapter$$ds = ds;
        IndexAdapter.class.$init$((IndexAdapter)this);
        StrictLogging.class.$init$((StrictLogging)this);
    }

    public static class CassandraIndexWriter
    extends IndexAdapter.IndexWriter
    implements StrictLogging {
        public final CassandraDataStore org$locationtech$geomesa$cassandra$data$CassandraIndexAdapter$CassandraIndexWriter$$ds;
        public final Option<String> org$locationtech$geomesa$cassandra$data$CassandraIndexAdapter$CassandraIndexWriter$$partition;
        private final Tuple3<CassandraColumnMapper, PreparedStatement, PreparedStatement>[] mappers;
        private int i;
        private final Logger logger;

        public Logger logger() {
            return this.logger;
        }

        public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
            this.logger = x$1;
        }

        private Tuple3<CassandraColumnMapper, PreparedStatement, PreparedStatement>[] mappers() {
            return this.mappers;
        }

        private int i() {
            return this.i;
        }

        private void i_$eq(int x$1) {
            this.i = x$1;
        }

        public void write(WritableFeature feature, package.RowKeyValue<?>[] values) {
            this.i_$eq(0);
            while (this.i() < values.length) {
                Tuple3<CassandraColumnMapper, PreparedStatement, PreparedStatement> tuple3;
                block6: {
                    package.RowKeyValue<?> rowKeyValue;
                    block9: {
                        block8: {
                            BoxedUnit boxedUnit;
                            PreparedStatement statement2;
                            CassandraColumnMapper mapper;
                            block7: {
                                BoxedUnit boxedUnit2;
                                Tuple2 tuple2;
                                tuple3 = this.mappers()[this.i()];
                                if (tuple3 == null) break block6;
                                CassandraColumnMapper mapper2 = (CassandraColumnMapper)tuple3._1();
                                PreparedStatement statement3 = (PreparedStatement)tuple3._2();
                                Tuple2 tuple22 = tuple2 = new Tuple2((Object)mapper2, (Object)statement3);
                                mapper = (CassandraColumnMapper)tuple22._1();
                                statement2 = (PreparedStatement)tuple22._2();
                                rowKeyValue = values[this.i()];
                                if (!(rowKeyValue instanceof package.SingleRowKeyValue)) break block7;
                                package.SingleRowKeyValue singleRowKeyValue = (package.SingleRowKeyValue)rowKeyValue;
                                Seq<Object> bindings = mapper.bind(singleRowKeyValue);
                                if (this.logger().underlying().isTraceEnabled()) {
                                    this.logger().underlying().trace("{} : {}", (Object[])new String[]{statement2.getQueryString(), CassandraIndexAdapter$.MODULE$.org$locationtech$geomesa$cassandra$data$CassandraIndexAdapter$$debug(bindings)});
                                    boxedUnit2 = BoxedUnit.UNIT;
                                } else {
                                    boxedUnit2 = BoxedUnit.UNIT;
                                }
                                boxedUnit = this.org$locationtech$geomesa$cassandra$data$CassandraIndexAdapter$CassandraIndexWriter$$ds.session().execute((Statement)statement2.bind((Object[])bindings.toArray(ClassTag$.MODULE$.AnyRef())));
                                break block8;
                            }
                            if (!(rowKeyValue instanceof package.MultiRowKeyValue)) break block9;
                            package.MultiRowKeyValue multiRowKeyValue = (package.MultiRowKeyValue)rowKeyValue;
                            multiRowKeyValue.split().foreach((Function1)new Serializable(this, mapper, statement2){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ CassandraIndexWriter $outer;
                                private final CassandraColumnMapper mapper$2;
                                private final PreparedStatement statement$1;

                                public final ResultSet apply(package.SingleRowKeyValue<Object> kv) {
                                    BoxedUnit boxedUnit;
                                    Seq<Object> bindings = this.mapper$2.bind(kv);
                                    if (this.$outer.logger().underlying().isTraceEnabled()) {
                                        this.$outer.logger().underlying().trace("{} : {}", (Object[])new String[]{this.statement$1.getQueryString(), CassandraIndexAdapter$.MODULE$.org$locationtech$geomesa$cassandra$data$CassandraIndexAdapter$$debug(bindings)});
                                        boxedUnit = BoxedUnit.UNIT;
                                    } else {
                                        boxedUnit = BoxedUnit.UNIT;
                                    }
                                    return this.$outer.org$locationtech$geomesa$cassandra$data$CassandraIndexAdapter$CassandraIndexWriter$$ds.session().execute((Statement)this.statement$1.bind((Object[])bindings.toArray(ClassTag$.MODULE$.AnyRef())));
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.mapper$2 = mapper$2;
                                    this.statement$1 = statement$1;
                                }
                            });
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        this.i_$eq(this.i() + 1);
                        continue;
                    }
                    throw new MatchError(rowKeyValue);
                }
                throw new MatchError(tuple3);
            }
        }

        public void delete(WritableFeature feature, package.RowKeyValue<?>[] values) {
            this.i_$eq(0);
            while (this.i() < values.length) {
                Tuple3<CassandraColumnMapper, PreparedStatement, PreparedStatement> tuple3;
                block6: {
                    package.RowKeyValue<?> rowKeyValue;
                    block9: {
                        block8: {
                            BoxedUnit boxedUnit;
                            PreparedStatement statement2;
                            CassandraColumnMapper mapper;
                            block7: {
                                BoxedUnit boxedUnit2;
                                Tuple2 tuple2;
                                tuple3 = this.mappers()[this.i()];
                                if (tuple3 == null) break block6;
                                CassandraColumnMapper mapper2 = (CassandraColumnMapper)tuple3._1();
                                PreparedStatement statement3 = (PreparedStatement)tuple3._3();
                                Tuple2 tuple22 = tuple2 = new Tuple2((Object)mapper2, (Object)statement3);
                                mapper = (CassandraColumnMapper)tuple22._1();
                                statement2 = (PreparedStatement)tuple22._2();
                                rowKeyValue = values[this.i()];
                                if (!(rowKeyValue instanceof package.SingleRowKeyValue)) break block7;
                                package.SingleRowKeyValue singleRowKeyValue = (package.SingleRowKeyValue)rowKeyValue;
                                Seq<Object> bindings = mapper.bindDelete(singleRowKeyValue);
                                if (this.logger().underlying().isTraceEnabled()) {
                                    this.logger().underlying().trace("{} : {}", (Object[])new String[]{statement2.getQueryString(), CassandraIndexAdapter$.MODULE$.org$locationtech$geomesa$cassandra$data$CassandraIndexAdapter$$debug(bindings)});
                                    boxedUnit2 = BoxedUnit.UNIT;
                                } else {
                                    boxedUnit2 = BoxedUnit.UNIT;
                                }
                                boxedUnit = this.org$locationtech$geomesa$cassandra$data$CassandraIndexAdapter$CassandraIndexWriter$$ds.session().execute((Statement)statement2.bind((Object[])bindings.toArray(ClassTag$.MODULE$.AnyRef())));
                                break block8;
                            }
                            if (!(rowKeyValue instanceof package.MultiRowKeyValue)) break block9;
                            package.MultiRowKeyValue multiRowKeyValue = (package.MultiRowKeyValue)rowKeyValue;
                            multiRowKeyValue.split().foreach((Function1)new Serializable(this, mapper, statement2){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ CassandraIndexWriter $outer;
                                private final CassandraColumnMapper mapper$3;
                                private final PreparedStatement statement$2;

                                public final ResultSet apply(package.SingleRowKeyValue<Object> kv) {
                                    BoxedUnit boxedUnit;
                                    Seq<Object> bindings = this.mapper$3.bindDelete(kv);
                                    if (this.$outer.logger().underlying().isTraceEnabled()) {
                                        this.$outer.logger().underlying().trace("{} : {}", (Object[])new String[]{this.statement$2.getQueryString(), CassandraIndexAdapter$.MODULE$.org$locationtech$geomesa$cassandra$data$CassandraIndexAdapter$$debug(bindings)});
                                        boxedUnit = BoxedUnit.UNIT;
                                    } else {
                                        boxedUnit = BoxedUnit.UNIT;
                                    }
                                    return this.$outer.org$locationtech$geomesa$cassandra$data$CassandraIndexAdapter$CassandraIndexWriter$$ds.session().execute((Statement)this.statement$2.bind((Object[])bindings.toArray(ClassTag$.MODULE$.AnyRef())));
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.mapper$3 = mapper$3;
                                    this.statement$2 = statement$2;
                                }
                            });
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        this.i_$eq(this.i() + 1);
                        continue;
                    }
                    throw new MatchError(rowKeyValue);
                }
                throw new MatchError(tuple3);
            }
        }

        public void flush() {
        }

        public void close() {
        }

        public CassandraIndexWriter(CassandraDataStore ds, Seq<GeoMesaFeatureIndex<?, ?>> indices, WritableFeature.FeatureWrapper wrapper, Option<String> partition) {
            this.org$locationtech$geomesa$cassandra$data$CassandraIndexAdapter$CassandraIndexWriter$$ds = ds;
            this.org$locationtech$geomesa$cassandra$data$CassandraIndexAdapter$CassandraIndexWriter$$partition = partition;
            super(indices, wrapper);
            StrictLogging.class.$init$((StrictLogging)this);
            this.mappers = (Tuple3[])Predef$.MODULE$.refArrayOps((Object[])super.indices().toArray(ClassTag$.MODULE$.apply(GeoMesaFeatureIndex.class))).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ CassandraIndexWriter $outer;

                public final Tuple3<CassandraColumnMapper, PreparedStatement, PreparedStatement> apply(GeoMesaFeatureIndex<?, ?> index) {
                    CassandraColumnMapper mapper = CassandraColumnMapper$.MODULE$.apply(index);
                    Seq seq = index.getTableNames(this.$outer.org$locationtech$geomesa$cassandra$data$CassandraIndexAdapter$CassandraIndexWriter$$partition);
                    Some some = Seq$.MODULE$.unapplySeq(seq);
                    if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0) {
                        String t;
                        String string;
                        String table = string = (t = (String)((SeqLike)some.get()).apply(0));
                        PreparedStatement insert = mapper.insert(this.$outer.org$locationtech$geomesa$cassandra$data$CassandraIndexAdapter$CassandraIndexWriter$$ds.session(), table);
                        PreparedStatement delete2 = mapper.delete(this.$outer.org$locationtech$geomesa$cassandra$data$CassandraIndexAdapter$CassandraIndexWriter$$ds.session(), table);
                        return new Tuple3((Object)mapper, (Object)insert, (Object)delete2);
                    }
                    throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected a single table but got: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{seq.mkString(", ")})));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple3.class)));
            this.i = 0;
        }
    }
}

