/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.cassandra.index;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Session;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.locationtech.geomesa.cassandra.index.CassandraColumnMapper;
import org.locationtech.geomesa.cassandra.index.CassandraColumnMapper$;
import org.locationtech.geomesa.cassandra.index.CassandraColumnMapper$class;
import org.locationtech.geomesa.cassandra.package;
import org.locationtech.geomesa.cassandra.package$NamedColumn$;
import org.locationtech.geomesa.index.api.package;
import org.locationtech.geomesa.index.index.attribute.AttributeIndexKey;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.runtime.BoxesRunTime;

public final class SharedAttributeColumnMapper$
implements CassandraColumnMapper {
    public static final SharedAttributeColumnMapper$ MODULE$;
    private final package.NamedColumn Index;
    private final package.NamedColumn Value;
    private final package.NamedColumn Secondary;
    private final package.NamedColumn FeatureId;
    private final package.NamedColumn Feature;
    private final Seq<package.NamedColumn> columns;

    static {
        new SharedAttributeColumnMapper$();
    }

    @Override
    public PreparedStatement insert(Session session, String table) {
        return CassandraColumnMapper$class.insert(this, session, table);
    }

    @Override
    public PreparedStatement delete(Session session, String table) {
        return CassandraColumnMapper$class.delete(this, session, table);
    }

    private package.NamedColumn Index() {
        return this.Index;
    }

    private package.NamedColumn Value() {
        return this.Value;
    }

    private package.NamedColumn Secondary() {
        return this.Secondary;
    }

    private package.NamedColumn FeatureId() {
        return this.FeatureId;
    }

    private package.NamedColumn Feature() {
        return this.Feature;
    }

    @Override
    public Seq<package.NamedColumn> columns() {
        return this.columns;
    }

    @Override
    public Seq<Object> bind(package.SingleRowKeyValue<?> value) {
        Object object = value.key();
        if (object instanceof AttributeIndexKey) {
            Tuple2 tuple2;
            AttributeIndexKey attributeIndexKey = (AttributeIndexKey)object;
            short i = attributeIndexKey.i();
            String v = attributeIndexKey.value();
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)BoxesRunTime.boxToShort((short)i), (Object)v);
            short i2 = BoxesRunTime.unboxToShort((Object)tuple22._1());
            String v2 = (String)tuple22._2();
            ByteBuffer secondary = ByteBuffer.wrap(value.tier());
            String fid = new String(value.id(), StandardCharsets.UTF_8);
            Seq seq = (Seq)value.values().map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final ByteBuffer apply(package.KeyValue v) {
                    return ByteBuffer.wrap(v.value());
                }
            }, Seq$.MODULE$.canBuildFrom());
            Some some = Seq$.MODULE$.unapplySeq(seq);
            if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0) {
                ByteBuffer feature;
                ByteBuffer byteBuffer;
                ByteBuffer feature2 = byteBuffer = (feature = (ByteBuffer)((SeqLike)some.get()).apply(0));
                return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray(new Object[]{BoxesRunTime.boxToShort((short)i2), v2, secondary, fid, feature2}));
            }
            throw new MatchError((Object)seq);
        }
        throw new MatchError(object);
    }

    @Override
    public Seq<Object> bindDelete(package.SingleRowKeyValue<?> value) {
        Object object = value.key();
        if (object instanceof AttributeIndexKey) {
            Tuple2 tuple2;
            AttributeIndexKey attributeIndexKey = (AttributeIndexKey)object;
            short i = attributeIndexKey.i();
            String v = attributeIndexKey.value();
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)BoxesRunTime.boxToShort((short)i), (Object)v);
            short i2 = BoxesRunTime.unboxToShort((Object)tuple22._1());
            String v2 = (String)tuple22._2();
            ByteBuffer secondary = ByteBuffer.wrap(value.tier());
            String fid = new String(value.id(), StandardCharsets.UTF_8);
            return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray(new Object[]{BoxesRunTime.boxToShort((short)i2), v2, secondary, fid}));
        }
        throw new MatchError(object);
    }

    @Override
    public Seq<package.RowSelect> select(package.ScanRange<?> range, Seq<package.ByteRange> tieredKeyRanges) {
        block11: {
            Seq seq;
            Seq seq2;
            block6: {
                package.ScanRange<?> scanRange;
                block10: {
                    block9: {
                        block8: {
                            block7: {
                                block5: {
                                    scanRange = range;
                                    if (!(scanRange instanceof package.SingleRowRange)) break block5;
                                    package.SingleRowRange singleRowRange = (package.SingleRowRange)scanRange;
                                    AttributeIndexKey row = (AttributeIndexKey)singleRowRange.row();
                                    Short i = BoxesRunTime.boxToShort((short)row.i());
                                    package.ColumnSelect indexSelect = new package.ColumnSelect(this.Index(), i, i, true, true);
                                    package.ColumnSelect valueSelect = new package.ColumnSelect(this.Value(), row.value(), row.value(), true, true);
                                    seq2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new package.ColumnSelect[]{indexSelect, valueSelect}));
                                    break block6;
                                }
                                if (!(scanRange instanceof package.BoundedRange)) break block7;
                                package.BoundedRange boundedRange = (package.BoundedRange)scanRange;
                                AttributeIndexKey lo = (AttributeIndexKey)boundedRange.lower();
                                AttributeIndexKey hi = (AttributeIndexKey)boundedRange.upper();
                                Short i = BoxesRunTime.boxToShort((short)lo.i());
                                package.ColumnSelect indexSelect = new package.ColumnSelect(this.Index(), i, i, true, true);
                                package.ColumnSelect valueSelect = new package.ColumnSelect(this.Value(), lo.value(), hi.value(), lo.inclusive(), hi.inclusive());
                                seq2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new package.ColumnSelect[]{indexSelect, valueSelect}));
                                break block6;
                            }
                            if (!(scanRange instanceof package.LowerBoundedRange)) break block8;
                            package.LowerBoundedRange lowerBoundedRange = (package.LowerBoundedRange)scanRange;
                            AttributeIndexKey lo = (AttributeIndexKey)lowerBoundedRange.lower();
                            Short i = BoxesRunTime.boxToShort((short)lo.i());
                            package.ColumnSelect indexSelect = new package.ColumnSelect(this.Index(), i, i, true, true);
                            package.ColumnSelect valueSelect = new package.ColumnSelect(this.Value(), lo.value(), null, lo.inclusive(), false);
                            seq2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new package.ColumnSelect[]{indexSelect, valueSelect}));
                            break block6;
                        }
                        if (!(scanRange instanceof package.UpperBoundedRange)) break block9;
                        package.UpperBoundedRange upperBoundedRange = (package.UpperBoundedRange)scanRange;
                        AttributeIndexKey hi = (AttributeIndexKey)upperBoundedRange.upper();
                        Short i = BoxesRunTime.boxToShort((short)hi.i());
                        package.ColumnSelect indexSelect = new package.ColumnSelect(this.Index(), i, i, true, true);
                        package.ColumnSelect valueSelect = new package.ColumnSelect(this.Value(), null, hi.value(), false, hi.inclusive());
                        seq2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new package.ColumnSelect[]{indexSelect, valueSelect}));
                        break block6;
                    }
                    if (!(scanRange instanceof package.PrefixRange)) break block10;
                    package.PrefixRange prefixRange = (package.PrefixRange)scanRange;
                    AttributeIndexKey prefix = (AttributeIndexKey)prefixRange.prefix();
                    Short i = BoxesRunTime.boxToShort((short)prefix.i());
                    package.ColumnSelect indexSelect = new package.ColumnSelect(this.Index(), i, i, true, true);
                    package.ColumnSelect valueSelect = new package.ColumnSelect(this.Value(), prefix.value(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "zzzz"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{prefix.value()})), prefix.inclusive(), false);
                    seq2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new package.ColumnSelect[]{indexSelect, valueSelect}));
                    break block6;
                }
                if (!(scanRange instanceof package.UnboundedRange)) break block11;
                package.UnboundedRange unboundedRange = (package.UnboundedRange)scanRange;
                AttributeIndexKey empty = (AttributeIndexKey)unboundedRange.empty();
                Short i = BoxesRunTime.boxToShort((short)empty.i());
                seq2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new package.ColumnSelect[]{new package.ColumnSelect(this.Index(), i, i, true, true)}));
            }
            Seq primary = seq2;
            if (tieredKeyRanges.isEmpty()) {
                seq = primary;
            } else {
                byte[] minTier = package.ByteRange$.MODULE$.min(tieredKeyRanges);
                byte[] maxTier = package.ByteRange$.MODULE$.max(tieredKeyRanges);
                seq = (Seq)primary.$colon$plus((Object)new package.ColumnSelect(this.Secondary(), ByteBuffer.wrap(minTier), ByteBuffer.wrap(maxTier), true, true), Seq$.MODULE$.canBuildFrom());
            }
            Seq clause = seq;
            return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new package.RowSelect[]{new package.RowSelect((Seq<package.ColumnSelect>)clause)}));
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected range type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{range})));
    }

    private SharedAttributeColumnMapper$() {
        MODULE$ = this;
        CassandraColumnMapper$class.$init$(this);
        this.Index = new package.NamedColumn("attrIdx", 0, "smallint", Short.TYPE, true);
        this.Value = new package.NamedColumn("attrVal", 1, "text", String.class, package$NamedColumn$.MODULE$.apply$default$5());
        this.Secondary = new package.NamedColumn("secondary", 2, "blob", ByteBuffer.class, package$NamedColumn$.MODULE$.apply$default$5());
        this.FeatureId = CassandraColumnMapper$.MODULE$.featureIdColumn(3);
        this.Feature = CassandraColumnMapper$.MODULE$.featureColumn(4);
        this.columns = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new package.NamedColumn[]{this.Index(), this.Value(), this.Secondary(), this.FeatureId(), this.Feature()}));
    }
}

