/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.filter;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.util.Locale;
import org.locationtech.geomesa.filter.GeometryProcessing;
import org.locationtech.geomesa.filter.GeometryProcessing$NoneStrategy$;
import org.locationtech.geomesa.filter.GeometryProcessing$Spatial4jStrategy$;
import org.locationtech.geomesa.filter.package$FilterProperties$;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.spatial.BinarySpatialOperator;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.runtime.BoxedUnit;

public final class GeometryProcessing$
implements GeometryProcessing,
LazyLogging {
    public static final GeometryProcessing$ MODULE$;
    private final String org$locationtech$geomesa$filter$GeometryProcessing$$SafeGeomString;
    private final GeometryProcessing.AbstractGeometryProcessing processor;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new GeometryProcessing$();
    }

    private Logger logger$lzycompute() {
        GeometryProcessing$ geometryProcessing$ = this;
        synchronized (geometryProcessing$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String org$locationtech$geomesa$filter$GeometryProcessing$$SafeGeomString() {
        return this.org$locationtech$geomesa$filter$GeometryProcessing$$SafeGeomString;
    }

    private GeometryProcessing.AbstractGeometryProcessing processor() {
        return this.processor;
    }

    @Override
    public Filter process(BinarySpatialOperator op, SimpleFeatureType sft, FilterFactory2 factory) {
        return this.processor().process(op, sft, factory);
    }

    @Override
    public Seq<Geometry> extract(BinarySpatialOperator op, String attribute2) {
        return this.processor().extract(op, attribute2);
    }

    public double metersMultiplier(String units) {
        double d;
        if (units == null) {
            d = 1.0;
        } else {
            String string = units.trim().toLowerCase(Locale.US);
            double d2 = "meters".equals(string) ? 1.0 : ("kilometers".equals(string) ? 1000.0 : ("feet".equals(string) ? 0.3048 : ("statute miles".equals(string) ? 1609.347 : ("nautical miles".equals(string) ? 1852.0 : 1.0))));
            d = d2;
        }
        return d;
    }

    public Seq<Geometry> org$locationtech$geomesa$filter$GeometryProcessing$$flatten(Geometry geometry) {
        Seq seq;
        Geometry geometry2 = geometry;
        if (geometry2 instanceof GeometryCollection) {
            GeometryCollection geometryCollection = (GeometryCollection)geometry2;
            seq = (Seq)((TraversableLike)Seq$.MODULE$.tabulate(geometryCollection.getNumGeometries(), (Function1)new Serializable(geometryCollection){
                public static final long serialVersionUID = 0L;
                private final GeometryCollection x2$1;

                public final Geometry apply(int x$1) {
                    return this.x2$1.getGeometryN(x$1);
                }
                {
                    this.x2$1 = x2$1;
                }
            })).flatMap((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Seq<Geometry> apply(Geometry geometry) {
                    return GeometryProcessing$.MODULE$.org$locationtech$geomesa$filter$GeometryProcessing$$flatten(geometry);
                }
            }, Seq$.MODULE$.canBuildFrom());
        } else {
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Geometry[]{geometry}));
        }
        return seq;
    }

    private GeometryProcessing$() {
        GeometryProcessing.AbstractGeometryProcessing abstractGeometryProcessing;
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
        this.org$locationtech$geomesa$filter$GeometryProcessing$$SafeGeomString = "gm-safe";
        String string = package$FilterProperties$.MODULE$.GeometryProcessing().get();
        if (string.equalsIgnoreCase("spatial4j")) {
            abstractGeometryProcessing = GeometryProcessing$Spatial4jStrategy$.MODULE$;
        } else if (string.equalsIgnoreCase("none")) {
            abstractGeometryProcessing = GeometryProcessing$NoneStrategy$.MODULE$;
        } else {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Invalid value for '{}', using default (spatial4j): {}", (Object[])new String[]{package$FilterProperties$.MODULE$.GeometryProcessing().property(), string});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            abstractGeometryProcessing = GeometryProcessing$Spatial4jStrategy$.MODULE$;
        }
        this.processor = abstractGeometryProcessing;
    }
}

