/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.wfs.bindings;

import javax.xml.namespace.QName;
import net.opengis.wfs.PropertyType;
import net.opengis.wfs.WfsFactory;
import org.eclipse.emf.ecore.EFactory;
import org.geotools.gml2.GML;
import org.geotools.gml2.GMLConfiguration;
import org.geotools.wfs.WFS;
import org.geotools.xml.AbstractComplexEMFBinding;
import org.geotools.xml.Configuration;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.Encoder;
import org.geotools.xml.EncoderDelegate;
import org.geotools.xml.Node;
import org.locationtech.jts.geom.Geometry;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.AttributesImpl;

public class PropertyTypeBinding
extends AbstractComplexEMFBinding {
    private static final String VALUE = "Value";

    public PropertyTypeBinding(WfsFactory factory) {
        super((EFactory)factory);
    }

    public QName getTarget() {
        return WFS.PropertyType;
    }

    public Element encode(Object object, Document document, Element value) throws Exception {
        return value;
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        return super.parse(instance, node, value);
    }

    public Object getProperty(final Object object, QName name) throws Exception {
        if (VALUE.equals(name.getLocalPart())) {
            return new EncoderDelegate(){

                public void encode(ContentHandler output) throws Exception {
                    Object value = ((PropertyType)object).getValue();
                    output.startElement("http://www.opengis.net/wfs", PropertyTypeBinding.VALUE, "wfs:Value", new AttributesImpl());
                    if (value instanceof Geometry) {
                        Encoder encoder = new Encoder((Configuration)new GMLConfiguration());
                        encoder.setInline(true);
                        encoder.encode(value, GML._Geometry, output);
                    } else {
                        String s = value.toString();
                        output.characters(s.toCharArray(), 0, s.length());
                    }
                    output.endElement("http://www.opengis.net/wfs", PropertyTypeBinding.VALUE, "wfs:Value");
                }
            };
        }
        return super.getProperty(object, name);
    }
}

