/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.cassandra.tools.export;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.util.List;
import java.util.Map;
import org.geotools.data.DataStore;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.locationtech.geomesa.cassandra.data.CassandraDataStore;
import org.locationtech.geomesa.cassandra.tools.CassandraConnectionParams;
import org.locationtech.geomesa.cassandra.tools.CassandraConnectionParams$class;
import org.locationtech.geomesa.cassandra.tools.CassandraDataStoreCommand;
import org.locationtech.geomesa.cassandra.tools.CassandraDataStoreCommand$class;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStore;
import org.locationtech.geomesa.tools.CatalogParam;
import org.locationtech.geomesa.tools.DataStoreCommand;
import org.locationtech.geomesa.tools.OptionalCqlFilterParam;
import org.locationtech.geomesa.tools.OptionalCredentialsParams;
import org.locationtech.geomesa.tools.OptionalIndexParam;
import org.locationtech.geomesa.tools.PasswordParams;
import org.locationtech.geomesa.tools.QueryHintsParams;
import org.locationtech.geomesa.tools.RequiredTypeNameParam;
import org.locationtech.geomesa.tools.export.ExportCommand;
import org.locationtech.geomesa.tools.export.formats.FeatureExporter;
import org.locationtech.geomesa.tools.utils.ParameterConverters;
import org.locationtech.geomesa.utils.index.IndexMode;
import org.locationtech.geomesa.utils.stats.MethodProfiling;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001U4A!\u0001\u0002\u0001\u001f\t12)Y:tC:$'/Y#ya>\u0014HoQ8n[\u0006tGM\u0003\u0002\u0004\t\u00051Q\r\u001f9peRT!!\u0002\u0004\u0002\u000bQ|w\u000e\\:\u000b\u0005\u001dA\u0011!C2bgN\fg\u000e\u001a:b\u0015\tI!\"A\u0004hK>lWm]1\u000b\u0005-a\u0011\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001\u0001bC\t\t\u0003#Qi\u0011A\u0005\u0006\u0002'\u0005)1oY1mC&\u0011QC\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0007]QB$D\u0001\u0019\u0015\t\u0019\u0011D\u0003\u0002\u0006\u0011%\u00111\u0004\u0007\u0002\u000e\u000bb\u0004xN\u001d;D_6l\u0017M\u001c3\u0011\u0005u\u0001S\"\u0001\u0010\u000b\u0005}1\u0011\u0001\u00023bi\u0006L!!\t\u0010\u0003%\r\u000b7o]1oIJ\fG)\u0019;b'R|'/\u001a\t\u0003G\u0011j\u0011\u0001B\u0005\u0003K\u0011\u0011\u0011dQ1tg\u0006tGM]1ECR\f7\u000b^8sK\u000e{W.\\1oI\")q\u0005\u0001C\u0001Q\u00051A(\u001b8jiz\"\u0012!\u000b\t\u0003U\u0001i\u0011A\u0001\u0005\bY\u0001\u0011\r\u0011\"\u0011.\u0003\u0019\u0001\u0018M]1ngV\ta\u0006\u0005\u00020\r:\u0011\u0001g\u0010\b\u0003cyr!AM\u001f\u000f\u0005MbdB\u0001\u001b<\u001d\t)$H\u0004\u00027s5\tqG\u0003\u00029\u001d\u00051AH]8pizJ\u0011!D\u0005\u0003\u00171I!!\u0003\u0006\n\u0005\u001dA\u0011BA\u0003\u0007\u0013\t\u0019AaB\u0003A\u0005!\u0005\u0011)\u0001\fDCN\u001c\u0018M\u001c3sC\u0016C\bo\u001c:u\u0007>lW.\u00198e!\tQ#IB\u0003\u0002\u0005!\u00051i\u0005\u0002C!!)qE\u0011C\u0001\u000bR\t\u0011I\u0002\u0003H\u0005\u0002A%!F\"bgN\fg\u000e\u001a:b\u000bb\u0004xN\u001d;QCJ\fWn]\n\b\rBIEkV._!\tQ\u0015K\u0004\u0002L\u001f:\u0011AJ\u0014\b\u0003g5K!!\u0002\u0005\n\u0005\rI\u0012B\u0001)\u0019\u00035)\u0005\u0010]8si\u000e{W.\\1oI&\u0011!k\u0015\u0002\r\u000bb\u0004xN\u001d;QCJ\fWn\u001d\u0006\u0003!b\u0001\"aI+\n\u0005Y#!!G\"bgN\fg\u000e\u001a:b\u0007>tg.Z2uS>t\u0007+\u0019:b[N\u0004\"\u0001W-\u000e\u0003eI!AW\r\u0003\u0019\r\u000bG/\u00197pOB\u000b'/Y7\u0011\u0005ac\u0016BA/\u001a\u0005U\u0011V-];je\u0016$G+\u001f9f\u001d\u0006lW\rU1sC6\u0004\"\u0001W0\n\u0005\u0001L\"AE(qi&|g.\u00197J]\u0012,\u0007\u0010U1sC6DQa\n$\u0005\u0002\t$\u0012a\u0019\t\u0003I\u001ak\u0011A\u0011\u0015\u0005\r\u001a\u0004\u0018\u000f\u0005\u0002h]6\t\u0001N\u0003\u0002jU\u0006Q!nY8n[\u0006tG-\u001a:\u000b\u0005-d\u0017!\u00022fkN$(\"A7\u0002\u0007\r|W.\u0003\u0002pQ\nQ\u0001+\u0019:b[\u0016$XM]:\u0002%\r|W.\\1oI\u0012+7o\u0019:jaRLwN\\\u0011\u0002e\u0006IS\t\u001f9peR\u0004c-Z1ukJ,7\u000f\t4s_6\u0004\u0013\rI$f_6+7/\u0019\u0011eCR\f\u0007e\u001d;pe\u0016Da\u0001\u001e\u0001!\u0002\u0013q\u0013a\u00029be\u0006l7\u000f\t")
public class CassandraExportCommand
implements ExportCommand<CassandraDataStore>,
CassandraDataStoreCommand {
    private final CassandraExportParams params;
    private final String name;
    private final Logger logger;
    private volatile boolean bitmap$0;

    @Override
    public scala.collection.immutable.Map<String, String> connection() {
        return CassandraDataStoreCommand$class.connection(this);
    }

    public String name() {
        return this.name;
    }

    public void org$locationtech$geomesa$tools$export$ExportCommand$_setter_$name_$eq(String x$1) {
        this.name = x$1;
    }

    public void execute() {
        ExportCommand.class.execute((ExportCommand)this);
    }

    public Option export(DataStore ds) {
        return ExportCommand.class.export((ExportCommand)this, (DataStore)ds);
    }

    public Option<Object> export(FeatureExporter exporter, SimpleFeatureCollection collection) {
        return ExportCommand.class.export((ExportCommand)this, (FeatureExporter)exporter, (SimpleFeatureCollection)collection);
    }

    public SimpleFeatureType getSchema(DataStore ds) {
        return ExportCommand.class.getSchema((ExportCommand)this, (DataStore)ds);
    }

    public SimpleFeatureCollection getFeatures(DataStore ds, Query query) {
        return ExportCommand.class.getFeatures((ExportCommand)this, (DataStore)ds, (Query)query);
    }

    public <R> R profile(Function1<Object, BoxedUnit> onComplete, Function0<R> code) {
        return (R)MethodProfiling.class.profile((MethodProfiling)this, onComplete, code);
    }

    public <R> R profile(Function2<R, Object, BoxedUnit> onComplete, Function0<R> code) {
        return (R)MethodProfiling.class.profile((MethodProfiling)this, onComplete, code);
    }

    public <R> R profile(String message, Function0<R> code) {
        return (R)MethodProfiling.class.profile((MethodProfiling)this, (String)message, code);
    }

    private Logger logger$lzycompute() {
        CassandraExportCommand cassandraExportCommand = this;
        synchronized (cassandraExportCommand) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public <T> T withDataStore(Function1<CassandraDataStore, T> method) throws ParameterException {
        return (T)DataStoreCommand.class.withDataStore((DataStoreCommand)this, method);
    }

    public DataStore loadDataStore() throws ParameterException {
        return DataStoreCommand.class.loadDataStore((DataStoreCommand)this);
    }

    @Override
    public CassandraExportParams params() {
        return this.params;
    }

    public CassandraExportCommand() {
        DataStoreCommand.class.$init$((DataStoreCommand)this);
        LazyLogging.class.$init$((LazyLogging)this);
        MethodProfiling.class.$init$((MethodProfiling)this);
        ExportCommand.class.$init$((ExportCommand)this);
        CassandraDataStoreCommand$class.$init$(this);
        this.params = new CassandraExportParams();
    }

    @Parameters(commandDescription="Export features from a GeoMesa data store")
    public static class CassandraExportParams
    implements ExportCommand.ExportParams,
    CassandraConnectionParams,
    CatalogParam,
    RequiredTypeNameParam,
    OptionalIndexParam {
        @Parameter(names={"--index"}, description="Specify a particular GeoMesa index", required=false)
        private String index;
        @Parameter(names={"-f", "--feature-name"}, description="Simple Feature Type name on which to operate", required=true)
        private String featureName;
        @Parameter(names={"-c", "--catalog"}, description="Catalog table for GeoMesa datastore", required=true)
        private String catalog;
        @Parameter(names={"-P", "--contact-point"}, description="Cassandra contact point (address of a Cassandra node)", required=true)
        private String contactPoint;
        @Parameter(names={"-k", "--key-space"}, description="Cassandra key space (must already exist)", required=true)
        private String keySpace;
        @Parameter(names={"-u", "--user"}, description="Connection user name")
        private String user;
        @Parameter(names={"-p", "--password"}, description="Connection password")
        private String password;
        @Parameter(names={"-o", "--output"}, description="Output to a file instead of std out")
        private String file;
        @Parameter(names={"--gzip"}, description="Level of gzip compression to apply to output, from 1-9")
        private Integer gzip;
        @Parameter(names={"-F", "--output-format"}, description="File format of output files (csv|tsv|gml|json|shp|avro|leaflet|orc|parquet|arrow)", required=false, converter=ParameterConverters.ExportFormatConverter.class)
        private Enumeration.Value outputFormat;
        @Parameter(names={"--no-header"}, description="Export as a delimited text format (csv|tsv) without a type header", required=false)
        private boolean noHeader;
        @Parameter(names={"-m", "--max-features"}, description="Maximum number of features to return. default: Unlimited")
        private Integer maxFeatures;
        @Parameter(names={"-a", "--attributes"}, description="Attributes from feature to export (comma-separated)...Comma-separated expressions with each in the format attribute[=filter_function_expression]|derived-attribute=filter_function_expression|'id'. 'id' will export the feature ID, filter_function_expression is an expression of filter function applied to attributes, literals and filter functions, i.e. can be nested")
        private List<String> attributes;
        @Parameter(names={"--hints"}, description="Query hints to set, in the form key1=value1;key2=value2", required=false, converter=ParameterConverters.HintConverter.class)
        private Map<String, String> hints;
        @Parameter(names={"-q", "--cql"}, description="CQL predicate", converter=ParameterConverters.FilterConverter.class)
        private Filter cqlFilter;

        public String index() {
            return this.index;
        }

        public void index_$eq(String x$1) {
            this.index = x$1;
        }

        public <DS extends GeoMesaDataStore<DS>> Option<GeoMesaFeatureIndex<?, ?>> loadIndex(DS ds, String typeName, IndexMode.IndexMode mode) throws ParameterException {
            return OptionalIndexParam.class.loadIndex((OptionalIndexParam)this, ds, (String)typeName, (IndexMode.IndexMode)mode);
        }

        public String featureName() {
            return this.featureName;
        }

        public void featureName_$eq(String x$1) {
            this.featureName = x$1;
        }

        public String catalog() {
            return this.catalog;
        }

        public void catalog_$eq(String x$1) {
            this.catalog = x$1;
        }

        @Override
        public String contactPoint() {
            return this.contactPoint;
        }

        @Override
        @TraitSetter
        public void contactPoint_$eq(String x$1) {
            this.contactPoint = x$1;
        }

        @Override
        public String keySpace() {
            return this.keySpace;
        }

        @Override
        @TraitSetter
        public void keySpace_$eq(String x$1) {
            this.keySpace = x$1;
        }

        public String user() {
            return this.user;
        }

        public void user_$eq(String x$1) {
            this.user = x$1;
        }

        public String password() {
            return this.password;
        }

        public void password_$eq(String x$1) {
            this.password = x$1;
        }

        public String file() {
            return this.file;
        }

        public void file_$eq(String x$1) {
            this.file = x$1;
        }

        public Integer gzip() {
            return this.gzip;
        }

        public void gzip_$eq(Integer x$1) {
            this.gzip = x$1;
        }

        public Enumeration.Value outputFormat() {
            return this.outputFormat;
        }

        public void outputFormat_$eq(Enumeration.Value x$1) {
            this.outputFormat = x$1;
        }

        public boolean noHeader() {
            return this.noHeader;
        }

        public void noHeader_$eq(boolean x$1) {
            this.noHeader = x$1;
        }

        public Integer maxFeatures() {
            return this.maxFeatures;
        }

        public void maxFeatures_$eq(Integer x$1) {
            this.maxFeatures = x$1;
        }

        public List<String> attributes() {
            return this.attributes;
        }

        public void attributes_$eq(List<String> x$1) {
            this.attributes = x$1;
        }

        public Map<String, String> hints() {
            return this.hints;
        }

        public void hints_$eq(Map<String, String> x$1) {
            this.hints = x$1;
        }

        public Filter cqlFilter() {
            return this.cqlFilter;
        }

        public void cqlFilter_$eq(Filter x$1) {
            this.cqlFilter = x$1;
        }

        public CassandraExportParams() {
            OptionalCqlFilterParam.class.$init$((OptionalCqlFilterParam)this);
            QueryHintsParams.class.$init$((QueryHintsParams)this);
            ExportCommand.ExportParams.class.$init$((ExportCommand.ExportParams)this);
            PasswordParams.class.$init$((PasswordParams)this);
            OptionalCredentialsParams.class.$init$((OptionalCredentialsParams)this);
            CassandraConnectionParams$class.$init$(this);
            CatalogParam.class.$init$((CatalogParam)this);
            RequiredTypeNameParam.class.$init$((RequiredTypeNameParam)this);
            OptionalIndexParam.class.$init$((OptionalIndexParam)this);
        }
    }
}

