/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.util.EnumSet;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.hdfs.client.HdfsDataOutputStream;
import org.apache.orc.impl.HadoopShims;
import org.apache.orc.impl.HadoopShimsPre2_6;
import org.apache.orc.impl.HadoopShimsPre2_7;
import org.apache.orc.impl.ZeroCopyShims;

public class HadoopShimsCurrent
implements HadoopShims {
    @Override
    public HadoopShims.DirectDecompressor getDirectDecompressor(HadoopShims.DirectCompressionType codec) {
        return HadoopShimsPre2_6.getDecompressor(codec);
    }

    @Override
    public HadoopShims.ZeroCopyReaderShim getZeroCopyReader(FSDataInputStream in, HadoopShims.ByteBufferPoolShim pool) throws IOException {
        return ZeroCopyShims.getZeroCopyReader(in, pool);
    }

    @Override
    public boolean endVariableLengthBlock(OutputStream output) throws IOException {
        if (output instanceof HdfsDataOutputStream) {
            HdfsDataOutputStream hdfs = (HdfsDataOutputStream)output;
            hdfs.hsync(EnumSet.of(HdfsDataOutputStream.SyncFlag.END_BLOCK));
            return true;
        }
        return false;
    }

    @Override
    public HadoopShims.KeyProvider getKeyProvider(Configuration conf, Random random) throws IOException {
        return HadoopShimsPre2_7.createKeyProvider(conf, random);
    }
}

