/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.geotools;

import com.typesafe.config.Config;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.text.StringEscapeUtils;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.locationtech.geomesa.utils.conf.IndexId;
import org.locationtech.geomesa.utils.geotools.NameableFeatureTypeFactory;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$AttributeOptions$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$Configs$;
import org.locationtech.geomesa.utils.geotools.sft.SimpleFeatureSpec;
import org.locationtech.geomesa.utils.geotools.sft.SimpleFeatureSpec$;
import org.locationtech.geomesa.utils.geotools.sft.SimpleFeatureSpecConfig$;
import org.locationtech.geomesa.utils.geotools.sft.SimpleFeatureSpecParser$;
import org.locationtech.geomesa.utils.geotools.sft.package;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.FeatureTypeFactory;
import org.opengis.feature.type.GeometryDescriptor;
import org.parboiled.errors.ParsingException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;

public final class SimpleFeatureTypes$ {
    public static final SimpleFeatureTypes$ MODULE$;
    private final ConcurrentHashMap<Tuple2<String, String>, package.ImmutableSimpleFeatureType> cache;

    static {
        new SimpleFeatureTypes$();
    }

    private ConcurrentHashMap<Tuple2<String, String>, package.ImmutableSimpleFeatureType> cache() {
        return this.cache;
    }

    public SimpleFeatureType createType(String typeName, String spec2) {
        Tuple2<String, String> tuple2 = this.parseTypeName(typeName);
        if (tuple2 != null) {
            Tuple2 tuple22;
            String namespace = (String)tuple2._1();
            String name2 = (String)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)namespace, (Object)name2);
            String namespace2 = (String)tuple23._1();
            String name3 = (String)tuple23._2();
            return this.createType(namespace2, name3, spec2);
        }
        throw new MatchError(tuple2);
    }

    public SimpleFeatureType createType(String namespace, String name2, String spec2) {
        try {
            SimpleFeatureSpec parsed = SimpleFeatureSpecParser$.MODULE$.parse(spec2, SimpleFeatureSpecParser$.MODULE$.parse$default$2());
            return this.createFeatureType(namespace, name2, parsed, this.createFeatureType$default$4());
        }
        catch (ParsingException parsingException) {
            throw new IllegalArgumentException(parsingException.getMessage(), parsingException);
        }
    }

    /*
     * WARNING - void declaration
     */
    public SimpleFeatureType createImmutableType(String typeName, String spec2) {
        void var3_3;
        Object object;
        package.ImmutableSimpleFeatureType sft = this.cache().get(new Tuple2((Object)typeName, (Object)spec2));
        if (sft == null) {
            sft = (package.ImmutableSimpleFeatureType)this.immutable(this.createType(typeName, spec2), this.immutable$default$2());
            object = this.cache().put((Tuple2<String, String>)new Tuple2((Object)typeName, (Object)spec2), sft);
        } else {
            object = BoxedUnit.UNIT;
        }
        return var3_3;
    }

    public SimpleFeatureType createImmutableType(String namespace, String name2, String spec2) {
        return this.createImmutableType(namespace == null ? name2 : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{namespace, name2})), spec2);
    }

    public SimpleFeatureType createType(Config conf, Option<String> typeName, Option<String> path) {
        Tuple2<Option<String>, SimpleFeatureSpec> tuple2 = SimpleFeatureSpecConfig$.MODULE$.parse(conf, path);
        if (tuple2 != null) {
            Tuple2 tuple22;
            Option nameFromConf = (Option)tuple2._1();
            SimpleFeatureSpec spec2 = (SimpleFeatureSpec)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)nameFromConf, (Object)spec2);
            Option nameFromConf2 = (Option)tuple23._1();
            SimpleFeatureSpec spec3 = (SimpleFeatureSpec)tuple23._2();
            Tuple2<String, String> tuple24 = this.parseTypeName((String)nameFromConf2.orElse((Function0)new Serializable(typeName){
                public static final long serialVersionUID = 0L;
                private final Option typeName$1;

                public final Option<String> apply() {
                    return this.typeName$1;
                }
                {
                    this.typeName$1 = typeName$1;
                }
            }).getOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Nothing$ apply() {
                    throw new IllegalArgumentException("Unable to parse type name from provided argument or config");
                }
            }));
            if (tuple24 != null) {
                Tuple2 tuple25;
                String namespace = (String)tuple24._1();
                String name2 = (String)tuple24._2();
                Tuple2 tuple26 = tuple25 = new Tuple2((Object)namespace, (Object)name2);
                String namespace2 = (String)tuple26._1();
                String name3 = (String)tuple26._2();
                return this.createFeatureType(namespace2, name3, spec3, this.createFeatureType$default$4());
            }
            throw new MatchError(tuple24);
        }
        throw new MatchError(tuple2);
    }

    public Option<String> createType$default$2() {
        return None$.MODULE$;
    }

    public Option<String> createType$default$3() {
        return new Some((Object)"sft");
    }

    public NameableFeatureTypeFactory.NameableSimpleFeatureType createNameableType(String spec2) {
        SimpleFeatureSpec parsed;
        try {
            parsed = SimpleFeatureSpecParser$.MODULE$.parse(spec2, SimpleFeatureSpecParser$.MODULE$.parse$default$2());
        }
        catch (ParsingException parsingException) {
            throw new IllegalArgumentException(parsingException.getMessage(), parsingException);
        }
        return (NameableFeatureTypeFactory.NameableSimpleFeatureType)this.createFeatureType(null, "", parsed, (Option<FeatureTypeFactory>)new Some((Object)new NameableFeatureTypeFactory()));
    }

    public AttributeDescriptor createDescriptor(String spec2) {
        try {
            return SimpleFeatureSpecParser$.MODULE$.parseAttribute(spec2, SimpleFeatureSpecParser$.MODULE$.parseAttribute$default$2()).toDescriptor();
        }
        catch (ParsingException parsingException) {
            throw new IllegalArgumentException(parsingException.getMessage(), parsingException);
        }
    }

    public String encodeType(SimpleFeatureType sft) {
        return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(sft.getAttributeDescriptors()).asScala()).map((Function1)new Serializable(sft){
            public static final long serialVersionUID = 0L;
            private final SimpleFeatureType sft$1;

            public final String apply(AttributeDescriptor x$4) {
                return SimpleFeatureTypes$.MODULE$.encodeDescriptor(this.sft$1, x$4);
            }
            {
                this.sft$1 = sft$1;
            }
        }, Buffer$.MODULE$.canBuildFrom())).mkString(",");
    }

    public String encodeType(SimpleFeatureType sft, boolean includeUserData) {
        return includeUserData ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.encodeType(sft), this.encodeUserData(sft)})) : this.encodeType(sft);
    }

    public String encodeDescriptor(SimpleFeatureType sft, AttributeDescriptor descriptor) {
        return SimpleFeatureSpec$.MODULE$.attribute(sft, descriptor).toSpec();
    }

    public String encodeUserData(SimpleFeatureType sft) {
        Seq<String> prefixes = RichSimpleFeatureType$RichSimpleFeatureType$.MODULE$.getUserDataPrefixes$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft));
        StringBuilder result = new StringBuilder(";");
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(sft.getUserData()).asScala()).foreach((Function1)new Serializable(prefixes, result){
            public static final long serialVersionUID = 0L;
            private final Seq prefixes$1;
            private final StringBuilder result$1;

            public final Object apply(Tuple2<Object, Object> x0$1) {
                Tuple2<Object, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    String string2;
                    Object k = tuple2._1();
                    Object v = tuple2._2();
                    BoxedUnit boxedUnit = v != null && this.prefixes$1.exists((Function1)new Serializable(this, string2 = k.toString()){
                        public static final long serialVersionUID = 0L;
                        private final String eta$0$1$1;

                        public final boolean apply(String x$1) {
                            return this.eta$0$1$1.startsWith(x$1);
                        }
                        {
                            this.eta$0$1$1 = eta$0$1$1;
                        }
                    }) ? this.result$1.append(SimpleFeatureTypes$.MODULE$.encodeUserData(k, v)).append(",") : BoxedUnit.UNIT;
                    return boxedUnit;
                }
                throw new MatchError(tuple2);
            }
            {
                this.prefixes$1 = prefixes$1;
                this.result$1 = result$1;
            }
        });
        return result.lengthCompare(1) > 0 ? result.substring(0, result.length() - 1) : "";
    }

    public String encodeUserData(Map<Object, Object> data) {
        String string2;
        if (data.isEmpty()) {
            string2 = "";
        } else {
            StringBuilder result = new StringBuilder(";");
            ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(data).asScala()).foreach((Function1)new Serializable(result){
                public static final long serialVersionUID = 0L;
                private final StringBuilder result$2;

                public final StringBuilder apply(Tuple2<Object, Object> x0$2) {
                    Tuple2<Object, Object> tuple2 = x0$2;
                    if (tuple2 != null) {
                        Object k = tuple2._1();
                        Object v = tuple2._2();
                        StringBuilder stringBuilder = this.result$2.append(SimpleFeatureTypes$.MODULE$.encodeUserData(k, v)).append(",");
                        return stringBuilder;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.result$2 = result$2;
                }
            });
            string2 = result.substring(0, result.length() - 1);
        }
        return string2;
    }

    public String encodeUserData(Object key2, Object value2) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "='", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key2, StringEscapeUtils.escapeJava((String)value2.toString())}));
    }

    public Config toConfig(SimpleFeatureType sft, boolean includeUserData, boolean includePrefix) {
        return SimpleFeatureSpecConfig$.MODULE$.toConfig(sft, includeUserData, includePrefix);
    }

    public boolean toConfig$default$2() {
        return true;
    }

    public boolean toConfig$default$3() {
        return true;
    }

    public String toConfigString(SimpleFeatureType sft, boolean includeUserData, boolean concise, boolean includePrefix, boolean json) {
        return SimpleFeatureSpecConfig$.MODULE$.toConfigString(sft, includeUserData, concise, includePrefix, json);
    }

    public boolean toConfigString$default$2() {
        return true;
    }

    public boolean toConfigString$default$3() {
        return false;
    }

    public boolean toConfigString$default$4() {
        return true;
    }

    public boolean toConfigString$default$5() {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SimpleFeatureType immutable(SimpleFeatureType sft, Map<Object, Object> extraData) {
        SimpleFeatureType simpleFeatureType = sft;
        if (simpleFeatureType instanceof package.ImmutableSimpleFeatureType) {
            package.ImmutableSimpleFeatureType immutableSimpleFeatureType = (package.ImmutableSimpleFeatureType)simpleFeatureType;
            if (extraData == null) return immutableSimpleFeatureType;
            if (extraData.isEmpty()) {
                return immutableSimpleFeatureType;
            }
        }
        ArrayList<AttributeDescriptor> schema = new ArrayList<AttributeDescriptor>(sft.getAttributeCount());
        package.ImmutableGeometryDescriptor geom = null;
        for (int i = 0; i < sft.getAttributeCount(); ++i) {
            boolean bl;
            AttributeDescriptor attributeDescriptor = sft.getDescriptor(i);
            if (attributeDescriptor instanceof GeometryDescriptor) {
                GeometryDescriptor geometryDescriptor = (GeometryDescriptor)attributeDescriptor;
                package.ImmutableGeometryDescriptor descriptor = new package.ImmutableGeometryDescriptor(geometryDescriptor.getType(), geometryDescriptor.getName(), geometryDescriptor.getMinOccurs(), geometryDescriptor.getMaxOccurs(), geometryDescriptor.isNillable(), geometryDescriptor.getDefaultValue(), geometryDescriptor.getUserData());
                GeometryDescriptor geometryDescriptor2 = geometryDescriptor;
                GeometryDescriptor geometryDescriptor3 = sft.getGeometryDescriptor();
                if (!(geometryDescriptor2 != null ? !geometryDescriptor2.equals(geometryDescriptor3) : geometryDescriptor3 != null)) {
                    geom = descriptor;
                }
                bl = schema.add((AttributeDescriptor)descriptor);
                continue;
            }
            bl = schema.add((AttributeDescriptor)new package.ImmutableAttributeDescriptor(attributeDescriptor.getType(), attributeDescriptor.getName(), attributeDescriptor.getMinOccurs(), attributeDescriptor.getMaxOccurs(), attributeDescriptor.isNillable(), attributeDescriptor.getDefaultValue(), attributeDescriptor.getUserData()));
        }
        Option userData2 = Option$.MODULE$.apply(extraData).filterNot((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Map<Object, Object> x$5) {
                return x$5.isEmpty();
            }
        }).map((Function1)new Serializable(sft){
            public static final long serialVersionUID = 0L;
            private final SimpleFeatureType sft$2;

            /*
             * WARNING - void declaration
             */
            public final HashMap<Object, Object> apply(Map<Object, Object> data) {
                void var2_2;
                HashMap<Object, Object> map2 = new HashMap<Object, Object>(data.size() + this.sft$2.getUserData().size());
                map2.putAll(this.sft$2.getUserData());
                map2.putAll(data);
                return var2_2;
            }
            {
                this.sft$2 = sft$2;
            }
        });
        return new package.ImmutableSimpleFeatureType(sft.getName(), (List<AttributeDescriptor>)schema, (GeometryDescriptor)geom, sft.isAbstract(), sft.getRestrictions(), sft.getSuper(), sft.getDescription(), (Map)userData2.getOrElse((Function0)new Serializable(sft){
            public static final long serialVersionUID = 0L;
            private final SimpleFeatureType sft$2;

            public final Map<Object, Object> apply() {
                return this.sft$2.getUserData();
            }
            {
                this.sft$2 = sft$2;
            }
        }));
    }

    public Map<Object, Object> immutable$default$2() {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public SimpleFeatureType mutable(SimpleFeatureType sft) {
        SimpleFeatureType simpleFeatureType;
        if (sft instanceof package.ImmutableSimpleFeatureType || ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(sft.getAttributeDescriptors()).asScala()).exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(AttributeDescriptor d) {
                return SimpleFeatureTypes$.MODULE$.org$locationtech$geomesa$utils$geotools$SimpleFeatureTypes$$isImmutable(d);
            }
        })) {
            void var2_2;
            SimpleFeatureType copy = SimpleFeatureTypeBuilder.copy((SimpleFeatureType)sft);
            copy.getUserData().putAll(sft.getUserData());
            simpleFeatureType = var2_2;
        } else {
            simpleFeatureType = sft;
        }
        return simpleFeatureType;
    }

    public boolean org$locationtech$geomesa$utils$geotools$SimpleFeatureTypes$$isImmutable(AttributeDescriptor d) {
        return d instanceof package.ImmutableAttributeDescriptor || d instanceof package.ImmutableGeometryDescriptor;
    }

    public SimpleFeatureType renameSft(SimpleFeatureType sft, String newName) {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.init(sft);
        int n = newName.indexOf(58);
        switch (n) {
            default: {
                builder.setNamespaceURI(newName.substring(0, n));
                builder.setName(newName.substring(n + 1));
                break;
            }
            case -1: {
                builder.setName(newName);
            }
        }
        SimpleFeatureType renamed = builder.buildFeatureType();
        renamed.getUserData().putAll(sft.getUserData());
        return renamed;
    }

    private SimpleFeatureType createFeatureType(String namespace, String name2, SimpleFeatureSpec spec2, Option<FeatureTypeFactory> factory) {
        None$ none$;
        Seq geomAttributes = (Seq)spec2.attributes().collect((PartialFunction)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends SimpleFeatureSpec.AttributeSpec, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof SimpleFeatureSpec.GeomAttributeSpec) {
                    SimpleFeatureSpec.GeomAttributeSpec geomAttributeSpec = (SimpleFeatureSpec.GeomAttributeSpec)A1;
                    object = geomAttributeSpec;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(SimpleFeatureSpec.AttributeSpec x1) {
                SimpleFeatureSpec.AttributeSpec attributeSpec = x1;
                boolean bl = attributeSpec instanceof SimpleFeatureSpec.GeomAttributeSpec;
                return bl;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Option defaultGeom = geomAttributes.find((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(SimpleFeatureSpec.GeomAttributeSpec x$6) {
                return x$6.options().get((Object)SimpleFeatureTypes$AttributeOptions$.MODULE$.OPT_DEFAULT()).exists((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(String x$7) {
                        return new StringOps(Predef$.MODULE$.augmentString(x$7)).toBoolean();
                    }
                });
            }
        }).orElse((Function0)new Serializable(geomAttributes){
            public static final long serialVersionUID = 0L;
            private final Seq geomAttributes$1;

            public final Option<SimpleFeatureSpec.GeomAttributeSpec> apply() {
                return this.geomAttributes$1.headOption();
            }
            {
                this.geomAttributes$1 = geomAttributes$1;
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(SimpleFeatureSpec.GeomAttributeSpec x$8) {
                return x$8.name();
            }
        });
        if (spec2.options().get((Object)SimpleFeatureTypes$Configs$.MODULE$.IGNORE_INDEX_DTG()).exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Object value2) {
                return SimpleFeatureTypes$.MODULE$.toBoolean(value2);
            }
        })) {
            none$ = None$.MODULE$;
        } else {
            Seq dateAttributes = (Seq)spec2.attributes().filter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(SimpleFeatureSpec.AttributeSpec x$9) {
                    return x$9.clazz().isAssignableFrom(Date.class);
                }
            });
            none$ = spec2.options().get((Object)SimpleFeatureTypes$Configs$.MODULE$.DEFAULT_DATE_KEY()).flatMap((Function1)new Serializable(dateAttributes){
                public static final long serialVersionUID = 0L;
                private final Seq dateAttributes$1;

                public final Option<SimpleFeatureSpec.AttributeSpec> apply(Object dtg) {
                    return this.dateAttributes$1.find((Function1)new Serializable(this, dtg){
                        public static final long serialVersionUID = 0L;
                        private final Object dtg$1;

                        public final boolean apply(SimpleFeatureSpec.AttributeSpec x$10) {
                            String string2 = x$10.name();
                            Object object = this.dtg$1;
                            return !(string2 != null ? !string2.equals(object) : object != null);
                        }
                        {
                            this.dtg$1 = dtg$1;
                        }
                    });
                }
                {
                    this.dateAttributes$1 = dateAttributes$1;
                }
            }).orElse((Function0)new Serializable(dateAttributes){
                public static final long serialVersionUID = 0L;
                private final Seq dateAttributes$1;

                public final Option<SimpleFeatureSpec.AttributeSpec> apply() {
                    return this.dateAttributes$1.find((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(SimpleFeatureSpec.AttributeSpec x$11) {
                            return x$11.options().get((Object)SimpleFeatureTypes$AttributeOptions$.MODULE$.OPT_DEFAULT()).exists((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final boolean apply(String x$12) {
                                    return new StringOps(Predef$.MODULE$.augmentString(x$12)).toBoolean();
                                }
                            });
                        }
                    });
                }
                {
                    this.dateAttributes$1 = dateAttributes$1;
                }
            }).orElse((Function0)new Serializable(dateAttributes){
                public static final long serialVersionUID = 0L;
                private final Seq dateAttributes$1;

                public final Option<SimpleFeatureSpec.AttributeSpec> apply() {
                    return this.dateAttributes$1.headOption();
                }
                {
                    this.dateAttributes$1 = dateAttributes$1;
                }
            }).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(SimpleFeatureSpec.AttributeSpec x$13) {
                    return x$13.name();
                }
            });
        }
        None$ defaultDate = none$;
        SimpleFeatureTypeBuilder b = (SimpleFeatureTypeBuilder)factory.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final SimpleFeatureTypeBuilder apply(FeatureTypeFactory x$14) {
                return new SimpleFeatureTypeBuilder(x$14);
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final SimpleFeatureTypeBuilder apply() {
                return new SimpleFeatureTypeBuilder();
            }
        });
        b.setNamespaceURI(namespace);
        b.setName(name2);
        b.addAll((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)spec2.attributes().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final AttributeDescriptor apply(SimpleFeatureSpec.AttributeSpec x$15) {
                return x$15.toDescriptor();
            }
        }, Seq$.MODULE$.canBuildFrom())).asJava());
        defaultGeom.foreach((Function1)new Serializable(b){
            public static final long serialVersionUID = 0L;
            private final SimpleFeatureTypeBuilder b$1;

            public final void apply(String x$1) {
                this.b$1.setDefaultGeometry(x$1);
            }
            {
                this.b$1 = b$1;
            }
        });
        SimpleFeatureType sft = b.buildFeatureType();
        sft.getUserData().putAll((Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(spec2.options()).asJava());
        SimpleFeatureType simpleFeatureType = RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft);
        defaultDate.foreach((Function1)new Serializable(simpleFeatureType){
            public static final long serialVersionUID = 0L;
            private final SimpleFeatureType eta$0$2$1;

            public final void apply(String dtg) {
                RichSimpleFeatureType$RichSimpleFeatureType$.MODULE$.setDtgField$extension(this.eta$0$2$1, dtg);
            }
            {
                this.eta$0$2$1 = eta$0$2$1;
            }
        });
        return sft;
    }

    private Option<FeatureTypeFactory> createFeatureType$default$4() {
        return None$.MODULE$;
    }

    private Tuple2<String, String> parseTypeName(String name2) {
        Tuple2 tuple2;
        int nsIndex = name2.lastIndexOf(58);
        Tuple2 tuple22 = tuple2 = nsIndex == -1 || nsIndex == name2.length() - 1 ? new Tuple2(null, (Object)name2) : new Tuple2((Object)name2.substring(0, nsIndex), (Object)name2.substring(nsIndex + 1));
        if (tuple2 != null) {
            Tuple2 tuple23;
            String namespace = (String)tuple2._1();
            String local = (String)tuple2._2();
            Tuple2 tuple24 = tuple23 = new Tuple2((Object)namespace, (Object)local);
            String namespace2 = (String)tuple24._1();
            String local2 = (String)tuple24._2();
            return new Tuple2((Object)namespace2, (Object)local2);
        }
        throw new MatchError((Object)tuple2);
    }

    public Seq<AttributeDescriptor> getSecondaryIndexedAttributes(SimpleFeatureType sft) {
        return (Seq)RichSimpleFeatureType$RichSimpleFeatureType$.MODULE$.getIndices$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)).flatMap((Function1)new Serializable(sft){
            public static final long serialVersionUID = 0L;
            public final SimpleFeatureType sft$3;

            public final Iterable<AttributeDescriptor> apply(IndexId i) {
                return Option$.MODULE$.option2Iterable(i.attributes().headOption().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.getSecondaryIndexedAttributes.1 $outer;

                    public final AttributeDescriptor apply(String x$1) {
                        return this.$outer.sft$3.getDescriptor(x$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }).filterNot((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(AttributeDescriptor x$17) {
                        return x$17 instanceof GeometryDescriptor;
                    }
                }));
            }
            {
                this.sft$3 = sft$3;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public boolean toBoolean(Object value2) {
        boolean bl;
        Object object = value2;
        if (object == null) {
            bl = false;
        } else if (object instanceof Boolean) {
            Boolean bl2 = (Boolean)object;
            bl = bl2;
        } else if (object instanceof String) {
            String string2 = (String)object;
            bl = Boolean.valueOf(string2);
        } else {
            bl = Boolean.valueOf(object.toString());
        }
        return bl;
    }

    private SimpleFeatureTypes$() {
        MODULE$ = this;
        this.cache = new ConcurrentHashMap();
    }
}

