/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.cassandra.data;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.exceptions.AlreadyExistsException;
import com.datastax.driver.core.querybuilder.Select;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.geotools.factory.Hints;
import org.locationtech.geomesa.cassandra.data.CassandraDataStore;
import org.locationtech.geomesa.cassandra.data.CassandraIndexAdapter$;
import org.locationtech.geomesa.cassandra.data.CassandraQueryPlan;
import org.locationtech.geomesa.cassandra.data.EmptyPlan;
import org.locationtech.geomesa.cassandra.data.StatementPlan;
import org.locationtech.geomesa.cassandra.index.CassandraColumnMapper;
import org.locationtech.geomesa.cassandra.index.CassandraColumnMapper$;
import org.locationtech.geomesa.cassandra.package;
import org.locationtech.geomesa.features.SerializationOption;
import org.locationtech.geomesa.features.kryo.KryoFeatureSerializer;
import org.locationtech.geomesa.features.kryo.KryoFeatureSerializer$;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex$;
import org.locationtech.geomesa.index.api.IndexAdapter;
import org.locationtech.geomesa.index.api.WritableFeature;
import org.locationtech.geomesa.index.api.WritableFeature$;
import org.locationtech.geomesa.index.api.package;
import org.locationtech.geomesa.index.conf.ColumnGroups;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.index.planning.LocalQueryRunner;
import org.locationtech.geomesa.index.planning.LocalQueryRunner$;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple5;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tUf\u0001B\u0001\u0003\u00015\u0011QcQ1tg\u0006tGM]1J]\u0012,\u00070\u00113baR,'O\u0003\u0002\u0004\t\u0005!A-\u0019;b\u0015\t)a!A\u0005dCN\u001c\u0018M\u001c3sC*\u0011q\u0001C\u0001\bO\u0016|W.Z:b\u0015\tI!\"\u0001\u0007m_\u000e\fG/[8oi\u0016\u001c\u0007NC\u0001\f\u0003\ry'oZ\u0002\u0001'\u0011\u0001a\u0002\u0006\u0011\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g!\r)\"\u0004H\u0007\u0002-)\u0011q\u0003G\u0001\u0004CBL'BA\r\u0007\u0003\u0015Ig\u000eZ3y\u0013\tYbC\u0001\u0007J]\u0012,\u00070\u00113baR,'\u000f\u0005\u0002\u001e=5\t!!\u0003\u0002 \u0005\t\u00112)Y:tC:$'/\u0019#bi\u0006\u001cFo\u001c:f!\t\t\u0003&D\u0001#\u0015\t\u0019C%\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u0002&M\u0005AA/\u001f9fg\u00064WMC\u0001(\u0003\r\u0019w.\\\u0005\u0003S\t\u0012Qb\u0015;sS\u000e$Hj\\4hS:<\u0007\u0002C\u0016\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000f\u0002\u0005\u0011\u001c\b\"B\u0017\u0001\t\u0003q\u0013A\u0002\u001fj]&$h\b\u0006\u00020aA\u0011Q\u0004\u0001\u0005\u0006W1\u0002\r\u0001\b\u0005\be\u0001\u0011\r\u0011\"\u00114\u00039!\u0018M\u00197f\u001d\u0006lW\rT5nSR,\u0012\u0001\u000e\t\u0004\u001fU:\u0014B\u0001\u001c\u0011\u0005\u0019y\u0005\u000f^5p]B\u0011q\u0002O\u0005\u0003sA\u00111!\u00138u\u0011\u0019Y\u0004\u0001)A\u0005i\u0005yA/\u00192mK:\u000bW.\u001a'j[&$\b\u0005C\u0003>\u0001\u0011\u0005c(A\u0006de\u0016\fG/\u001a+bE2,G\u0003B C+~\u0003\"a\u0004!\n\u0005\u0005\u0003\"\u0001B+oSRDQ!\u0007\u001fA\u0002\r\u00034\u0001R%T!\u0011)Ri\u0012*\n\u0005\u00193\"aE$f_6+7/\u0019$fCR,(/Z%oI\u0016D\bC\u0001%J\u0019\u0001!\u0011B\u0013\"\u0002\u0002\u0003\u0005)\u0011A&\u0003\u0007}#\u0013'\u0005\u0002M\u001fB\u0011q\"T\u0005\u0003\u001dB\u0011qAT8uQ&tw\r\u0005\u0002\u0010!&\u0011\u0011\u000b\u0005\u0002\u0004\u0003:L\bC\u0001%T\t%!&)!A\u0001\u0002\u000b\u00051JA\u0002`IIBQA\u0016\u001fA\u0002]\u000b\u0011\u0002]1si&$\u0018n\u001c8\u0011\u0007=)\u0004\f\u0005\u0002Z9:\u0011qBW\u0005\u00037B\ta\u0001\u0015:fI\u00164\u0017BA/_\u0005\u0019\u0019FO]5oO*\u00111\f\u0005\u0005\u0007Ar\"\t\u0019A1\u0002\rM\u0004H.\u001b;t!\ry!\rZ\u0005\u0003GB\u0011\u0001\u0002\u00102z]\u0006lWM\u0010\t\u0004K6\u0004hB\u00014l\u001d\t9'.D\u0001i\u0015\tIG\"\u0001\u0004=e>|GOP\u0005\u0002#%\u0011A\u000eE\u0001\ba\u0006\u001c7.Y4f\u0013\tqwNA\u0002TKFT!\u0001\u001c\t\u0011\u0007=\t8/\u0003\u0002s!\t)\u0011I\u001d:bsB\u0011q\u0002^\u0005\u0003kB\u0011AAQ=uK\")q\u000f\u0001C!q\u0006aA-\u001a7fi\u0016$\u0016M\u00197fgR\u0011q(\u001f\u0005\u0006uZ\u0004\ra_\u0001\u0007i\u0006\u0014G.Z:\u0011\u0007\u0015l\u0007\fC\u0003~\u0001\u0011\u0005c0A\u0006dY\u0016\f'\u000fV1cY\u0016\u001cH\u0003B \u0000\u0003\u0003AQA\u001f?A\u0002mDq!a\u0001}\u0001\u0004\t)!\u0001\u0004qe\u00164\u0017\u000e\u001f\t\u0004\u001fU\u0002\bbBA\u0005\u0001\u0011\u0005\u00131B\u0001\u0010GJ,\u0017\r^3Rk\u0016\u0014\u0018\u0010\u00157b]R!\u0011QBA\n!\ri\u0012qB\u0005\u0004\u0003#\u0011!AE\"bgN\fg\u000e\u001a:b#V,'/\u001f)mC:D\u0001\"!\u0006\u0002\b\u0001\u0007\u0011qC\u0001\tgR\u0014\u0018\r^3hsB!\u0011\u0011DA\u0019\u001d\u0011\tY\"a\f\u000f\t\u0005u\u0011Q\u0006\b\u0005\u0003?\tYC\u0004\u0003\u0002\"\u0005%b\u0002BA\u0012\u0003Oq1aZA\u0013\u0013\u0005Y\u0011BA\u0005\u000b\u0013\t9\u0001\"\u0003\u0002\u001a\r%\u0011q\u0003G\u0005\u0003YZIA!a\r\u00026\ti\u0011+^3ssN#(/\u0019;fOfT!\u0001\u001c\f\t\u000f\u0005e\u0002\u0001\"\u0011\u0002<\u0005a1M]3bi\u0016<&/\u001b;feRA\u0011Q\bBE\u0005?\u0013\u0019\f\u0005\u0003\u0002@\u0005ee\u0002BA!\u0003\u0013rA!a\u0011\u0002H9!\u0011qDA#\u0013\t)a!\u0003\u0002\u0004\t\u001d9\u00111\n\u0002\t\u0002\u00055\u0013!F\"bgN\fg\u000e\u001a:b\u0013:$W\r_!eCB$XM\u001d\t\u0004;\u0005=cAB\u0001\u0003\u0011\u0003\t\tfE\u0002\u0002P9Aq!LA(\t\u0003\t)\u0006\u0006\u0002\u0002N!Q\u0011\u0011LA(\u0005\u0004%\t!a\u0017\u0002\u001dQ\u000b'\r\\3OC6,G*[7jiV\tq\u0007\u0003\u0005\u0002`\u0005=\u0003\u0015!\u00038\u0003=!\u0016M\u00197f\u001d\u0006lW\rT5nSR\u0004\u0003\u0002CA2\u0003\u001f\"\t!!\u001a\u0002\u0013M$\u0018\r^3nK:$H\u0003CA4\u0003\u007f\n\u0019)a\"\u0011\t\u0005%\u00141P\u0007\u0003\u0003WRA!!\u001c\u0002p\u0005a\u0011/^3ss\n,\u0018\u000e\u001c3fe*!\u0011\u0011OA:\u0003\u0011\u0019wN]3\u000b\t\u0005U\u0014qO\u0001\u0007IJLg/\u001a:\u000b\u0007\u0005ed%\u0001\u0005eCR\f7\u000f^1y\u0013\u0011\ti(a\u001b\u0003\rM+G.Z2u\u0011\u001d\t\t)!\u0019A\u0002a\u000b\u0001b[3zgB\f7-\u001a\u0005\b\u0003\u000b\u000b\t\u00071\u0001Y\u0003\u0015!\u0018M\u00197f\u0011!\tI)!\u0019A\u0002\u0005-\u0015\u0001C2sSR,'/[1\u0011\t\u0015l\u0017Q\u0012\t\u0005\u0003\u001f\u000b\u0019J\u0004\u0003\u0002D\u0005E\u0015B\u00017\u0005\u0013\u0011\t)*a&\u0003\u0019\r{G.^7o'\u0016dWm\u0019;\u000b\u00051$aaBAN\u0003\u001f\u0002\u0011Q\u0014\u0002\u0015\u0007\u0006\u001c8/\u00198ee\u0006Le\u000eZ3y/JLG/\u001a:\u0014\u000b\u0005e\u0015q\u0014\u0011\u0011\t\u0005\u0005\u0016q\u0015\b\u0005\u00037\t\u0019+C\u0002\u0002&Z\tA\"\u00138eKb\fE-\u00199uKJLA!!+\u0002,\nY\u0011J\u001c3fq^\u0013\u0018\u000e^3s\u0015\r\t)K\u0006\u0005\nW\u0005e%\u0011!Q\u0001\nqAQ\"!-\u0002\u001a\n\u0005\t\u0015!\u0003\u00024\u0006\u0015\u0017aB5oI&\u001cWm\u001d\t\u0005K6\f)\f\r\u0004\u00028\u0006m\u0016\u0011\u0019\t\u0007+\u0015\u000bI,a0\u0011\u0007!\u000bY\fB\u0006\u0002>\u0006=\u0016\u0011!A\u0001\u0006\u0003Y%aA0%kA\u0019\u0001*!1\u0005\u0017\u0005\r\u0017qVA\u0001\u0002\u0003\u0015\ta\u0013\u0002\u0004?\u00122\u0014\u0002BAY\u0003OC1\"!3\u0002\u001a\n\u0005\t\u0015!\u0003\u0002L\u00069qO]1qa\u0016\u0014\b\u0003BAg\u0003'tA!a\u0007\u0002P&\u0019\u0011\u0011\u001b\f\u0002\u001f]\u0013\u0018\u000e^1cY\u00164U-\u0019;ve\u0016LA!!6\u0002X\nqa)Z1ukJ,wK]1qa\u0016\u0014(bAAi-!Ia+!'\u0003\u0002\u0003\u0006Ia\u0016\u0005\b[\u0005eE\u0011AAo))\ty.a9\u0002f\u0006U\u0018q\u001f\t\u0005\u0003C\fI*\u0004\u0002\u0002P!11&a7A\u0002qA\u0001\"!-\u0002\\\u0002\u0007\u0011q\u001d\t\u0005K6\fI\u000f\r\u0004\u0002l\u0006=\u00181\u001f\t\u0007+\u0015\u000bi/!=\u0011\u0007!\u000by\u000fB\u0006\u0002>\u0006\u0015\u0018\u0011!A\u0001\u0006\u0003Y\u0005c\u0001%\u0002t\u0012Y\u00111YAs\u0003\u0003\u0005\tQ!\u0001L\u0011!\tI-a7A\u0002\u0005-\u0007B\u0002,\u0002\\\u0002\u0007q\u000b\u0003\u0006\u0002|\u0006e%\u0019!C\u0005\u0003{\fq!\\1qa\u0016\u00148/\u0006\u0002\u0002\u0000B!q\"\u001dB\u0001!%y!1\u0001B\u0004\u0005#\u0011\t\"C\u0002\u0003\u0006A\u0011a\u0001V;qY\u0016\u001c\u0004\u0003\u0002B\u0005\u0005\u001bi!Aa\u0003\u000b\u0005e!\u0011\u0002\u0002B\b\u0005\u0017\u0011QcQ1tg\u0006tGM]1D_2,XN\\'baB,'\u000f\u0005\u0003\u0003\u0014\tUQBAA8\u0013\u0011\u00119\"a\u001c\u0003#A\u0013X\r]1sK\u0012\u001cF/\u0019;f[\u0016tG\u000fC\u0005\u0003\u001c\u0005e\u0005\u0015!\u0003\u0002\u0000\u0006AQ.\u00199qKJ\u001c\b\u0005\u0003\u0006\u0003 \u0005e\u0005\u0019!C\u0005\u00037\n\u0011!\u001b\u0005\u000b\u0005G\tI\n1A\u0005\n\t\u0015\u0012!B5`I\u0015\fHcA \u0003(!I!\u0011\u0006B\u0011\u0003\u0003\u0005\raN\u0001\u0004q\u0012\n\u0004\u0002\u0003B\u0017\u00033\u0003\u000b\u0015B\u001c\u0002\u0005%\u0004\u0003\u0002\u0003B\u0019\u00033#\tFa\r\u0002\u000b]\u0014\u0018\u000e^3\u0015\u000f}\u0012)Da\u0010\u0003T!A!q\u0007B\u0018\u0001\u0004\u0011I$A\u0004gK\u0006$XO]3\u0011\u0007U\u0011Y$C\u0002\u0003>Y\u0011qb\u0016:ji\u0006\u0014G.\u001a$fCR,(/\u001a\u0005\t\u0005\u0003\u0012y\u00031\u0001\u0003D\u00051a/\u00197vKN\u0004BaD9\u0003FA\"!q\tB(!\u0019\tIB!\u0013\u0003N%!!1JA\u001b\u0005-\u0011vn^&fsZ\u000bG.^3\u0011\u0007!\u0013y\u0005B\u0006\u0003R\t}\u0012\u0011!A\u0001\u0006\u0003Y%aA0%o!A!Q\u000bB\u0018\u0001\u0004\u00119&\u0001\u0004va\u0012\fG/\u001a\t\u0004\u001f\te\u0013b\u0001B.!\t9!i\\8mK\u0006t\u0007\u0002\u0003B0\u00033#\tF!\u0019\u0002\r\u0011,G.\u001a;f)\u0015y$1\rB3\u0011!\u00119D!\u0018A\u0002\te\u0002\u0002\u0003B!\u0005;\u0002\rAa\u001a\u0011\t=\t(\u0011\u000e\u0019\u0005\u0005W\u0012y\u0007\u0005\u0004\u0002\u001a\t%#Q\u000e\t\u0004\u0011\n=Da\u0003B9\u0005K\n\t\u0011!A\u0003\u0002-\u00131a\u0018\u00139\u0011!\u0011)(!'\u0005B\t]\u0014!\u00024mkNDG#A \t\u0011\tm\u0014\u0011\u0014C!\u0005o\nQa\u00197pg\u0016D\u0001Ba \u0002P\u0011%!\u0011Q\u0001\u0006I\u0016\u0014Wo\u001a\u000b\u00041\n\r\u0005\u0002\u0003BC\u0005{\u0002\rAa\"\u0002\u0011\tLg\u000eZ5oON\u00042!Z7\u000f\u0011!\u0011Y)a\u000eA\u0002\t5\u0015aA:giB!!q\u0012BN\u001b\t\u0011\tJ\u0003\u0003\u0003\u0014\nU\u0015AB:j[BdWM\u0003\u0003\u00038\t]%b\u0001BM\u0015\u00059q\u000e]3oO&\u001c\u0018\u0002\u0002BO\u0005#\u0013\u0011cU5na2,g)Z1ukJ,G+\u001f9f\u0011!\t\t,a\u000eA\u0002\t\u0005\u0006\u0003B3n\u0005G\u0003dA!*\u0003*\n=\u0006CB\u000bF\u0005O\u0013i\u000bE\u0002I\u0005S#1Ba+\u0003 \u0006\u0005\t\u0011!B\u0001\u0017\n\u0019q\fJ\u001a\u0011\u0007!\u0013y\u000bB\u0006\u00032\n}\u0015\u0011!A\u0001\u0006\u0003Y%aA0%i!Aa+a\u000e\u0011\u0002\u0003\u0007q\u000b")
public class CassandraIndexAdapter
implements IndexAdapter<CassandraDataStore>,
StrictLogging {
    public final CassandraDataStore org$locationtech$geomesa$cassandra$data$CassandraIndexAdapter$$ds;
    private final Option<Object> tableNameLimit;
    private final Logger logger;
    private final ColumnGroups groups;

    public static Select statement(String string, String string2, Seq<package.ColumnSelect> seq) {
        return CassandraIndexAdapter$.MODULE$.statement(string, string2, seq);
    }

    public static int TableNameLimit() {
        return CassandraIndexAdapter$.MODULE$.TableNameLimit();
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public ColumnGroups groups() {
        return this.groups;
    }

    public void org$locationtech$geomesa$index$api$IndexAdapter$_setter_$groups_$eq(ColumnGroups x$1) {
        this.groups = x$1;
    }

    public void org$locationtech$geomesa$index$api$IndexAdapter$_setter_$tableNameLimit_$eq(Option x$1) {
    }

    public Option<String> createWriter$default$3() {
        return IndexAdapter.class.createWriter$default$3((IndexAdapter)this);
    }

    public Option<Object> tableNameLimit() {
        return this.tableNameLimit;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void createTable(GeoMesaFeatureIndex<?, ?> index, Option<String> partition, Function0<Seq<byte[]>> splits) {
        BoxedUnit boxedUnit;
        Tuple2 tuple22;
        Cluster cluster = this.org$locationtech$geomesa$cassandra$data$CassandraIndexAdapter$$ds.session().getCluster();
        String table = index.configureTableName(partition, this.tableNameLimit());
        if (cluster.getMetadata().getKeyspace(this.org$locationtech$geomesa$cassandra$data$CassandraIndexAdapter$$ds.session().getLoggedKeyspace()).getTable(table) != null) return;
        Seq<package.NamedColumn> columns = CassandraColumnMapper$.MODULE$.apply(index).columns();
        Tuple2 tuple2 = columns.partition((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(package.NamedColumn x$1) {
                return x$1.partition();
            }
        });
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Seq partitions = (Seq)tuple2._1();
        Seq pks = (Seq)tuple2._2();
        Tuple2 tuple23 = tuple22 = new Tuple2((Object)partitions, (Object)pks);
        Seq partitions2 = (Seq)tuple23._1();
        Seq pks2 = (Seq)tuple23._2();
        String create = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CREATE TABLE ", " (", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table, ((TraversableOnce)columns.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(package.NamedColumn c) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{c.name(), c.cType()}));
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(", ")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PRIMARY KEY (", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)partitions2.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(package.NamedColumn x$3) {
                return x$3.name();
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString("(", ", ", ")")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{pks2.nonEmpty() ? ((TraversableOnce)pks2.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(package.NamedColumn x$4) {
                return x$4.name();
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(", ", ", ", "") : ""}))).toString();
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(create);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        try {
            this.org$locationtech$geomesa$cassandra$data$CassandraIndexAdapter$$ds.session().execute(create);
            return;
        }
        catch (AlreadyExistsException alreadyExistsException) {}
    }

    public void deleteTables(Seq<String> tables) {
        tables.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CassandraIndexAdapter $outer;

            public final ResultSet apply(String table) {
                BoxedUnit boxedUnit;
                String delete2 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DROP TABLE IF EXISTS ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table}));
                if (this.$outer.logger().underlying().isDebugEnabled()) {
                    this.$outer.logger().underlying().debug(delete2);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return this.$outer.org$locationtech$geomesa$cassandra$data$CassandraIndexAdapter$$ds.session().execute(delete2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void clearTables(Seq<String> tables, Option<byte[]> prefix) {
        if (prefix.isDefined()) {
            throw new IllegalArgumentException("Received a range in `clearTables` but table sharing should be disabled");
        }
        tables.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CassandraIndexAdapter $outer;

            public final ResultSet apply(String table) {
                BoxedUnit boxedUnit;
                String truncate = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TRUNCATE ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table}));
                if (this.$outer.logger().underlying().isDebugEnabled()) {
                    this.$outer.logger().underlying().debug(truncate);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return this.$outer.org$locationtech$geomesa$cassandra$data$CassandraIndexAdapter$$ds.session().execute(truncate);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public CassandraQueryPlan createQueryPlan(package.QueryStrategy strategy) {
        package.QueryStrategy queryStrategy = strategy;
        if (queryStrategy != null) {
            CassandraQueryPlan cassandraQueryPlan;
            Tuple5 tuple5;
            package.FilterStrategy filter = queryStrategy.filter();
            Seq keyRanges = queryStrategy.keyRanges();
            Seq tieredKeyRanges = queryStrategy.tieredKeyRanges();
            Option ecql = queryStrategy.ecql();
            Hints hints = queryStrategy.hints();
            Tuple5 tuple52 = tuple5 = new Tuple5((Object)filter, (Object)keyRanges, (Object)tieredKeyRanges, (Object)ecql, (Object)hints);
            package.FilterStrategy filter2 = (package.FilterStrategy)tuple52._1();
            Seq keyRanges2 = (Seq)tuple52._2();
            Seq tieredKeyRanges2 = (Seq)tuple52._3();
            Option ecql2 = (Option)tuple52._4();
            Hints hints2 = (Hints)tuple52._5();
            if (keyRanges2.isEmpty()) {
                cassandraQueryPlan = new EmptyPlan(filter2);
            } else {
                String ks = this.org$locationtech$geomesa$cassandra$data$CassandraIndexAdapter$$ds.session().getLoggedKeyspace();
                CassandraColumnMapper mapper = CassandraColumnMapper$.MODULE$.apply(strategy.index());
                Seq ranges = (Seq)keyRanges2.flatMap((Function1)new Serializable(this, tieredKeyRanges2, mapper){
                    public static final long serialVersionUID = 0L;
                    private final Seq tieredKeyRanges$1;
                    private final CassandraColumnMapper mapper$1;

                    public final Seq<package.RowSelect> apply(package.ScanRange<?> x$6) {
                        return this.mapper$1.select(x$6, (Seq<package.ByteRange>)this.tieredKeyRanges$1);
                    }
                    {
                        this.tieredKeyRanges$1 = tieredKeyRanges$1;
                        this.mapper$1 = mapper$1;
                    }
                }, Seq$.MODULE$.canBuildFrom());
                Seq tables = strategy.index().getTablesForQuery(filter2.filter());
                Seq statements = (Seq)tables.flatMap((Function1)new Serializable(this, ks, ranges){
                    public static final long serialVersionUID = 0L;
                    public final String ks$1;
                    private final Seq ranges$1;

                    public final Seq<Select> apply(String table) {
                        return (Seq)this.ranges$1.map((Function1)new Serializable(this, table){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$6 $outer;
                            private final String table$1;

                            public final Select apply(package.RowSelect r) {
                                return CassandraIndexAdapter$.MODULE$.statement(this.$outer.ks$1, this.table$1, r.clauses());
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.table$1 = table$1;
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                    }
                    {
                        this.ks$1 = ks$1;
                        this.ranges$1 = ranges$1;
                    }
                }, Seq$.MODULE$.canBuildFrom());
                KryoFeatureSerializer serializer = KryoFeatureSerializer$.MODULE$.apply(strategy.index().sft(), SerializationOption.SerializationOptions$.MODULE$.builder().lazy().withoutId().build());
                Function4 idSerializer = GeoMesaFeatureIndex$.MODULE$.idFromBytes(strategy.index().sft());
                Some hook = new Some((Object)new LocalQueryRunner.ArrowDictionaryHook(this.org$locationtech$geomesa$cassandra$data$CassandraIndexAdapter$$ds.stats(), filter2.filter()));
                Serializable transform = new Serializable(this, strategy, hints2, hook){
                    public static final long serialVersionUID = 0L;
                    private final package.QueryStrategy strategy$1;
                    private final Hints hints$1;
                    private final Some hook$1;

                    public final CloseableIterator<SimpleFeature> apply(CloseableIterator<SimpleFeature> x$7) {
                        return LocalQueryRunner$.MODULE$.transform(this.strategy$1.index().sft(), x$7, QueryHints$.MODULE$.RichHints(this.hints$1).getTransform(), this.hints$1, (Option)this.hook$1);
                    }
                    {
                        this.strategy$1 = strategy$1;
                        this.hints$1 = hints$1;
                        this.hook$1 = hook$1;
                    }
                };
                Serializable rowsToFeatures = new Serializable(this, ecql2, serializer, idSerializer, (Function1)transform){
                    public static final long serialVersionUID = 0L;
                    private final Option ecql$1;
                    public final KryoFeatureSerializer serializer$1;
                    public final Function4 idSerializer$1;
                    private final Function1 transform$1;

                    public final CloseableIterator<SimpleFeature> apply(CloseableIterator<Row> rows) {
                        Option option;
                        block4: {
                            CloseableIterator closeableIterator;
                            block3: {
                                CloseableIterator features;
                                block2: {
                                    features = rows.map((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ $anonfun$8 $outer;

                                        public final SimpleFeature apply(Row row) {
                                            byte[] bytes = ((String)row.get(CassandraColumnMapper$.MODULE$.FeatureIdColumnName(), String.class)).getBytes(StandardCharsets.UTF_8);
                                            String fid = (String)this.$outer.idSerializer$1.apply((Object)bytes, (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)bytes.length), null);
                                            ByteBuffer sf = row.getBytes(CassandraColumnMapper$.MODULE$.SimpleFeatureColumnName());
                                            byte[] bytes2 = (byte[])Array$.MODULE$.ofDim(sf.limit(), ClassTag$.MODULE$.Byte());
                                            sf.get(bytes2);
                                            return this.$outer.serializer$1.deserialize(fid, bytes2);
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                        }
                                    });
                                    option = this.ecql$1;
                                    if (!None$.MODULE$.equals(option)) break block2;
                                    closeableIterator = (CloseableIterator)this.transform$1.apply((Object)features);
                                    break block3;
                                }
                                if (!(option instanceof Some)) break block4;
                                Some some = (Some)option;
                                Filter e = (Filter)some.x();
                                closeableIterator = (CloseableIterator)this.transform$1.apply((Object)features.filter((Function1)new Serializable(this, e){
                                    public static final long serialVersionUID = 0L;
                                    private final Filter e$1;

                                    public final boolean apply(Object x$1) {
                                        return this.e$1.evaluate(x$1);
                                    }
                                    {
                                        this.e$1 = e$1;
                                    }
                                }));
                            }
                            return closeableIterator;
                        }
                        throw new MatchError((Object)option);
                    }
                    {
                        this.ecql$1 = ecql$1;
                        this.serializer$1 = serializer$1;
                        this.idSerializer$1 = idSerializer$1;
                        this.transform$1 = transform$1;
                    }
                };
                cassandraQueryPlan = new StatementPlan(filter2, (Seq<String>)tables, (Seq<Statement>)statements, this.org$locationtech$geomesa$cassandra$data$CassandraIndexAdapter$$ds.config().queryThreads(), (Option<Filter>)ecql2, (Function1<CloseableIterator<Row>, CloseableIterator<SimpleFeature>>)rowsToFeatures);
            }
            return cassandraQueryPlan;
        }
        throw new MatchError((Object)queryStrategy);
    }

    public CassandraIndexWriter createWriter(SimpleFeatureType sft, Seq<GeoMesaFeatureIndex<?, ?>> indices, Option<String> partition) {
        return new CassandraIndexWriter(this.org$locationtech$geomesa$cassandra$data$CassandraIndexAdapter$$ds, indices, WritableFeature$.MODULE$.wrapper(sft, this.groups()), partition);
    }

    public CassandraIndexAdapter(CassandraDataStore ds) {
        this.org$locationtech$geomesa$cassandra$data$CassandraIndexAdapter$$ds = ds;
        IndexAdapter.class.$init$((IndexAdapter)this);
        StrictLogging.class.$init$((StrictLogging)this);
        this.tableNameLimit = new Some((Object)BoxesRunTime.boxToInteger((int)CassandraIndexAdapter$.MODULE$.TableNameLimit()));
    }

    public static class CassandraIndexWriter
    extends IndexAdapter.IndexWriter
    implements StrictLogging {
        public final CassandraDataStore org$locationtech$geomesa$cassandra$data$CassandraIndexAdapter$CassandraIndexWriter$$ds;
        public final Option<String> org$locationtech$geomesa$cassandra$data$CassandraIndexAdapter$CassandraIndexWriter$$partition;
        private final Tuple3<CassandraColumnMapper, PreparedStatement, PreparedStatement>[] mappers;
        private int i;
        private final Logger logger;

        public Logger logger() {
            return this.logger;
        }

        public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
            this.logger = x$1;
        }

        private Tuple3<CassandraColumnMapper, PreparedStatement, PreparedStatement>[] mappers() {
            return this.mappers;
        }

        private int i() {
            return this.i;
        }

        private void i_$eq(int x$1) {
            this.i = x$1;
        }

        public void write(WritableFeature feature, package.RowKeyValue<?>[] values, boolean update) {
            this.i_$eq(0);
            while (this.i() < values.length) {
                Tuple3<CassandraColumnMapper, PreparedStatement, PreparedStatement> tuple3;
                block6: {
                    package.RowKeyValue<?> rowKeyValue;
                    block9: {
                        block8: {
                            BoxedUnit boxedUnit;
                            PreparedStatement statement2;
                            CassandraColumnMapper mapper;
                            block7: {
                                BoxedUnit boxedUnit2;
                                Tuple2 tuple2;
                                tuple3 = this.mappers()[this.i()];
                                if (tuple3 == null) break block6;
                                CassandraColumnMapper mapper2 = (CassandraColumnMapper)tuple3._1();
                                PreparedStatement statement3 = (PreparedStatement)tuple3._2();
                                Tuple2 tuple22 = tuple2 = new Tuple2((Object)mapper2, (Object)statement3);
                                mapper = (CassandraColumnMapper)tuple22._1();
                                statement2 = (PreparedStatement)tuple22._2();
                                rowKeyValue = values[this.i()];
                                if (!(rowKeyValue instanceof package.SingleRowKeyValue)) break block7;
                                package.SingleRowKeyValue singleRowKeyValue = (package.SingleRowKeyValue)rowKeyValue;
                                Seq<Object> bindings = mapper.bind(singleRowKeyValue);
                                if (this.logger().underlying().isTraceEnabled()) {
                                    this.logger().underlying().trace("{} : {}", (Object[])new String[]{statement2.getQueryString(), CassandraIndexAdapter$.MODULE$.org$locationtech$geomesa$cassandra$data$CassandraIndexAdapter$$debug(bindings)});
                                    boxedUnit2 = BoxedUnit.UNIT;
                                } else {
                                    boxedUnit2 = BoxedUnit.UNIT;
                                }
                                boxedUnit = this.org$locationtech$geomesa$cassandra$data$CassandraIndexAdapter$CassandraIndexWriter$$ds.session().execute((Statement)statement2.bind((Object[])bindings.toArray(ClassTag$.MODULE$.AnyRef())));
                                break block8;
                            }
                            if (!(rowKeyValue instanceof package.MultiRowKeyValue)) break block9;
                            package.MultiRowKeyValue multiRowKeyValue = (package.MultiRowKeyValue)rowKeyValue;
                            multiRowKeyValue.split().foreach((Function1)new Serializable(this, mapper, statement2){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ CassandraIndexWriter $outer;
                                private final CassandraColumnMapper mapper$2;
                                private final PreparedStatement statement$1;

                                public final ResultSet apply(package.SingleRowKeyValue<Object> kv) {
                                    BoxedUnit boxedUnit;
                                    Seq<Object> bindings = this.mapper$2.bind(kv);
                                    if (this.$outer.logger().underlying().isTraceEnabled()) {
                                        this.$outer.logger().underlying().trace("{} : {}", (Object[])new String[]{this.statement$1.getQueryString(), CassandraIndexAdapter$.MODULE$.org$locationtech$geomesa$cassandra$data$CassandraIndexAdapter$$debug(bindings)});
                                        boxedUnit = BoxedUnit.UNIT;
                                    } else {
                                        boxedUnit = BoxedUnit.UNIT;
                                    }
                                    return this.$outer.org$locationtech$geomesa$cassandra$data$CassandraIndexAdapter$CassandraIndexWriter$$ds.session().execute((Statement)this.statement$1.bind((Object[])bindings.toArray(ClassTag$.MODULE$.AnyRef())));
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.mapper$2 = mapper$2;
                                    this.statement$1 = statement$1;
                                }
                            });
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        this.i_$eq(this.i() + 1);
                        continue;
                    }
                    throw new MatchError(rowKeyValue);
                }
                throw new MatchError(tuple3);
            }
        }

        public void delete(WritableFeature feature, package.RowKeyValue<?>[] values) {
            this.i_$eq(0);
            while (this.i() < values.length) {
                Tuple3<CassandraColumnMapper, PreparedStatement, PreparedStatement> tuple3;
                block6: {
                    package.RowKeyValue<?> rowKeyValue;
                    block9: {
                        block8: {
                            BoxedUnit boxedUnit;
                            PreparedStatement statement2;
                            CassandraColumnMapper mapper;
                            block7: {
                                BoxedUnit boxedUnit2;
                                Tuple2 tuple2;
                                tuple3 = this.mappers()[this.i()];
                                if (tuple3 == null) break block6;
                                CassandraColumnMapper mapper2 = (CassandraColumnMapper)tuple3._1();
                                PreparedStatement statement3 = (PreparedStatement)tuple3._3();
                                Tuple2 tuple22 = tuple2 = new Tuple2((Object)mapper2, (Object)statement3);
                                mapper = (CassandraColumnMapper)tuple22._1();
                                statement2 = (PreparedStatement)tuple22._2();
                                rowKeyValue = values[this.i()];
                                if (!(rowKeyValue instanceof package.SingleRowKeyValue)) break block7;
                                package.SingleRowKeyValue singleRowKeyValue = (package.SingleRowKeyValue)rowKeyValue;
                                Seq<Object> bindings = mapper.bindDelete(singleRowKeyValue);
                                if (this.logger().underlying().isTraceEnabled()) {
                                    this.logger().underlying().trace("{} : {}", (Object[])new String[]{statement2.getQueryString(), CassandraIndexAdapter$.MODULE$.org$locationtech$geomesa$cassandra$data$CassandraIndexAdapter$$debug(bindings)});
                                    boxedUnit2 = BoxedUnit.UNIT;
                                } else {
                                    boxedUnit2 = BoxedUnit.UNIT;
                                }
                                boxedUnit = this.org$locationtech$geomesa$cassandra$data$CassandraIndexAdapter$CassandraIndexWriter$$ds.session().execute((Statement)statement2.bind((Object[])bindings.toArray(ClassTag$.MODULE$.AnyRef())));
                                break block8;
                            }
                            if (!(rowKeyValue instanceof package.MultiRowKeyValue)) break block9;
                            package.MultiRowKeyValue multiRowKeyValue = (package.MultiRowKeyValue)rowKeyValue;
                            multiRowKeyValue.split().foreach((Function1)new Serializable(this, mapper, statement2){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ CassandraIndexWriter $outer;
                                private final CassandraColumnMapper mapper$3;
                                private final PreparedStatement statement$2;

                                public final ResultSet apply(package.SingleRowKeyValue<Object> kv) {
                                    BoxedUnit boxedUnit;
                                    Seq<Object> bindings = this.mapper$3.bindDelete(kv);
                                    if (this.$outer.logger().underlying().isTraceEnabled()) {
                                        this.$outer.logger().underlying().trace("{} : {}", (Object[])new String[]{this.statement$2.getQueryString(), CassandraIndexAdapter$.MODULE$.org$locationtech$geomesa$cassandra$data$CassandraIndexAdapter$$debug(bindings)});
                                        boxedUnit = BoxedUnit.UNIT;
                                    } else {
                                        boxedUnit = BoxedUnit.UNIT;
                                    }
                                    return this.$outer.org$locationtech$geomesa$cassandra$data$CassandraIndexAdapter$CassandraIndexWriter$$ds.session().execute((Statement)this.statement$2.bind((Object[])bindings.toArray(ClassTag$.MODULE$.AnyRef())));
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.mapper$3 = mapper$3;
                                    this.statement$2 = statement$2;
                                }
                            });
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        this.i_$eq(this.i() + 1);
                        continue;
                    }
                    throw new MatchError(rowKeyValue);
                }
                throw new MatchError(tuple3);
            }
        }

        public void flush() {
        }

        public void close() {
        }

        public CassandraIndexWriter(CassandraDataStore ds, Seq<GeoMesaFeatureIndex<?, ?>> indices, WritableFeature.FeatureWrapper wrapper, Option<String> partition) {
            this.org$locationtech$geomesa$cassandra$data$CassandraIndexAdapter$CassandraIndexWriter$$ds = ds;
            this.org$locationtech$geomesa$cassandra$data$CassandraIndexAdapter$CassandraIndexWriter$$partition = partition;
            super(indices, wrapper);
            StrictLogging.class.$init$((StrictLogging)this);
            this.mappers = (Tuple3[])Predef$.MODULE$.refArrayOps((Object[])super.indices().toArray(ClassTag$.MODULE$.apply(GeoMesaFeatureIndex.class))).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ CassandraIndexWriter $outer;

                public final Tuple3<CassandraColumnMapper, PreparedStatement, PreparedStatement> apply(GeoMesaFeatureIndex<?, ?> index) {
                    CassandraColumnMapper mapper = CassandraColumnMapper$.MODULE$.apply(index);
                    Seq seq = index.getTableNames(this.$outer.org$locationtech$geomesa$cassandra$data$CassandraIndexAdapter$CassandraIndexWriter$$partition);
                    Some some = Seq$.MODULE$.unapplySeq(seq);
                    if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0) {
                        String t;
                        String string;
                        String table = string = (t = (String)((SeqLike)some.get()).apply(0));
                        PreparedStatement insert = mapper.insert(this.$outer.org$locationtech$geomesa$cassandra$data$CassandraIndexAdapter$CassandraIndexWriter$$ds.session(), table);
                        PreparedStatement delete2 = mapper.delete(this.$outer.org$locationtech$geomesa$cassandra$data$CassandraIndexAdapter$CassandraIndexWriter$$ds.session(), table);
                        return new Tuple3((Object)mapper, (Object)insert, (Object)delete2);
                    }
                    throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected a single table but got: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{seq.mkString(", ")})));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple3.class)));
            this.i = 0;
        }
    }
}

