/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import net.sf.saxon.Controller;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceOutputter;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.event.TreeReceiver;
import net.sf.saxon.evpull.BracketedElementIterator;
import net.sf.saxon.evpull.EndElementEvent;
import net.sf.saxon.evpull.EventAnnotationStripper;
import net.sf.saxon.evpull.EventIterator;
import net.sf.saxon.evpull.SingletonEventIterator;
import net.sf.saxon.evpull.StartElementEvent;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.expr.instruct.ParentNodeConstructor;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.instruct.ValueOf;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.lib.Validation;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.UType;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.Cardinality;

public abstract class ElementCreator
extends ParentNodeConstructor {
    protected boolean inheritNamespacesToChildren = true;
    protected boolean inheritNamespacesFromParent = true;

    public ItemType getItemType() {
        return NodeKindTest.ELEMENT;
    }

    public int getCardinality() {
        return 16384;
    }

    public void setInheritNamespacesToChildren(boolean inherit) {
        this.inheritNamespacesToChildren = inherit;
    }

    public boolean isInheritNamespacesToChildren() {
        return this.inheritNamespacesToChildren;
    }

    public void setInheritNamespacesFromParent(boolean inherit) {
        this.inheritNamespacesFromParent = inherit;
    }

    public boolean isInheritNamespacesFromParent() {
        return this.inheritNamespacesFromParent;
    }

    public int computeSpecialProperties() {
        int p = super.computeSpecialProperties() | 0x800000;
        if (this.getValidationAction() == 4) {
            p |= 0x4000000;
        }
        return p;
    }

    public void suppressValidation(int parentValidationMode) {
        if (this.getValidationAction() == parentValidationMode && this.getSchemaType() == null) {
            this.setValidationAction(3, null);
        }
    }

    protected void checkContentSequence(StaticContext env) throws XPathException {
        if (this.getContentExpression() instanceof Block) {
            Operand[] components = ((Block)this.getContentExpression()).getOperanda();
            boolean foundChild = false;
            boolean foundPossibleChild = false;
            for (Operand o : components) {
                XPathException de;
                Expression component = o.getChildExpression();
                ItemType it = component.getItemType();
                if (!(it instanceof NodeTest)) continue;
                boolean maybeEmpty = Cardinality.allowsZero(component.getCardinality());
                UType possibleNodeKinds = it.getUType();
                if (possibleNodeKinds.overlaps(UType.TEXT)) {
                    if (component instanceof ValueOf && ((ValueOf)component).getSelect() instanceof StringLiteral) {
                        String value = ((StringLiteral)((ValueOf)component).getSelect()).getStringValue();
                        if (value.isEmpty()) continue;
                        foundChild = true;
                        continue;
                    }
                    foundPossibleChild = true;
                    continue;
                }
                if (!possibleNodeKinds.overlaps(UType.CHILD_NODE_KINDS)) {
                    if (maybeEmpty) {
                        foundPossibleChild = true;
                        continue;
                    }
                    foundChild = true;
                    continue;
                }
                if (foundChild && possibleNodeKinds == UType.ATTRIBUTE && !maybeEmpty) {
                    de = new XPathException("Cannot create an attribute node after creating a child of the containing element");
                    de.setErrorCode(this.isXSLT() ? "XTDE0410" : "XQTY0024");
                    de.setLocator(component.getLocation());
                    throw de;
                }
                if (foundChild && possibleNodeKinds == UType.NAMESPACE && !maybeEmpty) {
                    de = new XPathException("Cannot create a namespace node after creating a child of the containing element");
                    de.setErrorCode(this.isXSLT() ? "XTDE0410" : "XQTY0024");
                    de.setLocator(component.getLocation());
                    throw de;
                }
                if ((foundChild || foundPossibleChild) && possibleNodeKinds == UType.ATTRIBUTE) {
                    env.issueWarning("Creating an attribute here will fail if previous instructions create any children", component.getLocation());
                    continue;
                }
                if (!foundChild && !foundPossibleChild || possibleNodeKinds != UType.NAMESPACE) continue;
                env.issueWarning("Creating a namespace node here will fail if previous instructions create any children", component.getLocation());
            }
        }
    }

    public abstract NodeName getElementName(XPathContext var1, NodeInfo var2) throws XPathException;

    public abstract String getNewBaseURI(XPathContext var1, NodeInfo var2);

    public abstract void outputNamespaceNodes(XPathContext var1, Receiver var2, NodeName var3, NodeInfo var4) throws XPathException;

    public NamespaceBinding[] getActiveNamespaces() throws XPathException {
        return null;
    }

    public int getImplementationMethod() {
        return 5;
    }

    public EventIterator iterateEvents(XPathContext context) throws XPathException {
        return this.iterateEvents(context, null);
    }

    protected EventIterator iterateEvents(XPathContext context, NodeInfo copiedNode) throws XPathException {
        if (!this.preservingTypes && this.getValidationAction() != 4) {
            return new SingletonEventIterator(this.evaluateItem(context));
        }
        Controller controller = context.getController();
        assert (controller != null);
        StartElementEvent start = new StartElementEvent(controller.makePipelineConfiguration());
        start.setElementName(this.getElementName(context, copiedNode));
        start.setTypeCode(this.getValidationAction() == 3 ? AnyType.getInstance() : Untyped.getInstance());
        start.setLocalNamespaces(this.getActiveNamespaces());
        start.setLocation(this.getLocation());
        BracketedElementIterator result = new BracketedElementIterator(start, this.getContentExpression().iterateEvents(context), EndElementEvent.getInstance());
        if (this.getValidationAction() == 4 && controller.getExecutable().isSchemaAware()) {
            return new EventAnnotationStripper(result);
        }
        return result;
    }

    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        return this.processLeavingTail(context, null);
    }

    public final TailCall processLeavingTail(XPathContext context, NodeInfo copiedNode) throws XPathException {
        try {
            int properties;
            SequenceReceiver out;
            NodeName elemName = this.getElementName(context, copiedNode);
            ComplexType typeCode = this.getValidationAction() == 3 ? AnyType.getInstance() : Untyped.getInstance();
            SequenceReceiver saved = out = context.getReceiver();
            boolean pop = false;
            SequenceReceiver elemOut = out;
            if (!this.preservingTypes) {
                ParseOptions options = new ParseOptions(this.getValidationOptions());
                options.setTopLevelElement(elemName.getStructuredQName());
                context.getConfiguration().prepareValidationReporting(context, options);
                SequenceReceiver validator = context.getConfiguration().getElementValidator(out, options, this.getLocation());
                if (validator != out) {
                    out = new TreeReceiver(validator);
                    context.setReceiver(out);
                    pop = true;
                }
                elemOut = out;
            }
            if (elemOut.getSystemId() == null) {
                elemOut.setSystemId(this.getNewBaseURI(context, copiedNode));
            }
            int n = properties = this.inheritNamespacesToChildren ? 0 : 128;
            if (!this.inheritNamespacesFromParent) {
                properties |= 0x10000;
            }
            elemOut.startElement(elemName, typeCode, this.getLocation(), properties);
            this.outputNamespaceNodes(context, elemOut, elemName, copiedNode);
            this.getContentExpression().process(context);
            elemOut.endElement();
            if (pop) {
                context.setReceiver(saved);
            }
            return null;
        }
        catch (XPathException e) {
            e.maybeSetLocation(this.getLocation());
            e.maybeSetContext(context);
            throw e;
        }
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        if (this.isLazyConstruction() && this.preservingTypes) {
            return context.getConfiguration().makeUnconstructedElement(this, context);
        }
        NodeInfo node = this.constructElement(context, null);
        return node;
    }

    private NodeInfo constructElement(XPathContext context, NodeInfo copiedNode) throws XPathException {
        try {
            int properties;
            Controller controller = context.getController();
            SequenceReceiver saved = context.getReceiver();
            SequenceOutputter seq = controller.allocateSequenceOutputter(1);
            seq.getPipelineConfiguration().setHostLanguage(this.getHostLanguage());
            seq.getPipelineConfiguration().setLocationIsCodeLocation(true);
            NodeName elemName = this.getElementName(context, copiedNode);
            ComplexType typeCode = this.getValidationAction() == 3 ? AnyType.getInstance() : Untyped.getInstance();
            SequenceReceiver ini = seq;
            if (!this.preservingTypes) {
                ParseOptions options = new ParseOptions(this.getValidationOptions());
                options.setTopLevelElement(elemName.getStructuredQName());
                controller.getConfiguration().prepareValidationReporting(context, options);
                SequenceReceiver validator = controller.getConfiguration().getElementValidator(ini, options, this.getLocation());
                if (ini.getSystemId() == null) {
                    ini.setSystemId(this.getNewBaseURI(context, copiedNode));
                }
                if (validator == ini) {
                    context.setReceiver(ini);
                } else {
                    TreeReceiver tr = new TreeReceiver(validator);
                    tr.setPipelineConfiguration(seq.getPipelineConfiguration());
                    context.setReceiver(tr);
                    ini = tr;
                }
            } else {
                context.setReceiver(ini);
                if (ini.getSystemId() == null) {
                    ini.setSystemId(this.getNewBaseURI(context, copiedNode));
                }
            }
            ini.open();
            int n = properties = this.inheritNamespacesToChildren ? 0 : 128;
            if (!this.inheritNamespacesFromParent) {
                properties |= 0x10000;
            }
            ini.startElement(elemName, typeCode, this.getLocation(), properties);
            this.outputNamespaceNodes(context, ini, elemName, null);
            this.getContentExpression().process(context);
            ini.endElement();
            ini.close();
            context.setReceiver(saved);
            NodeInfo result = (NodeInfo)seq.popLastItem();
            seq.reset();
            return result;
        }
        catch (XPathException err) {
            if (err instanceof ValidationException) {
                ((ValidationException)err).setLocation(this.getLocation());
                ((ValidationException)err).setSystemId(this.getSystemId());
            }
            err.maybeSetLocation(this.getLocation());
            err.maybeSetContext(context);
            throw err;
        }
    }

    protected void exportValidationAndType(ExpressionPresenter out) {
        SchemaType type;
        if (this.getValidationAction() != 4 && this.getValidationAction() != 8) {
            out.emitAttribute("validation", Validation.toString(this.getValidationAction()));
        }
        if (this.getValidationAction() == 8 && (type = this.getSchemaType()) != null) {
            out.emitAttribute("type", type.getStructuredQName());
        }
    }

    protected String getInheritanceFlags() {
        String flags = "";
        if (!this.inheritNamespacesFromParent) {
            flags = flags + "P";
        }
        if (!this.inheritNamespacesToChildren) {
            flags = flags + "C";
        }
        return flags;
    }

    public void setInheritanceFlags(String flags) {
        this.inheritNamespacesFromParent = !flags.contains("P");
        this.inheritNamespacesToChildren = !flags.contains("C");
    }
}

