/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.fs.storage.common;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import org.apache.hadoop.fs.Path;
import org.geotools.data.Query;
import org.geotools.filter.text.ecql.ECQL;
import org.locationtech.geomesa.fs.storage.api.FileSystemStorage;
import org.locationtech.geomesa.fs.storage.api.StorageMetadata;
import org.locationtech.geomesa.fs.storage.api.package;
import org.locationtech.geomesa.fs.storage.common.AbstractFileSystemStorage$;
import org.locationtech.geomesa.fs.storage.common.FileSystemThreadedReader$;
import org.locationtech.geomesa.fs.storage.common.utils.PathCache$;
import org.locationtech.geomesa.fs.storage.common.utils.StorageUtils$;
import org.locationtech.geomesa.fs.storage.common.utils.StorageUtils$FileType$;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.index.planning.QueryRunner$;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.locationtech.geomesa.utils.collection.CloseableIterator$;
import org.locationtech.geomesa.utils.io.WithClose$;
import org.locationtech.geomesa.utils.stats.MethodProfiling;
import org.locationtech.jts.geom.Envelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.IncludeFilter;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.Nothing$;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\tMe!B\u0001\u0003\u0003\u0003y!!G!cgR\u0014\u0018m\u0019;GS2,7+_:uK6\u001cFo\u001c:bO\u0016T!a\u0001\u0003\u0002\r\r|W.\\8o\u0015\t)a!A\u0004ti>\u0014\u0018mZ3\u000b\u0005\u001dA\u0011A\u00014t\u0015\tI!\"A\u0004hK>lWm]1\u000b\u0005-a\u0011\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001\u0001b\u0003\b\u0013\u0011\u0005E!R\"\u0001\n\u000b\u0003M\tQa]2bY\u0006L!!\u0006\n\u0003\r\u0005s\u0017PU3g!\t9\"$D\u0001\u0019\u0015\tIB!A\u0002ba&L!a\u0007\r\u0003#\u0019KG.Z*zgR,Wn\u0015;pe\u0006<W\r\u0005\u0002\u001eE5\taD\u0003\u0002 A\u0005)1\u000f^1ug*\u0011\u0011\u0005C\u0001\u0006kRLGn]\u0005\u0003Gy\u0011q\"T3uQ>$\u0007K]8gS2Lgn\u001a\t\u0003K1j\u0011A\n\u0006\u0003O!\nAb]2bY\u0006dwnZ4j]\u001eT!!\u000b\u0016\u0002\u0011QL\b/Z:bM\u0016T\u0011aK\u0001\u0004G>l\u0017BA\u0017'\u0005-a\u0015M_=M_\u001e<\u0017N\\4\t\u0011=\u0002!Q1A\u0005\u0002A\nqaY8oi\u0016DH/F\u00012!\t\u0011DI\u0004\u00024\u0005:\u0011A'\u0011\b\u0003k\u0001s!AN \u000f\u0005]rdB\u0001\u001d>\u001d\tID(D\u0001;\u0015\tYd\"\u0001\u0004=e>|GOP\u0005\u0002\u001b%\u00111\u0002D\u0005\u0003\u0013)I!a\u0002\u0005\n\u0005\u00151\u0011BA\r\u0005\u0013\t\u0019\u0005$A\u0004qC\u000e\\\u0017mZ3\n\u0005\u00153%!\u0005$jY\u0016\u001c\u0016p\u001d;f[\u000e{g\u000e^3yi*\u00111\t\u0007\u0005\t\u0011\u0002\u0011\t\u0011)A\u0005c\u0005A1m\u001c8uKb$\b\u0005\u0003\u0005K\u0001\t\u0015\r\u0011\"\u0001L\u0003!iW\r^1eCR\fW#\u0001'\u0011\u0005]i\u0015B\u0001(\u0019\u0005=\u0019Fo\u001c:bO\u0016lU\r^1eCR\f\u0007\u0002\u0003)\u0001\u0005\u0003\u0005\u000b\u0011\u0002'\u0002\u00135,G/\u00193bi\u0006\u0004\u0003\u0002\u0003*\u0001\u0005\u0003\u0005\u000b\u0011B*\u0002\u0013\u0015DH/\u001a8tS>t\u0007C\u0001+X\u001d\t\tR+\u0003\u0002W%\u00051\u0001K]3eK\u001aL!\u0001W-\u0003\rM#(/\u001b8h\u0015\t1&\u0003C\u0003\\\u0001\u0011\u0005A,\u0001\u0004=S:LGO\u0010\u000b\u0005;~\u0003\u0017\r\u0005\u0002_\u00015\t!\u0001C\u000305\u0002\u0007\u0011\u0007C\u0003K5\u0002\u0007A\nC\u0003S5\u0002\u00071\u000bC\u0003d\u0001\u0019EA-\u0001\u0007de\u0016\fG/Z,sSR,'\u000fF\u0002fY^\u0004\"AZ5\u000f\u0005M:\u0017B\u00015\u0019\u0003E1\u0015\u000e\\3TsN$X-\\*u_J\fw-Z\u0005\u0003U.\u0014\u0001CR5mKNK8\u000f^3n/JLG/\u001a:\u000b\u0005!D\u0002\"B7c\u0001\u0004q\u0017\u0001\u00024jY\u0016\u0004\"a\\;\u000e\u0003AT!aB9\u000b\u0005I\u001c\u0018A\u00025bI>|\u0007O\u0003\u0002u\u0019\u00051\u0011\r]1dQ\u0016L!A\u001e9\u0003\tA\u000bG\u000f\u001b\u0005\u0006q\n\u0004\r!_\u0001\tG\u0006dGNY1dWB\u0019!0!\u0003\u000f\u0005mlhB\u0001\u001b}\u0013\t\u0019AaB\u0003\u007f\u0005!\u0005q0A\rBEN$(/Y2u\r&dWmU=ti\u0016l7\u000b^8sC\u001e,\u0007c\u00010\u0002\u0002\u00191\u0011A\u0001E\u0001\u0003\u0007\u00192!!\u0001\u0011\u0011\u001dY\u0016\u0011\u0001C\u0001\u0003\u000f!\u0012a \u0004\u000b\u0003\u0017\t\t\u0001%A\u0012\u0002\u00055!AD,sSR,'oQ1mY\n\f7m[\n\u0004\u0003\u0013\u0001\u0002\u0002CA\t\u0003\u00131\t!a\u0005\u0002\u000f=t7\t\\8tKR1\u0011QCA\u000e\u0003_\u00012!EA\f\u0013\r\tIB\u0005\u0002\u0005+:LG\u000f\u0003\u0005\u0002\u001e\u0005=\u0001\u0019AA\u0010\u0003\u0019\u0011w.\u001e8egB!\u0011\u0011EA\u0016\u001b\t\t\u0019C\u0003\u0003\u0002&\u0005\u001d\u0012\u0001B4f_6T1!!\u000b\u000b\u0003\rQGo]\u0005\u0005\u0003[\t\u0019C\u0001\u0005F]Z,Gn\u001c9f\u0011!\t\t$a\u0004A\u0002\u0005M\u0012!B2pk:$\bcA\t\u00026%\u0019\u0011q\u0007\n\u0003\t1{gn\u001a\u0004\u000b\u0003w\t\t\u0001%A\u0012\u0002\u0005u\"\u0001\u0006$jY\u0016\u001c\u0016p\u001d;f[B\u000bG\u000f\u001b*fC\u0012,'oE\u0002\u0002:AA\u0001\"!\u0011\u0002:\u0019\u0005\u00111I\u0001\u0005e\u0016\fG\r\u0006\u0003\u0002F\u0005\u0015\u0004CBA$\u0003\u001b\n\t&\u0004\u0002\u0002J)\u0019\u00111\n\u0011\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002P\u0005%#!E\"m_N,\u0017M\u00197f\u0013R,'/\u0019;peB!\u00111KA1\u001b\t\t)F\u0003\u0003\u0002X\u0005e\u0013AB:j[BdWM\u0003\u0003\u0002\\\u0005u\u0013a\u00024fCR,(/\u001a\u0006\u0004\u0003?b\u0011aB8qK:<\u0017n]\u0005\u0005\u0003G\n)FA\u0007TS6\u0004H.\u001a$fCR,(/\u001a\u0005\b\u0003O\ny\u00041\u0001o\u0003\u0011\u0001\u0018\r\u001e5\u0007\u0015\u0005-\u0014\u0011\u0001I\u0001\u0004\u0003\tiGA\u0011NKR\fG-\u0019;b\u001f\n\u001cXM\u001d<j]\u001e4\u0015\u000e\\3TsN$X-\\,sSR,'oE\u0003\u0002j\u0005=T\r\u0005\u0003\u0002r\u0005mTBAA:\u0015\u0011\t)(a\u001e\u0002\t1\fgn\u001a\u0006\u0003\u0003s\nAA[1wC&!\u0011QPA:\u0005\u0019y%M[3di\"A\u0011\u0011QA5\t\u0003\t\u0019)\u0001\u0004%S:LG\u000f\n\u000b\u0003\u0003+Aq\u0001_A5\r\u0003\t9)\u0006\u0002\u0002\nB!\u00111RA\u0005\u001b\t\t\t\u0001\u0003\u0006\u00022\u0005%\u0004\u0019!C\u0005\u0003\u001f+\"!a\r\t\u0015\u0005M\u0015\u0011\u000ea\u0001\n\u0013\t)*A\u0005d_VtGo\u0018\u0013fcR!\u0011QCAL\u0011)\tI*!%\u0002\u0002\u0003\u0007\u00111G\u0001\u0004q\u0012\n\u0004\"CAO\u0003S\u0002\u000b\u0015BA\u001a\u0003\u0019\u0019w.\u001e8uA!Q\u0011QDA5\u0005\u0004%I!!)\u0016\u0005\u0005}\u0001\"CAS\u0003S\u0002\u000b\u0011BA\u0010\u0003\u001d\u0011w.\u001e8eg\u0002B\u0011\"!+\u0002jA%\t!a+\u0002\u000b]\u0014\u0018\u000e^3\u0015\t\u0005U\u0011Q\u0016\u0005\t\u00037\n9\u000b1\u0001\u0002R!I\u0011\u0011WA5!\u0013\u0005\u00111Q\u0001\u0006G2|7/\u001a\u0005\u0010\u0003k\u000bI\u0007%A\u0002\u0002\u0003%I!a.\u0002<\u0006Y1/\u001e9fe\u0012:(/\u001b;f)\u0011\t)\"!/\t\u0011\u0005m\u00131\u0017a\u0001\u0003#J1!!+j\u0011=\ty,!\u001b\u0011\u0002\u0007\u0005\t\u0011\"\u0003\u0002\u0004\u0006\u0005\u0017aC:va\u0016\u0014He\u00197pg\u0016LA!!-\u0002D&!\u0011QYAd\u0005%\u0019En\\:fC\ndWM\u0003\u0003\u0002J\u0006]\u0014AA5p\u0011\u001d\ti\r\u0001D\t\u0003\u001f\fAb\u0019:fCR,'+Z1eKJ$b!!5\u0002T\u0006\u001d\bc\u0001>\u0002:!A\u0011Q[Af\u0001\u0004\t9.\u0001\u0004gS2$XM\u001d\t\u0006#\u0005e\u0017Q\\\u0005\u0004\u00037\u0014\"AB(qi&|g\u000e\u0005\u0003\u0002`\u0006\rXBAAq\u0015\u0011\t).!\u0018\n\t\u0005\u0015\u0018\u0011\u001d\u0002\u0007\r&dG/\u001a:\t\u0011\u0005%\u00181\u001aa\u0001\u0003W\f\u0011\u0002\u001e:b]N4wN]7\u0011\u000bE\tI.!<\u0011\rE\tyoUAz\u0013\r\t\tP\u0005\u0002\u0007)V\u0004H.\u001a\u001a\u0011\t\u0005M\u0013Q_\u0005\u0005\u0003o\f)FA\tTS6\u0004H.\u001a$fCR,(/\u001a+za\u0016Dq!a?\u0001\t\u0003\ni0\u0001\u0007hKR4\u0015\u000e\\3QCRD7\u000f\u0006\u0003\u0002\u0000\n=\u0001#\u0002B\u0001\u0005\u0013qg\u0002\u0002B\u0002\u0005\u000fq1!\u000fB\u0003\u0013\u0005\u0019\u0012BA\"\u0013\u0013\u0011\u0011YA!\u0004\u0003\u0007M+\u0017O\u0003\u0002D%!9!\u0011CA}\u0001\u0004\u0019\u0016!\u00039beRLG/[8o\u0011\u001d\u0011)\u0002\u0001C!\u0005/\t\u0011bZ3u/JLG/\u001a:\u0015\u0007\u0015\u0014I\u0002C\u0004\u0003\u0012\tM\u0001\u0019A*\t\u000f\tu\u0001\u0001\"\u0011\u0003 \u0005Iq-\u001a;SK\u0006$WM\u001d\u000b\t\u0005C\u00119Ca\u000f\u0003@A\u0019!Ga\t\n\u0007\t\u0015bI\u0001\rDY>\u001cX-\u00192mK\u001a+\u0017\r^;sK&#XM]1u_JD\u0001B!\u000b\u0003\u001c\u0001\u0007!1F\u0001\t_JLw-\u001b8bYB!!Q\u0006B\u001c\u001b\t\u0011yC\u0003\u0003\u00032\tM\u0012\u0001\u00023bi\u0006T1A!\u000e\r\u0003!9Wm\u001c;p_2\u001c\u0018\u0002\u0002B\u001d\u0005_\u0011Q!U;fefD!B!\u0005\u0003\u001cA\u0005\t\u0019\u0001B\u001f!\u0011\t\u0012\u0011\\*\t\u0015\t\u0005#1\u0004I\u0001\u0002\u0004\u0011\u0019%A\u0004uQJ,\u0017\rZ:\u0011\u0007E\u0011)%C\u0002\u0003HI\u00111!\u00138u\u0011\u001d\u0011Y\u0005\u0001C!\u0005\u001b\nqaY8na\u0006\u001cG\u000f\u0006\u0004\u0002\u0016\t=#\u0011\u000b\u0005\t\u0005#\u0011I\u00051\u0001\u0003>!Q!\u0011\tB%!\u0003\u0005\rAa\u0011\u0007\r\tU\u0003\u0001\u0001B,\u0005-\tE\rZ\"bY2\u0014\u0017mY6\u0014\t\tM\u0003#\u001f\u0005\u000b\u0005#\u0011\u0019F!A!\u0002\u0013\u0019\u0006\"C7\u0003T\t\u0005\t\u0015!\u0003o\u0011\u001dY&1\u000bC\u0001\u0005?\"bA!\u0019\u0003f\t\u001d\u0004\u0003\u0002B2\u0005'j\u0011\u0001\u0001\u0005\b\u0005#\u0011i\u00061\u0001T\u0011\u0019i'Q\fa\u0001]\"A\u0011\u0011\u0003B*\t\u0003\u0012Y\u0007\u0006\u0004\u0002\u0016\t5$q\u000e\u0005\t\u0003;\u0011I\u00071\u0001\u0002 !A\u0011\u0011\u0007B5\u0001\u0004\t\u0019D\u0002\u0004\u0003t\u0001\u0001!Q\u000f\u0002\u0010\u0007>l\u0007/Y2u\u0007\u0006dGNY1dWN!!\u0011\u000f\tz\u0011)\u0011\tB!\u001d\u0003\u0002\u0003\u0006Ia\u0015\u0005\n[\nE$\u0011!Q\u0001\n9D1B! \u0003r\t\u0005\t\u0015!\u0003\u0002\u0000\u0006A!/\u001a9mC\u000e,G\rC\u0004\\\u0005c\"\tA!!\u0015\u0011\t\r%Q\u0011BD\u0005\u0013\u0003BAa\u0019\u0003r!9!\u0011\u0003B@\u0001\u0004\u0019\u0006BB7\u0003\u0000\u0001\u0007a\u000e\u0003\u0005\u0003~\t}\u0004\u0019AA\u0000\u0011!\t\tB!\u001d\u0005B\t5ECBA\u000b\u0005\u001f\u0013\t\n\u0003\u0005\u0002\u001e\t-\u0005\u0019AA\u0010\u0011!\t\tDa#A\u0002\u0005M\u0002")
public abstract class AbstractFileSystemStorage
implements FileSystemStorage,
MethodProfiling {
    private final package.FileSystemContext context;
    private final StorageMetadata metadata;
    public final String org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$$extension;
    private final Logger logger;
    private volatile boolean bitmap$0;

    public <R> R profile(Function1<Object, BoxedUnit> onComplete, Function0<R> code) {
        return (R)MethodProfiling.class.profile((MethodProfiling)this, onComplete, code);
    }

    public <R> R profile(Function2<R, Object, BoxedUnit> onComplete, Function0<R> code) {
        return (R)MethodProfiling.class.profile((MethodProfiling)this, onComplete, code);
    }

    public <R> R profile(String message, Function0<R> code) {
        return (R)MethodProfiling.class.profile((MethodProfiling)this, (String)message, code);
    }

    private Logger logger$lzycompute() {
        AbstractFileSystemStorage abstractFileSystemStorage = this;
        synchronized (abstractFileSystemStorage) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public Seq<StorageMetadata.PartitionMetadata> getPartitions() {
        return FileSystemStorage.class.getPartitions((FileSystemStorage)this);
    }

    public Seq<StorageMetadata.PartitionMetadata> getPartitions(Filter filter) {
        return FileSystemStorage.class.getPartitions((FileSystemStorage)this, (Filter)filter);
    }

    public Seq<package.PartitionFilter> getPartitionFilters(Filter filter, Option<String> partition) {
        return FileSystemStorage.class.getPartitionFilters((FileSystemStorage)this, (Filter)filter, partition);
    }

    public void close() {
        FileSystemStorage.class.close((FileSystemStorage)this);
    }

    public Option<String> getPartitionFilters$default$2() {
        return FileSystemStorage.class.getPartitionFilters$default$2((FileSystemStorage)this);
    }

    public Option<String> getReader$default$2() {
        return FileSystemStorage.class.getReader$default$2((FileSystemStorage)this);
    }

    public int getReader$default$3() {
        return FileSystemStorage.class.getReader$default$3((FileSystemStorage)this);
    }

    public int compact$default$2() {
        return package.Compactable.class.compact$default$2((package.Compactable)this);
    }

    public package.FileSystemContext context() {
        return this.context;
    }

    public StorageMetadata metadata() {
        return this.metadata;
    }

    public abstract FileSystemStorage.FileSystemWriter createWriter(Path var1, WriterCallback var2);

    public abstract FileSystemPathReader createReader(Option<Filter> var1, Option<Tuple2<String, SimpleFeatureType>> var2);

    public Seq<Path> getFilePaths(String partition) {
        Path baseDir = StorageUtils$.MODULE$.baseDirectory(this.context().root(), partition, this.metadata().leafStorage());
        Seq files = (Seq)this.metadata().getPartition(partition).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<String> apply(StorageMetadata.PartitionMetadata x$1) {
                return x$1.files();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Nothing$> apply() {
                return (Seq)Seq$.MODULE$.empty();
            }
        });
        return (Seq)files.flatMap((Function1)new Serializable(this, baseDir){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AbstractFileSystemStorage $outer;
            private final Path baseDir$1;

            public final Seq<Path> apply(String file) {
                Seq seq;
                Path path = new Path(this.baseDir$1, file);
                if (PathCache$.MODULE$.exists(this.$outer.context().fc(), path, PathCache$.MODULE$.exists$default$3())) {
                    seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Path[]{path}));
                } else {
                    BoxedUnit boxedUnit;
                    if (this.$outer.logger().underlying().isWarnEnabled()) {
                        this.$outer.logger().underlying().warn("Inconsistent metadata for {}: {}", new Object[]{this.$outer.metadata().sft().getTypeName(), path});
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    seq = (Seq)Seq$.MODULE$.empty();
                }
                return seq;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.baseDir$1 = baseDir$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public FileSystemStorage.FileSystemWriter getWriter(String partition) {
        Path path = StorageUtils$.MODULE$.nextFile(this.context().root(), partition, this.metadata().leafStorage(), this.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$$extension, StorageUtils$FileType$.MODULE$.Written());
        PathCache$.MODULE$.register(this.context().fc(), path, PathCache$.MODULE$.register$default$3(), PathCache$.MODULE$.register$default$4());
        return this.createWriter(path, new AddCallback(this, partition, path));
    }

    public Iterator<SimpleFeature> getReader(Query original, Option<String> partition, int threads) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        BoxedUnit boxedUnit3;
        BoxedUnit boxedUnit4;
        Query query = QueryRunner$.MODULE$.configureDefaultQuery(this.metadata().sft(), original);
        Option transform = QueryHints$.MODULE$.RichHints(query.getHints()).getTransform();
        Filter filter = (Filter)Option$.MODULE$.apply((Object)query.getFilter()).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final IncludeFilter apply() {
                return Filter.INCLUDE;
            }
        });
        Seq<package.PartitionFilter> filters = this.getPartitionFilters(filter, partition);
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Running query '{}' {}", (Object[])new String[]{query.getTypeName(), ECQL.toCQL((Filter)query.getFilter())});
            boxedUnit4 = BoxedUnit.UNIT;
        } else {
            boxedUnit4 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("  Original filter: {}", new Object[]{ECQL.toCQL((Filter)original.getFilter())});
            boxedUnit3 = BoxedUnit.UNIT;
        } else {
            boxedUnit3 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"  Transforms: "})).s((Seq)Nil$.MODULE$)).append(QueryHints$.MODULE$.RichHints(query.getHints()).getTransformDefinition().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(String t) {
                    return t.isEmpty() ? "empty" : t;
                }
            }).getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "none";
                }
            })).toString());
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"  Threading the read of ", " partitions with "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)filters.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(package.PartitionFilter x$2) {
                    return x$2.partitions().size();
                }
            }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " reader threads"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)threads)}))).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Iterator readers = filters.iterator().flatMap((Function1)new Serializable(this, transform){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AbstractFileSystemStorage $outer;
            private final Option transform$1;

            public final Iterator<Tuple2<FileSystemPathReader, Iterator<Path>>> apply(package.PartitionFilter fp) {
                Iterator iterator;
                Iterator paths = fp.partitions().iterator().flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$4 $outer;

                    public final Seq<Path> apply(String partition) {
                        return this.$outer.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$$anonfun$$$outer().getFilePaths(partition);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                if (paths.isEmpty()) {
                    iterator = package$.MODULE$.Iterator().empty();
                } else {
                    BoxedUnit boxedUnit;
                    BoxedUnit boxedUnit2;
                    Option filter = Option$.MODULE$.apply((Object)fp.filter()).filter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Filter x$3) {
                            Filter filter = x$3;
                            IncludeFilter includeFilter = Filter.INCLUDE;
                            return filter != null ? !filter.equals(includeFilter) : includeFilter != null;
                        }
                    });
                    FileSystemPathReader reader = this.$outer.createReader((Option<Filter>)filter, (Option<Tuple2<String, SimpleFeatureType>>)this.transform$1);
                    if (this.$outer.logger().underlying().isDebugEnabled()) {
                        this.$outer.logger().underlying().debug(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"  Reading ", " partitions with filter: "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)fp.partitions().size())}))).append(filter.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply(Filter x$1) {
                                return ECQL.toCQL((Filter)x$1);
                            }
                        }).getOrElse((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "INCLUDE";
                            }
                        })).toString());
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                    if (this.$outer.logger().underlying().isTraceEnabled()) {
                        this.$outer.logger().underlying().trace(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"  Filter: ", " Partitions: "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{filter.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply(Filter x$1) {
                                return ECQL.toCQL((Filter)x$1);
                            }
                        }).getOrElse((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "INCLUDE";
                            }
                        })}))).append((Object)fp.partitions().mkString(", ")).toString());
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    iterator = package$.MODULE$.Iterator().single((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)reader), (Object)paths));
                }
                return iterator;
            }

            public /* synthetic */ AbstractFileSystemStorage org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.transform$1 = transform$1;
            }
        });
        return readers.isEmpty() ? CloseableIterator$.MODULE$.empty() : FileSystemThreadedReader$.MODULE$.apply((Iterator<Tuple2<FileSystemPathReader, Iterator<Path>>>)readers, threads);
    }

    public void compact(Option<String> partition, int threads) {
        ((IterableLike)partition.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<String> apply(String x$4) {
                return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{x$4}));
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AbstractFileSystemStorage $outer;

            public final Seq<String> apply() {
                return (Seq)this.$outer.metadata().getPartitions(this.$outer.metadata().getPartitions$default$1()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(StorageMetadata.PartitionMetadata x$5) {
                        return x$5.name();
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        })).foreach((Function1)new Serializable(this, threads){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AbstractFileSystemStorage $outer;
            private final int threads$1;

            public final void apply(String partition) {
                Seq<Path> toCompact = this.$outer.getFilePaths(partition);
                if (toCompact.lengthCompare(2) < 0) {
                    BoxedUnit boxedUnit;
                    if (this.$outer.logger().underlying().isDebugEnabled()) {
                        this.$outer.logger().underlying().debug("Skipping compaction for single data file: {}", new Object[]{toCompact.mkString(", ")});
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    BoxedUnit boxedUnit;
                    BoxedUnit boxedUnit2;
                    BoxedUnit boxedUnit3;
                    BoxedUnit boxedUnit4;
                    BoxedUnit boxedUnit5;
                    Path path = StorageUtils$.MODULE$.nextFile(this.$outer.context().root(), partition, this.$outer.metadata().leafStorage(), this.$outer.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$$extension, StorageUtils$FileType$.MODULE$.Compacted());
                    if (this.$outer.logger().underlying().isDebugEnabled()) {
                        this.$outer.logger().underlying().debug("Compacting data files: [{}] to into file {}", new Object[]{toCompact.mkString(", "), path});
                        boxedUnit5 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit5 = BoxedUnit.UNIT;
                    }
                    LongRef written = LongRef.create((long)0L);
                    FileSystemPathReader reader = this.$outer.createReader((Option<Filter>)None$.MODULE$, (Option<Tuple2<String, SimpleFeatureType>>)None$.MODULE$);
                    CompactCallback callback = new CompactCallback(this.$outer, partition, path, toCompact);
                    WithClose$.MODULE$.apply((Object)this.$outer.createWriter(path, callback), (Function0)new Serializable(this, toCompact, reader){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$compact$3 $outer;
                        private final Seq toCompact$1;
                        private final FileSystemPathReader reader$1;

                        public final CloseableIterator<SimpleFeature> apply() {
                            return this.$outer.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$$anonfun$$threaded$1(this.toCompact$1, this.reader$1);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.toCompact$1 = toCompact$1;
                            this.reader$1 = reader$1;
                        }
                    }, (Function2)new Serializable(this, written){
                        public static final long serialVersionUID = 0L;
                        private final LongRef written$1;

                        public final void apply(FileSystemStorage.FileSystemWriter x0$1, CloseableIterator<SimpleFeature> x1$1) {
                            Tuple2 tuple2 = new Tuple2((Object)x0$1, x1$1);
                            if (tuple2 != null) {
                                FileSystemStorage.FileSystemWriter writer = (FileSystemStorage.FileSystemWriter)tuple2._1();
                                CloseableIterator features = (CloseableIterator)tuple2._2();
                                while (features.hasNext()) {
                                    writer.write((SimpleFeature)features.next());
                                    ++this.written$1.elem;
                                }
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return;
                            }
                            throw new MatchError((Object)tuple2);
                        }
                        {
                            this.written$1 = written$1;
                        }
                    });
                    PathCache$.MODULE$.register(this.$outer.context().fc(), path, PathCache$.MODULE$.register$default$3(), PathCache$.MODULE$.register$default$4());
                    if (this.$outer.logger().underlying().isDebugEnabled()) {
                        this.$outer.logger().underlying().debug("Wrote compacted file {}", new Object[]{path});
                        boxedUnit4 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit4 = BoxedUnit.UNIT;
                    }
                    if (this.$outer.logger().underlying().isDebugEnabled()) {
                        this.$outer.logger().underlying().debug("Deleting old files [{}]", new Object[]{toCompact.mkString(", ")});
                        boxedUnit3 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit3 = BoxedUnit.UNIT;
                    }
                    ListBuffer failures = (ListBuffer)ListBuffer$.MODULE$.empty();
                    toCompact.foreach((Function1)new Serializable(this, failures){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$compact$3 $outer;
                        private final ListBuffer failures$1;

                        public final void apply(Path f) {
                            if (!this.$outer.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$$anonfun$$$outer().context().fc().delete(f, false)) {
                                this.failures$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Path[]{f}));
                            }
                            PathCache$.MODULE$.invalidate(this.$outer.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$$anonfun$$$outer().context().fc(), f);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.failures$1 = failures$1;
                        }
                    });
                    if (failures.nonEmpty()) {
                        if (this.$outer.logger().underlying().isErrorEnabled()) {
                            this.$outer.logger().underlying().error("Failed to delete some files: [{}]", new Object[]{failures.mkString(", ")});
                            boxedUnit2 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit2 = BoxedUnit.UNIT;
                        }
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                    if (this.$outer.logger().underlying().isDebugEnabled()) {
                        this.$outer.logger().underlying().debug("Compacted {} records into file {}", new Object[]{BoxesRunTime.boxToLong((long)written.elem), path});
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                }
            }

            public /* synthetic */ AbstractFileSystemStorage org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$$anonfun$$$outer() {
                return this.$outer;
            }

            public final CloseableIterator org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$$anonfun$$threaded$1(Seq toCompact$1, FileSystemPathReader reader$1) {
                return FileSystemThreadedReader$.MODULE$.apply((Iterator<Tuple2<FileSystemPathReader, Iterator<Path>>>)package$.MODULE$.Iterator().single((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)reader$1), (Object)toCompact$1.toIterator())), this.threads$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.threads$1 = threads$1;
            }
        });
    }

    public AbstractFileSystemStorage(package.FileSystemContext context, StorageMetadata metadata, String extension2) {
        this.context = context;
        this.metadata = metadata;
        this.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$$extension = extension2;
        package.Compactable.class.$init$((package.Compactable)this);
        FileSystemStorage.class.$init$((FileSystemStorage)this);
        LazyLogging.class.$init$((LazyLogging)this);
        MethodProfiling.class.$init$((MethodProfiling)this);
    }

    public class AddCallback
    implements WriterCallback {
        private final String partition;
        private final Path file;
        public final /* synthetic */ AbstractFileSystemStorage $outer;

        @Override
        public void onClose(Envelope bounds, long count) {
            this.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$AddCallback$$$outer().metadata().addPartition(new StorageMetadata.PartitionMetadata(this.partition, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.file.getName()})), StorageMetadata.PartitionBounds$.MODULE$.apply(bounds), count));
        }

        public /* synthetic */ AbstractFileSystemStorage org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$AddCallback$$$outer() {
            return this.$outer;
        }

        public AddCallback(AbstractFileSystemStorage $outer, String partition, Path file) {
            this.partition = partition;
            this.file = file;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }

    public static interface WriterCallback {
        public void onClose(Envelope var1, long var2);
    }

    public class CompactCallback
    implements WriterCallback {
        private final String partition;
        private final Path file;
        private final Seq<Path> replaced;
        public final /* synthetic */ AbstractFileSystemStorage $outer;

        @Override
        public void onClose(Envelope bounds, long count) {
            Option partitionBounds = StorageMetadata.PartitionBounds$.MODULE$.apply(bounds);
            this.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$CompactCallback$$$outer().metadata().removePartition(new StorageMetadata.PartitionMetadata(this.partition, (Seq)this.replaced.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(Path x$6) {
                    return x$6.getName();
                }
            }, Seq$.MODULE$.canBuildFrom()), partitionBounds, count));
            this.org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$CompactCallback$$$outer().metadata().addPartition(new StorageMetadata.PartitionMetadata(this.partition, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.file.getName()})), partitionBounds, count));
        }

        public /* synthetic */ AbstractFileSystemStorage org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$CompactCallback$$$outer() {
            return this.$outer;
        }

        public CompactCallback(AbstractFileSystemStorage $outer, String partition, Path file, Seq<Path> replaced) {
            this.partition = partition;
            this.file = file;
            this.replaced = replaced;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }

    public static interface FileSystemPathReader {
        public CloseableIterator<SimpleFeature> read(Path var1);
    }

    public static interface MetadataObservingFileSystemWriter
    extends FileSystemStorage.FileSystemWriter {
        public void org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$MetadataObservingFileSystemWriter$_setter_$org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$MetadataObservingFileSystemWriter$$bounds_$eq(Envelope var1);

        public /* synthetic */ void org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$MetadataObservingFileSystemWriter$$super$write(SimpleFeature var1);

        public /* synthetic */ void org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$MetadataObservingFileSystemWriter$$super$close();

        public WriterCallback callback();

        public long org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$MetadataObservingFileSystemWriter$$count();

        @TraitSetter
        public void org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$MetadataObservingFileSystemWriter$$count_$eq(long var1);

        public Envelope org$locationtech$geomesa$fs$storage$common$AbstractFileSystemStorage$MetadataObservingFileSystemWriter$$bounds();

        public void write(SimpleFeature var1);

        public void close();
    }
}

