/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.process.transform;

import java.time.Duration;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.util.Date;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.process.ProcessException;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.locationtech.geomesa.process.GeoMesaProcess;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.locationtech.geomesa.utils.collection.SelfClosingIterator$;
import org.locationtech.geomesa.utils.date.DateUtils$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@DescribeProcess(title="Date Offset Process", description="Modifies the specified date field in a feature collection by an input time period.")
@ScalaSignature(bytes="\u0006\u0001-4A!\u0001\u0002\u0001\u001b\t\tB)\u0019;f\u001f\u001a47/\u001a;Qe>\u001cWm]:\u000b\u0005\r!\u0011!\u0003;sC:\u001chm\u001c:n\u0015\t)a!A\u0004qe>\u001cWm]:\u000b\u0005\u001dA\u0011aB4f_6,7/\u0019\u0006\u0003\u0013)\tA\u0002\\8dCRLwN\u001c;fG\"T\u0011aC\u0001\u0004_J<7\u0001A\n\u0004\u000191\u0002CA\b\u0015\u001b\u0005\u0001\"BA\t\u0013\u0003\u0011a\u0017M\\4\u000b\u0003M\tAA[1wC&\u0011Q\u0003\u0005\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005]AR\"\u0001\u0003\n\u0005e!!AD$f_6+7/\u0019)s_\u000e,7o\u001d\u0005\u00067\u0001!\t\u0001H\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003u\u0001\"A\b\u0001\u000e\u0003\tAQ\u0001\t\u0001\u0005\u0002\u0005\nq!\u001a=fGV$X\r\u0006\u0003#YmZ\u0005CA\u0012+\u001b\u0005!#BA\u0013'\u0003\u0019\u0019\u0018.\u001c9mK*\u0011q\u0005K\u0001\u0005I\u0006$\u0018M\u0003\u0002*\u0015\u0005Aq-Z8u_>d7/\u0003\u0002,I\t92+[7qY\u00164U-\u0019;ve\u0016\u001cu\u000e\u001c7fGRLwN\u001c\u0005\u0006[}\u0001\rAI\u0001\f_\n\u001ch)Z1ukJ,7\u000f\u000b\u0004-_Y:\u0004(\u000f\t\u0003aQj\u0011!\r\u0006\u0003eM\nqAZ1di>\u0014\u0018P\u0003\u0002\u0006Q%\u0011Q'\r\u0002\u0012\t\u0016\u001c8M]5cKB\u000b'/Y7fi\u0016\u0014\u0018\u0001\u00028b[\u0016\f\u0013aJ\u0001\fI\u0016\u001c8M]5qi&|g.I\u0001;\u00039Ie\u000e];uA\u0019,\u0017\r^;sKNDQ\u0001P\u0010A\u0002u\n\u0011\u0002Z1uK\u001aKW\r\u001c3\u0011\u0005y\"eBA C\u001b\u0005\u0001%\"A!\u0002\u000bM\u001c\u0017\r\\1\n\u0005\r\u0003\u0015A\u0002)sK\u0012,g-\u0003\u0002F\r\n11\u000b\u001e:j]\u001eT!a\u0011!)\rmzc\u0007\u0013\u001dJC\u0005a\u0014%\u0001&\u00029QCW\r\t3bi\u0016\u0004\u0013\r\u001e;sS\n,H/\u001a\u0011u_\u0002jw\u000eZ5gs\")Aj\ba\u0001{\u0005QA/[7f\u001f\u001a47/\u001a;)\r-{cG\u0014\u001dPC\u0005a\u0015%\u0001)\u0002-QKW.\u001a\u0011pM\u001a\u001cX\r\u001e\u0011)K::g\u0006\t)2\t&Bca\b*7+b:\u0006C\u0001\u0019T\u0013\t!\u0016G\u0001\bEKN\u001c'/\u001b2f%\u0016\u001cX\u000f\u001c;\"\u0003Y\u000baA]3tk2$\u0018%\u0001-\u0002#=+H\u000f];uA\r|G\u000e\\3di&|g\u000eK\u0002 5\u0006\u00042aP.^\u0013\ta\u0006I\u0001\u0004uQJ|wo\u001d\t\u0003=~k\u0011aM\u0005\u0003AN\u0012\u0001\u0003\u0015:pG\u0016\u001c8/\u0012=dKB$\u0018n\u001c8$\u0003uCc\u0001A2gObJ\u0007C\u0001\u0019e\u0013\t)\u0017GA\bEKN\u001c'/\u001b2f!J|7-Z:t\u0003\u0015!\u0018\u000e\u001e7fC\u0005A\u0017a\u0005#bi\u0016\u0004sJ\u001a4tKR\u0004\u0003K]8dKN\u001c\u0018%\u00016\u0002%6{G-\u001b4jKN\u0004C\u000f[3!gB,7-\u001b4jK\u0012\u0004C-\u0019;fA\u0019LW\r\u001c3!S:\u0004\u0013\r\t4fCR,(/\u001a\u0011d_2dWm\u0019;j_:\u0004#-\u001f\u0011b]\u0002Jg\u000e];uAQLW.\u001a\u0011qKJLw\u000e\u001a\u0018")
public class DateOffsetProcess
implements GeoMesaProcess {
    @DescribeResult(name="result", description="Output collection")
    public SimpleFeatureCollection execute(@DescribeParameter(name="data", description="Input features") SimpleFeatureCollection obsFeatures, @DescribeParameter(name="dateField", description="The date attribute to modify") String dateField, @DescribeParameter(name="timeOffset", description="Time offset (e.g. P1D)") String timeOffset) throws ProcessException {
        Duration period;
        try {
            period = Duration.parse(timeOffset);
        }
        catch (DateTimeParseException dateTimeParseException) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid offset ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{timeOffset})), dateTimeParseException);
        }
        int dtgIndex = ((SimpleFeatureType)obsFeatures.getSchema()).indexOf(dateField);
        Predef$.MODULE$.require(dtgIndex != -1, (Function0)new Serializable(this, obsFeatures, dateField){
            public static final long serialVersionUID = 0L;
            private final SimpleFeatureCollection obsFeatures$1;
            private final String dateField$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Field '", "' does not exist in input feature collection: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dateField$1, this.obsFeatures$1.getSchema()}));
            }
            {
                this.obsFeatures$1 = obsFeatures$1;
                this.dateField$1 = dateField$1;
            }
        });
        CloseableIterator iter = SelfClosingIterator$.MODULE$.apply(obsFeatures.features()).map((Function1)new Serializable(this, dateField, period, dtgIndex){
            public static final long serialVersionUID = 0L;
            private final String dateField$1;
            private final Duration period$1;
            private final int dtgIndex$1;

            public final SimpleFeature apply(SimpleFeature sf) {
                Date dtg = (Date)sf.getAttribute(this.dateField$1);
                ZonedDateTime offset = ZonedDateTime.ofInstant(DateUtils$.MODULE$.toInstant(dtg), ZoneOffset.UTC).plus(this.period$1);
                Date newDtg = Date.from(offset.toInstant());
                sf.setAttribute(this.dtgIndex$1, (Object)newDtg);
                return sf;
            }
            {
                this.dateField$1 = dateField$1;
                this.period$1 = period$1;
                this.dtgIndex$1 = dtgIndex$1;
            }
        });
        return new ListFeatureCollection((SimpleFeatureType)obsFeatures.getSchema(), JavaConversions$.MODULE$.seqAsJavaList((Seq)iter.toList()));
    }
}

