/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.utilities;

import com.sun.imageio.plugins.common.BogusColorSpace;
import com.sun.media.jai.codecimpl.util.RasterFactory;
import java.awt.Component;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.imageio.ImageReader;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ImageReaderWriterSpi;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.spi.ServiceRegistry;
import javax.imageio.stream.ImageInputStream;
import javax.media.jai.JAI;
import javax.media.jai.OperationRegistry;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.RenderedOp;
import javax.media.jai.registry.RIFRegistry;
import javax.media.jai.widget.ScrollingImagePanel;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ImageIOUtilities {
    static final int MAX_SUBSAMPLING_FACTOR = Integer.MAX_VALUE;
    static final int MAX_LEVELS = 31;
    static final String[] spacesFactory = new String[20];
    private static final int DEFAULT_ROI = -999;

    private ImageIOUtilities() {
    }

    public static final ColorModel createColorModel(SampleModel sampleModel) {
        if (sampleModel == null) {
            throw new IllegalArgumentException("sampleModel == null!");
        }
        int dataType = sampleModel.getDataType();
        switch (dataType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            default: {
                return null;
            }
        }
        ColorModel colorModel = null;
        int[] sampleSize = sampleModel.getSampleSize();
        if (sampleModel instanceof ComponentSampleModel) {
            int transparency;
            int numBands = sampleModel.getNumBands();
            ColorSpace colorSpace = null;
            colorSpace = numBands <= 2 ? ColorSpace.getInstance(1003) : (numBands <= 4 ? ColorSpace.getInstance(1000) : new BogusColorSpace(numBands));
            boolean hasAlpha = numBands == 2 || numBands == 4;
            boolean isAlphaPremultiplied = false;
            int n = transparency = hasAlpha ? 3 : 1;
            colorModel = dataType == 2 ? new ComponentColorModel(colorSpace, sampleSize, hasAlpha, isAlphaPremultiplied, transparency, dataType) : RasterFactory.createComponentColorModel((int)dataType, (ColorSpace)colorSpace, (boolean)hasAlpha, (boolean)isAlphaPremultiplied, (int)transparency);
        } else {
            if (sampleModel.getNumBands() <= 4 && sampleModel instanceof SinglePixelPackedSampleModel) {
                SinglePixelPackedSampleModel sppsm = (SinglePixelPackedSampleModel)sampleModel;
                int[] bitMasks = sppsm.getBitMasks();
                int rmask = 0;
                int gmask = 0;
                int bmask = 0;
                int amask = 0;
                int numBands = bitMasks.length;
                if (numBands <= 2) {
                    gmask = bmask = bitMasks[0];
                    rmask = bmask;
                    if (numBands == 2) {
                        amask = bitMasks[1];
                    }
                } else {
                    rmask = bitMasks[0];
                    gmask = bitMasks[1];
                    bmask = bitMasks[2];
                    if (numBands == 4) {
                        amask = bitMasks[3];
                    }
                }
                int bits = 0;
                for (int i = 0; i < sampleSize.length; ++i) {
                    bits += sampleSize[i];
                }
                return new DirectColorModel(bits, rmask, gmask, bmask, amask);
            }
            if (sampleModel instanceof MultiPixelPackedSampleModel) {
                int bitsPerSample = sampleSize[0];
                int numEntries = 1 << bitsPerSample;
                byte[] map = new byte[numEntries];
                for (int i = 0; i < numEntries; ++i) {
                    map[i] = (byte)(i * 255 / (numEntries - 1));
                }
                colorModel = new IndexColorModel(bitsPerSample, numEntries, map, map, map);
            }
        }
        return colorModel;
    }

    public static void displayImageIOMetadata(Node root) {
        ImageIOUtilities.displayMetadata(root, 0);
    }

    static void indent(int level) {
        for (int i = 0; i < level; ++i) {
            System.out.print("  ");
        }
    }

    static void displayMetadata(Node node, int level) {
        Node child;
        ImageIOUtilities.indent(level);
        System.out.print("<" + node.getNodeName());
        NamedNodeMap map = node.getAttributes();
        if (map != null) {
            int length = map.getLength();
            for (int i = 0; i < length; ++i) {
                Node attr = map.item(i);
                String attrValue = attr.getNodeValue();
                if (attrValue == null) {
                    attrValue = "";
                }
                System.out.print(" " + attr.getNodeName() + "=\"" + attrValue + "\"");
            }
        }
        System.out.print(">");
        String nodeValue = node.getNodeValue();
        if (nodeValue != null) {
            System.out.println(" " + nodeValue);
        } else {
            System.out.println("");
        }
        if (child != null) {
            for (child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                ImageIOUtilities.displayMetadata(child, level + 1);
            }
            ImageIOUtilities.indent(level);
            System.out.println("</" + node.getNodeName() + ">");
        }
    }

    static void visualizeRescaled(RenderedImage image, String title, int roiThreshold) {
        ROI roi = new ROI(image, roiThreshold);
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(image);
        if (roi != null) {
            pb.add(roi);
        }
        RenderedOp op = JAI.create((String)"extrema", (ParameterBlock)pb);
        double[][] extrema = (double[][])op.getProperty("extrema");
        double[] scale = new double[]{255.0 / (extrema[1][0] - extrema[0][0])};
        double[] offset = new double[]{255.0 * extrema[0][0] / (extrema[0][0] - extrema[1][0])};
        ParameterBlock pbRescale = new ParameterBlock();
        pbRescale.add(scale);
        pbRescale.add(offset);
        pbRescale.addSource(image);
        RenderedOp rescaledImage = JAI.create((String)"Rescale", (ParameterBlock)pbRescale);
        ParameterBlock pbConvert = new ParameterBlock();
        pbConvert.addSource(rescaledImage);
        pbConvert.add(0);
        RenderedOp destImage = JAI.create((String)"format", (ParameterBlock)pbConvert);
        ImageIOUtilities.visualize((RenderedImage)destImage, title);
    }

    public static void visualize(RenderedImage ri) {
        ImageIOUtilities.visualize(ri, "");
    }

    public static void visualize(RenderedImage ri, String title) {
        final JFrame frame = new JFrame(title);
        frame.getContentPane().add((Component)new ScrollingImagePanel(ri, 1024, 768));
        frame.setDefaultCloseOperation(3);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                frame.pack();
                frame.setSize(1024, 768);
                frame.setVisible(true);
            }
        });
    }

    public static void visualize(RenderedImage ri, String title, boolean rescale) {
        ImageIOUtilities.visualize(ri, title, rescale, -999);
    }

    public static void visualize(RenderedImage ri, String title, boolean rescale, int roiThreshold) {
        if (rescale) {
            ImageIOUtilities.visualizeRescaled(ri, title, roiThreshold);
        } else {
            ImageIOUtilities.visualize(ri, title);
        }
    }

    public static List<ImageReaderWriterSpi> getJDKImageReaderWriterSPI(ServiceRegistry registry, String formatName, boolean isReader) {
        String descPart;
        Class spiClass;
        IIORegistry iioRegistry = (IIORegistry)registry;
        if (isReader) {
            spiClass = ImageReaderSpi.class;
            descPart = " image reader";
        } else {
            spiClass = ImageWriterSpi.class;
            descPart = " image writer";
        }
        Iterator<ImageReaderSpi> iter = iioRegistry.getServiceProviders(spiClass, true);
        String desc = "standard " + formatName + descPart;
        String jiioPath = "com.sun.media.imageioimpl";
        Locale locale = Locale.getDefault();
        ArrayList<ImageReaderWriterSpi> list = new ArrayList<ImageReaderWriterSpi>();
        block0: while (iter.hasNext()) {
            ImageReaderWriterSpi provider = iter.next();
            if (!provider.getVendorName().startsWith("Sun Microsystems") || !desc.equalsIgnoreCase(provider.getDescription(locale)) || provider.getPluginClassName().startsWith(jiioPath)) continue;
            String[] formatNames = provider.getFormatNames();
            for (int i = 0; i < formatNames.length; ++i) {
                if (!formatNames[i].equalsIgnoreCase(formatName)) continue;
                list.add(provider);
                continue block0;
            }
        }
        return list;
    }

    public static List<ImageReaderWriterSpi> getImageReaderWriterSPI(ServiceRegistry registry, ServiceRegistry.Filter filter, String formatName, boolean isReader) {
        IIORegistry iioRegistry = (IIORegistry)registry;
        Class spiClass = isReader ? ImageReaderSpi.class : ImageWriterSpi.class;
        Iterator<ImageReaderSpi> iter = iioRegistry.getServiceProviders(spiClass, filter, true);
        ArrayList<ImageReaderWriterSpi> list = new ArrayList<ImageReaderWriterSpi>();
        block0: while (iter.hasNext()) {
            ImageReaderWriterSpi provider = iter.next();
            String[] formatNames = provider.getFormatNames();
            for (int i = 0; i < formatNames.length; ++i) {
                if (!formatNames[i].equalsIgnoreCase(formatName)) continue;
                list.add(provider);
                continue block0;
            }
        }
        return list;
    }

    public static boolean replaceProvider(Class<? extends ImageReaderWriterSpi> providerClass, String customProviderName, String originalProviderName, String format) {
        IIORegistry registry = IIORegistry.getDefaultInstance();
        ImageReaderWriterSpi standard = null;
        ImageReaderWriterSpi custom = null;
        Iterator<? extends ImageReaderWriterSpi> it = registry.getServiceProviders(providerClass, false);
        while (it.hasNext()) {
            ImageReaderWriterSpi provider = it.next();
            String providerClassName = provider.getClass().getName();
            String[] formats = provider.getFormatNames();
            for (int i = 0; i < formats.length; ++i) {
                if (!formats[i].equalsIgnoreCase(format)) continue;
                if (providerClassName.equalsIgnoreCase(originalProviderName)) {
                    standard = provider;
                } else if (providerClassName.equalsIgnoreCase(customProviderName)) {
                    custom = provider;
                }
                if (standard == null || custom == null) continue;
                if (ImageReaderSpi.class.isAssignableFrom(standard.getClass())) {
                    return registry.setOrdering(ImageReaderSpi.class, (ImageReaderSpi)custom, (ImageReaderSpi)standard);
                }
                return registry.setOrdering(ImageWriterSpi.class, (ImageWriterSpi)custom, (ImageWriterSpi)standard);
            }
        }
        return false;
    }

    public static boolean equals(Object object1, Object object2) {
        return object1 == object2 || object1 != null && object1.equals(object2);
    }

    public static boolean sameInterfaces(Class<?> object1, Class<?> object2, Class<?> base) {
        Class<?> c;
        int i;
        if (object1 == object2) {
            return true;
        }
        if (object1 == null || object2 == null) {
            return false;
        }
        Class<?>[] c1 = object1.getInterfaces();
        Class<?>[] c2 = object2.getInterfaces();
        int n = 0;
        for (i = 0; i < c2.length; ++i) {
            c = c2[i];
            if (!base.isAssignableFrom(c)) continue;
            c2[n++] = c;
        }
        block1: for (i = 0; i < c1.length; ++i) {
            c = c1[i];
            if (!base.isAssignableFrom(c)) continue;
            for (int j = 0; j < n; ++j) {
                if (!c.equals(c2[j])) continue;
                System.arraycopy(c2, j + 1, c2, j, --n - j);
                continue block1;
            }
            return false;
        }
        return n == 0;
    }

    public static String spaces(int length) {
        int last = spacesFactory.length - 1;
        if (length < 0) {
            length = 0;
        }
        if (length <= last) {
            if (spacesFactory[length] == null) {
                if (spacesFactory[last] == null) {
                    char[] blancs = new char[last];
                    Arrays.fill(blancs, ' ');
                    ImageIOUtilities.spacesFactory[last] = new String(blancs).intern();
                }
                ImageIOUtilities.spacesFactory[length] = spacesFactory[last].substring(0, length).intern();
            }
            return spacesFactory[length];
        }
        char[] blancs = new char[length];
        Arrays.fill(blancs, ' ');
        return new String(blancs);
    }

    public static Class<?> classForDataBufferType(int dataType) {
        switch (dataType) {
            case 0: {
                return Byte.class;
            }
            case 1: 
            case 2: {
                return Short.class;
            }
            case 3: {
                return Integer.class;
            }
            case 4: {
                return Float.class;
            }
            case 5: {
                return Double.class;
            }
        }
        throw new IllegalArgumentException("Wrong datatype:" + dataType);
    }

    public static String getShortName(Class<?> classe) {
        Class<?> el;
        if (classe == null) {
            return "<*>";
        }
        int dimension = 0;
        while ((el = classe.getComponentType()) != null) {
            classe = el;
            ++dimension;
        }
        String name = classe.getName();
        int lower = name.lastIndexOf(46);
        int upper = name.length();
        name = name.substring(lower + 1, upper).replace('$', '.');
        if (dimension != 0) {
            StringBuffer buffer = new StringBuffer(name);
            do {
                buffer.append("[]");
            } while (--dimension != 0);
            name = buffer.toString();
        }
        return name;
    }

    public static File urlToFile(URL url) {
        String path3;
        if (!"file".equals(url.getProtocol())) {
            return null;
        }
        String string = url.toExternalForm();
        if (string.contains("+")) {
            string = string.replace("+", "%2B");
        }
        try {
            string = URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Could not decode the URL to UTF-8 format", e);
        }
        String simplePrefix = "file:/";
        String standardPrefix = "file://";
        String os = System.getProperty("os.name");
        if (os.toUpperCase().contains("WINDOWS") && string.startsWith(standardPrefix)) {
            path3 = string.substring(standardPrefix.length() - 2);
        } else if (string.startsWith(standardPrefix)) {
            path3 = string.substring(standardPrefix.length());
        } else if (string.startsWith(simplePrefix)) {
            path3 = string.substring(simplePrefix.length() - 1);
        } else {
            String auth = url.getAuthority();
            String path2 = url.getPath().replace("%20", " ");
            path3 = auth != null && !auth.equals("") ? "//" + auth + path2 : path2;
        }
        return new File(path3);
    }

    public static int getSubSamplingFactor2(int xSubsamplingFactor, int ySubsamplingFactor) {
        boolean changedSubSamplingFactors;
        boolean resamplingIsRequired = false;
        int newSubSamplingFactor = 0;
        boolean subSamplingFactorsAreDifferent = xSubsamplingFactor != ySubsamplingFactor;
        newSubSamplingFactor = xSubsamplingFactor <= ySubsamplingFactor ? xSubsamplingFactor : ySubsamplingFactor;
        boolean bl = changedSubSamplingFactors = newSubSamplingFactor > Integer.MAX_VALUE;
        if (newSubSamplingFactor > Integer.MAX_VALUE) {
            newSubSamplingFactor = Integer.MAX_VALUE;
        }
        int optimalSubsampling = ImageIOUtilities.findOptimalSubSampling(newSubSamplingFactor);
        resamplingIsRequired = subSamplingFactorsAreDifferent || changedSubSamplingFactors || optimalSubsampling != newSubSamplingFactor;
        newSubSamplingFactor = !resamplingIsRequired ? 0 : optimalSubsampling;
        return newSubSamplingFactor;
    }

    static int findOptimalSubSampling(int newSubSamplingFactor) {
        int optimalSubSamplingFactor = 1;
        for (int level = 0; level < 31; ++level) {
            if (optimalSubSamplingFactor < newSubSamplingFactor) {
                optimalSubSamplingFactor = 1 << level;
                continue;
            }
            if (optimalSubSamplingFactor > newSubSamplingFactor) {
                optimalSubSamplingFactor >>= 1;
                break;
            }
            if (optimalSubSamplingFactor == newSubSamplingFactor) break;
        }
        return optimalSubSamplingFactor;
    }

    public static String getShortClassName(Object object) {
        return ImageIOUtilities.getShortName(object != null ? object.getClass() : null);
    }

    public static String adjustAttributeName(String attributeName) {
        if (attributeName.contains("\\")) {
            return attributeName.replace("\\", "_");
        }
        return attributeName;
    }

    public static synchronized void setNativeAccelerationAllowed(String operation, boolean allowed, JAI jai) {
        String product = "com.sun.media.jai";
        OperationRegistry registry = jai.getOperationRegistry();
        List factories = registry.getOrderedFactoryList("rendered", operation, "com.sun.media.jai");
        if (factories != null) {
            RenderedImageFactory javaFactory = null;
            RenderedImageFactory nativeFactory = null;
            Boolean currentState = null;
            for (RenderedImageFactory factory : factories) {
                String pack = factory.getClass().getPackage().getName();
                if (pack.equals("com.sun.media.jai.mlib")) {
                    nativeFactory = factory;
                    if (javaFactory != null) {
                        currentState = Boolean.FALSE;
                    }
                }
                if (!pack.equals("com.sun.media.jai.opimage")) continue;
                javaFactory = factory;
                if (nativeFactory == null) continue;
                currentState = Boolean.TRUE;
            }
            if (currentState != null && currentState != allowed) {
                RIFRegistry.unsetPreference((OperationRegistry)registry, (String)operation, (String)"com.sun.media.jai", (RenderedImageFactory)(allowed ? javaFactory : nativeFactory), (RenderedImageFactory)(allowed ? nativeFactory : javaFactory));
                RIFRegistry.setPreference((OperationRegistry)registry, (String)operation, (String)"com.sun.media.jai", (RenderedImageFactory)(allowed ? nativeFactory : javaFactory), (RenderedImageFactory)(allowed ? javaFactory : nativeFactory));
            }
        }
    }

    public static void setNativeAccelerationAllowed(String operation, boolean allowed) {
        ImageIOUtilities.setNativeAccelerationAllowed(operation, allowed, JAI.getDefaultInstance());
    }

    public static final void checkNotNull(Object checkMe, String message) {
        if (checkMe == null) {
            throw new IllegalArgumentException(message != null ? message : "The provided object was NULL");
        }
    }

    public static void disposeImage(RenderedImage rOp) {
        if (rOp != null && rOp instanceof RenderedOp) {
            ROI roiImage;
            PlanarImage image;
            Object roi;
            RenderedOp renderedOp = (RenderedOp)rOp;
            int nSources = renderedOp.getNumSources();
            if (nSources > 0) {
                for (int k = 0; k < nSources; ++k) {
                    Object source = null;
                    try {
                        source = renderedOp.getSourceObject(k);
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        // empty catch block
                    }
                    if (source == null) continue;
                    if (source instanceof RenderedOp) {
                        ImageIOUtilities.disposeImage((RenderedImage)((RenderedOp)source));
                        continue;
                    }
                    if (!(source instanceof BufferedImage)) continue;
                    ((BufferedImage)source).flush();
                    source = null;
                }
            } else {
                Object imageReader = rOp.getProperty("JAI.ImageReader");
                if (imageReader != null && imageReader instanceof ImageReader) {
                    ImageReader reader = (ImageReader)imageReader;
                    ImageInputStream stream = (ImageInputStream)reader.getInput();
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    try {
                        reader.dispose();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            if ((roi = rOp.getProperty("ROI")) != null && (roi instanceof ROI || roi instanceof RenderedImage) && (image = (roiImage = (ROI)roi).getAsImage()) != null) {
                image.dispose();
                image = null;
                roiImage = null;
            }
            if (rOp instanceof PlanarImage) {
                ((PlanarImage)rOp).dispose();
            } else if (rOp instanceof BufferedImage) {
                ((BufferedImage)rOp).flush();
                rOp = null;
            }
        }
    }
}

