/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.simple;

import java.util.List;
import java.util.Map;
import org.eclipse.xsd.XSDElementDeclaration;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.geometry.jts.CircularRing;
import org.geotools.geometry.jts.CircularString;
import org.geotools.geometry.jts.CompoundCurve;
import org.geotools.geometry.jts.CompoundRing;
import org.geotools.gml2.SrsSyntax;
import org.geotools.gml2.simple.FeatureCollectionEncoderDelegate;
import org.geotools.gml2.simple.GMLDelegate;
import org.geotools.gml2.simple.GMLWriter;
import org.geotools.gml2.simple.GeometryEncoder;
import org.geotools.gml2.simple.QualifiedName;
import org.geotools.gml3.bindings.GML3EncodingUtils;
import org.geotools.gml3.simple.CurveEncoder;
import org.geotools.gml3.simple.EnvelopeEncoder;
import org.geotools.gml3.simple.GeometryCollectionEncoder;
import org.geotools.gml3.simple.LineStringEncoder;
import org.geotools.gml3.simple.LinearRingEncoder;
import org.geotools.gml3.simple.MultiLineStringEncoder;
import org.geotools.gml3.simple.MultiPointEncoder;
import org.geotools.gml3.simple.MultiPolygonEncoder;
import org.geotools.gml3.simple.PointEncoder;
import org.geotools.gml3.simple.PolygonEncoder;
import org.geotools.gml3.v3_2.GML;
import org.geotools.gml3.v3_2.GMLConfiguration;
import org.geotools.gml3.v3_2.bindings.GML32EncodingUtils;
import org.geotools.xml.Configuration;
import org.geotools.xml.Encoder;
import org.geotools.xml.XSD;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.FeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class GML32FeatureCollectionEncoderDelegate
extends FeatureCollectionEncoderDelegate {
    public GML32FeatureCollectionEncoderDelegate(SimpleFeatureCollection features, Encoder encoder) {
        super(features, encoder, (GMLDelegate)new GML32Delegate(encoder));
        this.encodeGeometryIds = true;
    }

    protected Attributes getPropertyAttributes(QualifiedName name, FeatureType featureType, AttributeDescriptor attribute, Object value) {
        if ("identifier".equals(name.getLocalPart()) && "http://www.opengis.net/gml/3.2".equals(name.getNamespaceURI())) {
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute(null, "codeSpace", "codeSpace", null, featureType.getName().getNamespaceURI());
            return atts;
        }
        return null;
    }

    public static class GML32Delegate
    implements GMLDelegate {
        SrsSyntax srsSyntax;
        static final QualifiedName MEMBER = new QualifiedName("http://www.opengis.net/gml/3.2", GML.member.getLocalPart(), "gml");
        protected QualifiedName member;
        String gmlPrefix;
        String gmlUri = "http://www.opengis.net/gml/3.2";
        GML32EncodingUtils encodingUtils;
        int numDecimals;
        private boolean encodeMeasures;

        public GML32Delegate(Encoder encoder) {
            this.gmlPrefix = encoder.getNamespaces().getPrefix(this.gmlUri);
            this.member = MEMBER.derive(this.gmlPrefix, this.gmlUri);
            this.srsSyntax = (SrsSyntax)encoder.getContext().getComponentInstanceOfType(SrsSyntax.class);
            this.encodingUtils = new GML32EncodingUtils();
            this.numDecimals = this.getNumDecimals(encoder.getConfiguration());
            this.encodeMeasures = this.getEncodecoordinatesMeasures(encoder.getConfiguration());
        }

        private int getNumDecimals(Configuration configuration) {
            GMLConfiguration config = configuration instanceof GMLConfiguration ? (GMLConfiguration)configuration : (GMLConfiguration)configuration.getDependency(GMLConfiguration.class);
            if (config == null) {
                return 6;
            }
            return config.getNumDecimals();
        }

        private boolean getEncodecoordinatesMeasures(Configuration configuration) {
            GMLConfiguration config = configuration instanceof GMLConfiguration ? (GMLConfiguration)configuration : (GMLConfiguration)configuration.getDependency(GMLConfiguration.class);
            if (config == null) {
                return false;
            }
            return config.getEncodeMeasures();
        }

        public List getFeatureProperties(SimpleFeature f, XSDElementDeclaration element, Encoder e) {
            return this.encodingUtils.AbstractFeatureTypeGetProperties(f, element, e.getSchemaIndex(), e.getConfiguration());
        }

        public EnvelopeEncoder createEnvelopeEncoder(Encoder e) {
            return new EnvelopeEncoder(e, this.gmlPrefix, this.gmlUri);
        }

        public void setSrsNameAttribute(AttributesImpl atts, CoordinateReferenceSystem crs) {
            atts.addAttribute(null, "srsName", "srsName", null, GML3EncodingUtils.toURI(crs, this.srsSyntax).toString());
        }

        public void setGeometryDimensionAttribute(AttributesImpl atts, int dimension) {
            atts.addAttribute(null, "srsDimension", "srsDimension", null, String.valueOf(dimension));
        }

        public void initFidAttribute(AttributesImpl atts) {
            atts.addAttribute("http://www.opengis.net/gml/3.2", "id", "gml:id", null, "");
        }

        public void startFeatures(GMLWriter handler) throws Exception {
        }

        public void startFeature(GMLWriter handler) throws Exception {
            handler.startElement(this.member, null);
        }

        public void endFeature(GMLWriter handler) throws Exception {
            handler.endElement(this.member);
        }

        public void endFeatures(GMLWriter handler) throws Exception {
        }

        public void registerGeometryEncoders(Map<Class, GeometryEncoder> encoders, Encoder encoder) {
            encoders.put(Point.class, new PointEncoder(encoder, this.gmlPrefix, this.gmlUri));
            encoders.put(MultiPoint.class, new MultiPointEncoder(encoder, this.gmlPrefix, this.gmlUri));
            encoders.put(LineString.class, new LineStringEncoder(encoder, this.gmlPrefix, this.gmlUri));
            encoders.put(LinearRing.class, new LinearRingEncoder(encoder, this.gmlPrefix, this.gmlUri));
            encoders.put(MultiLineString.class, new MultiLineStringEncoder(encoder, this.gmlPrefix, this.gmlUri, true));
            encoders.put(Polygon.class, new PolygonEncoder(encoder, this.gmlPrefix, this.gmlUri));
            encoders.put(MultiPolygon.class, new MultiPolygonEncoder(encoder, this.gmlPrefix, this.gmlUri));
            encoders.put(CircularString.class, new CurveEncoder(encoder, this.gmlPrefix, this.gmlUri));
            encoders.put(CompoundCurve.class, new CurveEncoder(encoder, this.gmlPrefix, this.gmlUri));
            encoders.put(CircularRing.class, new CurveEncoder(encoder, this.gmlPrefix, this.gmlUri));
            encoders.put(CompoundRing.class, new CurveEncoder(encoder, this.gmlPrefix, this.gmlUri));
            encoders.put(GeometryCollection.class, new GeometryCollectionEncoder(encoder, this.gmlPrefix, this.gmlUri));
        }

        public String getGmlPrefix() throws Exception {
            return this.gmlPrefix;
        }

        public boolean supportsTuples() {
            return false;
        }

        public void startTuple(GMLWriter handler) throws SAXException {
        }

        public void endTuple(GMLWriter handler) throws SAXException {
        }

        public XSD getSchema() {
            return GML.getInstance();
        }

        public int getNumDecimals() {
            return this.numDecimals;
        }

        public boolean forceDecimalEncoding() {
            return false;
        }

        public boolean getEncodeMeasures() {
            return this.encodeMeasures;
        }
    }
}

