/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.tools.status;

import com.beust.jcommander.ParameterException;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigRenderOptions;
import org.locationtech.geomesa.convert.ConverterConfigLoader$;
import org.locationtech.geomesa.tools.Command;
import org.locationtech.geomesa.tools.Command$;
import org.locationtech.geomesa.tools.status.EnvironmentParameters;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypeLoader$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00194A!\u0001\u0002\u0001\u001b\t\u0011RI\u001c<je>tW.\u001a8u\u0007>lW.\u00198e\u0015\t\u0019A!\u0001\u0004ti\u0006$Xo\u001d\u0006\u0003\u000b\u0019\tQ\u0001^8pYNT!a\u0002\u0005\u0002\u000f\u001d,w.\\3tC*\u0011\u0011BC\u0001\rY>\u001c\u0017\r^5p]R,7\r\u001b\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\u0004\u000b\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g!\t)b#D\u0001\u0005\u0013\t9BAA\u0004D_6l\u0017M\u001c3\t\u000be\u0001A\u0011\u0001\u000e\u0002\rqJg.\u001b;?)\u0005Y\u0002C\u0001\u000f\u0001\u001b\u0005\u0011\u0001b\u0002\u0010\u0001\u0005\u0004%\teH\u0001\u0005]\u0006lW-F\u0001!!\t\tc%D\u0001#\u0015\t\u0019C%\u0001\u0003mC:<'\"A\u0013\u0002\t)\fg/Y\u0005\u0003O\t\u0012aa\u0015;sS:<\u0007BB\u0015\u0001A\u0003%\u0001%A\u0003oC6,\u0007\u0005C\u0004,\u0001\t\u0007I\u0011\t\u0017\u0002\rA\f'/Y7t+\u0005i\u0003C\u0001\u000f/\u0013\ty#AA\u000bF]ZL'o\u001c8nK:$\b+\u0019:b[\u0016$XM]:\t\rE\u0002\u0001\u0015!\u0003.\u0003\u001d\u0001\u0018M]1ng\u0002BQa\r\u0001\u0005BQ\nq!\u001a=fGV$X\rF\u00016!\tya'\u0003\u00028!\t!QK\\5u\u0011\u0015I\u0004\u0001\"\u0001;\u0003!a\u0017n\u001d;TMR\u001cHCA\u001b<\u0011\u001da\u0004\b%AA\u0002u\nQA\\1nKN\u00042A\u0010$J\u001d\tyDI\u0004\u0002A\u00076\t\u0011I\u0003\u0002C\u0019\u00051AH]8pizJ\u0011!E\u0005\u0003\u000bB\tq\u0001]1dW\u0006<W-\u0003\u0002H\u0011\n!A*[:u\u0015\t)\u0005\u0003\u0005\u0002K\u001b:\u0011qbS\u0005\u0003\u0019B\ta\u0001\u0015:fI\u00164\u0017BA\u0014O\u0015\ta\u0005\u0003C\u0003Q\u0001\u0011\u0005\u0011+\u0001\bmSN$8i\u001c8wKJ$XM]:\u0015\u0005U\u0012\u0006b\u0002\u001fP!\u0003\u0005\r!\u0010\u0005\u0006)\u0002!\t\u0001N\u0001\u000eY&\u001cHo\u00154ug:\u000bW.Z:\t\u000bY\u0003A\u0011\u0001\u001b\u0002%1L7\u000f^\"p]Z,'\u000f^3s\u001d\u0006lWm\u001d\u0005\b1\u0002\t\n\u0011\"\u0001Z\u0003Ia\u0017n\u001d;TMR\u001cH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0003iS#!P.,\u0003q\u0003\"!\u00182\u000e\u0003yS!a\u00181\u0002\u0013Ut7\r[3dW\u0016$'BA1\u0011\u0003)\tgN\\8uCRLwN\\\u0005\u0003Gz\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011\u001d)\u0007!%A\u0005\u0002e\u000b\u0001\u0004\\5ti\u000e{gN^3si\u0016\u00148\u000f\n3fM\u0006,H\u000e\u001e\u00132\u0001")
public class EnvironmentCommand
implements Command {
    private final String name;
    private final EnvironmentParameters params = new EnvironmentParameters();

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public EnvironmentParameters params() {
        return this.params;
    }

    @Override
    public void execute() {
        if (!(this.params().sfts() != null || this.params().converters() != null || this.params().listSfts() || this.params().listConverters() || this.params().describeSfts() || this.params().describeConverters())) {
            Command$.MODULE$.output().info("No flags given; displaying list of SFTs and Converters.");
            Command$.MODULE$.output().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Use 'help ", "' to see complete command options."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name()})));
            this.listSftsNames();
            this.listConverterNames();
        } else {
            if (this.params().listSfts()) {
                this.listSftsNames();
            }
            if (this.params().listConverters()) {
                this.listConverterNames();
            }
            if (this.params().describeSfts()) {
                this.listSfts(this.listSfts$default$1());
            }
            if (this.params().describeConverters()) {
                this.listConverters(this.listConverters$default$1());
            }
            if (this.params().sfts() != null) {
                this.listSfts((List<String>)JavaConversions$.MODULE$.asScalaBuffer(this.params().sfts()).toList());
            }
            if (this.params().converters() != null) {
                this.listConverters((List<String>)JavaConversions$.MODULE$.asScalaBuffer(this.params().converters()).toList());
            }
        }
    }

    public void listSfts(List<String> names) {
        block5: {
            String string;
            block8: {
                block3: {
                    Object object;
                    List filtered;
                    block7: {
                        block6: {
                            String paramsLower;
                            block4: {
                                block2: {
                                    List all = SimpleFeatureTypeLoader$.MODULE$.sfts();
                                    filtered = names.isEmpty() ? all : (List)names.flatMap((Function1)new Serializable(this, all){
                                        public static final long serialVersionUID = 0L;
                                        private final List all$1;

                                        public final Iterable<SimpleFeatureType> apply(String n) {
                                            return Option$.MODULE$.option2Iterable(this.all$1.find((Function1)new Serializable(this, n){
                                                public static final long serialVersionUID = 0L;
                                                private final String n$1;

                                                public final boolean apply(SimpleFeatureType x$1) {
                                                    String string = x$1.getTypeName();
                                                    String string2 = this.n$1;
                                                    return !(string != null ? !string.equals(string2) : string2 != null);
                                                }
                                                {
                                                    this.n$1 = n$1;
                                                }
                                            }));
                                        }
                                        {
                                            this.all$1 = all$1;
                                        }
                                    }, List$.MODULE$.canBuildFrom());
                                    Command$.MODULE$.output().info("Simple Feature Types:");
                                    if (!filtered.isEmpty()) break block2;
                                    Command$.MODULE$.output().info("None available");
                                    break block3;
                                }
                                String string2 = paramsLower = this.params().format().toLowerCase();
                                String string3 = "typesafe";
                                if (!(string2 == null ? string3 != null : !string2.equals(string3))) break block4;
                                String string4 = paramsLower;
                                String string5 = "spec";
                                if (string4 != null ? !string4.equals(string5) : string5 != null) break block5;
                            }
                            if (!"typesafe".equals(string = paramsLower)) break block6;
                            object = new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ EnvironmentCommand $outer;

                                public final String apply(SimpleFeatureType sft) {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SimpleFeatureTypes$.MODULE$.toConfigString(sft, !this.$outer.params().excludeUserData(), this.$outer.params().concise(), SimpleFeatureTypes$.MODULE$.toConfigString$default$4(), SimpleFeatureTypes$.MODULE$.toConfigString$default$5())}));
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            };
                            break block7;
                        }
                        if (!"spec".equals(string)) break block8;
                        object = new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ EnvironmentCommand $outer;

                            public final String apply(SimpleFeatureType sft) {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SimpleFeatureTypes$.MODULE$.encodeType(sft, !this.$outer.params().excludeUserData())}));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        };
                    }
                    Serializable formatFn = object;
                    ((List)((List)filtered.sortBy((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(SimpleFeatureType x$2) {
                            return x$2.getTypeName();
                        }
                    }, (Ordering)Ordering.String$.MODULE$)).map((Function1)new Serializable(this, (Function1)formatFn){
                        public static final long serialVersionUID = 0L;
                        private final Function1 formatFn$1;

                        public final String apply(SimpleFeatureType s) {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{s.getTypeName(), this.formatFn$1.apply((Object)s)}));
                        }
                        {
                            this.formatFn$1 = formatFn$1;
                        }
                    }, List$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final void apply(String x$1) {
                            Command$.MODULE$.output().info(x$1);
                        }
                    });
                }
                return;
            }
            throw new MatchError((Object)string);
        }
        throw new ParameterException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown format '", "'. Valid values are 'typesafe' or 'spec'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.params().format()})));
    }

    public List<String> listSfts$default$1() {
        return List$.MODULE$.empty();
    }

    public void listConverters(List<String> names) {
        Map all = ConverterConfigLoader$.MODULE$.confs();
        Map filtered = names.isEmpty() ? all : (scala.collection.immutable.Iterable)names.flatMap((Function1)new Serializable(this, all){
            public static final long serialVersionUID = 0L;
            private final Map all$2;

            public final Iterable<Tuple2<String, Config>> apply(String n) {
                return Option$.MODULE$.option2Iterable(this.all$2.find((Function1)new Serializable(this, n){
                    public static final long serialVersionUID = 0L;
                    private final String n$2;

                    public final boolean apply(Tuple2<String, Config> x$3) {
                        Object object = x$3._1();
                        String string = this.n$2;
                        return !(object != null ? !object.equals(string) : string != null);
                    }
                    {
                        this.n$2 = n$2;
                    }
                }));
            }
            {
                this.all$2 = all$2;
            }
        }, List$.MODULE$.canBuildFrom());
        Command$.MODULE$.output().info("Simple Feature Type Converters:");
        if (filtered.isEmpty()) {
            Command$.MODULE$.output().info("None available");
        } else {
            ConfigRenderOptions options = ConfigRenderOptions.defaults().setJson(false).setOriginComments(false);
            scala.collection.immutable.Iterable strings = (scala.collection.immutable.Iterable)filtered.map((Function1)new Serializable(this, options){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ EnvironmentCommand $outer;
                private final ConfigRenderOptions options$1;

                public final String apply(Tuple2<String, Config> x0$1) {
                    Tuple2<String, Config> tuple2 = x0$1;
                    if (tuple2 != null) {
                        String cname = (String)tuple2._1();
                        Config conf = (Config)tuple2._2();
                        String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"converter-name=", "\\n", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cname, this.$outer.org$locationtech$geomesa$tools$status$EnvironmentCommand$$render$1(conf, this.options$1)}));
                        return string;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.options$1 = options$1;
                }
            }, Iterable$.MODULE$.canBuildFrom());
            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])strings.toArray(ClassTag$.MODULE$.apply(String.class))).sorted((Ordering)Ordering.String$.MODULE$)).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(String x$1) {
                    Command$.MODULE$.output().info(x$1);
                }
            });
        }
    }

    public List<String> listConverters$default$1() {
        return List$.MODULE$.empty();
    }

    public void listSftsNames() {
        Command$.MODULE$.output().info("Simple Feature Types:");
        List all = SimpleFeatureTypeLoader$.MODULE$.sfts();
        ((List)((List)all.sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(SimpleFeatureType x$4) {
                return x$4.getTypeName();
            }
        }, (Ordering)Ordering.String$.MODULE$)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(SimpleFeatureType s) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{s.getTypeName()}));
            }
        }, List$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(String x$1) {
                Command$.MODULE$.output().info(x$1);
            }
        });
    }

    public void listConverterNames() {
        Command$.MODULE$.output().info("Simple Feature Type Converters:");
        Map all = ConverterConfigLoader$.MODULE$.confs();
        Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])((TraversableOnce)all.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, Config> x0$2) {
                Tuple2<String, Config> tuple2 = x0$2;
                if (tuple2 != null) {
                    String cname = (String)tuple2._1();
                    String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cname}));
                    return string;
                }
                throw new MatchError(tuple2);
            }
        }, Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class))).sorted((Ordering)Ordering.String$.MODULE$)).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(String x$1) {
                Command$.MODULE$.output().info(x$1);
            }
        });
    }

    public final String org$locationtech$geomesa$tools$status$EnvironmentCommand$$render$1(Config c, ConfigRenderOptions options$1) {
        return c.root().render(options$1);
    }

    public EnvironmentCommand() {
        this.name = "env";
    }
}

