/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.planning;

import org.geotools.data.Query;
import org.geotools.factory.Hints;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.locationtech.geomesa.arrow.package$;
import org.locationtech.geomesa.filter.FilterHelper$;
import org.locationtech.geomesa.filter.FilterValues;
import org.locationtech.geomesa.filter.factory.FastFilterFactory$;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.index.conf.QueryHints$Internal$;
import org.locationtech.geomesa.index.geoserver.ViewParams$;
import org.locationtech.geomesa.index.iterators.DensityScan$;
import org.locationtech.geomesa.index.iterators.StatsScan$;
import org.locationtech.geomesa.index.planning.QueryInterceptor;
import org.locationtech.geomesa.index.planning.QueryPlanner$;
import org.locationtech.geomesa.index.planning.QueryRunner;
import org.locationtech.geomesa.index.planning.QueryRunner$;
import org.locationtech.geomesa.index.utils.ExplainLogging;
import org.locationtech.geomesa.index.utils.Explainer;
import org.locationtech.geomesa.utils.bin.BinaryOutputEncoder$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.IncludeFilter;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.spatial.BBOX;
import org.opengis.geometry.BoundingBox;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.runtime.BoxedUnit;

public abstract class QueryRunner$class {
    public static Explainer runQuery$default$3(QueryRunner $this) {
        return new ExplainLogging();
    }

    /*
     * WARNING - void declaration
     */
    public static Query configureQuery(QueryRunner $this, SimpleFeatureType sft, Query original) {
        void var3_3;
        Query query = new Query(original);
        $this.interceptors().apply(sft).foreach((Function1)new Serializable($this, query){
            public static final long serialVersionUID = 0L;
            private final Query query$1;

            public final void apply(QueryInterceptor interceptor) {
                BoxedUnit boxedUnit;
                interceptor.rewrite(this.query$1);
                if (QueryRunner$.MODULE$.org$locationtech$geomesa$index$planning$QueryRunner$$logger().underlying().isTraceEnabled()) {
                    QueryRunner$.MODULE$.org$locationtech$geomesa$index$planning$QueryRunner$$logger().underlying().trace("Query rewritten by {} to: {}", new Object[]{interceptor, this.query$1});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            {
                this.query$1 = query$1;
            }
        });
        QueryPlanner$.MODULE$.threadedHints().get().foreach((Function1)new Serializable($this, query){
            public static final long serialVersionUID = 0L;
            public final Query query$1;

            public final void apply(Map<Object, Object> hints) {
                hints.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ QueryRunner$.anonfun.configureQuery.2 $outer;

                    public final Object apply(Tuple2<Object, Object> x0$1) {
                        Tuple2<Object, Object> tuple2 = x0$1;
                        if (tuple2 != null) {
                            Object k = tuple2._1();
                            Object v = tuple2._2();
                            Object object = this.$outer.query$1.getHints().put(k, v);
                            return object;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                QueryPlanner$.MODULE$.threadedHints().clear();
            }
            {
                this.query$1 = query$1;
            }
        });
        ViewParams$.MODULE$.setHints(query);
        QueryPlanner$.MODULE$.setQueryTransforms(query, sft);
        query.getHints().put((Object)QueryHints$Internal$.MODULE$.RETURN_SFT(), (Object)$this.getReturnSft(sft, query.getHints()));
        QueryPlanner$.MODULE$.setQuerySort(sft, query);
        QueryPlanner$.MODULE$.setMaxFeatures(query);
        QueryHints$.MODULE$.RichHints(query.getHints()).getDensityEnvelope().foreach((Function1)new Serializable($this, query, sft){
            public static final long serialVersionUID = 0L;
            private final Query query$1;
            private final SimpleFeatureType sft$1;

            public final void apply(Envelope env) {
                FilterValues geoms = FilterHelper$.MODULE$.extractGeometries(this.query$1.getFilter(), RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getGeomField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(this.sft$1)), FilterHelper$.MODULE$.extractGeometries$default$3());
                if (geoms.isEmpty() || geoms.exists((Function1)new Serializable(this, env){
                    public static final long serialVersionUID = 0L;
                    private final Envelope env$1;

                    public final boolean apply(Geometry g) {
                        return !this.env$1.contains(g.getEnvelopeInternal());
                    }
                    {
                        this.env$1 = env$1;
                    }
                })) {
                    BBOX bbox = org.locationtech.geomesa.filter.package$.MODULE$.ff().bbox((Expression)org.locationtech.geomesa.filter.package$.MODULE$.ff().property(this.sft$1.getGeometryDescriptor().getLocalName()), (BoundingBox)((ReferencedEnvelope)env));
                    Filter filter2 = this.query$1.getFilter();
                    IncludeFilter includeFilter = Filter.INCLUDE;
                    if (!(filter2 != null ? !filter2.equals(includeFilter) : includeFilter != null)) {
                        this.query$1.setFilter((Filter)bbox);
                    } else {
                        this.query$1.setFilter(org.locationtech.geomesa.filter.package$.MODULE$.andFilters((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Filter[]{this.query$1.getFilter(), bbox})), (FilterFactory)org.locationtech.geomesa.filter.package$.MODULE$.ff()));
                    }
                }
            }
            {
                this.query$1 = query$1;
                this.sft$1 = sft$1;
            }
        });
        if (query.getFilter() != null) {
            Filter filter2 = query.getFilter();
            IncludeFilter includeFilter = Filter.INCLUDE;
            if (filter2 == null ? includeFilter != null : !filter2.equals(includeFilter)) {
                query.setFilter(FastFilterFactory$.MODULE$.optimize(sft, query.getFilter()));
            }
        }
        return var3_3;
    }

    public static SimpleFeatureType getReturnSft(QueryRunner $this, SimpleFeatureType sft, Hints hints) {
        return QueryHints$.MODULE$.RichHints(hints).isBinQuery() ? BinaryOutputEncoder$.MODULE$.BinEncodedSft() : (QueryHints$.MODULE$.RichHints(hints).isArrowQuery() ? package$.MODULE$.ArrowEncodedSft() : (QueryHints$.MODULE$.RichHints(hints).isDensityQuery() ? DensityScan$.MODULE$.DensitySft() : (QueryHints$.MODULE$.RichHints(hints).isStatsQuery() ? StatsScan$.MODULE$.StatsSft() : (SimpleFeatureType)QueryHints$.MODULE$.RichHints(hints).getTransformSchema().getOrElse((Function0)new Serializable($this, sft){
            public static final long serialVersionUID = 0L;
            private final SimpleFeatureType sft$2;

            public final SimpleFeatureType apply() {
                return this.sft$2;
            }
            {
                this.sft$2 = sft$2;
            }
        }))));
    }

    public static void $init$(QueryRunner $this) {
    }
}

