/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.features.serialization;

import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.locationtech.geomesa.features.serialization.DimensionalBounds$GeometryCollectionBounds$;
import org.locationtech.geomesa.features.serialization.DimensionalBounds$LineStringBounds$;
import org.locationtech.geomesa.features.serialization.DimensionalBounds$MultiLineStringBounds$;
import org.locationtech.geomesa.features.serialization.DimensionalBounds$MultiPointBounds$;
import org.locationtech.geomesa.features.serialization.DimensionalBounds$MultiPolygonBounds$;
import org.locationtech.geomesa.features.serialization.DimensionalBounds$PolygonBounds$;
import org.locationtech.geomesa.features.serialization.TwkbSerialization;
import org.locationtech.geomesa.features.serialization.TwkbSerialization$;
import org.locationtech.geomesa.features.serialization.TwkbSerialization$FlagBytes$;
import org.locationtech.geomesa.features.serialization.TwkbSerialization$GeometryBytes$;
import org.locationtech.geomesa.features.serialization.VarIntEncoding$;
import org.locationtech.geomesa.features.serialization.package$;
import org.locationtech.geomesa.utils.geometry.GeometryPrecision;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.EmptyMethodCache;
import scala.runtime.MethodCache;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

public abstract class TwkbSerialization$class {
    private static Class[] reflParams$Cache1 = new Class[]{Byte.TYPE};
    private static volatile SoftReference reflPoly$Cache1 = new SoftReference<EmptyMethodCache>(new EmptyMethodCache());
    private static Class[] reflParams$Cache2 = new Class[0];
    private static volatile SoftReference reflPoly$Cache2 = new SoftReference<EmptyMethodCache>(new EmptyMethodCache());
    private static Class[] reflParams$Cache3 = new Class[0];
    private static volatile SoftReference reflPoly$Cache3 = new SoftReference<EmptyMethodCache>(new EmptyMethodCache());
    private static Class[] reflParams$Cache4 = new Class[0];
    private static volatile SoftReference reflPoly$Cache4 = new SoftReference<EmptyMethodCache>(new EmptyMethodCache());

    public static Method reflMethod$Method1(Class x$1) {
        Method method1;
        MethodCache methodCache1 = (MethodCache)reflPoly$Cache1.get();
        if (methodCache1 == null) {
            methodCache1 = new EmptyMethodCache();
            reflPoly$Cache1 = new SoftReference<MethodCache>(methodCache1);
        }
        if ((method1 = methodCache1.find(x$1)) != null) {
            return method1;
        }
        method1 = ScalaRunTime$.MODULE$.ensureAccessible(x$1.getMethod("writeByte", reflParams$Cache1));
        reflPoly$Cache1 = new SoftReference<MethodCache>(methodCache1.add(x$1, method1));
        return method1;
    }

    public static Method reflMethod$Method2(Class x$1) {
        Method method2;
        MethodCache methodCache2 = (MethodCache)reflPoly$Cache2.get();
        if (methodCache2 == null) {
            methodCache2 = new EmptyMethodCache();
            reflPoly$Cache2 = new SoftReference<MethodCache>(methodCache2);
        }
        if ((method2 = methodCache2.find(x$1)) != null) {
            return method2;
        }
        method2 = ScalaRunTime$.MODULE$.ensureAccessible(x$1.getMethod("readByte", reflParams$Cache2));
        reflPoly$Cache2 = new SoftReference<MethodCache>(methodCache2.add(x$1, method2));
        return method2;
    }

    public static Method reflMethod$Method3(Class x$1) {
        Method method3;
        MethodCache methodCache3 = (MethodCache)reflPoly$Cache3.get();
        if (methodCache3 == null) {
            methodCache3 = new EmptyMethodCache();
            reflPoly$Cache3 = new SoftReference<MethodCache>(methodCache3);
        }
        if ((method3 = methodCache3.find(x$1)) != null) {
            return method3;
        }
        method3 = ScalaRunTime$.MODULE$.ensureAccessible(x$1.getMethod("readByte", reflParams$Cache3));
        reflPoly$Cache3 = new SoftReference<MethodCache>(methodCache3.add(x$1, method3));
        return method3;
    }

    public static Method reflMethod$Method4(Class x$1) {
        Method method4;
        MethodCache methodCache4 = (MethodCache)reflPoly$Cache4.get();
        if (methodCache4 == null) {
            methodCache4 = new EmptyMethodCache();
            reflPoly$Cache4 = new SoftReference<MethodCache>(methodCache4);
        }
        if ((method4 = methodCache4.find(x$1)) != null) {
            return method4;
        }
        method4 = ScalaRunTime$.MODULE$.ensureAccessible(x$1.getMethod("readByte", reflParams$Cache4));
        reflPoly$Cache4 = new SoftReference<MethodCache>(methodCache4.add(x$1, method4));
        return method4;
    }

    public static void serialize(TwkbSerialization $this, Object out, Geometry geometry, GeometryPrecision.TwkbPrecision precision) {
        Geometry geometry2;
        block27: {
            block20: {
                TwkbSerialization.XYState state;
                block26: {
                    block25: {
                        block24: {
                            block23: {
                                block22: {
                                    block21: {
                                        BoxedUnit boxedUnit;
                                        block19: {
                                            if (geometry != null) break block19;
                                            Object qual1 = out;
                                            try {
                                                TwkbSerialization$class.reflMethod$Method1(qual1.getClass()).invoke(qual1, BoxesRunTime.boxToByte((byte)TwkbSerialization$.MODULE$.org$locationtech$geomesa$features$serialization$TwkbSerialization$$ZeroByte()));
                                            }
                                            catch (InvocationTargetException invocationTargetException) {
                                                throw invocationTargetException.getCause();
                                            }
                                            break block20;
                                        }
                                        Coordinate coord = geometry.getCoordinate();
                                        state = coord == null || Double.isNaN(coord.getZ()) ? new TwkbSerialization.XYState($this, precision.xy()) : new TwkbSerialization.XYZState($this, precision.xy(), precision.z());
                                        geometry2 = geometry;
                                        if (!(geometry2 instanceof Point)) break block21;
                                        Point point = (Point)geometry2;
                                        if (point.isEmpty()) {
                                            state.writeMetadata(out, TwkbSerialization$GeometryBytes$.MODULE$.TwkbPoint(), true, false);
                                            boxedUnit = BoxedUnit.UNIT;
                                        } else {
                                            state.writeMetadata(out, TwkbSerialization$GeometryBytes$.MODULE$.TwkbPoint(), false, false);
                                            state.writeCoordinate(out, point.getCoordinate());
                                            boxedUnit = BoxedUnit.UNIT;
                                        }
                                        BoxedUnit boxedUnit2 = boxedUnit;
                                        break block20;
                                    }
                                    if (!(geometry2 instanceof LineString)) break block22;
                                    LineString lineString = (LineString)geometry2;
                                    if (lineString.isEmpty()) {
                                        state.writeMetadata(out, TwkbSerialization$GeometryBytes$.MODULE$.TwkbLineString(), true, false);
                                    } else {
                                        state.writeMetadata(out, TwkbSerialization$GeometryBytes$.MODULE$.TwkbLineString(), false, true);
                                        state.writeBoundingBox(out, lineString, DimensionalBounds$LineStringBounds$.MODULE$);
                                    }
                                    TwkbSerialization$class.writeLineString($this, out, lineString, state);
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    break block20;
                                }
                                if (!(geometry2 instanceof Polygon)) break block23;
                                Polygon polygon = (Polygon)geometry2;
                                if (polygon.isEmpty()) {
                                    state.writeMetadata(out, TwkbSerialization$GeometryBytes$.MODULE$.TwkbPolygon(), true, false);
                                } else {
                                    state.writeMetadata(out, TwkbSerialization$GeometryBytes$.MODULE$.TwkbPolygon(), false, true);
                                    state.writeBoundingBox(out, polygon, DimensionalBounds$PolygonBounds$.MODULE$);
                                }
                                TwkbSerialization$class.writePolygon($this, out, polygon, state);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                break block20;
                            }
                            if (!(geometry2 instanceof MultiPoint)) break block24;
                            MultiPoint multiPoint = (MultiPoint)geometry2;
                            if (multiPoint.isEmpty()) {
                                state.writeMetadata(out, TwkbSerialization$GeometryBytes$.MODULE$.TwkbMultiPoint(), true, false);
                            } else {
                                state.writeMetadata(out, TwkbSerialization$GeometryBytes$.MODULE$.TwkbMultiPoint(), false, true);
                                state.writeBoundingBox(out, multiPoint, DimensionalBounds$MultiPointBounds$.MODULE$);
                            }
                            TwkbSerialization$class.writeMultiPoint($this, out, multiPoint, state);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block20;
                        }
                        if (!(geometry2 instanceof MultiLineString)) break block25;
                        MultiLineString multiLineString = (MultiLineString)geometry2;
                        if (multiLineString.isEmpty()) {
                            state.writeMetadata(out, TwkbSerialization$GeometryBytes$.MODULE$.TwkbMultiLineString(), true, false);
                        } else {
                            state.writeMetadata(out, TwkbSerialization$GeometryBytes$.MODULE$.TwkbMultiLineString(), false, true);
                            state.writeBoundingBox(out, multiLineString, DimensionalBounds$MultiLineStringBounds$.MODULE$);
                        }
                        TwkbSerialization$class.writeMultiLineString($this, out, multiLineString, state);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block20;
                    }
                    if (!(geometry2 instanceof MultiPolygon)) break block26;
                    MultiPolygon multiPolygon = (MultiPolygon)geometry2;
                    if (multiPolygon.isEmpty()) {
                        state.writeMetadata(out, TwkbSerialization$GeometryBytes$.MODULE$.TwkbMultiPolygon(), true, false);
                    } else {
                        state.writeMetadata(out, TwkbSerialization$GeometryBytes$.MODULE$.TwkbMultiPolygon(), false, true);
                        state.writeBoundingBox(out, multiPolygon, DimensionalBounds$MultiPolygonBounds$.MODULE$);
                    }
                    TwkbSerialization$class.writeMultiPolygon($this, out, multiPolygon, state);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block20;
                }
                if (!(geometry2 instanceof GeometryCollection)) break block27;
                GeometryCollection geometryCollection = (GeometryCollection)geometry2;
                if (geometryCollection.isEmpty()) {
                    state.writeMetadata(out, TwkbSerialization$GeometryBytes$.MODULE$.TwkbCollection(), true, false);
                } else {
                    state.writeMetadata(out, TwkbSerialization$GeometryBytes$.MODULE$.TwkbCollection(), false, true);
                    state.writeBoundingBox(out, geometryCollection, DimensionalBounds$GeometryCollectionBounds$.MODULE$);
                }
                TwkbSerialization$class.writeCollection($this, out, geometryCollection, state);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)geometry2);
    }

    public static GeometryPrecision.TwkbPrecision serialize$default$3(TwkbSerialization $this) {
        return new GeometryPrecision.TwkbPrecision(GeometryPrecision.TwkbPrecision$.MODULE$.apply$default$1(), GeometryPrecision.TwkbPrecision$.MODULE$.apply$default$2(), GeometryPrecision.TwkbPrecision$.MODULE$.apply$default$3());
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    public static Geometry deserialize(TwkbSerialization $this, Object in) {
        Geometry geometry;
        block17: {
            try {
                void var10_4;
                block26: {
                    Point point;
                    block20: {
                        byte by;
                        block25: {
                            TwkbSerialization.XYState state;
                            block24: {
                                block23: {
                                    block22: {
                                        block21: {
                                            block19: {
                                                TwkbSerialization.XYState xYState;
                                                boolean isEmpty;
                                                byte flags;
                                                byte precisionAndType;
                                                block18: {
                                                    Object qual2 = in;
                                                    try {
                                                        precisionAndType = BoxesRunTime.unboxToByte((Object)((Byte)TwkbSerialization$class.reflMethod$Method2(qual2.getClass()).invoke(qual2, new Object[0])));
                                                        if (precisionAndType == TwkbSerialization$.MODULE$.org$locationtech$geomesa$features$serialization$TwkbSerialization$$ZeroByte()) {
                                                            geometry = null;
                                                            break block17;
                                                        }
                                                        if (precisionAndType != package$.MODULE$.NOT_NULL_BYTE()) break block18;
                                                    }
                                                    catch (InvocationTargetException invocationTargetException) {
                                                        throw invocationTargetException.getCause();
                                                    }
                                                    geometry = $this.deserializeWkb(in, $this.deserializeWkb$default$2());
                                                    break block17;
                                                }
                                                byte geomType = (byte)(precisionAndType & 0xF);
                                                int precision = VarIntEncoding$.MODULE$.zigzagDecode((precisionAndType & 0xF0) >>> 4);
                                                Object qual3 = in;
                                                try {
                                                    flags = BoxesRunTime.unboxToByte((Object)((Byte)TwkbSerialization$class.reflMethod$Method3(qual3.getClass()).invoke(qual3, new Object[0])));
                                                }
                                                catch (InvocationTargetException invocationTargetException) {
                                                    throw invocationTargetException.getCause();
                                                }
                                                boolean hasBoundingBox = (byte)(flags & TwkbSerialization$FlagBytes$.MODULE$.BoundingBoxFlag()) != 0;
                                                boolean hasExtendedDims = (byte)(flags & TwkbSerialization$FlagBytes$.MODULE$.ExtendedDimsFlag()) != 0;
                                                boolean bl = isEmpty = (byte)(flags & TwkbSerialization$FlagBytes$.MODULE$.EmptyFlag()) != 0;
                                                if (hasExtendedDims) {
                                                    Object qual4 = in;
                                                    byte extendedDims = BoxesRunTime.unboxToByte((Object)((Byte)TwkbSerialization$class.reflMethod$Method4(qual4.getClass()).invoke(qual4, new Object[0])));
                                                    xYState = (extendedDims & 1) != 0 ? ((extendedDims & 2) != 0 ? new TwkbSerialization.XYZMState($this, precision, (extendedDims & 0x1C) >> 2, (extendedDims & 0xE0) >>> 5) : new TwkbSerialization.XYZState($this, precision, (extendedDims & 0x1C) >> 2)) : ((extendedDims & 2) != 0 ? new TwkbSerialization.XYMState($this, precision, (extendedDims & 0xE0) >>> 5) : new TwkbSerialization.XYState($this, precision));
                                                } else {
                                                    xYState = state = new TwkbSerialization.XYState($this, precision);
                                                }
                                                if (hasBoundingBox) {
                                                    state.skipBoundingBox(in);
                                                }
                                                by = geomType;
                                                if (TwkbSerialization$GeometryBytes$.MODULE$.TwkbPoint() != by) break block19;
                                                point = $this.org$locationtech$geomesa$features$serialization$TwkbSerialization$$factory().createPoint(isEmpty ? null : $this.org$locationtech$geomesa$features$serialization$TwkbSerialization$$csFactory().create(TwkbSerialization$class.readPointArray($this, in, 1, state)));
                                                break block20;
                                            }
                                            if (TwkbSerialization$GeometryBytes$.MODULE$.TwkbLineString() != by) break block21;
                                            point = TwkbSerialization$class.readLineString($this, in, state);
                                            break block20;
                                        }
                                        if (TwkbSerialization$GeometryBytes$.MODULE$.TwkbPolygon() != by) break block22;
                                        point = TwkbSerialization$class.readPolygon($this, in, state);
                                        break block20;
                                    }
                                    if (TwkbSerialization$GeometryBytes$.MODULE$.TwkbMultiPoint() != by) break block23;
                                    point = TwkbSerialization$class.readMultiPoint($this, in, state);
                                    break block20;
                                }
                                if (TwkbSerialization$GeometryBytes$.MODULE$.TwkbMultiLineString() != by) break block24;
                                point = TwkbSerialization$class.readMultiLineString($this, in, state);
                                break block20;
                            }
                            if (TwkbSerialization$GeometryBytes$.MODULE$.TwkbMultiPolygon() != by) break block25;
                            point = TwkbSerialization$class.readMultiPolygon($this, in, state);
                            break block20;
                        }
                        if (TwkbSerialization$GeometryBytes$.MODULE$.TwkbCollection() != by) break block26;
                        point = TwkbSerialization$class.readCollection($this, in);
                    }
                    geometry = point;
                    break block17;
                }
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid TWKB geometry type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)var10_4)})));
                catch (InvocationTargetException invocationTargetException) {
                    throw invocationTargetException.getCause();
                }
            }
            catch (Throwable throwable) {
                Geometry geometry2;
                BoxedUnit boxedUnit;
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    throw throwable;
                }
                Throwable e = (Throwable)option.get();
                if ($this.logger().underlying().isErrorEnabled()) {
                    $this.logger().underlying().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error reading serialized kryo geometry:"})).s((Seq)Nil$.MODULE$), e);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                geometry = geometry2 = null;
            }
        }
        return geometry;
    }

    private static void writeLineString(TwkbSerialization $this, Object out, LineString g, TwkbSerialization.DeltaState state) {
        TwkbSerialization$class.writePointArray($this, out, g.getCoordinateSequence(), g.getNumPoints(), state);
    }

    private static LineString readLineString(TwkbSerialization $this, Object in, TwkbSerialization.DeltaState state) {
        return $this.org$locationtech$geomesa$features$serialization$TwkbSerialization$$factory().createLineString($this.org$locationtech$geomesa$features$serialization$TwkbSerialization$$csFactory().create(TwkbSerialization$class.readPointArray($this, in, $this.readUnsignedVarInt(in), state)));
    }

    private static void writePolygon(TwkbSerialization $this, Object out, Polygon g, TwkbSerialization.DeltaState state) {
        if (g.isEmpty()) {
            $this.writeUnsignedVarInt(out, 0);
        } else {
            int numRings = g.getNumInteriorRing();
            $this.writeUnsignedVarInt(out, numRings + 1);
            CoordinateSequence ring = g.getExteriorRing().getCoordinateSequence();
            TwkbSerialization$class.writePointArray($this, out, ring, ring.size() - 1, state);
            for (int j = 0; j < numRings; ++j) {
                ring = g.getInteriorRingN(j).getCoordinateSequence();
                TwkbSerialization$class.writePointArray($this, out, ring, ring.size() - 1, state);
            }
        }
    }

    private static Polygon readPolygon(TwkbSerialization $this, Object in, TwkbSerialization.DeltaState state) {
        Polygon polygon;
        int numRings = $this.readUnsignedVarInt(in);
        if (numRings == 0) {
            polygon = $this.org$locationtech$geomesa$features$serialization$TwkbSerialization$$factory().createPolygon(null, null);
        } else {
            LinearRing exteriorRing = TwkbSerialization$class.readLinearRing($this, in, $this.readUnsignedVarInt(in), state);
            LinearRing[] interiorRings = (LinearRing[])Array$.MODULE$.ofDim(numRings - 1, ClassTag$.MODULE$.apply(LinearRing.class));
            for (int i = 1; i < numRings; ++i) {
                interiorRings[i - 1] = TwkbSerialization$class.readLinearRing($this, in, $this.readUnsignedVarInt(in), state);
            }
            polygon = $this.org$locationtech$geomesa$features$serialization$TwkbSerialization$$factory().createPolygon(exteriorRing, interiorRings);
        }
        return polygon;
    }

    private static void writeMultiPoint(TwkbSerialization $this, Object out, MultiPoint g, TwkbSerialization.DeltaState state) {
        int length = g.getNumPoints();
        $this.writeUnsignedVarInt(out, length);
        for (int i = 0; i < length; ++i) {
            state.writeCoordinate(out, ((Point)g.getGeometryN(i)).getCoordinate());
        }
    }

    private static MultiPoint readMultiPoint(TwkbSerialization $this, Object in, TwkbSerialization.DeltaState state) {
        int numPoints = $this.readUnsignedVarInt(in);
        return numPoints == 0 ? $this.org$locationtech$geomesa$features$serialization$TwkbSerialization$$factory().createMultiPoint(null) : $this.org$locationtech$geomesa$features$serialization$TwkbSerialization$$factory().createMultiPoint((Point[])Predef$.MODULE$.refArrayOps((Object[])TwkbSerialization$class.readPointArray($this, in, numPoints, state)).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TwkbSerialization $outer;

            public final Point apply(Coordinate x$1) {
                return this.$outer.org$locationtech$geomesa$features$serialization$TwkbSerialization$$factory().createPoint(x$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Point.class))));
    }

    private static void writeMultiLineString(TwkbSerialization $this, Object out, MultiLineString g, TwkbSerialization.DeltaState state) {
        int length = g.getNumGeometries();
        $this.writeUnsignedVarInt(out, length);
        for (int i = 0; i < length; ++i) {
            CoordinateSequence line = ((LineString)g.getGeometryN(i)).getCoordinateSequence();
            TwkbSerialization$class.writePointArray($this, out, line, line.size(), state);
        }
    }

    private static MultiLineString readMultiLineString(TwkbSerialization $this, Object in, TwkbSerialization.DeltaState state) {
        MultiLineString multiLineString;
        int numLineStrings = $this.readUnsignedVarInt(in);
        if (numLineStrings == 0) {
            multiLineString = $this.org$locationtech$geomesa$features$serialization$TwkbSerialization$$factory().createMultiLineString(null);
        } else {
            LineString[] lineStrings = (LineString[])Array$.MODULE$.ofDim(numLineStrings, ClassTag$.MODULE$.apply(LineString.class));
            for (int i = 0; i < numLineStrings; ++i) {
                lineStrings[i] = TwkbSerialization$class.readLineString($this, in, state);
            }
            multiLineString = $this.org$locationtech$geomesa$features$serialization$TwkbSerialization$$factory().createMultiLineString(lineStrings);
        }
        return multiLineString;
    }

    private static void writeMultiPolygon(TwkbSerialization $this, Object out, MultiPolygon g, TwkbSerialization.DeltaState state) {
        int length = g.getNumGeometries();
        $this.writeUnsignedVarInt(out, length);
        for (int i = 0; i < length; ++i) {
            TwkbSerialization$class.writePolygon($this, out, (Polygon)g.getGeometryN(i), state);
        }
    }

    private static MultiPolygon readMultiPolygon(TwkbSerialization $this, Object in, TwkbSerialization.DeltaState state) {
        MultiPolygon multiPolygon;
        int numPolygons = $this.readUnsignedVarInt(in);
        if (numPolygons == 0) {
            multiPolygon = $this.org$locationtech$geomesa$features$serialization$TwkbSerialization$$factory().createMultiPolygon(null);
        } else {
            Polygon[] polygons = (Polygon[])Array$.MODULE$.ofDim(numPolygons, ClassTag$.MODULE$.apply(Polygon.class));
            for (int i = 0; i < numPolygons; ++i) {
                polygons[i] = TwkbSerialization$class.readPolygon($this, in, state);
            }
            multiPolygon = $this.org$locationtech$geomesa$features$serialization$TwkbSerialization$$factory().createMultiPolygon(polygons);
        }
        return multiPolygon;
    }

    private static void writeCollection(TwkbSerialization $this, Object out, GeometryCollection g, TwkbSerialization.DeltaState state) {
        int length = g.getNumGeometries();
        $this.writeUnsignedVarInt(out, length);
        for (int i = 0; i < length; ++i) {
            $this.serialize(out, g.getGeometryN(i), $this.serialize$default$3());
        }
    }

    private static GeometryCollection readCollection(TwkbSerialization $this, Object in) {
        GeometryCollection geometryCollection;
        int numGeoms = $this.readUnsignedVarInt(in);
        if (numGeoms == 0) {
            geometryCollection = $this.org$locationtech$geomesa$features$serialization$TwkbSerialization$$factory().createGeometryCollection(null);
        } else {
            Geometry[] geoms = (Geometry[])Array$.MODULE$.ofDim(numGeoms, ClassTag$.MODULE$.apply(Geometry.class));
            for (int i = 0; i < numGeoms; ++i) {
                geoms[i] = $this.deserialize(in);
            }
            geometryCollection = $this.org$locationtech$geomesa$features$serialization$TwkbSerialization$$factory().createGeometryCollection(geoms);
        }
        return geometryCollection;
    }

    private static void writePointArray(TwkbSerialization $this, Object out, CoordinateSequence coords, int length, TwkbSerialization.DeltaState state) {
        $this.writeUnsignedVarInt(out, length);
        for (int i = 0; i < length; ++i) {
            state.writeCoordinate(out, coords.getCoordinate(i));
        }
    }

    private static Coordinate[] readPointArray(TwkbSerialization $this, Object in, int length, TwkbSerialization.DeltaState state) {
        Coordinate[] result = (Coordinate[])Array$.MODULE$.ofDim(length, ClassTag$.MODULE$.apply(Coordinate.class));
        for (int i = 0; i < length; ++i) {
            result[i] = state.readCoordinate(in);
        }
        return result;
    }

    private static LinearRing readLinearRing(TwkbSerialization $this, Object in, int length, TwkbSerialization.DeltaState state) {
        LinearRing linearRing;
        if (length == 0) {
            linearRing = $this.org$locationtech$geomesa$features$serialization$TwkbSerialization$$factory().createLinearRing(null);
        } else {
            Coordinate[] result = (Coordinate[])Array$.MODULE$.ofDim(length + 1, ClassTag$.MODULE$.apply(Coordinate.class));
            for (int i = 0; i < length; ++i) {
                result[i] = state.readCoordinate(in);
            }
            result[length] = result[0];
            linearRing = $this.org$locationtech$geomesa$features$serialization$TwkbSerialization$$factory().createLinearRing($this.org$locationtech$geomesa$features$serialization$TwkbSerialization$$csFactory().create(result));
        }
        return linearRing;
    }

    public static void $init$(TwkbSerialization $this) {
        $this.org$locationtech$geomesa$features$serialization$TwkbSerialization$_setter_$org$locationtech$geomesa$features$serialization$TwkbSerialization$$factory_$eq(new GeometryFactory());
        $this.org$locationtech$geomesa$features$serialization$TwkbSerialization$_setter_$org$locationtech$geomesa$features$serialization$TwkbSerialization$$csFactory_$eq($this.org$locationtech$geomesa$features$serialization$TwkbSerialization$$factory().getCoordinateSequenceFactory());
    }
}

