/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.parquet.jobs;

import org.apache.hadoop.mapreduce.Job;
import org.apache.parquet.hadoop.ParquetInputFormat;
import org.apache.parquet.hadoop.ParquetOutputFormat;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.locationtech.geomesa.fs.storage.common.jobs.StorageConfiguration$;
import org.locationtech.geomesa.parquet.jobs.ParquetPartitionOutputFormat;
import org.locationtech.geomesa.parquet.jobs.ParquetStorageConfiguration;
import org.locationtech.geomesa.parquet.jobs.SimpleFeatureReadSupport;
import org.locationtech.geomesa.parquet.jobs.SimpleFeatureWriteSupport;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Serializable;
import scala.runtime.BoxedUnit;

public abstract class ParquetStorageConfiguration$class {
    public static void configureOutput(ParquetStorageConfiguration $this, SimpleFeatureType sft, Job job) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        job.setOutputFormatClass(ParquetPartitionOutputFormat.class);
        StorageConfiguration$.MODULE$.setSft(job.getConfiguration(), sft);
        ParquetInputFormat.setReadSupportClass((Job)job, SimpleFeatureReadSupport.class);
        ParquetOutputFormat.setWriteSupportClass((Job)job, SimpleFeatureWriteSupport.class);
        String summaryLevel = (String)Option$.MODULE$.apply((Object)((String)sft.getUserData().get("parquet.summary.metadata.level"))).getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return ParquetOutputFormat.JobSummaryLevel.NONE.toString();
            }
        });
        job.getConfiguration().set("parquet.summary.metadata.level", summaryLevel);
        if ($this.logger().underlying().isDebugEnabled()) {
            $this.logger().underlying().debug("Parquet metadata summary level is {}", new Object[]{summaryLevel});
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        CompressionCodecName compression = (CompressionCodecName)Option$.MODULE$.apply((Object)((String)sft.getUserData().get("parquet.compression"))).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final CompressionCodecName apply(String x$1) {
                return CompressionCodecName.valueOf((String)x$1);
            }
        }).getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final CompressionCodecName apply() {
                return CompressionCodecName.SNAPPY;
            }
        });
        ParquetOutputFormat.setCompression((Job)job, (CompressionCodecName)compression);
        if ($this.logger().underlying().isDebugEnabled()) {
            $this.logger().underlying().debug("Parquet compression is {}", new Object[]{compression});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static void $init$(ParquetStorageConfiguration $this) {
    }
}

