/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.DefaultServiceInfo;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.InProcessLockingManager;
import org.geotools.data.LockingManager;
import org.geotools.data.Query;
import org.geotools.data.ServiceInfo;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.data.store.ContentFeatureStore;
import org.geotools.data.store.ContentState;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.NameImpl;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.GeometryFactory;
import org.opengis.feature.FeatureFactory;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureTypeFactory;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;

public abstract class ContentDataStore
implements DataStore {
    public static final String JOINED_FEATURE_TYPE = "JoinedFeatureType";
    protected static final int WRITER_ADD = 1;
    protected static final int WRITER_UPDATE = 2;
    protected static final int WRITER_COMMIT = 4;
    protected final Map<Name, ContentEntry> entries;
    protected final Logger LOGGER;
    protected FeatureTypeFactory typeFactory;
    protected FeatureFactory featureFactory;
    protected FilterFactory filterFactory;
    protected GeometryFactory geometryFactory;
    protected String namespaceURI;
    protected LockingManager lockingManager = new InProcessLockingManager();
    protected DataStoreFactorySpi dataStoreFactory;

    public ContentDataStore() {
        this.entries = new ConcurrentHashMap<Name, ContentEntry>();
        this.LOGGER = Logging.getLogger((String)this.getClass().getPackage().getName());
        this.setFilterFactory(CommonFactoryFinder.getFilterFactory());
    }

    public FeatureTypeFactory getFeatureTypeFactory() {
        return this.typeFactory;
    }

    public void setFeatureTypeFactory(FeatureTypeFactory typeFactory) {
        this.typeFactory = typeFactory;
    }

    public void setFeatureFactory(FeatureFactory featureFactory) {
        this.featureFactory = featureFactory;
    }

    public FilterFactory getFilterFactory() {
        return this.filterFactory;
    }

    public FeatureFactory getFeatureFactory() {
        return this.featureFactory;
    }

    public void setFilterFactory(FilterFactory filterFactory) {
        this.filterFactory = filterFactory;
    }

    public GeometryFactory getGeometryFactory() {
        return this.geometryFactory;
    }

    public void setGeometryFactory(GeometryFactory geometryFactory) {
        this.geometryFactory = geometryFactory;
    }

    public DataStoreFactorySpi getDataStoreFactory() {
        return this.dataStoreFactory;
    }

    public void setDataStoreFactory(DataStoreFactorySpi dataStoreFactory) {
        this.dataStoreFactory = dataStoreFactory;
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public void setNamespaceURI(String namespaceURI) {
        this.namespaceURI = namespaceURI;
    }

    public Logger getLogger() {
        return this.LOGGER;
    }

    @Override
    public ServiceInfo getInfo() {
        DefaultServiceInfo info = new DefaultServiceInfo();
        info.setDescription("Features from " + this.getClass().getSimpleName());
        info.setSchema(FeatureTypes.DEFAULT_NAMESPACE);
        return info;
    }

    @Override
    public final String[] getTypeNames() throws IOException {
        List<Name> typeNames = this.createTypeNames();
        String[] names = new String[typeNames.size()];
        for (int i = 0; i < typeNames.size(); ++i) {
            Name typeName = typeNames.get(i);
            names[i] = typeName.getLocalPart();
        }
        return names;
    }

    @Override
    public void createSchema(SimpleFeatureType featureType) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public final SimpleFeatureType getSchema(String typeName) throws IOException {
        ContentFeatureSource featureSource = this.getFeatureSource(typeName);
        return featureSource.getSchema();
    }

    @Override
    public ContentFeatureSource getFeatureSource(String typeName) throws IOException {
        return this.getFeatureSource(new NameImpl(null, typeName), Transaction.AUTO_COMMIT);
    }

    public ContentFeatureSource getFeatureSource(String typeName, Transaction tx) throws IOException {
        return this.getFeatureSource(new NameImpl(null, typeName), tx);
    }

    public ContentFeatureSource getFeatureSource(Name typeName, Transaction tx) throws IOException {
        ContentEntry entry = this.ensureEntry(typeName);
        ContentFeatureSource featureSource = this.createFeatureSource(entry);
        featureSource.setTransaction(tx);
        return featureSource;
    }

    @Override
    public FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(Query query, Transaction tx) throws IOException {
        if (query.getTypeName() == null) {
            throw new IllegalArgumentException("Query does not specify type.");
        }
        return this.getFeatureSource(query.getTypeName(), tx).getReader(query);
    }

    @Override
    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(String typeName, Filter filter, Transaction tx) throws IOException {
        ContentFeatureStore featureStore = this.ensureFeatureStore(typeName, tx);
        return featureStore.getWriter(filter, 3);
    }

    protected final ContentFeatureStore ensureFeatureStore(String typeName, Transaction tx) throws IOException {
        ContentFeatureSource featureSource = this.getFeatureSource(typeName, tx);
        if (!(featureSource instanceof ContentFeatureStore)) {
            throw new IOException(typeName + " is read only");
        }
        return (ContentFeatureStore)featureSource;
    }

    @Override
    public final FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(String typeName, Transaction tx) throws IOException {
        return this.getFeatureWriter(typeName, (Filter)Filter.INCLUDE, tx);
    }

    @Override
    public final FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriterAppend(String typeName, Transaction tx) throws IOException {
        ContentFeatureStore featureStore = this.ensureFeatureStore(typeName, tx);
        FeatureWriter<SimpleFeatureType, SimpleFeature> writer = featureStore.getWriter((Filter)Filter.INCLUDE, 1);
        while (writer.hasNext()) {
            writer.next();
        }
        return writer;
    }

    @Override
    public final LockingManager getLockingManager() {
        return this.lockingManager;
    }

    @Override
    public final void updateSchema(String typeName, SimpleFeatureType featureType) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void dispose() {
        for (ContentEntry entry : this.entries.values()) {
            entry.dispose();
        }
        this.entries.clear();
    }

    public ContentEntry getEntry(Name name) {
        return this.entries.get(name);
    }

    protected ContentState createContentState(ContentEntry entry) {
        return new ContentState(entry);
    }

    protected final Name name(String typeName) {
        return new NameImpl(this.namespaceURI, typeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final ContentEntry entry(Name name) throws IOException {
        NameImpl defaultNsName;
        boolean unqualifiedSearch;
        ContentEntry entry = null;
        boolean found = this.entries.containsKey(name);
        boolean bl = unqualifiedSearch = name.getNamespaceURI() == null;
        if (!found && unqualifiedSearch && this.namespaceURI != null && this.entries.containsKey(defaultNsName = new NameImpl(this.namespaceURI, name.getLocalPart()))) {
            name = defaultNsName;
            found = true;
        }
        if (!found) {
            List<Name> typeNames = this.createTypeNames();
            for (Name tn : typeNames) {
                ContentDataStore contentDataStore = this;
                synchronized (contentDataStore) {
                    if (!this.entries.containsKey(tn)) {
                        entry = new ContentEntry(this, tn);
                        this.entries.put(tn, entry);
                    }
                }
                if (found || !tn.equals((Object)name) && (!unqualifiedSearch || !tn.getLocalPart().equals(name.getLocalPart()))) continue;
                name = tn;
                found = true;
            }
        }
        return this.entries.get(name);
    }

    protected final ContentEntry ensureEntry(Name name) throws IOException {
        ContentEntry entry = this.entry(name);
        if (entry == null) {
            throw new IOException("Schema '" + name + "' does not exist.");
        }
        return entry;
    }

    protected final void removeEntry(Name name) {
        if (this.entries.containsKey(name)) {
            this.entries.remove(name);
        }
    }

    protected abstract List<Name> createTypeNames() throws IOException;

    protected abstract ContentFeatureSource createFeatureSource(ContentEntry var1) throws IOException;

    @Override
    public SimpleFeatureSource getFeatureSource(Name typeName) throws IOException {
        return this.getFeatureSource(typeName, Transaction.AUTO_COMMIT);
    }

    @Override
    public List<Name> getNames() throws IOException {
        String[] typeNames = this.getTypeNames();
        ArrayList<Name> names = new ArrayList<Name>(typeNames.length);
        for (String typeName : typeNames) {
            names.add(new NameImpl(typeName));
        }
        return names;
    }

    @Override
    public SimpleFeatureType getSchema(Name name) throws IOException {
        return this.getSchema(name.getLocalPart());
    }

    @Override
    public void updateSchema(Name typeName, SimpleFeatureType featureType) throws IOException {
        this.updateSchema(typeName.getLocalPart(), featureType);
    }

    @Override
    public void removeSchema(Name typeName) throws IOException {
        throw new UnsupportedOperationException("Schema removal not supported");
    }

    @Override
    public void removeSchema(String typeName) throws IOException {
        throw new UnsupportedOperationException("Schema removal not supported");
    }
}

