/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings.ext;

import java.util.ArrayList;
import org.geotools.gml3.bindings.CurvePropertyTypeBinding;
import org.geotools.gml3.bindings.CurveTypeBinding;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.Node;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;

public class CurveArrayPropertyTypeBinding
extends org.geotools.gml3.bindings.CurveArrayPropertyTypeBinding
implements Comparable {
    public CurveArrayPropertyTypeBinding(GeometryFactory gf) {
        super(gf);
    }

    @Override
    public Class getType() {
        return MultiLineString.class;
    }

    @Override
    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        ArrayList<LineString> lineStrings = new ArrayList<LineString>();
        for (Node child : node.getChildren()) {
            Object nodeValue = child.getValue();
            if (nodeValue instanceof MultiLineString) {
                MultiLineString curve = (MultiLineString)nodeValue;
                for (int i = 0; i < curve.getNumGeometries(); ++i) {
                    LineString lineString = (LineString)curve.getGeometryN(i);
                    lineStrings.add(lineString);
                }
                continue;
            }
            if (!(nodeValue instanceof LineString)) continue;
            LineString lineString = (LineString)nodeValue;
            lineStrings.add(lineString);
        }
        return this.gf.createMultiLineString(GeometryFactory.toLineStringArray(lineStrings));
    }

    public int compareTo(Object o) {
        if (o instanceof CurveTypeBinding || o instanceof CurvePropertyTypeBinding) {
            return 1;
        }
        return 0;
    }
}

