/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.fs.storage.common.jobs;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.locationtech.geomesa.fs.storage.common.utils.StorageUtils$FileType$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;

public final class StorageConfiguration$ {
    public static final StorageConfiguration$ MODULE$;
    private final String PathKey;
    private final String PartitionsKey;
    private final String FileTypeKey;
    private final String SftNameKey;
    private final String SftSpecKey;

    static {
        new StorageConfiguration$();
    }

    public String PathKey() {
        return this.PathKey;
    }

    public String PartitionsKey() {
        return this.PartitionsKey;
    }

    public String FileTypeKey() {
        return this.FileTypeKey;
    }

    public String SftNameKey() {
        return this.SftNameKey;
    }

    public String SftSpecKey() {
        return this.SftSpecKey;
    }

    public void setSft(Configuration conf, SimpleFeatureType sft) {
        String name = (String)Option$.MODULE$.apply((Object)sft.getName().getNamespaceURI()).map((Function1)new Serializable(sft){
            public static final long serialVersionUID = 0L;
            private final SimpleFeatureType sft$1;

            public final String apply(String ns) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ns, this.sft$1.getTypeName()}));
            }
            {
                this.sft$1 = sft$1;
            }
        }).getOrElse((Function0)new Serializable(sft){
            public static final long serialVersionUID = 0L;
            private final SimpleFeatureType sft$1;

            public final String apply() {
                return this.sft$1.getTypeName();
            }
            {
                this.sft$1 = sft$1;
            }
        });
        conf.set(this.SftNameKey(), name);
        conf.set(this.SftSpecKey(), SimpleFeatureTypes$.MODULE$.encodeType(sft, true));
    }

    public SimpleFeatureType getSft(Configuration conf) {
        return SimpleFeatureTypes$.MODULE$.createType(conf.get(this.SftNameKey()), conf.get(this.SftSpecKey()));
    }

    public void setRootPath(Configuration conf, Path path) {
        conf.set(this.PathKey(), path.toString());
    }

    public Path getRootPath(Configuration conf) {
        return new Path(conf.get(this.PathKey()));
    }

    public void setPartitions(Configuration conf, String[] partitions) {
        conf.setStrings(this.PartitionsKey(), partitions);
    }

    public String[] getPartitions(Configuration conf) {
        return conf.getStrings(this.PartitionsKey());
    }

    public void setFileType(Configuration conf, Enumeration.Value fileType) {
        conf.set(this.FileTypeKey(), fileType.toString());
    }

    public Enumeration.Value getFileType(Configuration conf) {
        return StorageUtils$FileType$.MODULE$.withName(conf.get(this.FileTypeKey()));
    }

    private StorageConfiguration$() {
        MODULE$ = this;
        this.PathKey = "geomesa.fs.path";
        this.PartitionsKey = "geomesa.fs.partitions";
        this.FileTypeKey = "geomesa.fs.output.file-type";
        this.SftNameKey = "geomesa.fs.sft.name";
        this.SftSpecKey = "geomesa.fs.sft.spec";
    }
}

