/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.tools.export.formats;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Writer;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.csv.CSVPrinter;
import org.locationtech.geomesa.tools.export.formats.DelimitedExporter$;
import org.locationtech.geomesa.tools.export.formats.FeatureExporter;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.locationtech.geomesa.utils.geotools.package$;
import org.locationtech.geomesa.utils.text.WKTUtils$;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Iterable$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;

@ScalaSignature(bytes="\u0006\u0001\u0005]c\u0001B\u0001\u0003\u0001=\u0011\u0011\u0003R3mS6LG/\u001a3FqB|'\u000f^3s\u0015\t\u0019A!A\u0004g_Jl\u0017\r^:\u000b\u0005\u00151\u0011AB3ya>\u0014HO\u0003\u0002\b\u0011\u0005)Ao\\8mg*\u0011\u0011BC\u0001\bO\u0016|W.Z:b\u0015\tYA\"\u0001\u0007m_\u000e\fG/[8oi\u0016\u001c\u0007NC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\u0011\u0001\u0001\u0003\u0007\u000f\u0011\u0005E1R\"\u0001\n\u000b\u0005M!\u0012\u0001\u00027b]\u001eT\u0011!F\u0001\u0005U\u00064\u0018-\u0003\u0002\u0018%\t1qJ\u00196fGR\u0004\"!\u0007\u000e\u000e\u0003\tI!a\u0007\u0002\u0003\u001f\u0019+\u0017\r^;sK\u0016C\bo\u001c:uKJ\u0004\"!\b\u0013\u000e\u0003yQ!a\b\u0011\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005\u0005\u0012\u0013\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003\r\n1aY8n\u0013\t)cDA\u0006MCjLHj\\4hS:<\u0007\u0002C\u0014\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0015\u0002\u000fA\u0014\u0018N\u001c;feB\u0011\u0011\u0006M\u0007\u0002U)\u00111\u0006L\u0001\u0004GN4(BA\u0017/\u0003\u001d\u0019w.\\7p]NT!a\f\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0013\t\t$F\u0001\u0006D'Z\u0003&/\u001b8uKJD\u0001b\r\u0001\u0003\u0002\u0003\u0006I\u0001N\u0001\u000bo&$\b\u000eS3bI\u0016\u0014\bCA\u001b9\u001b\u00051$\"A\u001c\u0002\u000bM\u001c\u0017\r\\1\n\u0005e2$a\u0002\"p_2,\u0017M\u001c\u0005\tw\u0001\u0011\t\u0011)A\u0005i\u0005Q\u0011N\\2mk\u0012,\u0017\nZ:\t\u000bu\u0002A\u0011\u0001 \u0002\rqJg.\u001b;?)\u0011y\u0004)\u0011\"\u0011\u0005e\u0001\u0001\"B\u0014=\u0001\u0004A\u0003\"B\u001a=\u0001\u0004!\u0004\"B\u001e=\u0001\u0004!\u0004\"\u0002#\u0001\t\u0003*\u0015!B:uCJ$HC\u0001$J!\t)t)\u0003\u0002Im\t!QK\\5u\u0011\u0015Q5\t1\u0001L\u0003\r\u0019h\r\u001e\t\u0003\u0019Nk\u0011!\u0014\u0006\u0003\u001d>\u000baa]5na2,'B\u0001)R\u0003\u001d1W-\u0019;ve\u0016T!A\u0015\u0007\u0002\u000f=\u0004XM\\4jg&\u0011A+\u0014\u0002\u0012'&l\u0007\u000f\\3GK\u0006$XO]3UsB,\u0007\"B\u0003\u0001\t\u00032FCA,^!\r)\u0004LW\u0005\u00033Z\u0012aa\u00149uS>t\u0007CA\u001b\\\u0013\tafG\u0001\u0003M_:<\u0007\"\u00020V\u0001\u0004y\u0016\u0001\u00034fCR,(/Z:\u0011\u0007\u0001D7N\u0004\u0002bM:\u0011!-Z\u0007\u0002G*\u0011AMD\u0001\u0007yI|w\u000e\u001e \n\u0003]J!a\u001a\u001c\u0002\u000fA\f7m[1hK&\u0011\u0011N\u001b\u0002\t\u0013R,'/\u0019;pe*\u0011qM\u000e\t\u0003\u00192L!!\\'\u0003\u001bMKW\u000e\u001d7f\r\u0016\fG/\u001e:f\u0011\u0015y\u0007\u0001\"\u0011q\u0003\u0015\u0019Gn\\:f)\u00051\u0005\"\u0002:\u0001\t\u0013\u0019\u0018!C:ue&tw-\u001b4z)\t!8\u0010\u0005\u0002vq:\u0011QG^\u0005\u0003oZ\na\u0001\u0015:fI\u00164\u0017BA={\u0005\u0019\u0019FO]5oO*\u0011qO\u000e\u0005\u0006yF\u0004\r!`\u0001\u0004_\nT\u0007CA\u001b\u007f\u0013\tyhGA\u0002B]f<q!a\u0001\u0003\u0011\u0003\t)!A\tEK2LW.\u001b;fI\u0016C\bo\u001c:uKJ\u00042!GA\u0004\r\u0019\t!\u0001#\u0001\u0002\nM!\u0011qAA\u0006!\r)\u0014QB\u0005\u0004\u0003\u001f1$AB!osJ+g\rC\u0004>\u0003\u000f!\t!a\u0005\u0015\u0005\u0005\u0015\u0001bB\u0016\u0002\b\u0011\u0005\u0011q\u0003\u000b\b\u007f\u0005e\u0011\u0011FA\u0016\u0011!\tY\"!\u0006A\u0002\u0005u\u0011AB<sSR,'\u000f\u0005\u0003\u0002 \u0005\u0015RBAA\u0011\u0015\r\t\u0019\u0003F\u0001\u0003S>LA!a\n\u0002\"\t1qK]5uKJDaaMA\u000b\u0001\u0004!\u0004\u0002C\u001e\u0002\u0016A\u0005\t\u0019\u0001\u001b\t\u0011\u0005=\u0012q\u0001C\u0001\u0003c\t1\u0001^:w)\u001dy\u00141GA\u001b\u0003oA\u0001\"a\u0007\u0002.\u0001\u0007\u0011Q\u0004\u0005\u0007g\u00055\u0002\u0019\u0001\u001b\t\u0011m\ni\u0003%AA\u0002QB!\"a\u000f\u0002\bE\u0005I\u0011AA\u001f\u00035\u00197O\u001e\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011q\b\u0016\u0004i\u0005\u00053FAA\"!\u0011\t)%a\u0014\u000e\u0005\u0005\u001d#\u0002BA%\u0003\u0017\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u00055c'\u0001\u0006b]:|G/\u0019;j_:LA!!\u0015\u0002H\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0015\u0005U\u0013qAI\u0001\n\u0003\ti$A\u0007ugZ$C-\u001a4bk2$He\r")
public class DelimitedExporter
implements FeatureExporter,
LazyLogging {
    public final CSVPrinter org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$printer;
    private final boolean withHeader;
    public final boolean org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$includeIds;
    private final Logger logger;
    private volatile boolean bitmap$0;

    public static boolean tsv$default$3() {
        return DelimitedExporter$.MODULE$.tsv$default$3();
    }

    public static boolean csv$default$3() {
        return DelimitedExporter$.MODULE$.csv$default$3();
    }

    public static DelimitedExporter tsv(Writer writer, boolean bl, boolean bl2) {
        return DelimitedExporter$.MODULE$.tsv(writer, bl, bl2);
    }

    public static DelimitedExporter csv(Writer writer, boolean bl, boolean bl2) {
        return DelimitedExporter$.MODULE$.csv(writer, bl, bl2);
    }

    private Logger logger$lzycompute() {
        DelimitedExporter delimitedExporter = this;
        synchronized (delimitedExporter) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public void start(SimpleFeatureType sft) {
        if (this.withHeader) {
            if (this.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$includeIds) {
                this.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$printer.print((Object)"id");
            }
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(sft.getAttributeDescriptors()).asScala()).foreach((Function1)new Serializable(this, sft){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DelimitedExporter $outer;
                private final SimpleFeatureType sft$1;

                public final void apply(AttributeDescriptor descriptor) {
                    this.$outer.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$printer.print((Object)SimpleFeatureTypes$.MODULE$.encodeDescriptor(this.sft$1, descriptor));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.sft$1 = sft$1;
                }
            });
            this.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$printer.println();
            this.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$printer.flush();
        }
    }

    @Override
    public Option<Object> export(Iterator<SimpleFeature> features) {
        BoxedUnit boxedUnit;
        LongRef count = LongRef.create((long)0L);
        features.foreach((Function1)new Serializable(this, count){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelimitedExporter $outer;
            private final LongRef count$1;

            public final void apply(SimpleFeature sf) {
                if (this.$outer.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$includeIds) {
                    this.$outer.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$printer.print((Object)sf.getID());
                }
                for (int i = 0; i < sf.getAttributeCount(); ++i) {
                    this.$outer.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$printer.print((Object)this.$outer.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$stringify(sf.getAttribute(i)));
                }
                this.$outer.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$printer.println();
                ++this.count$1.elem;
                if (this.count$1.elem % 10000L == 0L) {
                    BoxedUnit boxedUnit;
                    if (this.$outer.logger().underlying().isDebugEnabled()) {
                        this.$outer.logger().underlying().debug("wrote {} features", new Object[]{BoxesRunTime.boxToLong((long)this.count$1.elem)});
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.count$1 = count$1;
            }
        });
        this.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$printer.flush();
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Exported {} features", new Object[]{BoxesRunTime.boxToLong((long)count.elem)});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return new Some((Object)BoxesRunTime.boxToLong((long)count.elem));
    }

    @Override
    public void close() {
        this.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$printer.close();
    }

    public String org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$stringify(Object obj) {
        String string;
        Object object = obj;
        if (object == null) {
            string = "";
        } else if (object instanceof Geometry) {
            Geometry geometry = (Geometry)object;
            string = WKTUtils$.MODULE$.write(geometry);
        } else if (object instanceof Date) {
            Date date = (Date)object;
            string = package$.MODULE$.GeoToolsDateFormat().format(Instant.ofEpochMilli(date.getTime()).atZone(ZoneOffset.UTC));
        } else if (object instanceof List) {
            List list = (List)object;
            string = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(list).asScala()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DelimitedExporter $outer;

                public final String apply(Object obj) {
                    return this.$outer.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$stringify(obj);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, Buffer$.MODULE$.canBuildFrom())).mkString(",");
        } else if (object instanceof Map) {
            Map map = (Map)object;
            string = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(map).asScala()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DelimitedExporter $outer;

                public final String apply(Tuple2<Object, Object> x0$1) {
                    Tuple2<Object, Object> tuple2 = x0$1;
                    if (tuple2 != null) {
                        Object k = tuple2._1();
                        Object v = tuple2._2();
                        String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "->", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$stringify(k), this.$outer.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$stringify(v)}));
                        return string;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, Iterable$.MODULE$.canBuildFrom())).mkString(",");
        } else {
            string = obj.toString();
        }
        return string;
    }

    public DelimitedExporter(CSVPrinter printer, boolean withHeader, boolean includeIds) {
        this.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$printer = printer;
        this.withHeader = withHeader;
        this.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$includeIds = includeIds;
        LazyLogging.class.$init$((LazyLogging)this);
    }
}

