/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.process.analytic;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.locationtech.geomesa.index.geotools.GeoMesaFeatureCollection$;
import org.locationtech.geomesa.process.GeoMesaProcess;
import org.locationtech.geomesa.process.analytic.AttributeVisitor;
import org.locationtech.geomesa.process.analytic.UniqueProcess$;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.IncludeFilter;
import org.opengis.util.ProgressListener;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.Nothing$;

@DescribeProcess(title="Geomesa Unique", description="Finds unique attributes values, optimized for GeoMesa")
@ScalaSignature(bytes="\u0006\u0001\u0005\u0005g\u0001B\u0001\u0003\u00015\u0011Q\"\u00168jcV,\u0007K]8dKN\u001c(BA\u0002\u0005\u0003!\tg.\u00197zi&\u001c'BA\u0003\u0007\u0003\u001d\u0001(o\\2fgNT!a\u0002\u0005\u0002\u000f\u001d,w.\\3tC*\u0011\u0011BC\u0001\rY>\u001c\u0017\r^5p]R,7\r\u001b\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M!\u0001A\u0004\f\u001b!\tyA#D\u0001\u0011\u0015\t\t\"#\u0001\u0003mC:<'\"A\n\u0002\t)\fg/Y\u0005\u0003+A\u0011aa\u00142kK\u000e$\bCA\f\u0019\u001b\u0005!\u0011BA\r\u0005\u000599Um\\'fg\u0006\u0004&o\\2fgN\u0004\"a\u0007\u0012\u000e\u0003qQ!!\b\u0010\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005}\u0001\u0013\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003\u0005\n1aY8n\u0013\t\u0019CDA\u0006MCjLHj\\4hS:<\u0007\"B\u0013\u0001\t\u00031\u0013A\u0002\u001fj]&$h\bF\u0001(!\tA\u0003!D\u0001\u0003\u0011\u0015Q\u0003\u0001\"\u0001,\u0003\u001d)\u00070Z2vi\u0016$\u0002\u0002\f\u001cF+\u0012l7/\u001f\t\u0003[Qj\u0011A\f\u0006\u0003_A\naa]5na2,'BA\u00193\u0003\u0011!\u0017\r^1\u000b\u0005MR\u0011\u0001C4f_R|w\u000e\\:\n\u0005Ur#aF*j[BdWMR3biV\u0014XmQ8mY\u0016\u001cG/[8o\u0011\u00159\u0014\u00061\u0001-\u0003!1W-\u0019;ve\u0016\u001c\bF\u0002\u001c:\u0001\u0006\u00135\t\u0005\u0002;}5\t1H\u0003\u0002={\u00059a-Y2u_JL(BA\u00033\u0013\ty4HA\tEKN\u001c'/\u001b2f!\u0006\u0014\u0018-\\3uKJ\fAA\\1nK\u0006\nq'A\u0006eKN\u001c'/\u001b9uS>t\u0017%\u0001#\u00021%s\u0007/\u001e;!M\u0016\fG/\u001e:fA\r|G\u000e\\3di&|g\u000eC\u0003GS\u0001\u0007q)A\u0005biR\u0014\u0018NY;uKB\u0011\u0001J\u0014\b\u0003\u00132k\u0011A\u0013\u0006\u0002\u0017\u0006)1oY1mC&\u0011QJS\u0001\u0007!J,G-\u001a4\n\u0005=\u0003&AB*ue&twM\u0003\u0002N\u0015\"2Q)\u000f!S\u0005N\u000b\u0013AR\u0011\u0002)\u0006Y\u0013\t\u001e;sS\n,H/\u001a\u0011xQ>\u001cX\rI;oSF,X\r\t<bYV,7\u000fI1sK\u0002*\u0007\u0010\u001e:bGR,G\rC\u0003WS\u0001\u0007q+\u0001\u0004gS2$XM\u001d\t\u00031rk\u0011!\u0017\u0006\u0003-jS!a\u0017\u0006\u0002\u000f=\u0004XM\\4jg&\u0011Q,\u0017\u0002\u0007\r&dG/\u001a:)\u0011UK\u0004i\u00181b\u0005\n\f\u0013AV\u0001\u0004[&tW$\u0001\u0001\"\u0003\r\fQ\u0006\u00165fA\u0019LG\u000e^3sAQ|\u0007%\u00199qYf\u0004Co\u001c\u0011uQ\u0016\u0004c-Z1ukJ,\u0007eY8mY\u0016\u001cG/[8o\u0011\u0015)\u0017\u00061\u0001g\u0003%A\u0017n\u001d;pOJ\fW\u000e\u0005\u0002\u0010O&\u0011\u0001\u000e\u0005\u0002\b\u0005>|G.Z1oQ!!\u0017\b\u00116aC\n[\u0017%A3\"\u00031\fae\u0011:fCR,\u0007%\u0019\u0011iSN$xn\u001a:b[\u0002zg\rI1uiJL'-\u001e;fAY\fG.^3t\u0011\u0015q\u0017\u00061\u0001H\u0003\u0011\u0019xN\u001d;)\u00115L\u0004\t\u001d1b\u0005F\f\u0013A\\\u0011\u0002e\u0006A3k\u001c:uAI,7/\u001e7ug\u0002j\u0003%\u00197m_^,G\r\t;pA\t,\u0007%Q*DA=\u0014\b\u0005R#T\u0007\")A/\u000ba\u0001M\u0006Y1o\u001c:u\u0005f\u001cu.\u001e8uQ!\u0019\u0018\b\u0011<aC\n;\u0018%\u0001;\"\u0003a\fAgU8si\u0002\u0012\u0017\u0010\t5jgR|wM]1nA\r|WO\u001c;tA%t7\u000f^3bI\u0002zg\rI1uiJL'-\u001e;fAY\fG.^3t\u0011\u0015Q\u0018\u00061\u0001|\u0003A\u0001(o\\4sKN\u001cH*[:uK:,'\u000f\u0005\u0002}\u007f6\tQP\u0003\u0002\u007f5\u0006!Q\u000f^5m\u0013\r\t\t! \u0002\u0011!J|wM]3tg2K7\u000f^3oKJD\u0013\"KA\u0003\u0001\u0006-!)a\u0004\u0011\u0007i\n9!C\u0002\u0002\nm\u0012a\u0002R3tGJL'-\u001a*fgVdG/\t\u0002\u0002\u000e\u00051!/Z:vYR\f#!!\u0005\u0002\u0003\u001a+\u0017\r^;sK\u0002\u001aw\u000e\u001c7fGRLwN\u001c\u0011xSRD\u0007%\u00198!CR$(/\u001b2vi\u0016\u00043m\u001c8uC&t\u0017N\\4!i\",\u0007%\u001e8jcV,\u0007E^1mk\u0016\u001c\bF\u0003\u0001\u0002\u0016\u0005m\u0011Q\u0004\"\u0002\"A\u0019!(a\u0006\n\u0007\u0005e1HA\bEKN\u001c'/\u001b2f!J|7-Z:t\u0003\u0015!\u0018\u000e\u001e7fC\t\ty\"\u0001\bHK>lWm]1!+:L\u0017/^3\"\u0005\u0005\r\u0012!\u000e$j]\u0012\u001c\b%\u001e8jcV,\u0007%\u0019;ue&\u0014W\u000f^3tAY\fG.^3tY\u0001z\u0007\u000f^5nSj,G\r\t4pe\u0002:Um\\'fg\u0006<q!a\n\u0003\u0011\u0003\tI#A\u0007V]&\fX/\u001a)s_\u000e,7o\u001d\t\u0004Q\u0005-bAB\u0001\u0003\u0011\u0003\tic\u0005\u0003\u0002,\u0005=\u0002cA%\u00022%\u0019\u00111\u0007&\u0003\r\u0005s\u0017PU3g\u0011\u001d)\u00131\u0006C\u0001\u0003o!\"!!\u000b\t\u0015\u0005m\u00121\u0006b\u0001\n\u0003\ti$A\u0004TMRt\u0015-\\3\u0016\u0005\u0005}\u0002cA\b\u0002B%\u0011q\n\u0005\u0005\n\u0003\u000b\nY\u0003)A\u0005\u0003\u007f\t\u0001b\u00154u\u001d\u0006lW\r\t\u0005\u000b\u0003\u0013\nYC1A\u0005\u0002\u0005u\u0012AD!uiJL'-\u001e;f-\u0006dW/\u001a\u0005\n\u0003\u001b\nY\u0003)A\u0005\u0003\u007f\tq\"\u0011;ue&\u0014W\u000f^3WC2,X\r\t\u0005\u000b\u0003#\nYC1A\u0005\u0002\u0005u\u0012AD!uiJL'-\u001e;f\u0007>,h\u000e\u001e\u0005\n\u0003+\nY\u0003)A\u0005\u0003\u007f\tq\"\u0011;ue&\u0014W\u000f^3D_VtG\u000f\t\u0005\t\u00033\nY\u0003\"\u0001\u0002\\\u000512M]3bi\u0016\u0014V\r^;s]\u000e{G\u000e\\3di&|g\u000eF\u0006-\u0003;\n\u0019(a$\u0002\u0016\u0006u\u0005\u0002CA0\u0003/\u0002\r!!\u0019\u0002\u0019Ut\u0017.];f-\u0006dW/Z:\u0011\u000f!\u000b\u0019'a\u001a\u0002n%\u0019\u0011Q\r)\u0003\u00075\u000b\u0007\u000fE\u0002J\u0003SJ1!a\u001bK\u0005\r\te.\u001f\t\u0004\u0013\u0006=\u0014bAA9\u0015\n!Aj\u001c8h\u0011!\t)(a\u0016A\u0002\u0005]\u0014a\u00022j]\u0012Lgn\u001a\u0019\u0005\u0003s\n\u0019\tE\u0003I\u0003w\ny(C\u0002\u0002~A\u0013Qa\u00117bgN\u0004B!!!\u0002\u00042\u0001A\u0001DAC\u0003g\n\t\u0011!A\u0003\u0002\u0005\u001d%aA0%cE!\u0011\u0011RA4!\rI\u00151R\u0005\u0004\u0003\u001bS%a\u0002(pi\"Lgn\u001a\u0005\bK\u0006]\u0003\u0019AAI!\rI\u00151S\u0005\u0003Q*CqA\\A,\u0001\u0004\t9\n\u0005\u0003J\u00033;\u0015bAAN\u0015\n1q\n\u001d;j_:Dq\u0001^A,\u0001\u0004\t\t\n\u0003\u0005\u0002\"\u0006-B\u0011AAR\u0003=\u0019'/Z1uKVs\u0017.];f'\u001a$HCBAS\u0003g\u000by\f\u0005\u0003\u0002(\u0006=VBAAU\u0015\ry\u00131\u0016\u0006\u0004\u0003[S\u0016a\u00024fCR,(/Z\u0005\u0005\u0003c\u000bIKA\tTS6\u0004H.\u001a$fCR,(/\u001a+za\u0016D\u0001\"!\u001e\u0002 \u0002\u0007\u0011Q\u0017\u0019\u0005\u0003o\u000bY\fE\u0003I\u0003w\nI\f\u0005\u0003\u0002\u0002\u0006mF\u0001DA_\u0003g\u000b\t\u0011!A\u0003\u0002\u0005\u001d%aA0%e!9Q-a(A\u0002\u0005E\u0005")
public class UniqueProcess
implements GeoMesaProcess,
LazyLogging {
    private final Logger logger;
    private volatile boolean bitmap$0;

    public static SimpleFeatureType createUniqueSft(Class<?> clazz, boolean bl) {
        return UniqueProcess$.MODULE$.createUniqueSft(clazz, bl);
    }

    public static SimpleFeatureCollection createReturnCollection(Map<Object, Object> map, Class<?> clazz, boolean bl, Option<String> option, boolean bl2) {
        return UniqueProcess$.MODULE$.createReturnCollection(map, clazz, bl, option, bl2);
    }

    public static String AttributeCount() {
        return UniqueProcess$.MODULE$.AttributeCount();
    }

    public static String AttributeValue() {
        return UniqueProcess$.MODULE$.AttributeValue();
    }

    public static String SftName() {
        return UniqueProcess$.MODULE$.SftName();
    }

    private Logger logger$lzycompute() {
        UniqueProcess uniqueProcess = this;
        synchronized (uniqueProcess) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @DescribeResult(name="result", description="Feature collection with an attribute containing the unique values")
    public SimpleFeatureCollection execute(@DescribeParameter(name="features", description="Input feature collection") SimpleFeatureCollection features, @DescribeParameter(name="attribute", description="Attribute whose unique values are extracted") String attribute, @DescribeParameter(name="filter", min=0, description="The filter to apply to the feature collection") Filter filter, @DescribeParameter(name="histogram", min=0, description="Create a histogram of attribute values") Boolean histogram, @DescribeParameter(name="sort", min=0, description="Sort results - allowed to be ASC or DESC") String sort, @DescribeParameter(name="sortByCount", min=0, description="Sort by histogram counts instead of attribute values") Boolean sortByCount, ProgressListener progressListener) {
        AttributeDescriptor attributeDescriptor = (AttributeDescriptor)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((SimpleFeatureType)features.getSchema()).getAttributeDescriptors()).asScala()).find((Function1)new Serializable(this, attribute){
            public static final long serialVersionUID = 0L;
            private final String attribute$1;

            public final boolean apply(AttributeDescriptor x$1) {
                String string = x$1.getLocalName();
                String string2 = this.attribute$1;
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.attribute$1 = attribute$1;
            }
        }).getOrElse((Function0)new Serializable(this, attribute){
            public static final long serialVersionUID = 0L;
            private final String attribute$1;

            public final Nothing$ apply() {
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attribute ", " does not exist in feature schema."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.attribute$1})));
            }
            {
                this.attribute$1 = attribute$1;
            }
        });
        boolean hist = Option$.MODULE$.apply((Object)histogram).exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Boolean x$2) {
                return x$2;
            }
        });
        boolean sortBy = Option$.MODULE$.apply((Object)sortByCount).exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Boolean x$3) {
                return x$3;
            }
        });
        AttributeVisitor visitor = new AttributeVisitor(features, attributeDescriptor, (Option<Filter>)Option$.MODULE$.apply((Object)filter).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Filter x$4) {
                Filter filter = x$4;
                IncludeFilter includeFilter = Filter.INCLUDE;
                return filter != null ? !filter.equals(includeFilter) : includeFilter != null;
            }
        }), hist);
        GeoMesaFeatureCollection$.MODULE$.visit((FeatureCollection)features, (FeatureVisitor)visitor, progressListener);
        Map<Object, Object> uniqueValues = visitor.getResult().attributes();
        Class binding = attributeDescriptor.getType().getBinding();
        return UniqueProcess$.MODULE$.createReturnCollection(uniqueValues, binding, hist, (Option<String>)Option$.MODULE$.apply((Object)sort), sortBy);
    }

    public UniqueProcess() {
        LazyLogging.class.$init$((LazyLogging)this);
    }
}

