/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.process.knn;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.locationtech.geomesa.filter.package$;
import org.locationtech.geomesa.process.knn.GeoHashSpiral;
import org.locationtech.geomesa.process.knn.GeoHashSpiral$;
import org.locationtech.geomesa.process.knn.NearestNeighbors;
import org.locationtech.geomesa.process.knn.NearestNeighbors$;
import org.locationtech.geomesa.process.knn.SimpleFeatureWithDistance;
import org.locationtech.geomesa.utils.collection.SelfClosingIterator;
import org.locationtech.geomesa.utils.collection.SelfClosingIterator$;
import org.locationtech.geomesa.utils.geohash.BoundingBox$;
import org.locationtech.geomesa.utils.geohash.GeoHash;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.BBOX;
import org.opengis.geometry.BoundingBox;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.VolatileByteRef;

public final class KNNQuery$
implements LazyLogging {
    public static final KNNQuery$ MODULE$;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new KNNQuery$();
    }

    private Logger logger$lzycompute() {
        KNNQuery$ kNNQuery$ = this;
        synchronized (kNNQuery$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public NearestNeighbors runNewKNNQuery(SimpleFeatureSource source, Query query, int numDesired, double searchDistanceInMeters, double maxDistanceInMeters, SimpleFeature aFeatureForSearch) {
        GeoHashSpiral geoHashPQ = GeoHashSpiral$.MODULE$.apply(aFeatureForSearch, searchDistanceInMeters, maxDistanceInMeters);
        NearestNeighbors sfPQ = NearestNeighbors$.MODULE$.apply(aFeatureForSearch, numDesired);
        return this.runKNNQuery(source, query, geoHashPQ, sfPQ);
    }

    public NearestNeighbors runKNNQuery(SimpleFeatureSource source, Query query, GeoHashSpiral ghPQ, NearestNeighbors sfPQ) {
        while (true) {
            BoxedUnit boxedUnit;
            VolatileByteRef bitmap$0 = VolatileByteRef.create((byte)0);
            if (!ghPQ.hasNext()) break;
            ObjectRef subQueryInfo$lzy = ObjectRef.zero();
            GeoHash newGH = ghPQ.next();
            Query newQuery = this.generateKNNQuery(newGH, query, source);
            SelfClosingIterator newFeatures = SelfClosingIterator$.MODULE$.apply(source.getFeatures(newQuery).features());
            newFeatures.foreach((Function1)new Serializable(sfPQ){
                public static final long serialVersionUID = 0L;
                private final NearestNeighbors sfPQ$1;

                public final void apply(SimpleFeature sf) {
                    this.sfPQ$1.add(new SimpleFeatureWithDistance(sf, this.sfPQ$1.distance(sf)));
                }
                {
                    this.sfPQ$1 = sfPQ$1;
                }
            });
            if (sfPQ.isFull()) {
                sfPQ.maxDistance().foreach((Function1)new Serializable(ghPQ){
                    public static final long serialVersionUID = 0L;
                    private final GeoHashSpiral ghPQ$1;

                    public final void apply(double x) {
                        this.apply$mcVD$sp(x);
                    }

                    public void apply$mcVD$sp(double x) {
                        this.ghPQ$1.mutateFilterDistance(x);
                    }
                    {
                        this.ghPQ$1 = ghPQ$1;
                    }
                });
            }
            if (this.logger().underlying().isTraceEnabled()) {
                this.logger().underlying().trace("KNN Status: Completed subQuery: (hash,distance, PQ size) = {} ", new Object[]{this.subQueryInfo$1(sfPQ, newGH, subQueryInfo$lzy, bitmap$0)});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            sfPQ = sfPQ.getKNN();
        }
        return sfPQ;
    }

    public Query generateKNNQuery(GeoHash gh, Query oldQuery, SimpleFeatureSource source) {
        PropertyName geomProp = package$.MODULE$.ff().property(source.getSchema().getGeometryDescriptor().getName());
        ReferencedEnvelope newGHEnv = new ReferencedEnvelope(BoundingBox$.MODULE$.toEnvelope(gh.bbox()), oldQuery.getCoordinateSystem());
        BBOX newGHFilter = package$.MODULE$.ff().bbox((Expression)geomProp, (BoundingBox)newGHEnv);
        Query newQuery = new Query(oldQuery);
        newQuery.setFilter((Filter)package$.MODULE$.ff().and((Filter)newGHFilter, oldQuery.getFilter()));
        return newQuery;
    }

    private final String subQueryInfo$lzycompute$1(NearestNeighbors sfPQ$1, GeoHash newGH$1, ObjectRef subQueryInfo$lzy$1, VolatileByteRef bitmap$0$1) {
        KNNQuery$ kNNQuery$ = this;
        synchronized (kNNQuery$) {
            if ((byte)(bitmap$0$1.elem & 1) == 0) {
                subQueryInfo$lzy$1.elem = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ", ", ", ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{newGH$1.hash(), sfPQ$1.maxDistance().getOrElse((Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final double apply() {
                        return this.apply$mcD$sp();
                    }

                    public double apply$mcD$sp() {
                        return 0.0;
                    }
                }), BoxesRunTime.boxToInteger((int)sfPQ$1.size())}));
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
            }
            return (String)subQueryInfo$lzy$1.elem;
        }
    }

    private final String subQueryInfo$1(NearestNeighbors sfPQ$1, GeoHash newGH$1, ObjectRef subQueryInfo$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 1) == 0 ? this.subQueryInfo$lzycompute$1(sfPQ$1, newGH$1, subQueryInfo$lzy$1, bitmap$0$1) : (String)subQueryInfo$lzy$1.elem;
    }

    private KNNQuery$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
    }
}

