/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.visitor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.geotools.feature.visitor.Aggregate;
import org.geotools.feature.visitor.CalcResult;
import org.geotools.feature.visitor.FeatureAttributeVisitor;
import org.geotools.feature.visitor.FeatureCalc;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.expression.Expression;
import org.opengis.util.ProgressListener;

public class GroupByVisitor
implements FeatureCalc,
FeatureAttributeVisitor {
    private final Aggregate aggregate;
    private final Expression expression;
    private final FeatureCalc visitorProtoType;
    private final List<Expression> groupByAttributes;
    private final ProgressListener progressListener;
    private final InMemoryGroupBy inMemoryGroupBy = new InMemoryGroupBy();
    private CalcResult optimizationResult = CalcResult.NULL_RESULT;

    public GroupByVisitor(Aggregate aggregateVisitor, Expression expression, List<Expression> groupByAttributes, ProgressListener progressListener) {
        this.aggregate = aggregateVisitor;
        this.expression = expression;
        this.groupByAttributes = groupByAttributes;
        this.progressListener = progressListener;
        this.visitorProtoType = aggregateVisitor.create(expression);
    }

    public boolean wasOptimized() {
        return this.optimizationResult != null && this.optimizationResult != CalcResult.NULL_RESULT;
    }

    public boolean wasVisited() {
        return !this.inMemoryGroupBy.groupByIndexes.isEmpty();
    }

    @Override
    public CalcResult getResult() {
        Map<List<Object>, CalcResult> results = this.inMemoryGroupBy.visit();
        GroupByResult result = new GroupByResult(results, this.aggregate, this.groupByAttributes);
        if (this.optimizationResult == CalcResult.NULL_RESULT) {
            return result;
        }
        return this.optimizationResult.merge(result);
    }

    public void visit(Feature feature) {
        this.inMemoryGroupBy.index((SimpleFeature)feature);
    }

    public Expression getExpression() {
        return this.expression;
    }

    public FeatureVisitor getAggregateVisitor() {
        return this.visitorProtoType;
    }

    public List<Expression> getGroupByAttributes() {
        return this.groupByAttributes;
    }

    public void setValue(List<GroupByRawResult> value) {
        HashMap<List<Object>, CalcResult> results = new HashMap<List<Object>, CalcResult>();
        for (GroupByRawResult groupByRawResult : value) {
            results.put(groupByRawResult.groupByValues, this.aggregate.wrap(this.expression, groupByRawResult.visitorValue));
        }
        GroupByResult newResult = new GroupByResult(results, this.aggregate, this.groupByAttributes);
        this.optimizationResult = this.optimizationResult == CalcResult.NULL_RESULT ? newResult : this.optimizationResult.merge(newResult);
    }

    @Override
    public List<Expression> getExpressions() {
        ArrayList<Expression> result = new ArrayList<Expression>(this.groupByAttributes);
        result.add(this.expression);
        return result;
    }

    public static class GroupByResult
    implements CalcResult {
        private final Map<List<Object>, CalcResult> results;
        private final Aggregate aggregateVisitor;
        private final List<Expression> groupByAttributes;

        public GroupByResult(Map<List<Object>, CalcResult> results, Aggregate aggregateVisitor, List<Expression> groupByAttributes) {
            this.results = results;
            this.aggregateVisitor = aggregateVisitor;
            this.groupByAttributes = groupByAttributes;
        }

        public Map<List<Object>, CalcResult> getResults() {
            return this.results;
        }

        public Aggregate getAggregateVisitor() {
            return this.aggregateVisitor;
        }

        public List<Expression> getGroupByAttributes() {
            return this.groupByAttributes;
        }

        @Override
        public boolean isCompatible(CalcResult newResult) {
            if (newResult == CalcResult.NULL_RESULT) {
                return true;
            }
            if (!(newResult instanceof GroupByResult)) {
                return false;
            }
            GroupByResult groupByResult = (GroupByResult)newResult;
            return this.aggregateVisitor == groupByResult.getAggregateVisitor() && this.groupByAttributes.equals(groupByResult.getGroupByAttributes());
        }

        @Override
        public CalcResult merge(CalcResult newResult) {
            if (!this.isCompatible(newResult)) {
                throw new IllegalArgumentException(String.format("Feature calculation result '%s' is not compatible it this result '%s'.", newResult.getClass().getSimpleName(), GroupByResult.class.getSimpleName()));
            }
            if (newResult == CalcResult.NULL_RESULT) {
                return new GroupByResult(this.results, this.aggregateVisitor, this.groupByAttributes);
            }
            HashMap<List<Object>, CalcResult> mergedResults = new HashMap<List<Object>, CalcResult>(this.results);
            for (Map.Entry<List<Object>, CalcResult> entry : ((GroupByResult)newResult).getResults().entrySet()) {
                CalcResult existingResult = (CalcResult)mergedResults.get(entry.getKey());
                if (existingResult != null) {
                    mergedResults.put(entry.getKey(), existingResult.merge(entry.getValue()));
                    continue;
                }
                mergedResults.put(entry.getKey(), entry.getValue());
            }
            return new GroupByResult(mergedResults, this.aggregateVisitor, this.groupByAttributes);
        }

        @Override
        public Object getValue() {
            return this.toArray();
        }

        @Override
        public int toInt() {
            return 0;
        }

        @Override
        public double toDouble() {
            return 0.0;
        }

        @Override
        public String toString() {
            return null;
        }

        @Override
        public long toLong() {
            return 0L;
        }

        @Override
        public float toFloat() {
            return 0.0f;
        }

        @Override
        public Geometry toGeometry() {
            return null;
        }

        @Override
        public Envelope toEnvelope() {
            return null;
        }

        @Override
        public Point toPoint() {
            return null;
        }

        @Override
        public Set toSet() {
            return this.results.entrySet().stream().map(this::entryToArray).collect(Collectors.toSet());
        }

        @Override
        public List toList() {
            return this.results.entrySet().stream().map(this::entryToArray).collect(Collectors.toList());
        }

        @Override
        public Object[] toArray() {
            return this.results.entrySet().stream().map(this::entryToArray).toArray();
        }

        @Override
        public Map toMap() {
            HashMap<List<Object>, Object> result = new HashMap<List<Object>, Object>();
            for (Map.Entry<List<Object>, CalcResult> item : this.results.entrySet()) {
                result.put(item.getKey(), item.getValue().getValue());
            }
            return result;
        }

        private Object[] entryToArray(Map.Entry<List<Object>, CalcResult> entry) {
            Object[] result = Arrays.copyOf(entry.getKey().toArray(), entry.getKey().size() + 1);
            result[entry.getKey().size()] = entry.getValue().getValue();
            return result;
        }
    }

    private class InMemoryGroupBy {
        private final Map<List<Object>, FeatureCalc> groupByIndexes = new HashMap<List<Object>, FeatureCalc>();

        private InMemoryGroupBy() {
        }

        void index(SimpleFeature feature) {
            List groupByValues = GroupByVisitor.this.groupByAttributes.stream().map(expression -> expression.evaluate((Object)feature)).collect(Collectors.toList());
            FeatureCalc calc = this.groupByIndexes.get(groupByValues);
            if (calc == null) {
                calc = GroupByVisitor.this.aggregate.create(GroupByVisitor.this.expression);
                this.groupByIndexes.put(groupByValues, calc);
            }
            calc.visit((Feature)feature);
        }

        Map<List<Object>, CalcResult> visit() {
            HashMap<List<Object>, CalcResult> results = new HashMap<List<Object>, CalcResult>();
            for (Map.Entry<List<Object>, FeatureCalc> entry : this.groupByIndexes.entrySet()) {
                results.put(entry.getKey(), entry.getValue().getResult());
            }
            return results;
        }
    }

    public static class GroupByRawResult {
        final List<Object> groupByValues;
        final Object visitorValue;

        public GroupByRawResult(List<Object> groupByValues, Object visitorsValue) {
            this.groupByValues = groupByValues;
            this.visitorValue = visitorsValue;
        }
    }
}

