/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.CardinalityCheckingIterator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.LazySequence;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;

public abstract class TreatFn
extends SystemFunction
implements Callable {
    public abstract String getErrorCodeForTypeErrors();

    public abstract int getRequiredCardinality();

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        SequenceIterator iterator = arguments[0].iterate();
        int card = this.getRequiredCardinality();
        RoleDiagnostic role = this.makeRoleDiagnostic();
        iterator = new CardinalityCheckingIterator(iterator, card, role, null);
        return new LazySequence(iterator);
    }

    public RoleDiagnostic makeRoleDiagnostic() {
        RoleDiagnostic role = new RoleDiagnostic(0, this.getFunctionName().getDisplayName(), 0);
        role.setErrorCode(this.getErrorCodeForTypeErrors());
        return role;
    }

    public static class ZeroOrOne
    extends TreatFn {
        public int getRequiredCardinality() {
            return 24576;
        }

        public String getErrorCodeForTypeErrors() {
            return "FORG0003";
        }
    }

    public static class OneOrMore
    extends TreatFn {
        public int getRequiredCardinality() {
            return 49152;
        }

        public String getErrorCodeForTypeErrors() {
            return "FORG0004";
        }
    }

    public static class ExactlyOne
    extends TreatFn {
        public int getRequiredCardinality() {
            return 16384;
        }

        public String getErrorCodeForTypeErrors() {
            return "FORG0005";
        }
    }
}

