/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.filters;

import org.locationtech.geomesa.index.filters.Z3Filter$;
import org.locationtech.geomesa.index.index.z3.package;
import org.locationtech.geomesa.utils.index.ByteArrays$;
import org.locationtech.sfcurve.zorder.Z3$;
import scala.Function1;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.TraversableOnce;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005e\u0001B\u0001\u0003\u00015\u0011\u0001BW\u001aGS2$XM\u001d\u0006\u0003\u0007\u0011\tqAZ5mi\u0016\u00148O\u0003\u0002\u0006\r\u0005)\u0011N\u001c3fq*\u0011q\u0001C\u0001\bO\u0016|W.Z:b\u0015\tI!\"\u0001\u0007m_\u000e\fG/[8oi\u0016\u001c\u0007NC\u0001\f\u0003\ry'oZ\u0002\u0001'\t\u0001a\u0002\u0005\u0002\u0010%5\t\u0001CC\u0001\u0012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0002C\u0001\u0004B]f\u0014VM\u001a\u0005\t+\u0001\u0011)\u0019!C\u0001-\u0005\u0011\u00010_\u000b\u0002/A\u0019q\u0002\u0007\u000e\n\u0005e\u0001\"!B!se\u0006L\bcA\b\u00197A\u0011q\u0002H\u0005\u0003;A\u00111!\u00138u\u0011!y\u0002A!A!\u0002\u00139\u0012a\u0001=zA!A\u0011\u0005\u0001BC\u0002\u0013\u0005!%A\u0001u+\u0005\u0019\u0003cA\b\u0019/!AQ\u0005\u0001B\u0001B\u0003%1%\u0001\u0002uA!Aq\u0005\u0001BC\u0002\u0013\u0005\u0001&\u0001\u0005nS:,\u0005o\\2i+\u0005I\u0003CA\b+\u0013\tY\u0003CA\u0003TQ>\u0014H\u000f\u0003\u0005.\u0001\t\u0005\t\u0015!\u0003*\u0003%i\u0017N\\#q_\u000eD\u0007\u0005\u0003\u00050\u0001\t\u0015\r\u0011\"\u0001)\u0003!i\u0017\r_#q_\u000eD\u0007\u0002C\u0019\u0001\u0005\u0003\u0005\u000b\u0011B\u0015\u0002\u00135\f\u00070\u00129pG\"\u0004\u0003\"B\u001a\u0001\t\u0003!\u0014A\u0002\u001fj]&$h\bF\u00036oaJ$\b\u0005\u00027\u00015\t!\u0001C\u0003\u0016e\u0001\u0007q\u0003C\u0003\"e\u0001\u00071\u0005C\u0003(e\u0001\u0007\u0011\u0006C\u00030e\u0001\u0007\u0011\u0006C\u0003=\u0001\u0011\u0005Q(\u0001\u0005j]\n{WO\u001c3t)\rq\u0014i\u0012\t\u0003\u001f}J!\u0001\u0011\t\u0003\u000f\t{w\u000e\\3b]\")!i\u000fa\u0001\u0007\u0006\u0019!-\u001e4\u0011\u0007=AB\t\u0005\u0002\u0010\u000b&\u0011a\t\u0005\u0002\u0005\u0005f$X\rC\u0003Iw\u0001\u00071$\u0001\u0004pM\u001a\u001cX\r\u001e\u0005\u0006\u0015\u0002!IaS\u0001\u000ea>Lg\u000e^%o\u0005>,h\u000eZ:\u0015\u0005yb\u0005\"B'J\u0001\u0004q\u0015!\u0001>\u0011\u0005=y\u0015B\u0001)\u0011\u0005\u0011auN\\4\t\u000bI\u0003A\u0011B*\u0002\u0019QLW.Z%o\u0005>,h\u000eZ:\u0015\u0007y\"f\u000bC\u0003V#\u0002\u0007\u0011&A\u0003fa>\u001c\u0007\u000eC\u0003N#\u0002\u0007a\nC\u0003Y\u0001\u0011\u0005\u0013,\u0001\u0005u_N#(/\u001b8h)\u0005Q\u0006CA._\u001d\tyA,\u0003\u0002^!\u00051\u0001K]3eK\u001aL!a\u00181\u0003\rM#(/\u001b8h\u0015\ti\u0006cB\u0003c\u0005!\u00051-\u0001\u0005[g\u0019KG\u000e^3s!\t1DMB\u0003\u0002\u0005!\u0005Qm\u0005\u0002e\u001d!)1\u0007\u001aC\u0001OR\t1\rC\u0004jI\n\u0007I\u0011\u00026\u0002\u001dI\u000bgnZ3TKB\f'/\u0019;peV\t1\u000e\u0005\u0002mc6\tQN\u0003\u0002o_\u0006!A.\u00198h\u0015\u0005\u0001\u0018\u0001\u00026bm\u0006L!aX7\t\rM$\u0007\u0015!\u0003l\u0003=\u0011\u0016M\\4f'\u0016\u0004\u0018M]1u_J\u0004\u0003bB;e\u0005\u0004%IA[\u0001\u000e)\u0016\u0014XnU3qCJ\fGo\u001c:\t\r]$\u0007\u0015!\u0003l\u00039!VM]7TKB\f'/\u0019;pe\u0002Bq!\u001f3C\u0002\u0013%!.\u0001\bFa>\u001c\u0007nU3qCJ\fGo\u001c:\t\rm$\u0007\u0015!\u0003l\u0003=)\u0005o\\2i'\u0016\u0004\u0018M]1u_J\u0004\u0003bB?e\u0005\u0004%\tA[\u0001\u00061f[U-\u001f\u0005\u0007\u007f\u0012\u0004\u000b\u0011B6\u0002\raK6*Z=!\u0011!\t\u0019\u0001\u001ab\u0001\n\u0003Q\u0017\u0001\u0002+LKfDq!a\u0002eA\u0003%1.A\u0003U\u0017\u0016L\b\u0005\u0003\u0005\u0002\f\u0011\u0014\r\u0011\"\u0001k\u0003!)\u0005o\\2i\u0017\u0016L\bbBA\bI\u0002\u0006Ia[\u0001\n\u000bB|7\r[&fs\u0002Bq!a\u0005e\t\u0003\t)\"A\u0003baBd\u0017\u0010F\u00026\u0003/A\u0001\"!\u0007\u0002\u0012\u0001\u0007\u00111D\u0001\u0007m\u0006dW/Z:\u0011\t\u0005u\u0011q\t\b\u0005\u0003?\t\tE\u0004\u0003\u0002\"\u0005mb\u0002BA\u0012\u0003sqA!!\n\u000289!\u0011qEA\u001b\u001d\u0011\tI#a\r\u000f\t\u0005-\u0012\u0011G\u0007\u0003\u0003[Q1!a\f\r\u0003\u0019a$o\\8u}%\t1\"\u0003\u0002\n\u0015%\u0011q\u0001C\u0005\u0003\u000b\u0019I!!\u0002\u0003\n\t\u0005u\u0012qH\u0001\u0003uNR!!\u0002\u0003\n\t\u0005\r\u0013QI\u0001\ba\u0006\u001c7.Y4f\u0015\u0011\ti$a\u0010\n\t\u0005%\u00131\n\u0002\u000e5NJe\u000eZ3y-\u0006dW/Z:\u000b\t\u0005\r\u0013Q\t\u0005\b\u0003\u001f\"G\u0011AA)\u0003A\u0019XM]5bY&TX\rV8CsR,7\u000fF\u0002D\u0003'Bq!!\u0016\u0002N\u0001\u0007Q'\u0001\u0004gS2$XM\u001d\u0005\b\u00033\"G\u0011AA.\u0003Q!Wm]3sS\u0006d\u0017N_3Ge>l')\u001f;fgR\u0019Q'!\u0018\t\u000f\u0005}\u0013q\u000ba\u0001\u0007\u0006Q1/\u001a:jC2L'0\u001a3\t\u000f\u0005\rD\r\"\u0001\u0002f\u0005\u00112/\u001a:jC2L'0\u001a+p'R\u0014\u0018N\\4t)\u0011\t9'!\u001c\u0011\u000bm\u000bIG\u0017.\n\u0007\u0005-\u0004MA\u0002NCBDq!!\u0016\u0002b\u0001\u0007Q\u0007C\u0004\u0002r\u0011$\t!a\u001d\u0002-\u0011,7/\u001a:jC2L'0\u001a$s_6\u001cFO]5oON$2!NA;\u0011!\ty&a\u001cA\u0002\u0005]\u0004CBA=\u0003\u007fR&,\u0004\u0002\u0002|)\u0019\u0011Q\u0010\t\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002l\u0005m\u0004")
public class Z3Filter {
    private final int[][] xy;
    private final int[][][] t;
    private final short minEpoch;
    private final short maxEpoch;

    public static Z3Filter deserializeFromStrings(Map<String, String> map) {
        return Z3Filter$.MODULE$.deserializeFromStrings(map);
    }

    public static scala.collection.immutable.Map<String, String> serializeToStrings(Z3Filter z3Filter) {
        return Z3Filter$.MODULE$.serializeToStrings(z3Filter);
    }

    public static Z3Filter deserializeFromBytes(byte[] byArray) {
        return Z3Filter$.MODULE$.deserializeFromBytes(byArray);
    }

    public static byte[] serializeToBytes(Z3Filter z3Filter) {
        return Z3Filter$.MODULE$.serializeToBytes(z3Filter);
    }

    public static Z3Filter apply(package.Z3IndexValues z3IndexValues) {
        return Z3Filter$.MODULE$.apply(z3IndexValues);
    }

    public static String EpochKey() {
        return Z3Filter$.MODULE$.EpochKey();
    }

    public static String TKey() {
        return Z3Filter$.MODULE$.TKey();
    }

    public static String XYKey() {
        return Z3Filter$.MODULE$.XYKey();
    }

    public int[][] xy() {
        return this.xy;
    }

    public int[][][] t() {
        return this.t;
    }

    public short minEpoch() {
        return this.minEpoch;
    }

    public short maxEpoch() {
        return this.maxEpoch;
    }

    public boolean inBounds(byte[] buf, int offset) {
        long keyZ = ByteArrays$.MODULE$.readLong(buf, offset + 2);
        return this.pointInBounds(keyZ) && this.timeInBounds(ByteArrays$.MODULE$.readShort(buf, offset), keyZ);
    }

    private boolean pointInBounds(long z) {
        int x = Z3$.MODULE$.d0$extension(Z3$.MODULE$.apply(z));
        int y = Z3$.MODULE$.d1$extension(Z3$.MODULE$.apply(z));
        for (int i = 0; i < this.xy().length; ++i) {
            int[] xyi = this.xy()[i];
            if (x < xyi[0] || x > xyi[2] || y < xyi[1] || y > xyi[3]) continue;
            return true;
        }
        return false;
    }

    private boolean timeInBounds(short epoch, long z) {
        boolean bl;
        if (epoch > this.maxEpoch() || epoch < this.minEpoch()) {
            bl = true;
        } else {
            int[][] tEpoch = this.t()[epoch - this.minEpoch()];
            if (tEpoch == null) {
                bl = true;
            } else {
                int time = Z3$.MODULE$.d2$extension(Z3$.MODULE$.apply(z));
                for (int i = 0; i < tEpoch.length; ++i) {
                    int[] ti = tEpoch[i];
                    if (time < ti[0] || time > ti[1]) continue;
                    return true;
                }
                bl = false;
            }
        }
        return bl;
    }

    public String toString() {
        return ((TraversableOnce)Z3Filter$.MODULE$.serializeToStrings(this).toSeq().sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, String> x$1) {
                return (String)x$1._1();
            }
        }, (Ordering)Ordering.String$.MODULE$)).mkString(",");
    }

    public Z3Filter(int[][] xy, int[][][] t, short minEpoch, short maxEpoch) {
        this.xy = xy;
        this.t = t;
        this.minEpoch = minEpoch;
        this.maxEpoch = maxEpoch;
    }
}

