/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.index.z3;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.time.ZonedDateTime;
import java.util.Date;
import org.geotools.factory.Hints;
import org.locationtech.geomesa.curve.BinnedTime;
import org.locationtech.geomesa.curve.BinnedTime$;
import org.locationtech.geomesa.curve.LegacyYearXZ3SFC;
import org.locationtech.geomesa.curve.TimePeriod$;
import org.locationtech.geomesa.curve.XZ3SFC;
import org.locationtech.geomesa.curve.XZ3SFC$;
import org.locationtech.geomesa.filter.Bounds;
import org.locationtech.geomesa.filter.FilterHelper$;
import org.locationtech.geomesa.filter.FilterValues;
import org.locationtech.geomesa.filter.FilterValues$;
import org.locationtech.geomesa.index.api.IndexKeySpace;
import org.locationtech.geomesa.index.api.IndexKeySpace$class;
import org.locationtech.geomesa.index.api.ShardStrategy;
import org.locationtech.geomesa.index.api.WritableFeature;
import org.locationtech.geomesa.index.api.package;
import org.locationtech.geomesa.index.api.package$ByteRange$;
import org.locationtech.geomesa.index.conf.QueryProperties$;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStoreFactory;
import org.locationtech.geomesa.index.index.z3.XZ3IndexKeySpace$;
import org.locationtech.geomesa.index.index.z3.package;
import org.locationtech.geomesa.index.utils.Explainer;
import org.locationtech.geomesa.utils.geotools.GeometryUtils$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.index.ByteArrays$;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.sfcurve.IndexRange;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple4;
import scala.Tuple6;
import scala.collection.GenTraversable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.VolatileByteRef;
import scala.util.Right;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\tMe\u0001B\u0001\u0003\u00019\u0011\u0001\u0003\u0017.4\u0013:$W\r_&fsN\u0003\u0018mY3\u000b\u0005\r!\u0011A\u0001>4\u0015\t)a!A\u0003j]\u0012,\u0007P\u0003\u0002\u0006\u000f)\u0011\u0001\"C\u0001\bO\u0016|W.Z:b\u0015\tQ1\"\u0001\u0007m_\u000e\fG/[8oi\u0016\u001c\u0007NC\u0001\r\u0003\ry'oZ\u0002\u0001'\u0011\u0001q\"\u0006\u0014\u0011\u0005A\u0019R\"A\t\u000b\u0003I\tQa]2bY\u0006L!\u0001F\t\u0003\r\u0005s\u0017PU3g!\u00111\u0012dG\u0012\u000e\u0003]Q!\u0001\u0007\u0004\u0002\u0007\u0005\u0004\u0018.\u0003\u0002\u001b/\ti\u0011J\u001c3fq.+\u0017p\u00159bG\u0016\u0004\"\u0001\b\u0011\u000f\u0005uqR\"\u0001\u0002\n\u0005}\u0011\u0011a\u00029bG.\fw-Z\u0005\u0003C\t\u0012a\u0002\u0017.4\u0013:$W\r\u001f,bYV,7O\u0003\u0002 \u0005A\u0011A\u0004J\u0005\u0003K\t\u0012!BW\u001aJ]\u0012,\u0007pS3z!\t9c&D\u0001)\u0015\tI#&\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u0002,Y\u0005AA/\u001f9fg\u00064WMC\u0001.\u0003\r\u0019w.\\\u0005\u0003_!\u00121\u0002T1{s2{wmZ5oO\"A\u0011\u0007\u0001BC\u0002\u0013\u0005!'A\u0002tMR,\u0012a\r\t\u0003imj\u0011!\u000e\u0006\u0003m]\naa]5na2,'B\u0001\u001d:\u0003\u001d1W-\u0019;ve\u0016T!AO\u0006\u0002\u000f=\u0004XM\\4jg&\u0011A(\u000e\u0002\u0012'&l\u0007\u000f\\3GK\u0006$XO]3UsB,\u0007\u0002\u0003 \u0001\u0005\u0003\u0005\u000b\u0011B\u001a\u0002\tM4G\u000f\t\u0005\t\u0001\u0002\u0011)\u0019!C\u0001\u0003\u0006A1\u000f[1sI&tw-F\u0001C!\t12)\u0003\u0002E/\ti1\u000b[1sIN#(/\u0019;fOfD\u0001B\u0012\u0001\u0003\u0002\u0003\u0006IAQ\u0001\ng\"\f'\u000fZ5oO\u0002B\u0001\u0002\u0013\u0001\u0003\u0002\u0003\u0006I!S\u0001\nO\u0016|WNR5fY\u0012\u0004\"AS'\u000f\u0005AY\u0015B\u0001'\u0012\u0003\u0019\u0001&/\u001a3fM&\u0011aj\u0014\u0002\u0007'R\u0014\u0018N\\4\u000b\u00051\u000b\u0002\u0002C)\u0001\u0005\u0003\u0005\u000b\u0011B%\u0002\u0011\u0011$xMR5fY\u0012DQa\u0015\u0001\u0005\u0002Q\u000ba\u0001P5oSRtD#B+W/bK\u0006CA\u000f\u0001\u0011\u0015\t$\u000b1\u00014\u0011\u0015\u0001%\u000b1\u0001C\u0011\u0015A%\u000b1\u0001J\u0011\u0015\t&\u000b1\u0001J\u0011\u001dY\u0006A1A\u0005\u0012q\u000b\u0011bZ3p[&sG-\u001a=\u0016\u0003u\u0003\"\u0001\u00050\n\u0005}\u000b\"aA%oi\"1\u0011\r\u0001Q\u0001\nu\u000b!bZ3p[&sG-\u001a=!\u0011\u001d\u0019\u0007A1A\u0005\u0012q\u000b\u0001\u0002\u001a;h\u0013:$W\r\u001f\u0005\u0007K\u0002\u0001\u000b\u0011B/\u0002\u0013\u0011$x-\u00138eKb\u0004\u0003bB4\u0001\u0005\u0004%\t\u0002[\u0001\u0004g\u001a\u001cW#A5\u0011\u0005)lW\"A6\u000b\u00051<\u0011!B2veZ,\u0017B\u00018l\u0005\u0019A&lM*G\u0007\"1\u0001\u000f\u0001Q\u0001\n%\fAa\u001d4dA!9!\u000f\u0001b\u0001\n#\u0019\u0018a\u0003;j[\u0016$v.\u00138eKb,\u0012\u0001\u001e\t\u0004k\u0006\u001dab\u0001<\u0002\u00049\u0019q/!\u0001\u000f\u0005a|hBA=\u007f\u001d\tQX0D\u0001|\u0015\taX\"\u0001\u0004=e>|GOP\u0005\u0002\u0019%\u0011!bC\u0005\u0003\u0011%I!\u0001\\\u0004\n\u0007\u0005\u00151.\u0001\u0006CS:tW\r\u001a+j[\u0016LA!!\u0003\u0002\f\t\u0001B+[7f)>\u0014\u0015N\u001c8fIRKW.\u001a\u0006\u0004\u0003\u000bY\u0007bBA\b\u0001\u0001\u0006I\u0001^\u0001\ri&lW\rV8J]\u0012,\u0007\u0010\t\u0005\n\u0003'\u0001!\u0019!C\u0005\u0003+\t1\u0002Z1uKR{\u0017J\u001c3fqV\u0011\u0011q\u0003\t\u0005\u00033\tYBD\u0002k\u0003\u0007IA!!\b\u0002\f\t\u0001B)\u0019;f)>\u0014\u0015N\u001c8fIRKW.\u001a\u0005\t\u0003C\u0001\u0001\u0015!\u0003\u0002\u0018\u0005aA-\u0019;f)>Le\u000eZ3yA!I\u0011Q\u0005\u0001C\u0002\u0013%\u0011qE\u0001\u000eE>,h\u000eZ:U_\u0012\u000bG/Z:\u0016\u0005\u0005%\u0002c\u0002\t\u0002,\u0005=\u00121J\u0005\u0004\u0003[\t\"!\u0003$v]\u000e$\u0018n\u001c82!\u001d\u0001\u0012\u0011GA\u001b\u0003kI1!a\r\u0012\u0005\u0019!V\u000f\u001d7feA)\u0001#a\u000e\u0002<%\u0019\u0011\u0011H\t\u0003\r=\u0003H/[8o!\u0011\ti$a\u0012\u000e\u0005\u0005}\"\u0002BA!\u0003\u0007\nA\u0001^5nK*\u0011\u0011QI\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002J\u0005}\"!\u0004.p]\u0016$G)\u0019;f)&lW\rE\u0004\u0011\u0003c\tY$a\u000f\t\u0011\u0005=\u0003\u0001)A\u0005\u0003S\taBY8v]\u0012\u001cHk\u001c#bi\u0016\u001c\b\u0005C\u0005\u0002T\u0001\u0011\r\u0011\"\u0003\u0002V\u0005A\u0011n\u001d)pS:$8/\u0006\u0002\u0002XA\u0019\u0001#!\u0017\n\u0007\u0005m\u0013CA\u0004C_>dW-\u00198\t\u0011\u0005}\u0003\u0001)A\u0005\u0003/\n\u0011\"[:Q_&tGo\u001d\u0011\t\u0013\u0005\r\u0004A1A\u0005B\u0005\u0015\u0014AC1uiJL'-\u001e;fgV\u0011\u0011q\r\t\u0006\u0003S\n\t(\u0013\b\u0005\u0003W\nyGD\u0002{\u0003[J\u0011AE\u0005\u0003?EIA!a\u001d\u0002v\t\u00191+Z9\u000b\u0005}\t\u0002\u0002CA=\u0001\u0001\u0006I!a\u001a\u0002\u0017\u0005$HO]5ckR,7\u000f\t\u0005\n\u0003{\u0002!\u0019!C!\u0003\u007f\n!#\u001b8eKb\\U-\u001f\"zi\u0016dUM\\4uQV\u0011\u0011\u0011\u0011\t\b\u0003S\n\u0019)a\"^\u0013\u0011\t))!\u001e\u0003\u000bIKw\r\u001b;\u0011\u0011A\tI)!$^;vK1!a#\u0012\u0005%1UO\\2uS>t7\u0007E\u0003\u0011\u0003\u001f\u000b\u0019*C\u0002\u0002\u0012F\u0011Q!\u0011:sCf\u00042\u0001EAK\u0013\r\t9*\u0005\u0002\u0005\u0005f$X\r\u0003\u0005\u0002\u001c\u0002\u0001\u000b\u0011BAA\u0003MIg\u000eZ3y\u0017\u0016L()\u001f;f\u0019\u0016tw\r\u001e5!\u0011%\ty\n\u0001b\u0001\n\u0003\n\t+A\u0004tQ\u0006\u0014\u0018N\\4\u0016\u0005\u00055\u0005\u0002CAS\u0001\u0001\u0006I!!$\u0002\u0011MD\u0017M]5oO\u0002Bq!!+\u0001\t\u0003\nY+\u0001\u0006u_&sG-\u001a=LKf$\"\"!,\u0002B\u0006-\u0017qZAj!\u0015\ty+a/$\u001d\u0011\t\t,!/\u000f\t\u0005M\u0016q\u0017\b\u0004o\u0006U\u0016BA\u0003\b\u0013\tAb!\u0003\u0002 /%!\u0011QXA`\u0005-\u0011vn^&fsZ\u000bG.^3\u000b\u0005}9\u0002\u0002CAb\u0003O\u0003\r!!2\u0002\u0011]\u0014\u0018\u000e^1cY\u0016\u00042AFAd\u0013\r\tIm\u0006\u0002\u0010/JLG/\u00192mK\u001a+\u0017\r^;sK\"A\u0011QZAT\u0001\u0004\ti)\u0001\u0003uS\u0016\u0014\b\u0002CAi\u0003O\u0003\r!!$\u0002\u0005%$\u0007BCAk\u0003O\u0003\n\u00111\u0001\u0002X\u00059A.\u001a8jK:$\bbBAm\u0001\u0011\u0005\u00131\\\u0001\u000fO\u0016$\u0018J\u001c3fqZ\u000bG.^3t)\u0015Y\u0012Q\\Av\u0011!\ty.a6A\u0002\u0005\u0005\u0018A\u00024jYR,'\u000f\u0005\u0003\u0002d\u0006\u001dXBAAs\u0015\r\ty.O\u0005\u0005\u0003S\f)O\u0001\u0004GS2$XM\u001d\u0005\t\u0003[\f9\u000e1\u0001\u0002p\u00069Q\r\u001f9mC&t\u0007\u0003BAy\u0003ol!!a=\u000b\u0007\u0005Uh!A\u0003vi&d7/\u0003\u0003\u0002z\u0006M(!C#ya2\f\u0017N\\3s\u0011\u001d\ti\u0010\u0001C!\u0003\u007f\f\u0011bZ3u%\u0006tw-Z:\u0015\r\t\u0005!Q\u0002B\t!\u0019\tIGa\u0001\u0003\b%!!QAA;\u0005!IE/\u001a:bi>\u0014\b#BAX\u0005\u0013\u0019\u0013\u0002\u0002B\u0006\u0003\u007f\u0013\u0011bU2b]J\u000bgnZ3\t\u000f\t=\u00111 a\u00017\u00051a/\u00197vKND\u0011Ba\u0005\u0002|B\u0005\t\u0019A/\u0002\u00155,H\u000e^5qY&,'\u000fC\u0004\u0003\u0018\u0001!\tE!\u0007\u0002\u001b\u001d,GOU1oO\u0016\u0014\u0015\u0010^3t)\u0019\u0011YBa\t\u0003(A1\u0011\u0011\u000eB\u0002\u0005;\u0001B!a,\u0003 %!!\u0011EA`\u0005%\u0011\u0015\u0010^3SC:<W\r\u0003\u0005\u0003&\tU\u0001\u0019\u0001B\u0001\u0003\u0019\u0011\u0018M\\4fg\"Q\u0011Q\u001aB\u000b!\u0003\u0005\r!a\u0016\t\u000f\t-\u0002\u0001\"\u0011\u0003.\u0005iQo]3Gk2dg)\u001b7uKJ$\u0002\"a\u0016\u00030\tM\"q\n\u0005\t\u0005\u001f\u0011I\u00031\u0001\u00032A!\u0001#a\u000e\u001c\u0011!\u0011)D!\u000bA\u0002\t]\u0012AB2p]\u001aLw\rE\u0003\u0011\u0003o\u0011I\u0004\u0005\u0003\u0003<\t%c\u0002\u0002B\u001f\u0005\u0007rA!a-\u0003@%\u0019!\u0011\t\u0004\u0002\u0011\u001d,w\u000e^8pYNLAA!\u0012\u0003H\u00059r)Z8NKN\fG)\u0019;b'R|'/\u001a$bGR|'/\u001f\u0006\u0004\u0005\u00032\u0011\u0002\u0002B&\u0005\u001b\u0012acR3p\u001b\u0016\u001c\u0018\rR1uCN#xN]3D_:4\u0017n\u001a\u0006\u0005\u0005\u000b\u00129\u0005\u0003\u0005\u0003R\t%\u0002\u0019\u0001B*\u0003\u0015A\u0017N\u001c;t!\u0011\u0011)F!\u0018\u000e\u0005\t]#\u0002\u0002B-\u00057\nqAZ1di>\u0014\u0018PC\u0002\u0003B-IAAa\u0018\u0003X\t)\u0001*\u001b8ug\u001e9!1\r\u0002\t\u0002\t\u0015\u0014\u0001\u0005-[g%sG-\u001a=LKf\u001c\u0006/Y2f!\ri\"q\r\u0004\u0007\u0003\tA\tA!\u001b\u0014\u000b\t\u001dtBa\u001b\u0011\r\t5$1O\u000e$\u001d\u0011\t\tLa\u001c\n\u0007\tEt#A\u0007J]\u0012,\u0007pS3z'B\f7-Z\u0005\u0005\u0005k\u00129H\u0001\u000bJ]\u0012,\u0007pS3z'B\f7-\u001a$bGR|'/\u001f\u0006\u0004\u0005c:\u0002bB*\u0003h\u0011\u0005!1\u0010\u000b\u0003\u0005KB\u0001Ba \u0003h\u0011\u0005#\u0011Q\u0001\tgV\u0004\bo\u001c:ugR1\u0011q\u000bBB\u0005\u000bCa!\rB?\u0001\u0004\u0019\u0004\u0002CA2\u0005{\u0002\r!a\u001a\t\u0011\t%%q\rC!\u0005\u0017\u000bQ!\u00199qYf$r!\u0016BG\u0005\u001f\u0013\t\n\u0003\u00042\u0005\u000f\u0003\ra\r\u0005\t\u0003G\u00129\t1\u0001\u0002h!A\u0011Q\u001aBD\u0001\u0004\t9\u0006")
public class XZ3IndexKeySpace
implements IndexKeySpace<package.XZ3IndexValues, package.Z3IndexKey>,
LazyLogging {
    private final SimpleFeatureType sft;
    private final ShardStrategy sharding;
    public final String org$locationtech$geomesa$index$index$z3$XZ3IndexKeySpace$$geomField;
    public final String org$locationtech$geomesa$index$index$z3$XZ3IndexKeySpace$$dtgField;
    private final int geomIndex;
    private final int dtgIndex;
    private final XZ3SFC sfc;
    private final Function1<Object, BinnedTime> timeToIndex;
    private final Function1<ZonedDateTime, BinnedTime> org$locationtech$geomesa$index$index$z3$XZ3IndexKeySpace$$dateToIndex;
    private final Function1<Tuple2<Option<ZonedDateTime>, Option<ZonedDateTime>>, Tuple2<ZonedDateTime, ZonedDateTime>> org$locationtech$geomesa$index$index$z3$XZ3IndexKeySpace$$boundsToDates;
    private final boolean isPoints;
    private final Seq<String> attributes;
    private final Right<Function3<byte[], Object, Object, Object>, Object> indexKeyByteLength;
    private final byte[] sharing;
    private final Logger logger;
    private volatile boolean bitmap$0;

    public static XZ3IndexKeySpace apply(SimpleFeatureType simpleFeatureType, Seq<String> seq, boolean bl) {
        return XZ3IndexKeySpace$.MODULE$.apply(simpleFeatureType, (Seq)seq, bl);
    }

    public static boolean supports(SimpleFeatureType simpleFeatureType, Seq<String> seq) {
        return XZ3IndexKeySpace$.MODULE$.supports(simpleFeatureType, seq);
    }

    private Logger logger$lzycompute() {
        XZ3IndexKeySpace xZ3IndexKeySpace = this;
        synchronized (xZ3IndexKeySpace) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public int getRanges$default$2() {
        return IndexKeySpace$class.getRanges$default$2(this);
    }

    @Override
    public boolean getRangeBytes$default$2() {
        return IndexKeySpace$class.getRangeBytes$default$2(this);
    }

    @Override
    public boolean toIndexKey$default$4() {
        return IndexKeySpace$class.toIndexKey$default$4(this);
    }

    @Override
    public SimpleFeatureType sft() {
        return this.sft;
    }

    @Override
    public ShardStrategy sharding() {
        return this.sharding;
    }

    public int geomIndex() {
        return this.geomIndex;
    }

    public int dtgIndex() {
        return this.dtgIndex;
    }

    public XZ3SFC sfc() {
        return this.sfc;
    }

    public Function1<Object, BinnedTime> timeToIndex() {
        return this.timeToIndex;
    }

    public Function1<ZonedDateTime, BinnedTime> org$locationtech$geomesa$index$index$z3$XZ3IndexKeySpace$$dateToIndex() {
        return this.org$locationtech$geomesa$index$index$z3$XZ3IndexKeySpace$$dateToIndex;
    }

    public Function1<Tuple2<Option<ZonedDateTime>, Option<ZonedDateTime>>, Tuple2<ZonedDateTime, ZonedDateTime>> org$locationtech$geomesa$index$index$z3$XZ3IndexKeySpace$$boundsToDates() {
        return this.org$locationtech$geomesa$index$index$z3$XZ3IndexKeySpace$$boundsToDates;
    }

    private boolean isPoints() {
        return this.isPoints;
    }

    @Override
    public Seq<String> attributes() {
        return this.attributes;
    }

    public Right<Function3<byte[], Object, Object, Object>, Object> indexKeyByteLength() {
        return this.indexKeyByteLength;
    }

    @Override
    public byte[] sharing() {
        return this.sharing;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public package.RowKeyValue<package.Z3IndexKey> toIndexKey(WritableFeature writable, byte[] tier, byte[] id, boolean lenient) {
        byte[] shard;
        long xz;
        Tuple2 tuple2;
        Geometry geom = (Geometry)writable.getAttribute(this.geomIndex());
        if (geom == null) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Null geometry in feature ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{writable.feature().getID()})));
        }
        Envelope envelope = geom.getEnvelopeInternal();
        Date dtg = (Date)writable.getAttribute(this.dtgIndex());
        long time = dtg == null ? 0L : dtg.getTime();
        BinnedTime binnedTime = (BinnedTime)this.timeToIndex().apply((Object)BoxesRunTime.boxToLong((long)time));
        if (binnedTime == null) throw new MatchError((Object)binnedTime);
        short b = binnedTime.bin();
        long t = binnedTime.offset();
        Tuple2 tuple22 = tuple2 = new Tuple2((Object)BoxesRunTime.boxToShort((short)b), (Object)BoxesRunTime.boxToLong((long)t));
        short b2 = BoxesRunTime.unboxToShort((Object)tuple22._1());
        long t2 = tuple22._2$mcJ$sp();
        try {
            xz = this.sfc().index(envelope.getMinX(), envelope.getMinY(), (double)t2, envelope.getMaxX(), envelope.getMaxY(), (double)t2, lenient);
            shard = this.sharding().apply(writable);
        }
        catch (Throwable throwable) {
            void var7_7;
            void var5_5;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid xz value from geometry/time: ", ",", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var5_5, var7_7})), e);
        }
        byte[] bytes = (byte[])Array$.MODULE$.ofDim(shard.length + 10 + id.length, ClassTag$.MODULE$.Byte());
        if (Predef$.MODULE$.byteArrayOps(shard).isEmpty()) {
            ByteArrays$.MODULE$.writeShort(b2, bytes, 0);
            ByteArrays$.MODULE$.writeLong(xz, bytes, 2);
            System.arraycopy(id, 0, bytes, 10, id.length);
            return new package.SingleRowKeyValue<package.Z3IndexKey>(bytes, this.sharing(), shard, new package.Z3IndexKey(b2, xz), tier, id, writable.values());
        } else {
            bytes[0] = BoxesRunTime.unboxToByte((Object)Predef$.MODULE$.byteArrayOps(shard).head());
            ByteArrays$.MODULE$.writeShort(b2, bytes, 1);
            ByteArrays$.MODULE$.writeLong(xz, bytes, 3);
            System.arraycopy(id, 0, bytes, 11, id.length);
        }
        return new package.SingleRowKeyValue<package.Z3IndexKey>(bytes, this.sharing(), shard, new package.Z3IndexKey(b2, xz), tier, id, writable.values());
    }

    @Override
    public package.XZ3IndexValues getIndexValues(Filter filter2, Explainer explain) {
        FilterValues extracted = FilterHelper$.MODULE$.extractGeometries(filter2, this.org$locationtech$geomesa$index$index$z3$XZ3IndexKeySpace$$geomField, this.isPoints());
        FilterValues geometries = extracted.nonEmpty() ? extracted : new FilterValues((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Polygon[]{org.locationtech.geomesa.utils.geotools.package$.MODULE$.WholeWorldPolygon()})), FilterValues$.MODULE$.apply$default$2(), FilterValues$.MODULE$.apply$default$3());
        Filter x$8 = filter2;
        String x$9 = this.org$locationtech$geomesa$index$index$z3$XZ3IndexKeySpace$$dtgField;
        boolean x$10 = true;
        boolean x$11 = FilterHelper$.MODULE$.extractIntervals$default$3();
        FilterValues intervals = FilterHelper$.MODULE$.extractIntervals(x$8, x$9, x$11, x$10);
        explain.apply((Function0<String>)new Serializable(this, geometries){
            public static final long serialVersionUID = 0L;
            private final FilterValues geometries$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Geometries: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.geometries$1}));
            }
            {
                this.geometries$1 = geometries$1;
            }
        });
        explain.apply((Function0<String>)new Serializable(this, intervals){
            public static final long serialVersionUID = 0L;
            private final FilterValues intervals$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Intervals: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.intervals$1}));
            }
            {
                this.intervals$1 = intervals$1;
            }
        });
        if (intervals.disjoint()) {
            explain.apply((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Disjoint dates extracted, short-circuiting to empty query";
                }
            });
            return new package.XZ3IndexValues(this.sfc(), (FilterValues<Geometry>)FilterValues$.MODULE$.empty(), (Seq<Tuple4<Object, Object, Object, Object>>)((Seq)Seq$.MODULE$.empty()), (FilterValues<Bounds<ZonedDateTime>>)FilterValues$.MODULE$.empty(), (Map<Object, Tuple2<Object, Object>>)Predef$.MODULE$.Map().empty(), (Seq<Tuple2<Object, Object>>)((Seq)Seq$.MODULE$.empty()));
        }
        int multiplier = BoxesRunTime.unboxToInt((Object)QueryProperties$.MODULE$.PolygonDecompMultiplier().toInt().get());
        int bits = BoxesRunTime.unboxToInt((Object)QueryProperties$.MODULE$.PolygonDecompBits().toInt().get());
        Seq xy = (Seq)geometries.values().flatMap((Function1)new Serializable(this, multiplier, bits){
            public static final long serialVersionUID = 0L;
            private final int multiplier$2;
            private final int bits$1;

            public final Seq<Tuple4<Object, Object, Object, Object>> apply(Geometry x$2) {
                return GeometryUtils$.MODULE$.bounds(x$2, this.multiplier$2, this.bits$1);
            }
            {
                this.multiplier$2 = multiplier$2;
                this.bits$1 = bits$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        scala.collection.mutable.Map timesByBin = Map$.MODULE$.empty();
        Builder unboundedBins = Seq$.MODULE$.newBuilder();
        intervals.foreach((Function1)new Serializable(this, timesByBin, unboundedBins){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ XZ3IndexKeySpace $outer;
            public final scala.collection.mutable.Map timesByBin$1;
            private final Builder unboundedBins$1;

            public final Object apply(Bounds<ZonedDateTime> interval) {
                Tuple2 tuple2 = (Tuple2)this.$outer.org$locationtech$geomesa$index$index$z3$XZ3IndexKeySpace$$boundsToDates().apply((Object)interval.bounds());
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    ZonedDateTime lower = (ZonedDateTime)tuple2._1();
                    ZonedDateTime upper = (ZonedDateTime)tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)lower, (Object)upper);
                    ZonedDateTime lower2 = (ZonedDateTime)tuple23._1();
                    ZonedDateTime upper2 = (ZonedDateTime)tuple23._2();
                    BinnedTime binnedTime = (BinnedTime)this.$outer.org$locationtech$geomesa$index$index$z3$XZ3IndexKeySpace$$dateToIndex().apply((Object)lower2);
                    if (binnedTime != null) {
                        Tuple2 tuple24;
                        short lb = binnedTime.bin();
                        long lt = binnedTime.offset();
                        Tuple2 tuple25 = tuple24 = new Tuple2((Object)BoxesRunTime.boxToShort((short)lb), (Object)BoxesRunTime.boxToLong((long)lt));
                        short lb2 = BoxesRunTime.unboxToShort((Object)tuple25._1());
                        long lt2 = tuple25._2$mcJ$sp();
                        BinnedTime binnedTime2 = (BinnedTime)this.$outer.org$locationtech$geomesa$index$index$z3$XZ3IndexKeySpace$$dateToIndex().apply((Object)upper2);
                        if (binnedTime2 != null) {
                            BoxedUnit boxedUnit;
                            Tuple2 tuple26;
                            short ub = binnedTime2.bin();
                            long ut = binnedTime2.offset();
                            Tuple2 tuple27 = tuple26 = new Tuple2((Object)BoxesRunTime.boxToShort((short)ub), (Object)BoxesRunTime.boxToLong((long)ut));
                            short ub2 = BoxesRunTime.unboxToShort((Object)tuple27._1());
                            long ut2 = tuple27._2$mcJ$sp();
                            if (interval.isBoundedBothSides()) {
                                if (lb2 == ub2) {
                                    this.$outer.org$locationtech$geomesa$index$index$z3$XZ3IndexKeySpace$$updateTime$1(lb2, lt2, ut2, this.timesByBin$1);
                                    boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    this.$outer.org$locationtech$geomesa$index$index$z3$XZ3IndexKeySpace$$updateTime$1(lb2, lt2, this.$outer.sfc().zBounds()._2$mcD$sp(), this.timesByBin$1);
                                    this.$outer.org$locationtech$geomesa$index$index$z3$XZ3IndexKeySpace$$updateTime$1(ub2, this.$outer.sfc().zBounds()._1$mcD$sp(), ut2, this.timesByBin$1);
                                    package$.MODULE$.Range().inclusive(lb2 + 1, ub2 - 1).foreach$mVc$sp((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ $anonfun$getIndexValues$4 $outer;

                                        public final void apply(int b) {
                                            this.apply$mcVI$sp(b);
                                        }

                                        public void apply$mcVI$sp(int b) {
                                            this.$outer.timesByBin$1.update((Object)BoxesRunTime.boxToShort((short)((short)b)), (Object)this.$outer.org$locationtech$geomesa$index$index$z3$XZ3IndexKeySpace$$anonfun$$$outer().sfc().zBounds());
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                        }
                                    });
                                    boxedUnit = BoxedUnit.UNIT;
                                }
                            } else if (interval.lower().value().isDefined()) {
                                this.$outer.org$locationtech$geomesa$index$index$z3$XZ3IndexKeySpace$$updateTime$1(lb2, lt2, this.$outer.sfc().zBounds()._2$mcD$sp(), this.timesByBin$1);
                                boxedUnit = this.unboundedBins$1.$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToShort((short)((short)(lb2 + 1))), (Object)BoxesRunTime.boxToShort((short)Short.MAX_VALUE)));
                            } else if (interval.upper().value().isDefined()) {
                                this.$outer.org$locationtech$geomesa$index$index$z3$XZ3IndexKeySpace$$updateTime$1(ub2, this.$outer.sfc().zBounds()._1$mcD$sp(), ut2, this.timesByBin$1);
                                boxedUnit = this.unboundedBins$1.$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToShort((short)0), (Object)BoxesRunTime.boxToShort((short)((short)(ub2 - 1)))));
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            return boxedUnit;
                        }
                        throw new MatchError((Object)binnedTime2);
                    }
                    throw new MatchError((Object)binnedTime);
                }
                throw new MatchError((Object)tuple2);
            }

            public /* synthetic */ XZ3IndexKeySpace org$locationtech$geomesa$index$index$z3$XZ3IndexKeySpace$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.timesByBin$1 = timesByBin$1;
                this.unboundedBins$1 = unboundedBins$1;
            }
        });
        return new package.XZ3IndexValues(this.sfc(), (FilterValues<Geometry>)geometries, (Seq<Tuple4<Object, Object, Object, Object>>)xy, (FilterValues<Bounds<ZonedDateTime>>)intervals, (Map<Object, Tuple2<Object, Object>>)timesByBin.toMap(Predef$.MODULE$.$conforms()), (Seq<Tuple2<Object, Object>>)((Seq)unboundedBins.result()));
    }

    @Override
    public Iterator<package.ScanRange<package.Z3IndexKey>> getRanges(package.XZ3IndexValues values2, int multiplier) {
        ObjectRef wholePeriodRanges$lzy = ObjectRef.zero();
        VolatileByteRef bitmap$0 = VolatileByteRef.create((byte)0);
        package.XZ3IndexValues xZ3IndexValues = values2;
        if (xZ3IndexValues != null) {
            Tuple4 tuple4;
            XZ3SFC sfc = xZ3IndexValues.sfc();
            Seq<Tuple4<Object, Object, Object, Object>> xy = xZ3IndexValues.spatialBounds();
            Map<Object, Tuple2<Object, Object>> timesByBin = xZ3IndexValues.temporalBounds();
            Seq<Tuple2<Object, Object>> unboundedBins = xZ3IndexValues.temporalUnbounded();
            Tuple4 tuple42 = tuple4 = new Tuple4((Object)sfc, xy, timesByBin, unboundedBins);
            XZ3SFC sfc2 = (XZ3SFC)tuple42._1();
            Seq xy2 = (Seq)tuple42._2();
            Map timesByBin2 = (Map)tuple42._3();
            Seq unboundedBins2 = (Seq)tuple42._4();
            Option target = QueryProperties$.MODULE$.ScanRangesTarget().option().map((Function1)new Serializable(this, multiplier, timesByBin2){
                public static final long serialVersionUID = 0L;
                private final int multiplier$1;
                private final Map timesByBin$2;

                public final int apply(String t) {
                    return scala.math.package$.MODULE$.max(1, this.timesByBin$2.isEmpty() ? new StringOps(Predef$.MODULE$.augmentString(t)).toInt() : new StringOps(Predef$.MODULE$.augmentString(t)).toInt() / this.timesByBin$2.size() / this.multiplier$1);
                }
                {
                    this.multiplier$1 = multiplier$1;
                    this.timesByBin$2 = timesByBin$2;
                }
            });
            Iterator bounded = timesByBin2.iterator().flatMap((Function1)new Serializable(this, sfc2, xy2, target, wholePeriodRanges$lzy, bitmap$0){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ XZ3IndexKeySpace $outer;
                private final XZ3SFC sfc$1;
                private final Seq xy$1;
                private final Option target$1;
                private final ObjectRef wholePeriodRanges$lzy$1;
                private final VolatileByteRef bitmap$0$1;

                public final Seq<package.BoundedRange<package.Z3IndexKey>> apply(Tuple2<Object, Tuple2<Object, Object>> x0$2) {
                    Tuple2<Object, Tuple2<Object, Object>> tuple2 = x0$2;
                    if (tuple2 != null) {
                        short bin = BoxesRunTime.unboxToShort((Object)tuple2._1());
                        Tuple2 times = (Tuple2)tuple2._2();
                        Seq zs = times == this.sfc$1.zBounds() ? this.$outer.org$locationtech$geomesa$index$index$z3$XZ3IndexKeySpace$$wholePeriodRanges$1(this.sfc$1, this.xy$1, this.target$1, this.wholePeriodRanges$lzy$1, this.bitmap$0$1) : this.$outer.org$locationtech$geomesa$index$index$z3$XZ3IndexKeySpace$$toZRanges$1(times, this.sfc$1, this.xy$1, this.target$1);
                        Seq seq = (Seq)zs.map((Function1)new Serializable(this, bin){
                            public static final long serialVersionUID = 0L;
                            private final short bin$1;

                            public final package.BoundedRange<package.Z3IndexKey> apply(IndexRange r) {
                                return new package.BoundedRange<package.Z3IndexKey>(new package.Z3IndexKey(this.bin$1, r.lower()), new package.Z3IndexKey(this.bin$1, r.upper()));
                            }
                            {
                                this.bin$1 = bin$1;
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                        return seq;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.sfc$1 = sfc$1;
                    this.xy$1 = xy$1;
                    this.target$1 = target$1;
                    this.wholePeriodRanges$lzy$1 = wholePeriodRanges$lzy$1;
                    this.bitmap$0$1 = bitmap$0$1;
                }
            });
            Iterator unbounded = unboundedBins2.iterator().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ XZ3IndexKeySpace $outer;

                public final Product apply(Tuple2<Object, Object> x0$3) {
                    Tuple2<Object, Object> tuple2;
                    block8: {
                        Product product;
                        block6: {
                            BoxedUnit boxedUnit;
                            block7: {
                                block5: {
                                    tuple2 = x0$3;
                                    if (tuple2 == null) break block5;
                                    short lower = BoxesRunTime.unboxToShort((Object)tuple2._1());
                                    short s = BoxesRunTime.unboxToShort((Object)tuple2._2());
                                    if (Short.MAX_VALUE != s) break block5;
                                    product = new package.LowerBoundedRange<package.Z3IndexKey>(new package.Z3IndexKey(lower, 0L));
                                    break block6;
                                }
                                if (tuple2 == null) break block7;
                                short s = BoxesRunTime.unboxToShort((Object)tuple2._1());
                                short upper = BoxesRunTime.unboxToShort((Object)tuple2._2());
                                if (0 != s) break block7;
                                product = new package.UpperBoundedRange<package.Z3IndexKey>(new package.Z3IndexKey(upper, Long.MAX_VALUE));
                                break block6;
                            }
                            if (tuple2 == null) break block8;
                            short lower = BoxesRunTime.unboxToShort((Object)tuple2._1());
                            short upper = BoxesRunTime.unboxToShort((Object)tuple2._2());
                            if (this.$outer.logger().underlying().isErrorEnabled()) {
                                this.$outer.logger().underlying().error("Unexpected unbounded bin endpoints: {}:{}", new Object[]{BoxesRunTime.boxToShort((short)lower), BoxesRunTime.boxToShort((short)upper)});
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            product = new package.UnboundedRange<package.Z3IndexKey>(new package.Z3IndexKey(0, 0L));
                        }
                        return product;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            return bounded.$plus$plus((Function0)new Serializable(this, unbounded){
                public static final long serialVersionUID = 0L;
                private final Iterator unbounded$1;

                public final Iterator<Product> apply() {
                    return this.unbounded$1;
                }
                {
                    this.unbounded$1 = unbounded$1;
                }
            });
        }
        throw new MatchError((Object)xZ3IndexValues);
    }

    @Override
    public Iterator<package.ByteRange> getRangeBytes(Iterator<package.ScanRange<package.Z3IndexKey>> ranges, boolean tier) {
        return this.sharding().length() == 0 ? ranges.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final package.ByteRange apply(package.ScanRange<package.Z3IndexKey> x0$4) {
                package.ScanRange<package.Z3IndexKey> scanRange;
                block6: {
                    package.BoundedByteRange boundedByteRange;
                    block3: {
                        block5: {
                            block4: {
                                block2: {
                                    scanRange = x0$4;
                                    if (!(scanRange instanceof package.BoundedRange)) break block2;
                                    package.BoundedRange boundedRange = (package.BoundedRange)scanRange;
                                    package.Z3IndexKey lo = (package.Z3IndexKey)boundedRange.lower();
                                    package.Z3IndexKey hi = (package.Z3IndexKey)boundedRange.upper();
                                    boundedByteRange = new package.BoundedByteRange(ByteArrays$.MODULE$.toBytes(lo.bin(), lo.z()), ByteArrays$.MODULE$.toBytesFollowingPrefix(hi.bin(), hi.z()));
                                    break block3;
                                }
                                if (!(scanRange instanceof package.LowerBoundedRange)) break block4;
                                package.LowerBoundedRange lowerBoundedRange = (package.LowerBoundedRange)scanRange;
                                package.Z3IndexKey lo = (package.Z3IndexKey)lowerBoundedRange.lower();
                                boundedByteRange = new package.BoundedByteRange(ByteArrays$.MODULE$.toBytes(lo.bin(), lo.z()), package$ByteRange$.MODULE$.UnboundedUpperRange());
                                break block3;
                            }
                            if (!(scanRange instanceof package.UpperBoundedRange)) break block5;
                            package.UpperBoundedRange upperBoundedRange = (package.UpperBoundedRange)scanRange;
                            package.Z3IndexKey hi = (package.Z3IndexKey)upperBoundedRange.upper();
                            boundedByteRange = new package.BoundedByteRange(package$ByteRange$.MODULE$.UnboundedLowerRange(), ByteArrays$.MODULE$.toBytesFollowingPrefix(hi.bin(), hi.z()));
                            break block3;
                        }
                        if (!(scanRange instanceof package.UnboundedRange)) break block6;
                        boundedByteRange = new package.BoundedByteRange(package$ByteRange$.MODULE$.UnboundedLowerRange(), package$ByteRange$.MODULE$.UnboundedUpperRange());
                    }
                    return boundedByteRange;
                }
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected range type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{scanRange})));
            }
        }) : ranges.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ XZ3IndexKeySpace $outer;

            public final GenTraversableOnce<package.ByteRange> apply(package.ScanRange<package.Z3IndexKey> x0$5) {
                package.ScanRange<package.Z3IndexKey> scanRange;
                block6: {
                    GenTraversable genTraversable;
                    block3: {
                        block5: {
                            block4: {
                                block2: {
                                    scanRange = x0$5;
                                    if (!(scanRange instanceof package.BoundedRange)) break block2;
                                    package.BoundedRange boundedRange = (package.BoundedRange)scanRange;
                                    package.Z3IndexKey lo = (package.Z3IndexKey)boundedRange.lower();
                                    package.Z3IndexKey hi = (package.Z3IndexKey)boundedRange.upper();
                                    byte[] lower = ByteArrays$.MODULE$.toBytes(lo.bin(), lo.z());
                                    byte[] upper = ByteArrays$.MODULE$.toBytesFollowingPrefix(hi.bin(), hi.z());
                                    genTraversable = (GenTraversableOnce)this.$outer.sharding().shards().map((Function1)new Serializable(this, lower, upper){
                                        public static final long serialVersionUID = 0L;
                                        private final byte[] lower$1;
                                        private final byte[] upper$1;

                                        public final package.BoundedByteRange apply(byte[] p) {
                                            return new package.BoundedByteRange(ByteArrays$.MODULE$.concat(p, this.lower$1), ByteArrays$.MODULE$.concat(p, this.upper$1));
                                        }
                                        {
                                            this.lower$1 = lower$1;
                                            this.upper$1 = upper$1;
                                        }
                                    }, Seq$.MODULE$.canBuildFrom());
                                    break block3;
                                }
                                if (!(scanRange instanceof package.LowerBoundedRange)) break block4;
                                package.LowerBoundedRange lowerBoundedRange = (package.LowerBoundedRange)scanRange;
                                package.Z3IndexKey lo = (package.Z3IndexKey)lowerBoundedRange.lower();
                                byte[] lower = ByteArrays$.MODULE$.toBytes(lo.bin(), lo.z());
                                byte[] upper = package$ByteRange$.MODULE$.UnboundedUpperRange();
                                genTraversable = (GenTraversableOnce)this.$outer.sharding().shards().map((Function1)new Serializable(this, lower, upper){
                                    public static final long serialVersionUID = 0L;
                                    private final byte[] lower$2;
                                    private final byte[] upper$2;

                                    public final package.BoundedByteRange apply(byte[] p) {
                                        return new package.BoundedByteRange(ByteArrays$.MODULE$.concat(p, this.lower$2), ByteArrays$.MODULE$.concat(p, this.upper$2));
                                    }
                                    {
                                        this.lower$2 = lower$2;
                                        this.upper$2 = upper$2;
                                    }
                                }, Seq$.MODULE$.canBuildFrom());
                                break block3;
                            }
                            if (!(scanRange instanceof package.UpperBoundedRange)) break block5;
                            package.UpperBoundedRange upperBoundedRange = (package.UpperBoundedRange)scanRange;
                            package.Z3IndexKey hi = (package.Z3IndexKey)upperBoundedRange.upper();
                            byte[] lower = package$ByteRange$.MODULE$.UnboundedLowerRange();
                            byte[] upper = ByteArrays$.MODULE$.toBytesFollowingPrefix(hi.bin(), hi.z());
                            genTraversable = (GenTraversableOnce)this.$outer.sharding().shards().map((Function1)new Serializable(this, lower, upper){
                                public static final long serialVersionUID = 0L;
                                private final byte[] lower$3;
                                private final byte[] upper$3;

                                public final package.BoundedByteRange apply(byte[] p) {
                                    return new package.BoundedByteRange(ByteArrays$.MODULE$.concat(p, this.lower$3), ByteArrays$.MODULE$.concat(p, this.upper$3));
                                }
                                {
                                    this.lower$3 = lower$3;
                                    this.upper$3 = upper$3;
                                }
                            }, Seq$.MODULE$.canBuildFrom());
                            break block3;
                        }
                        if (!(scanRange instanceof package.UnboundedRange)) break block6;
                        genTraversable = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new package.BoundedByteRange[]{new package.BoundedByteRange(package$ByteRange$.MODULE$.UnboundedLowerRange(), package$ByteRange$.MODULE$.UnboundedUpperRange())}));
                    }
                    return genTraversable;
                }
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected range type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{scanRange})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Override
    public boolean useFullFilter(Option<package.XZ3IndexValues> values2, Option<GeoMesaDataStoreFactory.GeoMesaDataStoreConfig> config, Hints hints) {
        return true;
    }

    public final void org$locationtech$geomesa$index$index$z3$XZ3IndexKeySpace$$updateTime$1(short bin, double lt, double ut, scala.collection.mutable.Map timesByBin$1) {
        Option option;
        block4: {
            Tuple2.mcDD.sp sp2;
            block3: {
                Some some;
                Tuple2 tuple2;
                block2: {
                    option = timesByBin$1.get((Object)BoxesRunTime.boxToShort((short)bin));
                    if (!None$.MODULE$.equals(option)) break block2;
                    sp2 = new Tuple2.mcDD.sp(lt, ut);
                    break block3;
                }
                if (!(option instanceof Some) || (tuple2 = (Tuple2)(some = (Some)option).x()) == null) break block4;
                double min2 = tuple2._1$mcD$sp();
                double max2 = tuple2._2$mcD$sp();
                sp2 = new Tuple2.mcDD.sp(scala.math.package$.MODULE$.min(min2, lt), scala.math.package$.MODULE$.max(max2, ut));
            }
            Tuple2.mcDD.sp times = sp2;
            timesByBin$1.update((Object)BoxesRunTime.boxToShort((short)bin), (Object)times);
            return;
        }
        throw new MatchError((Object)option);
    }

    public final Seq org$locationtech$geomesa$index$index$z3$XZ3IndexKeySpace$$toZRanges$1(Tuple2 t, XZ3SFC sfc$1, Seq xy$1, Option target$1) {
        return sfc$1.ranges((Seq)xy$1.map((Function1)new Serializable(this, t){
            public static final long serialVersionUID = 0L;
            private final Tuple2 t$1;

            public final Tuple6<Object, Object, Object, Object, Object, Object> apply(Tuple4<Object, Object, Object, Object> x0$1) {
                Tuple4<Object, Object, Object, Object> tuple4 = x0$1;
                if (tuple4 != null) {
                    double xmin = BoxesRunTime.unboxToDouble((Object)tuple4._1());
                    double ymin = BoxesRunTime.unboxToDouble((Object)tuple4._2());
                    double xmax = BoxesRunTime.unboxToDouble((Object)tuple4._3());
                    double ymax = BoxesRunTime.unboxToDouble((Object)tuple4._4());
                    Tuple6 tuple6 = new Tuple6((Object)BoxesRunTime.boxToDouble((double)xmin), (Object)BoxesRunTime.boxToDouble((double)ymin), (Object)BoxesRunTime.boxToDouble((double)this.t$1._1$mcD$sp()), (Object)BoxesRunTime.boxToDouble((double)xmax), (Object)BoxesRunTime.boxToDouble((double)ymax), (Object)BoxesRunTime.boxToDouble((double)this.t$1._2$mcD$sp()));
                    return tuple6;
                }
                throw new MatchError(tuple4);
            }
            {
                this.t$1 = t$1;
            }
        }, Seq$.MODULE$.canBuildFrom()), target$1);
    }

    private final Seq wholePeriodRanges$lzycompute$1(XZ3SFC sfc$1, Seq xy$1, Option target$1, ObjectRef wholePeriodRanges$lzy$1, VolatileByteRef bitmap$0$1) {
        XZ3IndexKeySpace xZ3IndexKeySpace = this;
        synchronized (xZ3IndexKeySpace) {
            if ((byte)(bitmap$0$1.elem & 1) == 0) {
                wholePeriodRanges$lzy$1.elem = this.org$locationtech$geomesa$index$index$z3$XZ3IndexKeySpace$$toZRanges$1(sfc$1.zBounds(), sfc$1, xy$1, target$1);
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
            }
            return (Seq)wholePeriodRanges$lzy$1.elem;
        }
    }

    public final Seq org$locationtech$geomesa$index$index$z3$XZ3IndexKeySpace$$wholePeriodRanges$1(XZ3SFC sfc$1, Seq xy$1, Option target$1, ObjectRef wholePeriodRanges$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 1) == 0 ? this.wholePeriodRanges$lzycompute$1(sfc$1, xy$1, target$1, wholePeriodRanges$lzy$1, bitmap$0$1) : (Seq)wholePeriodRanges$lzy$1.elem;
    }

    public XZ3IndexKeySpace(SimpleFeatureType sft, ShardStrategy sharding, String geomField, String dtgField) {
        this.sft = sft;
        this.sharding = sharding;
        this.org$locationtech$geomesa$index$index$z3$XZ3IndexKeySpace$$geomField = geomField;
        this.org$locationtech$geomesa$index$index$z3$XZ3IndexKeySpace$$dtgField = dtgField;
        IndexKeySpace$class.$init$(this);
        LazyLogging.class.$init$((LazyLogging)this);
        Predef$.MODULE$.require(Geometry.class.isAssignableFrom(sft.getDescriptor(geomField).getType().getBinding()), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ XZ3IndexKeySpace $outer;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected field ", " to have a geometry binding, but instead it has: "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$locationtech$geomesa$index$index$z3$XZ3IndexKeySpace$$geomField}))).append((Object)this.$outer.sft().getDescriptor(this.$outer.org$locationtech$geomesa$index$index$z3$XZ3IndexKeySpace$$geomField).getType().getBinding().getSimpleName()).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Predef$.MODULE$.require(Date.class.isAssignableFrom(sft.getDescriptor(dtgField).getType().getBinding()), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ XZ3IndexKeySpace $outer;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected field ", " to have a date binding, but instead it has: "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$locationtech$geomesa$index$index$z3$XZ3IndexKeySpace$$dtgField}))).append((Object)this.$outer.sft().getDescriptor(this.$outer.org$locationtech$geomesa$index$index$z3$XZ3IndexKeySpace$$dtgField).getType().getBinding().getSimpleName()).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.geomIndex = sft.indexOf(geomField);
        this.dtgIndex = sft.indexOf(dtgField);
        Enumeration.Value value = RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getZ3Interval$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft));
        Enumeration.Value value2 = TimePeriod$.MODULE$.Year();
        Enumeration.Value value3 = value;
        Object object = !(value2 != null ? !value2.equals(value3) : value3 != null) ? new LegacyYearXZ3SFC(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getXZPrecision$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft))) : XZ3SFC$.MODULE$.apply(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getXZPrecision$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)), value);
        this.sfc = object;
        this.timeToIndex = BinnedTime$.MODULE$.timeToBinnedTime(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getZ3Interval$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        this.org$locationtech$geomesa$index$index$z3$XZ3IndexKeySpace$$dateToIndex = BinnedTime$.MODULE$.dateToBinnedTime(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getZ3Interval$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        this.org$locationtech$geomesa$index$index$z3$XZ3IndexKeySpace$$boundsToDates = BinnedTime$.MODULE$.boundsToIndexableDates(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getZ3Interval$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        this.isPoints = Point.class.isAssignableFrom(sft.getDescriptor(this.geomIndex()).getType().getBinding());
        this.attributes = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{geomField, dtgField}));
        this.indexKeyByteLength = package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToInteger((int)(10 + sharding.length())));
        this.sharing = (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte());
    }
}

