/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.criteria.support;

import java.util.Comparator;
import org.calrissian.mango.criteria.domain.AbstractKeyValueLeaf;
import org.calrissian.mango.criteria.domain.AndNode;
import org.calrissian.mango.criteria.domain.EqualsLeaf;
import org.calrissian.mango.criteria.domain.GreaterThanEqualsLeaf;
import org.calrissian.mango.criteria.domain.GreaterThanLeaf;
import org.calrissian.mango.criteria.domain.HasLeaf;
import org.calrissian.mango.criteria.domain.HasNotLeaf;
import org.calrissian.mango.criteria.domain.Leaf;
import org.calrissian.mango.criteria.domain.LessThanEqualsLeaf;
import org.calrissian.mango.criteria.domain.LessThanLeaf;
import org.calrissian.mango.criteria.domain.Node;
import org.calrissian.mango.criteria.domain.NotEqualsLeaf;
import org.calrissian.mango.criteria.domain.OrNode;
import org.calrissian.mango.criteria.domain.ParentNode;
import org.calrissian.mango.criteria.domain.RangeLeaf;
import org.calrissian.mango.criteria.domain.criteria.AndCriteria;
import org.calrissian.mango.criteria.domain.criteria.Criteria;
import org.calrissian.mango.criteria.domain.criteria.EqualsCriteria;
import org.calrissian.mango.criteria.domain.criteria.GreaterThanCriteria;
import org.calrissian.mango.criteria.domain.criteria.GreaterThanEqualsCriteria;
import org.calrissian.mango.criteria.domain.criteria.HasCriteria;
import org.calrissian.mango.criteria.domain.criteria.HasNotCriteria;
import org.calrissian.mango.criteria.domain.criteria.LessThanCriteria;
import org.calrissian.mango.criteria.domain.criteria.LessThanEqualsCriteria;
import org.calrissian.mango.criteria.domain.criteria.NotEqualsCriteria;
import org.calrissian.mango.criteria.domain.criteria.OrCriteria;
import org.calrissian.mango.criteria.domain.criteria.ParentCriteria;
import org.calrissian.mango.criteria.domain.criteria.RangeCriteria;
import org.calrissian.mango.criteria.support.ComparableComparator;

public class NodeUtils {
    public static boolean isLeaf(Node node) {
        return node instanceof Leaf || node.children() == null || node.children().size() == 0;
    }

    public static boolean isEmpty(Node node) {
        return node == null || node.children() != null && node.children().size() == 0;
    }

    public static boolean parentContainsOnlyLeaves(ParentNode parentNode) {
        for (Node child : parentNode.children()) {
            if (NodeUtils.isLeaf(child)) continue;
            return false;
        }
        return true;
    }

    public static boolean isRangeLeaf(Leaf leaf) {
        return leaf instanceof RangeLeaf || leaf instanceof GreaterThanEqualsLeaf || leaf instanceof GreaterThanLeaf || leaf instanceof LessThanLeaf || leaf instanceof LessThanEqualsLeaf;
    }

    public static Criteria criteriaFromNode(Node node) {
        return NodeUtils.criteriaFromNode(node, new ComparableComparator(), null);
    }

    public static Criteria criteriaFromNode(Node node, Comparator rangeComparator) {
        return NodeUtils.criteriaFromNode(node, rangeComparator, null);
    }

    private static Criteria criteriaFromNode(Node node, Comparator rangeComparator, ParentCriteria parent) {
        Criteria curNode = null;
        curNode = node instanceof AndNode ? new AndCriteria(parent) : (node instanceof OrNode ? new OrCriteria(parent) : NodeUtils.parseLeaf(node, rangeComparator, parent));
        if (node.children() != null) {
            for (Node child : node.children()) {
                if (child instanceof Leaf) {
                    curNode.addChild(NodeUtils.parseLeaf(child, rangeComparator, (ParentCriteria)curNode));
                    continue;
                }
                curNode.addChild(NodeUtils.criteriaFromNode(child, rangeComparator, (ParentCriteria)curNode));
            }
        }
        if (parent != null) {
            parent.addChild(curNode);
        }
        return curNode;
    }

    private static Criteria parseLeaf(Node node, Comparator rangeComparator, ParentCriteria parent) {
        AbstractKeyValueLeaf leaf = (AbstractKeyValueLeaf)node;
        if (node instanceof EqualsLeaf) {
            return new EqualsCriteria(leaf.getKey(), leaf.getValue(), rangeComparator, parent);
        }
        if (node instanceof NotEqualsLeaf) {
            return new NotEqualsCriteria(leaf.getKey(), leaf.getValue(), rangeComparator, parent);
        }
        if (node instanceof HasLeaf) {
            return new HasCriteria(leaf.getKey(), parent);
        }
        if (node instanceof HasNotLeaf) {
            return new HasNotCriteria(leaf.getKey(), parent);
        }
        if (node instanceof LessThanLeaf) {
            return new LessThanCriteria(leaf.getKey(), leaf.getValue(), rangeComparator, parent);
        }
        if (node instanceof LessThanEqualsLeaf) {
            return new LessThanEqualsCriteria(leaf.getKey(), leaf.getValue(), rangeComparator, parent);
        }
        if (node instanceof GreaterThanLeaf) {
            return new GreaterThanCriteria(leaf.getKey(), leaf.getValue(), rangeComparator, parent);
        }
        if (node instanceof GreaterThanEqualsLeaf) {
            return new GreaterThanEqualsCriteria(leaf.getKey(), leaf.getValue(), rangeComparator, parent);
        }
        if (node instanceof RangeCriteria) {
            RangeLeaf rangeLeaf = (RangeLeaf)leaf;
            return new RangeCriteria(leaf.getKey(), leaf.getValue(), rangeLeaf.getEnd(), rangeComparator, parent);
        }
        throw new IllegalArgumentException("An unsupported leaf was encountered: " + node.getClass());
    }
}

